/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core.expr;

import java.util.Objects;
import java.util.Optional;
import org.n52.svalbard.odata.core.expr.Expr;
import org.n52.svalbard.odata.core.expr.ExprVisitor;

public class GeoValueExpr
implements Expr {
    private final String value;

    public GeoValueExpr(String value) {
        this.value = Objects.requireNonNull(value);
    }

    public String getGeometry() {
        return this.value;
    }

    @Override
    public boolean isGeometry() {
        return true;
    }

    @Override
    public Optional<GeoValueExpr> asGeometry() {
        return Optional.of(this);
    }

    public String toString() {
        return String.format("'%s'", this.value);
    }

    public String toODataString() {
        return this.value;
    }

    @Override
    public <T, X extends Throwable> T accept(ExprVisitor<T, X> visitor) throws X {
        return visitor.visitGeometry(this);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GeoValueExpr)) {
            return false;
        }
        return Objects.equals(this.value, ((GeoValueExpr)o).getGeometry());
    }
}

