/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core.expr;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.n52.shetland.oasis.odata.ODataExpr;
import org.n52.svalbard.odata.core.expr.Expr;
import org.n52.svalbard.odata.core.expr.ExprVisitor;
import org.n52.svalbard.odata.core.expr.TextExpr;
import org.n52.svalbard.odata.core.expr.arithmetic.ArithmeticExpr;
import org.n52.svalbard.odata.core.expr.bool.BooleanExpr;
import org.n52.svalbard.odata.core.expr.temporal.TemporalExpr;

public class MethodCallExpr
implements BooleanExpr,
ArithmeticExpr,
TemporalExpr,
TextExpr {
    private final String name;
    private final List<Expr> parameters;

    public MethodCallExpr(String name, List<Expr> parameters) {
        this.name = Objects.requireNonNull(name);
        this.parameters = Objects.requireNonNull(parameters);
    }

    public MethodCallExpr(String name, Expr ... parameter) {
        this.name = Objects.requireNonNull(name);
        this.parameters = Objects.requireNonNull(Arrays.asList(parameter));
    }

    public String getName() {
        return this.name;
    }

    public List<Expr> getParameters() {
        return Collections.unmodifiableList(this.parameters);
    }

    @Override
    public boolean isMethodCall() {
        return true;
    }

    @Override
    public Optional<MethodCallExpr> asMethodCall() {
        return Optional.of(this);
    }

    public String toString() {
        return this.format(this.parameters.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public String toODataString() {
        return this.format(this.parameters.stream().map(ODataExpr::toODataString).collect(Collectors.joining(", ")));
    }

    private String format(String parameters) {
        return String.format("%s(%s)", this.name, parameters);
    }

    @Override
    public <T, X extends Throwable> T accept(ExprVisitor<T, X> visitor) throws X {
        return visitor.visitMethodCall(this);
    }

    public int hashCode() {
        return Objects.hash(this.parameters, this.name);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodCallExpr)) {
            return false;
        }
        return Objects.equals(this.name, ((MethodCallExpr)o).getName()) && Objects.equals(this.parameters, ((MethodCallExpr)o).getParameters());
    }
}

