/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core.expr;

import java.util.Objects;
import java.util.Optional;
import org.n52.svalbard.odata.core.expr.Expr;

public abstract class UnaryExpr<T>
implements Expr {
    private static final String TO_STRING_TEMPLATE = "(%s %s)";
    private final T operator;
    private final Expr operand;

    public UnaryExpr(T operator, Expr operand) {
        this.operator = Objects.requireNonNull(operator);
        this.operand = Objects.requireNonNull(operand);
    }

    public T getOperator() {
        return this.operator;
    }

    public Expr getOperand() {
        return this.operand;
    }

    @Override
    public Optional<UnaryExpr<?>> asUnary() {
        return Optional.of(this);
    }

    public String toString() {
        return String.format(TO_STRING_TEMPLATE, this.operator.toString(), this.operand);
    }

    public String toODataString() {
        return String.format(TO_STRING_TEMPLATE, this.operator.toString().toLowerCase(), this.operand.toODataString());
    }

    public int hashCode() {
        return Objects.hash(this.operator, this.operand);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnaryExpr)) {
            return false;
        }
        return Objects.equals(this.operator, ((UnaryExpr)o).getOperator()) && Objects.equals(this.operand, ((UnaryExpr)o).getOperand());
    }
}

