/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.odata.core.expr.bool;

import java.util.Optional;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.svalbard.odata.core.expr.BinaryExpr;
import org.n52.svalbard.odata.core.expr.Expr;
import org.n52.svalbard.odata.core.expr.ExprVisitor;
import org.n52.svalbard.odata.core.expr.bool.BooleanExpr;

public class ComparisonExpr
extends BinaryExpr<FilterConstants.ComparisonOperator>
implements BooleanExpr {
    public ComparisonExpr(FilterConstants.ComparisonOperator operator, Expr left, Expr right) {
        super(operator, left, right);
    }

    @Override
    public boolean isComparison() {
        return true;
    }

    @Override
    public Optional<ComparisonExpr> asComparison() {
        return Optional.of(this);
    }

    @Override
    public <T, X extends Throwable> T accept(ExprVisitor<T, X> visitor) throws X {
        return visitor.visitComparison(this);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ComparisonExpr)) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public String toODataString() {
        return String.format("(%s %s %s)", this.getLeft().toODataString(), this.getSTAName((FilterConstants.ComparisonOperator)this.getOperator()), this.getRight().toODataString());
    }

    private String getSTAName(FilterConstants.ComparisonOperator operator) {
        switch (operator) {
            case PropertyIsEqualTo: {
                return "eq";
            }
            case PropertyIsNotEqualTo: {
                return "ne";
            }
            case PropertyIsLessThan: {
                return "lt";
            }
            case PropertyIsGreaterThan: {
                return "gt";
            }
            case PropertyIsLessThanOrEqualTo: {
                return "le";
            }
            case PropertyIsGreaterThanOrEqualTo: {
                return "ge";
            }
        }
        throw new IllegalArgumentException(String.format("Operators %s is not supported.", operator));
    }
}

