/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.opengis.gml.x32.AbstractFeatureType;
import net.opengis.gml.x32.AbstractGMLType;
import net.opengis.gml.x32.CodeWithAuthorityType;
import net.opengis.gml.x32.ReferenceType;
import net.opengis.om.x20.NamedValuePropertyType;
import net.opengis.om.x20.NamedValueType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlDouble;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlInt;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGML;
import org.n52.shetland.ogc.gml.AbstractGeometry;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.GmlMeasureType;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.HrefAttributeValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.ReferenceValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.xlink.W3CHrefAttribute;
import org.n52.svalbard.ConformanceClass;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGmlDecoderv321<T, S>
extends AbstractXmlDecoder<T, S>
implements ConformanceClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractGmlDecoderv321.class);

    protected AbstractGML parseAbstractGMLType(AbstractGMLType agmlt, AbstractGML abstractGML) throws DecodingException {
        this.parseIdentifier(agmlt, abstractGML);
        this.parseNames(agmlt, abstractGML);
        this.paresDescription(agmlt, abstractGML);
        return abstractGML;
    }

    protected AbstractFeature parseAbstractFeatureType(AbstractFeatureType aft, AbstractFeature abstractFeature) throws DecodingException {
        this.parseAbstractGMLType((AbstractGMLType)aft, (AbstractGML)abstractFeature);
        return abstractFeature;
    }

    protected AbstractGML parseIdentifier(AbstractGMLType agmlt, AbstractGML abstractGML) throws DecodingException {
        if (agmlt.isSetIdentifier()) {
            abstractGML.setIdentifier(this.parseCodeWithAuthorityTye(agmlt.getIdentifier()));
        }
        return abstractGML;
    }

    protected AbstractGML parseNames(AbstractGMLType agmlt, AbstractGML abstractGML) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])agmlt.getNameArray())) {
            for (net.opengis.gml.x32.CodeType ct : agmlt.getNameArray()) {
                abstractGML.addName(this.parseCodeType(ct));
            }
        }
        return abstractGML;
    }

    protected AbstractGML paresDescription(AbstractGMLType agmlt, AbstractGML abstractGML) {
        if (agmlt.isSetDescription()) {
            if (agmlt.getDescription().isSetHref()) {
                abstractGML.setDescription(agmlt.getDescription().getHref());
            } else {
                abstractGML.setDescription(agmlt.getDescription().getStringValue());
            }
        }
        return abstractGML;
    }

    protected CodeWithAuthority parseCodeWithAuthorityTye(CodeWithAuthorityType xbCodeWithAuthority) {
        if (xbCodeWithAuthority.getStringValue() != null && !xbCodeWithAuthority.getStringValue().isEmpty()) {
            CodeWithAuthority sosCodeWithAuthority = new CodeWithAuthority(xbCodeWithAuthority.getStringValue());
            sosCodeWithAuthority.setCodeSpace(xbCodeWithAuthority.getCodeSpace());
            return sosCodeWithAuthority;
        }
        return null;
    }

    protected CodeType parseCodeType(net.opengis.gml.x32.CodeType element) throws DecodingException {
        CodeType codeType = new CodeType(element.getStringValue());
        if (element.isSetCodeSpace()) {
            try {
                codeType.setCodeSpace(new URI(element.getCodeSpace()));
            }
            catch (URISyntaxException e) {
                throw new DecodingException((Throwable)e, "Error while creating URI from '{}'", element.getCodeSpace(), new Object[0]);
            }
        }
        return codeType;
    }

    protected org.n52.shetland.ogc.gml.ReferenceType parseReferenceType(ReferenceType rt) {
        org.n52.shetland.ogc.gml.ReferenceType referenceType = new org.n52.shetland.ogc.gml.ReferenceType("UNKNOWN");
        if (rt.isSetTitle() && !Strings.isNullOrEmpty((String)rt.getTitle())) {
            referenceType.setTitle(rt.getTitle());
        }
        if (rt.isSetHref() && !Strings.isNullOrEmpty((String)rt.getHref())) {
            referenceType.setHref(rt.getHref());
        }
        if (rt.isSetRole() && !Strings.isNullOrEmpty((String)rt.getRole())) {
            referenceType.setRole(rt.getRole());
        }
        return referenceType;
    }

    protected List<org.n52.shetland.ogc.gml.ReferenceType> parseReferenceType(ReferenceType[] referenceTypes) {
        ArrayList list = Lists.newArrayList();
        if (CollectionHelper.isNotNullOrEmpty((Object[])referenceTypes)) {
            for (ReferenceType referenceType : referenceTypes) {
                list.add(this.parseReferenceType(referenceType));
            }
        }
        return list;
    }

    protected Set<NamedValue<?>> parseNamedValueTypeArray(NamedValuePropertyType[] namedValuePropertyArray) throws DecodingException {
        TreeSet parameters = Sets.newTreeSet();
        for (NamedValuePropertyType namedValueProperty : namedValuePropertyArray) {
            parameters.add(this.parseNamedValueType(namedValueProperty));
        }
        return parameters;
    }

    protected NamedValue<?> parseNamedValueType(NamedValuePropertyType namedValueProperty) throws DecodingException {
        if (namedValueProperty.isSetNamedValue()) {
            NamedValueType namedValue = namedValueProperty.getNamedValue();
            NamedValue<?> sosNamedValue = this.parseNamedValueValue(namedValue.getValue());
            org.n52.shetland.ogc.gml.ReferenceType referenceType = (org.n52.shetland.ogc.gml.ReferenceType)this.decodeXmlObject((XmlObject)namedValue.getName());
            sosNamedValue.setName(referenceType);
            return sosNamedValue;
        }
        if (namedValueProperty.isSetHref()) {
            NamedValue sosNamedValue = new NamedValue();
            org.n52.shetland.ogc.gml.ReferenceType referenceType = new org.n52.shetland.ogc.gml.ReferenceType(namedValueProperty.getHref());
            if (namedValueProperty.isSetTitle()) {
                referenceType.setTitle(namedValueProperty.getTitle());
            }
            sosNamedValue.setName(referenceType);
            return sosNamedValue;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)namedValueProperty);
    }

    protected NamedValue<?> parseNamedValueValue(XmlObject xml) throws DecodingException {
        Object value;
        XmlObject xmlObject = xml;
        if (xmlObject.schemaType() == XmlAnyTypeImpl.type) {
            try {
                xmlObject = XmlObject.Factory.parse((String)xml.xmlText(this.getXmlOptions()).trim());
            }
            catch (XmlException e) {
                LOGGER.error("Error while parsing NamedValueValue", (Throwable)e);
            }
        }
        if ((value = XmlBoolean.Factory.newInstance().schemaType().equals(xmlObject.schemaType()) ? Boolean.valueOf(((XmlBoolean)xmlObject).getBooleanValue()) : (XmlString.Factory.newInstance().schemaType().equals(xmlObject.schemaType()) ? ((XmlString)xmlObject).getStringValue() : (XmlInt.Factory.newInstance().schemaType().equals(xmlObject.schemaType()) ? (Number)((XmlInt)xmlObject).getIntValue() : (Number)(XmlInteger.Factory.newInstance().schemaType().equals(xmlObject.schemaType()) ? (Number)((XmlInteger)xmlObject).getBigIntegerValue().intValue() : (Number)(XmlDouble.Factory.newInstance().schemaType().equals(xmlObject.schemaType()) ? Double.valueOf(((XmlDouble)xmlObject).getDoubleValue()) : this.decodeXmlObject(xmlObject)))))) instanceof BooleanValue) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)((BooleanValue)value));
            return namedValue;
        }
        if (value instanceof SweBoolean) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new BooleanValue(((SweBoolean)value).getValue()));
            return namedValue;
        }
        if (value instanceof Boolean) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new BooleanValue((Boolean)value));
            return namedValue;
        }
        if (value instanceof CategoryValue) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)((CategoryValue)value));
            return namedValue;
        }
        if (value instanceof SweCategory) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new CategoryValue(((SweCategory)value).getValue(), ((SweCategory)value).getCodeSpace()));
            return namedValue;
        }
        if (value instanceof CountValue) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)((CountValue)value));
            return namedValue;
        }
        if (value instanceof SweCount) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new CountValue(((SweCount)value).getValue()));
            return namedValue;
        }
        if (value instanceof Integer) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new CountValue((Integer)value));
            return namedValue;
        }
        if (value instanceof GeometryValue) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)((GeometryValue)value));
            return namedValue;
        }
        if (value instanceof QuantityValue) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)((QuantityValue)value));
            return namedValue;
        }
        if (value instanceof GmlMeasureType) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new QuantityValue(((GmlMeasureType)value).getValue(), ((GmlMeasureType)value).getUnit()));
            return namedValue;
        }
        if (value instanceof SweQuantity) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new QuantityValue(((SweQuantity)value).getValue(), ((SweQuantity)value).getUom()));
            return namedValue;
        }
        if (value instanceof Double) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new QuantityValue((Double)value));
            return namedValue;
        }
        if (value instanceof TextValue) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)((TextValue)value));
            return namedValue;
        }
        if (value instanceof SweText) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new TextValue((SweText)value));
            return namedValue;
        }
        if (value instanceof String) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new TextValue((String)value));
            return namedValue;
        }
        if (value instanceof AbstractGeometry) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new GeometryValue((AbstractGeometry)value));
            return namedValue;
        }
        if (value instanceof org.n52.shetland.ogc.gml.ReferenceType) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new ReferenceValue((org.n52.shetland.ogc.gml.ReferenceType)value));
            return namedValue;
        }
        if (value instanceof W3CHrefAttribute) {
            NamedValue namedValue = new NamedValue();
            namedValue.setValue((Value)new HrefAttributeValue((W3CHrefAttribute)value));
            return namedValue;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }
}

