/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.AbstractFeatureType;
import net.opengis.om.x20.NamedValuePropertyType;
import net.opengis.om.x20.OMObservationDocument;
import net.opengis.om.x20.OMObservationType;
import net.opengis.om.x20.TimeObjectPropertyType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.apache.xmlbeans.impl.values.XmlAnyTypeImpl;
import org.locationtech.jts.geom.Geometry;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGeometry;
import org.n52.shetland.ogc.gml.GmlMeasureType;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.gml.time.IndeterminateValue;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.AbstractPhenomenon;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservableProperty;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.OmObservationConstellation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.ComplexValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.NilTemplateValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.ReferenceValue;
import org.n52.shetland.ogc.om.values.SweDataArrayValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.sensorML.SensorML;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.swe.SweAbstractDataRecord;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.w3c.Nillable;
import org.n52.svalbard.decode.AbstractOmDecoderv20;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmDecoderv20
extends AbstractOmDecoderv20 {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmDecoderv20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/om/2.0", (Class[])new Class[]{OMObservationType.class, NamedValuePropertyType.class, OMObservationDocument.class, NamedValuePropertyType[].class});
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.of((Object)OmConstants.OBS_TYPE_SWE_ARRAY_OBSERVATION_TYPE, (Object)OmConstants.OBS_TYPE_COMPLEX_OBSERVATION_TYPE, (Object)OmConstants.OBS_TYPE_GEOMETRY_OBSERVATION_TYPE, (Object)OmConstants.OBS_TYPE_CATEGORY_OBSERVATION_TYPE, (Object)OmConstants.OBS_TYPE_COUNT_OBSERVATION_TYPE, (Object)OmConstants.OBS_TYPE_MEASUREMENT_TYPE, (Object[])new SupportedType[]{OmConstants.OBS_TYPE_TEXT_OBSERVATION_TYPE, OmConstants.OBS_TYPE_TRUTH_OBSERVATION_TYPE});
    private static final Set<String> CONFORMANCE_CLASSES = ImmutableSet.of((Object)"http://www.opengis.net/spec/OMXML/2.0/conf/measurement", (Object)"http://www.opengis.net/spec/OMXML/2.0/conf/categoryObservation", (Object)"http://www.opengis.net/spec/OMXML/2.0/conf/countObservation", (Object)"http://www.opengis.net/spec/OMXML/2.0/conf/truthObservation", (Object)"http://www.opengis.net/spec/OMXML/2.0/conf/geometryObservation", (Object)"http://www.opengis.net/spec/OMXML/2.0/conf/complexObservation", (Object[])new String[]{"http://www.opengis.net/spec/OMXML/2.0/conf/textObservation"});

    public OmDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    @Override
    public Object decode(Object object) throws DecodingException {
        if (object instanceof OMObservationDocument) {
            OMObservationDocument omObservationDocument = (OMObservationDocument)object;
            return this.parseOmObservation(omObservationDocument.getOMObservation());
        }
        if (object instanceof OMObservationType) {
            return this.parseOmObservation((OMObservationType)object);
        }
        return super.decode(object);
    }

    private OmObservation parseOmObservation(OMObservationType omObservation) throws DecodingException {
        HashMap featureMap = Maps.newHashMap();
        OmObservation sosObservation = new OmObservation();
        this.parseAbstractFeatureType((AbstractFeatureType)omObservation, (AbstractFeature)sosObservation);
        OmObservationConstellation observationConstallation = this.getObservationConstellation(omObservation, featureMap);
        sosObservation.setObservationConstellation(observationConstallation);
        sosObservation.setResultTime(this.getResultTime(omObservation));
        sosObservation.setValidTime(this.getValidTime(omObservation));
        if (omObservation.getParameterArray() != null) {
            sosObservation.setParameter(this.parseNamedValueTypeArray(omObservation.getParameterArray()));
        }
        sosObservation.setValue(this.getObservationValue(omObservation));
        return sosObservation;
    }

    private OmObservationConstellation getObservationConstellation(OMObservationType omot, Map<String, AbstractFeature> featureMap) throws DecodingException {
        OmObservationConstellation observationConstellation = new OmObservationConstellation();
        observationConstellation.setObservationType(this.getObservationType(omot));
        observationConstellation.setProcedure(this.createProcedure(omot));
        observationConstellation.setObservableProperty(this.getObservableProperty(omot));
        observationConstellation.setFeatureOfInterest(this.createFeatureOfInterest(omot, featureMap));
        return observationConstellation;
    }

    private String getObservationType(OMObservationType omObservation) {
        if (omObservation.getType() != null) {
            return omObservation.getType().getHref();
        }
        return null;
    }

    private AbstractPhenomenon getObservableProperty(OMObservationType omObservation) {
        if (omObservation.getObservedProperty() != null) {
            return new OmObservableProperty(omObservation.getObservedProperty().getHref());
        }
        return null;
    }

    private Time getPhenomenonTime(OMObservationType omObservation) throws DecodingException {
        Object decodedObject;
        TimeObjectPropertyType phenomenonTime = omObservation.getPhenomenonTime();
        if (phenomenonTime.isSetHref() && phenomenonTime.getHref().startsWith("#")) {
            TimeInstant timeInstant = new TimeInstant();
            timeInstant.setGmlId(phenomenonTime.getHref());
            return timeInstant;
        }
        if (phenomenonTime.isSetNilReason() && phenomenonTime.getNilReason() instanceof String && ((String)phenomenonTime.getNilReason()).equals(IndeterminateValue.TEMPLATE.getValue())) {
            return new TimeInstant(IndeterminateValue.TEMPLATE);
        }
        if (phenomenonTime.isSetAbstractTimeObject() && (decodedObject = this.decodeXmlObject((XmlObject)phenomenonTime.getAbstractTimeObject())) instanceof Time) {
            return (Time)decodedObject;
        }
        throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested phenomenonTime type is not supported by this service!", new Object[0]);
    }

    private TimeInstant getResultTime(OMObservationType omObservation) throws DecodingException {
        if (omObservation.getResultTime().isSetHref()) {
            TimeInstant timeInstant = new TimeInstant();
            timeInstant.setGmlId(omObservation.getResultTime().getHref());
            if (omObservation.getResultTime().getHref().charAt(0) == '#') {
                timeInstant.setReference("phenomenonTime");
            } else {
                timeInstant.setReference(omObservation.getResultTime().getHref());
            }
            return timeInstant;
        }
        if (omObservation.getResultTime().isSetNilReason() && omObservation.getResultTime().getNilReason() instanceof String && Time.NilReason.template.equals((Object)Time.NilReason.getEnumForString((String)((String)omObservation.getResultTime().getNilReason())))) {
            TimeInstant timeInstant = new TimeInstant();
            timeInstant.setNilReason(Time.NilReason.getEnumForString((String)((String)omObservation.getResultTime().getNilReason())));
            return timeInstant;
        }
        if (omObservation.getResultTime().isSetTimeInstant()) {
            Object decodedObject = this.decodeXmlObject((XmlObject)omObservation.getResultTime().getTimeInstant());
            if (decodedObject instanceof TimeInstant) {
                return (TimeInstant)decodedObject;
            }
            throw OmDecoderv20.unsupportedResultTimeType();
        }
        throw OmDecoderv20.unsupportedResultTimeType();
    }

    private TimePeriod getValidTime(OMObservationType omObservation) throws DecodingException {
        if (omObservation.isSetValidTime()) {
            Object decodedObject = this.decodeXmlObject((XmlObject)omObservation.getValidTime().getTimePeriod());
            if (decodedObject instanceof TimePeriod) {
                return (TimePeriod)decodedObject;
            }
            throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested validTime type is not supported by this service!", new Object[0]);
        }
        return null;
    }

    private ObservationValue<?> getObservationValue(OMObservationType omObservation) throws DecodingException {
        Time phenomenonTime = this.getPhenomenonTime(omObservation);
        SingleObservationValue observationValue = !omObservation.getResult().getDomNode().hasChildNodes() && phenomenonTime.isSetNilReason() && phenomenonTime.getNilReason().equals((Object)Time.NilReason.template) ? new SingleObservationValue((Value)new NilTemplateValue()) : this.getResult(omObservation);
        observationValue.setPhenomenonTime(phenomenonTime);
        return observationValue;
    }

    private ObservationValue<?> getResult(OMObservationType omObservation) throws DecodingException {
        XmlObject xbResult = omObservation.getResult();
        if (xbResult.schemaType() == XmlAnyTypeImpl.type) {
            if (!xbResult.getDomNode().hasChildNodes()) {
                return new SingleObservationValue((Value)new NilTemplateValue());
            }
            try {
                xbResult = XmlObject.Factory.parse((String)xbResult.xmlText(this.getXmlOptions()).trim());
            }
            catch (XmlException e) {
                LOGGER.error("Error while parsing NamedValueValue", (Throwable)e);
            }
        }
        if (xbResult.schemaType() == XmlBoolean.type) {
            XmlBoolean xbBoolean = (XmlBoolean)xbResult;
            BooleanValue booleanValue = new BooleanValue(Boolean.valueOf(xbBoolean.getBooleanValue()));
            return new SingleObservationValue((Value)booleanValue);
        }
        if (xbResult.schemaType() == XmlInteger.type) {
            XmlInteger xbInteger = (XmlInteger)xbResult;
            CountValue countValue = new CountValue(Integer.valueOf(Integer.parseInt(xbInteger.getBigIntegerValue().toString())));
            return new SingleObservationValue((Value)countValue);
        }
        if (xbResult.schemaType() == XmlString.type) {
            XmlString xbString = (XmlString)xbResult;
            TextValue stringValue = new TextValue(xbString.getStringValue());
            return new SingleObservationValue((Value)stringValue);
        }
        Object decodedObject = this.decodeXmlObject(xbResult);
        if (decodedObject instanceof ObservationValue) {
            return (ObservationValue)decodedObject;
        }
        if (decodedObject instanceof GmlMeasureType) {
            GmlMeasureType measureType = (GmlMeasureType)decodedObject;
            QuantityValue quantitiyValue = new QuantityValue(measureType.getValue(), measureType.getUnit());
            return new SingleObservationValue((Value)quantitiyValue);
        }
        if (decodedObject instanceof ReferenceType) {
            if (omObservation.isSetType() && omObservation.getType().isSetHref() && omObservation.getType().getHref().equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ReferenceObservation")) {
                return new SingleObservationValue((Value)new ReferenceValue((ReferenceType)decodedObject));
            }
            return new SingleObservationValue((Value)new CategoryValue(((ReferenceType)decodedObject).getHref()));
        }
        if (decodedObject instanceof Geometry) {
            return new SingleObservationValue((Value)new GeometryValue((Geometry)decodedObject));
        }
        if (decodedObject instanceof AbstractGeometry) {
            SingleObservationValue result = new SingleObservationValue();
            result.setValue((Value)new GeometryValue(((AbstractGeometry)decodedObject).getGeometry()));
            return result;
        }
        if (decodedObject instanceof SweDataArray) {
            return new SingleObservationValue((Value)new SweDataArrayValue((SweDataArray)decodedObject));
        }
        if (decodedObject instanceof SweDataRecord) {
            return new SingleObservationValue((Value)new ComplexValue((SweAbstractDataRecord)((SweDataRecord)decodedObject)));
        }
        throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested result type '%s' is not supported by this service!", new Object[]{decodedObject.getClass().getSimpleName()});
    }

    private AbstractFeature checkFeatureWithMap(AbstractFeature featureOfInterest, Map<String, AbstractFeature> featureMap) {
        if (featureOfInterest.getGmlId() != null && !featureOfInterest.getGmlId().isEmpty()) {
            if (featureMap.containsKey(featureOfInterest.getGmlId())) {
                return featureMap.get(featureOfInterest.getGmlId());
            }
            featureMap.put(featureOfInterest.getGmlId(), featureOfInterest);
        }
        return featureOfInterest;
    }

    private Nillable<AbstractFeature> createProcedure(OMObservationType omObservation) {
        if (omObservation.getProcedure().isNil() || omObservation.getProcedure().isSetNilReason()) {
            if (omObservation.getProcedure().isSetNilReason()) {
                return Nillable.nil((String)omObservation.getProcedure().getNilReason().toString());
            }
        } else if (omObservation.getProcedure().isSetHref()) {
            SensorML procedure = new SensorML();
            procedure.setIdentifier(omObservation.getProcedure().getHref());
            return Nillable.of((Object)procedure);
        }
        return Nillable.nil();
    }

    private Nillable<AbstractFeature> createFeatureOfInterest(OMObservationType omot, Map<String, AbstractFeature> featureMap) throws DecodingException {
        if (omot.getFeatureOfInterest().isNil() || omot.getFeatureOfInterest().isSetNilReason()) {
            if (omot.getFeatureOfInterest().isSetNilReason()) {
                return Nillable.nil((String)omot.getFeatureOfInterest().getNilReason().toString());
            }
        } else {
            Object decodeXmlElement = this.decodeXmlElement((XmlObject)omot.getFeatureOfInterest());
            if (decodeXmlElement instanceof AbstractFeature) {
                AbstractFeature featureOfInterest = (AbstractFeature)decodeXmlElement;
                return Nillable.of((Object)this.checkFeatureWithMap(featureOfInterest, featureMap));
            }
        }
        return Nillable.nil();
    }

    private static DecodingException unsupportedResultTimeType() {
        return new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested resultTime type is not supported by this service!", new Object[0]);
    }
}

