/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.opengis.gml.x32.AbstractCRSType;
import net.opengis.gml.x32.AbstractCoordinateSystemType;
import net.opengis.gml.x32.AbstractDatumType;
import net.opengis.gml.x32.AbstractGMLType;
import net.opengis.gml.x32.AbstractGeometryType;
import net.opengis.gml.x32.AbstractRingPropertyType;
import net.opengis.gml.x32.AbstractRingType;
import net.opengis.gml.x32.AggregationType;
import net.opengis.gml.x32.CodeType;
import net.opengis.gml.x32.CodeWithAuthorityType;
import net.opengis.gml.x32.CoordinateSystemAxisDocument;
import net.opengis.gml.x32.CoordinateSystemAxisPropertyType;
import net.opengis.gml.x32.CoordinateSystemAxisType;
import net.opengis.gml.x32.CurvePropertyType;
import net.opengis.gml.x32.DefinitionType;
import net.opengis.gml.x32.DirectPositionListType;
import net.opengis.gml.x32.DirectPositionType;
import net.opengis.gml.x32.DomainOfValidityDocument;
import net.opengis.gml.x32.EnvelopeType;
import net.opengis.gml.x32.FeatureCollectionDocument;
import net.opengis.gml.x32.FeatureCollectionType;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.gml.x32.GenericMetaDataDocument;
import net.opengis.gml.x32.GenericMetaDataType;
import net.opengis.gml.x32.GeometryPropertyType;
import net.opengis.gml.x32.LineStringDocument;
import net.opengis.gml.x32.LineStringType;
import net.opengis.gml.x32.LinearRingType;
import net.opengis.gml.x32.MeasureType;
import net.opengis.gml.x32.MultiCurveDocument;
import net.opengis.gml.x32.MultiCurveType;
import net.opengis.gml.x32.MultiPointDocument;
import net.opengis.gml.x32.MultiPointType;
import net.opengis.gml.x32.PointDocument;
import net.opengis.gml.x32.PointType;
import net.opengis.gml.x32.PolygonDocument;
import net.opengis.gml.x32.PolygonType;
import net.opengis.gml.x32.ReferenceType;
import net.opengis.gml.x32.TimeIndeterminateValueType;
import net.opengis.gml.x32.TimeInstantDocument;
import net.opengis.gml.x32.TimeInstantPropertyType;
import net.opengis.gml.x32.TimeInstantType;
import net.opengis.gml.x32.TimePeriodDocument;
import net.opengis.gml.x32.TimePeriodPropertyType;
import net.opengis.gml.x32.TimePeriodType;
import net.opengis.gml.x32.TimePositionType;
import net.opengis.gml.x32.VerticalCRSPropertyType;
import net.opengis.gml.x32.VerticalCRSType;
import net.opengis.gml.x32.VerticalCSDocument;
import net.opengis.gml.x32.VerticalCSPropertyType;
import net.opengis.gml.x32.VerticalCSType;
import net.opengis.gml.x32.VerticalDatumDocument;
import net.opengis.gml.x32.VerticalDatumPropertyType;
import net.opengis.gml.x32.VerticalDatumType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.isotc211.x2005.gmd.EXExtentType;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.janmayen.function.Predicates;
import org.n52.shetland.ogc.HasDefaultEncoding;
import org.n52.shetland.ogc.gml.AbstractCRS;
import org.n52.shetland.ogc.gml.AbstractCoordinateSystem;
import org.n52.shetland.ogc.gml.AbstractDatum;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGML;
import org.n52.shetland.ogc.gml.AbstractGeometry;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.CoordinateSystemAxis;
import org.n52.shetland.ogc.gml.Definition;
import org.n52.shetland.ogc.gml.DomainOfValidity;
import org.n52.shetland.ogc.gml.GenericMetaData;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.VerticalCRS;
import org.n52.shetland.ogc.gml.VerticalCS;
import org.n52.shetland.ogc.gml.VerticalDatum;
import org.n52.shetland.ogc.gml.time.IndeterminateValue;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.gml.time.TimePosition;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.util.CRSHelper;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.EnvelopeOrGeometry;
import org.n52.shetland.util.IdGenerator;
import org.n52.shetland.util.JTSHelper;
import org.n52.shetland.util.MinMax;
import org.n52.shetland.util.OMHelper;
import org.n52.shetland.util.ReferencedEnvelope;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Actuate;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.shetland.w3c.xlink.Show;
import org.n52.shetland.w3c.xlink.Type;
import org.n52.svalbard.encode.AbstractGmlEncoderv321;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.ActuateType;
import org.w3.x1999.xlink.ShowType;
import org.w3.x1999.xlink.TypeType;

@Configurable
public class GmlEncoderv321
extends AbstractGmlEncoderv321<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GmlEncoderv321.class);
    private static final Set<EncoderKey> ENCODER_KEY_TYPES = CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/gml/3.2", (Class[])new Class[]{Time.class, Geometry.class, CategoryValue.class, org.n52.shetland.ogc.gml.ReferenceType.class, QuantityValue.class, CodeWithAuthority.class, CodeType.class, SamplingFeature.class, ReferencedEnvelope.class, EnvelopeOrGeometry.class, FeatureCollection.class, AbstractGeometry.class});
    private String srsNamePrefixURL = "http://www.opengis.net/def/crs/EPSG/0/";
    private String srsNamePrefixURN = "urn:ogc:def:crs:EPSG::";

    public GmlEncoderv321() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEY_TYPES));
    }

    @Setting(value="coding.srsNamePrefixURL", required=false)
    public void setSrsNamePrefixURL(String prefix) {
        this.srsNamePrefixURL = CRSHelper.asHttpPrefix((String)prefix);
    }

    @Setting(value="coding.srsNamePrefixURN", required=false)
    public void setSrsNamePrefixURN(String prefix) {
        this.srsNamePrefixURN = CRSHelper.asUrnPrefix((String)prefix);
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEY_TYPES);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/gml/3.2", "gml");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{GmlConstants.GML_32_SCHEMAL_LOCATION});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XmlObject encode(Object element, EncodingContext ctx) throws EncodingException {
        XmlObject encodedObject = null;
        if (element instanceof Time) {
            return this.createTime((Time)element, ctx);
        }
        if (element instanceof Geometry) {
            return this.createPosition((Geometry)element, ctx);
        }
        if (element instanceof CategoryValue) {
            return this.createReferenceTypeForCategroyValue((CategoryValue)element);
        }
        if (element instanceof org.n52.shetland.ogc.gml.ReferenceType) {
            return this.createReferencType((org.n52.shetland.ogc.gml.ReferenceType)element);
        }
        if (element instanceof CodeWithAuthority) {
            return this.createCodeWithAuthorityType((CodeWithAuthority)element);
        }
        if (element instanceof QuantityValue) {
            return this.createMeasureType((QuantityValue)element);
        }
        if (element instanceof CodeType) {
            return this.createCodeType((CodeType)element);
        }
        if (element instanceof AbstractFeature) {
            return this.createFeaturePropertyType((AbstractFeature)element, ctx);
        }
        if (element instanceof AbstractGeometry) {
            return this.createGeomteryPropertyType((AbstractGeometry)element, ctx);
        }
        if (element instanceof ReferencedEnvelope) {
            return this.createEnvelope((ReferencedEnvelope)element);
        }
        if (element instanceof EnvelopeOrGeometry) {
            if (((EnvelopeOrGeometry)element).isEnvelope()) {
                return this.createEnvelope((ReferencedEnvelope)((EnvelopeOrGeometry)element).getEnvelope().get());
            }
            if (!((EnvelopeOrGeometry)element).isGeometry()) throw new UnsupportedEncoderInputException((Encoder)this, element);
            return this.createPosition((Geometry)((EnvelopeOrGeometry)element).getGeometry().get(), ctx);
        }
        if (element instanceof GenericMetaData) {
            return this.createGenericMetaData((GenericMetaData)element, ctx);
        }
        if (element instanceof VerticalDatum) {
            return this.createVerticalDatum((VerticalDatum)element, ctx);
        }
        if (element instanceof DomainOfValidity) {
            return this.createDomainOfValidity((DomainOfValidity)element, ctx);
        }
        if (element instanceof VerticalCRS) {
            return this.createVerticalCRS((VerticalCRS)element, ctx);
        }
        if (element instanceof VerticalCS) {
            return this.createVerticalCS((VerticalCS)element, ctx);
        }
        if (!(element instanceof CoordinateSystemAxis)) throw new UnsupportedEncoderInputException((Encoder)this, element);
        return this.createCoordinateSystemAxis((CoordinateSystemAxis)element, ctx);
    }

    private XmlObject createFeaturePropertyType(AbstractFeature feature, EncodingContext ctx) throws EncodingException {
        if (feature instanceof FeatureCollection) {
            return this.createFeatureCollection((FeatureCollection)feature, ctx);
        }
        if (feature instanceof SamplingFeature) {
            return this.createFeature(feature, ctx);
        }
        if (feature.isSetDefaultElementEncoding()) {
            return this.encodeObjectToXml(feature.getDefaultElementEncoding(), feature);
        }
        if (ctx.has((Enum)XmlEncoderFlags.ENCODE_NAMESPACE) && ctx.get((Enum)XmlEncoderFlags.ENCODE_NAMESPACE).isPresent()) {
            return this.encodeObjectToXml((String)ctx.get((Enum)XmlEncoderFlags.ENCODE_NAMESPACE).get(), feature, ctx);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)feature);
    }

    private XmlObject createFeatureCollection(FeatureCollection element, EncodingContext ctx) throws EncodingException {
        FeatureCollectionDocument featureCollectionDoc = FeatureCollectionDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        FeatureCollectionType featureCollection = featureCollectionDoc.addNewFeatureCollection();
        featureCollection.setId(element.getGmlId());
        EncodingContext context = ctx.with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE).without((Enum)XmlBeansEncodingFlags.DOCUMENT);
        if (element.isSetMembers()) {
            for (AbstractFeature abstractFeature : element.getMembers().values()) {
                featureCollection.addNewFeatureMember().set(this.createFeaturePropertyType(abstractFeature, context));
            }
        }
        if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            return featureCollectionDoc;
        }
        FeaturePropertyType featurePropertyType = FeaturePropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        featurePropertyType.addNewAbstractFeature().set((XmlObject)featureCollection);
        return XmlHelper.substituteElement((XmlObject)featurePropertyType.getAbstractFeature(), (XmlObject)featurePropertyType);
    }

    private XmlObject createFeature(AbstractFeature feature, EncodingContext ctx) throws EncodingException {
        FeaturePropertyType featurePropertyType = FeaturePropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (this.isNotSamplingFeature(feature) || ctx.has((Enum)XmlBeansEncodingFlags.REFERENCED)) {
            featurePropertyType.setHref(feature.getIdentifierCodeWithAuthority().getValue());
            return featurePropertyType;
        }
        AbstractSamplingFeature samplingFeature = (AbstractSamplingFeature)feature;
        if (samplingFeature.isSetGmlID() && samplingFeature.isEncoded()) {
            featurePropertyType.setHref("#" + samplingFeature.getGmlId());
            return featurePropertyType;
        }
        if (ctx.has((Enum)XmlBeansEncodingFlags.ENCODE) && !ctx.getBoolean((Enum)XmlBeansEncodingFlags.ENCODE) || !samplingFeature.isEncode()) {
            featurePropertyType.setHref(feature.getIdentifierCodeWithAuthority().getValue());
            if (feature instanceof SamplingFeature && samplingFeature.isSetName()) {
                featurePropertyType.setTitle(samplingFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        if (!samplingFeature.isSetGeometry()) {
            featurePropertyType.setHref(samplingFeature.getIdentifierCodeWithAuthority().getValue());
            if (samplingFeature.isSetName()) {
                featurePropertyType.setTitle(samplingFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        if (samplingFeature.isSetUrl()) {
            featurePropertyType.setHref(samplingFeature.getUrl());
            if (samplingFeature.isSetName()) {
                featurePropertyType.setTitle(samplingFeature.getFirstName().getValue());
            }
            return featurePropertyType;
        }
        String namespace = ctx.getString((Enum)XmlEncoderFlags.ENCODE_NAMESPACE).orElseGet(() -> samplingFeature.isSetDefaultElementEncoding() ? samplingFeature.getDefaultElementEncoding() : OMHelper.getNamespaceForFeatureType((String)samplingFeature.getFeatureType()));
        XmlObject encodedXmlObject = this.encodeObjectToXml(namespace, samplingFeature);
        if (encodedXmlObject != null) {
            return encodedXmlObject;
        }
        if (feature.isSetXml()) {
            try {
                return XmlObject.Factory.parse((String)feature.getXml());
            }
            catch (XmlException xmle) {
                throw new EncodingException("Error while encoding featurePropertyType!", (Throwable)xmle);
            }
        }
        featurePropertyType.setHref(feature.getIdentifierCodeWithAuthority().getValue());
        if (samplingFeature.isSetName()) {
            featurePropertyType.setTitle(feature.getFirstName().getValue());
        }
        return featurePropertyType;
    }

    @Override
    protected XmlObject createFeature(FeaturePropertyType featurePropertyType, AbstractFeature abstractFeature, EncodingContext ctx) throws EncodingException {
        return featurePropertyType.set(this.createFeature(abstractFeature, ctx));
    }

    private boolean isNotSamplingFeature(AbstractFeature feature) {
        return !(feature instanceof SamplingFeature);
    }

    private XmlObject createEnvelope(ReferencedEnvelope sosEnvelope) {
        int srid = sosEnvelope.getSrid();
        EnvelopeType envelopeType = EnvelopeType.Factory.newInstance();
        MinMax minmax = sosEnvelope.getMinMaxFromEnvelope();
        envelopeType.addNewLowerCorner().setStringValue((String)minmax.getMinimum());
        envelopeType.addNewUpperCorner().setStringValue((String)minmax.getMaximum());
        envelopeType.setSrsName(this.getSrsName(srid));
        return envelopeType;
    }

    private XmlObject createTime(Time time, EncodingContext ctx) throws EncodingException {
        if (time == null) {
            return null;
        }
        if (time instanceof TimeInstant) {
            TimeInstant instant = (TimeInstant)time;
            if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                return this.createTimeInstantDocument(instant);
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                return this.createTimeInstantPropertyType(instant);
            }
            return this.createTimeInstantType(instant);
        }
        if (time instanceof TimePeriod) {
            TimePeriod period = (TimePeriod)time;
            if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                return this.createTimePeriodDocument(period);
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                return this.createTimePeriodPropertyType(period);
            }
            return this.createTimePeriodType(period);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)time);
    }

    private XmlObject createTimePeriodDocument(TimePeriod time) throws EncodingException {
        TimePeriodDocument timePeriodDoc = TimePeriodDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimePeriodType(time, timePeriodDoc.addNewTimePeriod());
        return timePeriodDoc;
    }

    private XmlObject createTimePeriodPropertyType(TimePeriod time) throws EncodingException {
        TimePeriodPropertyType timePeriodPropertyType = TimePeriodPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimePeriodType(time, timePeriodPropertyType.addNewTimePeriod());
        return timePeriodPropertyType;
    }

    private void createTimePeriodType(TimePeriod timePeriod, TimePeriodType timePeriodType) throws EncodingException {
        if (timePeriod.getGmlId() != null && !timePeriod.getGmlId().isEmpty()) {
            timePeriodType.setId(timePeriod.getGmlId());
        } else {
            timePeriodType.setId("tp_" + IdGenerator.generate((String)(timePeriod.toString() + System.currentTimeMillis())));
        }
        timePeriodType.setBeginPosition(this.createTimePositionType(timePeriod.getStartTimePosition()));
        timePeriodType.setEndPosition(this.createTimePositionType(timePeriod.getEndTimePosition()));
    }

    private TimePeriodType createTimePeriodType(TimePeriod timePeriod) throws EncodingException {
        TimePeriodType timePeriodType = TimePeriodType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimePeriodType(timePeriod, timePeriodType);
        return timePeriodType;
    }

    private XmlObject createTimeInstantDocument(TimeInstant time) throws EncodingException {
        TimeInstantDocument timeInstantDoc = TimeInstantDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimeInstantType(time, timeInstantDoc.addNewTimeInstant());
        return timeInstantDoc;
    }

    private XmlObject createTimeInstantPropertyType(TimeInstant time) throws EncodingException {
        TimeInstantPropertyType timeInstantPropertyType = TimeInstantPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimeInstantType(time, timeInstantPropertyType.addNewTimeInstant());
        return timeInstantPropertyType;
    }

    private void createTimeInstantType(TimeInstant timeInstant, TimeInstantType timeInstantType) throws EncodingException {
        if (timeInstant.isSetGmlId()) {
            timeInstantType.setId(timeInstant.getGmlId());
        } else {
            timeInstantType.setId("ti_" + IdGenerator.generate((String)(timeInstantType.toString() + System.currentTimeMillis())));
        }
        timeInstantType.setTimePosition(this.createTimePositionType(timeInstant.getTimePosition()));
    }

    private TimeInstantType createTimeInstantType(TimeInstant timeInstant) throws EncodingException {
        TimeInstantType timeInstantType = TimeInstantType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimeInstantType(timeInstant, timeInstantType);
        return timeInstantType;
    }

    private TimePositionType createTimePositionType(TimePosition timePosition) throws DateTimeFormatException {
        TimePositionType xbTimePosition = TimePositionType.Factory.newInstance();
        if (!timePosition.isSetTime()) {
            String indeterminateValue = Optional.ofNullable(timePosition.getIndeterminateValue()).orElse(IndeterminateValue.UNKNOWN).getValue();
            if (TimeIndeterminateValueType.Enum.forString((String)indeterminateValue) != null) {
                xbTimePosition.setIndeterminatePosition(TimeIndeterminateValueType.Enum.forString((String)indeterminateValue));
            } else {
                xbTimePosition.setStringValue(indeterminateValue);
            }
        } else {
            String endString = DateTimeHelper.formatDateTime2String((TimePosition)timePosition);
            xbTimePosition.setStringValue(endString);
        }
        return xbTimePosition;
    }

    private XmlObject createGeomteryPropertyType(AbstractGeometry element, EncodingContext ctx) throws EncodingException {
        GeometryPropertyType geometryPropertyType = GeometryPropertyType.Factory.newInstance();
        if (element.isReferenced()) {
            geometryPropertyType.setHref(element.getGmlId());
        } else {
            AbstractGeometryType xmlObject = this.createAbstractGeometry(element, ctx);
            geometryPropertyType.setAbstractGeometry(xmlObject);
            XmlHelper.substituteElement((XmlObject)geometryPropertyType.getAbstractGeometry(), (XmlObject)xmlObject);
        }
        return geometryPropertyType;
    }

    private AbstractGeometryType createAbstractGeometry(AbstractGeometry element, EncodingContext ctx) throws EncodingException {
        XmlObject xbGeometry = this.createPosition(element.getGeometry(), ctx);
        AbstractGeometryType abstractGeometryType = null;
        if (xbGeometry instanceof AbstractGeometryType) {
            abstractGeometryType = (AbstractGeometryType)xbGeometry;
        } else if (xbGeometry instanceof GeometryPropertyType) {
            abstractGeometryType = ((GeometryPropertyType)xbGeometry).getAbstractGeometry();
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)element);
        }
        if (element.isSetIdentifier()) {
            abstractGeometryType.setIdentifier(this.createCodeWithAuthorityType(element.getIdentifierCodeWithAuthority()));
        }
        if (element.isSetName()) {
            for (CodeType codeType : element.getName()) {
                abstractGeometryType.addNewName().set((XmlObject)this.createCodeType(codeType));
            }
        }
        if (element.isSetDescription()) {
            abstractGeometryType.addNewDescription().setStringValue(element.getDescription());
        }
        return abstractGeometryType;
    }

    private XmlObject createPosition(Geometry geom, EncodingContext ctx) throws EncodingException {
        String foiId = ctx.get((Enum)XmlBeansEncodingFlags.GMLID).orElse(null);
        if (geom instanceof Point) {
            PointType xbPoint = PointType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            xbPoint.setId(this.getGmlID(geom, foiId));
            this.createPointFromJtsGeometry((Point)geom, xbPoint);
            if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                PointDocument xbPointDoc = PointDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                xbPointDoc.setPoint(xbPoint);
                return xbPointDoc;
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                GeometryPropertyType geometryPropertyType = GeometryPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                geometryPropertyType.setAbstractGeometry((AbstractGeometryType)xbPoint);
                geometryPropertyType.getAbstractGeometry().substitute(GmlConstants.QN_POINT_32, PointType.type);
                return geometryPropertyType;
            }
            return xbPoint;
        }
        if (geom instanceof LineString) {
            LineStringType xbLineString = LineStringType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            xbLineString.setId(this.getGmlID(geom, foiId));
            this.createLineStringFromJtsGeometry((LineString)geom, xbLineString);
            if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                LineStringDocument xbLineStringDoc = LineStringDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                xbLineStringDoc.setLineString(xbLineString);
                return xbLineStringDoc;
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                GeometryPropertyType geometryPropertyType = GeometryPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                geometryPropertyType.setAbstractGeometry((AbstractGeometryType)xbLineString);
                geometryPropertyType.getAbstractGeometry().substitute(GmlConstants.QN_LINESTRING_32, LineStringType.type);
                return geometryPropertyType;
            }
            return xbLineString;
        }
        if (geom instanceof MultiLineString) {
            MultiCurveType xbMultiCurve = MultiCurveType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            xbMultiCurve.setId(this.getGmlID(geom, foiId));
            xbMultiCurve.setSrsName(this.getSrsName(geom));
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                Geometry lineString = geom.getGeometryN(i);
                LineStringType xbLineString = LineStringType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                xbLineString.setId(this.getGmlID(geom, foiId));
                xbLineString.addNewPosList().setStringValue(JTSHelper.getCoordinatesString((Geometry)lineString));
                CurvePropertyType xbCurveMember = xbMultiCurve.addNewCurveMember();
                xbCurveMember.addNewAbstractCurve().set((XmlObject)xbLineString);
                XmlHelper.substituteElement((XmlObject)xbCurveMember.getAbstractCurve(), (XmlObject)xbLineString);
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                MultiCurveDocument xbMultiCurveDoc = MultiCurveDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                xbMultiCurveDoc.setMultiCurve(xbMultiCurve);
                return xbMultiCurveDoc;
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                GeometryPropertyType xbGeometryProperty = GeometryPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                xbGeometryProperty.addNewAbstractGeometry().set((XmlObject)xbMultiCurve);
                XmlHelper.substituteElement((XmlObject)xbGeometryProperty.getAbstractGeometry(), (XmlObject)xbMultiCurve);
                return xbGeometryProperty;
            }
            return xbMultiCurve;
        }
        if (geom instanceof Polygon) {
            PolygonType xbPolygon = PolygonType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            xbPolygon.setId(this.getGmlID(geom, foiId));
            this.createPolygonFromJtsGeometry((Polygon)geom, xbPolygon);
            if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                PolygonDocument xbPolygonDoc = PolygonDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                xbPolygonDoc.setPolygon(xbPolygon);
                return xbPolygonDoc;
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                GeometryPropertyType geometryPropertyType = GeometryPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                geometryPropertyType.setAbstractGeometry((AbstractGeometryType)xbPolygon);
                geometryPropertyType.getAbstractGeometry().substitute(GmlConstants.QN_POLYGON_32, PolygonType.type);
                return geometryPropertyType;
            }
            return xbPolygon;
        }
        if (geom instanceof MultiPoint) {
            MultiPointType xbMultiPoint = MultiPointType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            String id = this.getGmlID(geom, foiId);
            xbMultiPoint.setId(id);
            this.createMultiPointFromJtsGeometry((MultiPoint)geom, xbMultiPoint, id);
            if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                MultiPointDocument xbMultiPointDoc = MultiPointDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                xbMultiPointDoc.setMultiPoint(xbMultiPoint);
                return xbMultiPointDoc;
            }
            if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
                GeometryPropertyType geometryPropertyType = GeometryPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                geometryPropertyType.setAbstractGeometry((AbstractGeometryType)xbMultiPoint);
                geometryPropertyType.getAbstractGeometry().substitute(GmlConstants.QN_MULTI_POINT_32, PolygonType.type);
                return geometryPropertyType;
            }
            return xbMultiPoint;
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)geom);
    }

    private String getGmlID(Geometry geom, String gmlId) {
        String id = !Strings.isNullOrEmpty((String)gmlId) ? gmlId : (geom.getUserData() != null && geom.getUserData() instanceof Map && ((Map)geom.getUserData()).containsKey(XmlBeansEncodingFlags.GMLID.name()) ? (String)((Map)geom.getUserData()).get(XmlBeansEncodingFlags.GMLID.name()) : IdGenerator.generate((String)geom.toText()));
        return geom.getGeometryType() + "_" + id;
    }

    private void createPointFromJtsGeometry(Point jtsPoint, PointType xbPoint) {
        DirectPositionType xbPos = xbPoint.addNewPos();
        xbPos.setSrsName(this.getSrsName((Geometry)jtsPoint));
        xbPos.setStringValue(JTSHelper.getCoordinatesString((Geometry)jtsPoint));
    }

    private void createLineStringFromJtsGeometry(LineString jtsLineString, LineStringType xbLst) {
        String srsName = this.getSrsName((Geometry)jtsLineString);
        xbLst.setSrsName(srsName);
        DirectPositionListType xbPosList = xbLst.addNewPosList();
        xbPosList.setSrsName(srsName);
        xbPosList.setStringValue(JTSHelper.getCoordinatesString((Geometry)jtsLineString));
    }

    private void createPolygonFromJtsGeometry(Polygon jtsPolygon, PolygonType xbPolType) {
        List jtsPolygons = PolygonExtracter.getPolygons((Geometry)jtsPolygon);
        String srsName = this.getSrsName((Geometry)jtsPolygon);
        for (int i = 0; i < jtsPolygons.size(); ++i) {
            Polygon pol = (Polygon)jtsPolygons.get(i);
            AbstractRingPropertyType xbArpt = xbPolType.addNewExterior();
            AbstractRingType xbArt = xbArpt.addNewAbstractRing();
            LinearRingType xbLrt = LinearRingType.Factory.newInstance();
            Coordinate[] ring = JTSHelper.getExteriorRingCoordinatesFromPolygon((Polygon)pol);
            DirectPositionListType xbPosList = xbLrt.addNewPosList();
            xbPosList.setSrsName(srsName);
            xbPosList.setStringValue(JTSHelper.getCoordinatesString((Coordinate[])ring));
            xbArt.set((XmlObject)xbLrt);
            XmlCursor cursor = xbArpt.newCursor();
            if (cursor.toChild(GmlConstants.QN_ABSTRACT_RING_32)) {
                cursor.setName(GmlConstants.QN_LINEAR_RING_32);
            }
            cursor.dispose();
            int numberOfInteriorRings = pol.getNumInteriorRing();
            for (int ringNumber = 0; ringNumber < numberOfInteriorRings; ++ringNumber) {
                xbArpt = xbPolType.addNewInterior();
                xbArt = xbArpt.addNewAbstractRing();
                xbLrt = LinearRingType.Factory.newInstance();
                xbPosList = xbLrt.addNewPosList();
                xbPosList.setSrsName(srsName);
                xbPosList.setStringValue(JTSHelper.getCoordinatesString((Geometry)pol.getInteriorRingN(ringNumber)));
                xbArt.set((XmlObject)xbLrt);
                cursor = xbArpt.newCursor();
                if (cursor.toChild(GmlConstants.QN_ABSTRACT_RING_32)) {
                    cursor.setName(GmlConstants.QN_LINEAR_RING_32);
                }
                cursor.dispose();
            }
        }
    }

    private void createMultiPointFromJtsGeometry(MultiPoint geom, MultiPointType xbMultiPoint, String id) throws EncodingException {
        for (int i = 0; i < geom.getNumGeometries(); ++i) {
            Geometry geometry = geom.getGeometryN(i);
            if (!(geometry instanceof Point)) continue;
            PointType pt = xbMultiPoint.addNewPointMember().addNewPoint();
            pt.setId(id + "_" + i);
            this.createPointFromJtsGeometry((Point)geometry, pt);
        }
    }

    private XmlObject createReferenceTypeForCategroyValue(CategoryValue categoryValue) {
        ReferenceType xbRef = ReferenceType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (categoryValue.isSetValue()) {
            if (categoryValue.getValue().startsWith("http://")) {
                xbRef.setHref(categoryValue.getValue());
            } else {
                xbRef.setTitle(categoryValue.getValue());
            }
            if (categoryValue.isSetUnit()) {
                xbRef.setRole(categoryValue.getUnit());
            }
        } else {
            xbRef.setNil();
        }
        return xbRef;
    }

    private ReferenceType createReferencType(org.n52.shetland.ogc.gml.ReferenceType sosReferenceType) {
        if (!sosReferenceType.isSetHref()) {
            String exceptionText = String.format("The required 'href' parameter is empty for encoding %s!", ReferenceType.class.getName());
            LOGGER.error(exceptionText);
            throw new IllegalArgumentException(exceptionText);
        }
        ReferenceType referenceType = ReferenceType.Factory.newInstance();
        referenceType.setHref(sosReferenceType.getHref());
        if (sosReferenceType.isSetTitle()) {
            referenceType.setTitle(sosReferenceType.getTitle());
        }
        if (sosReferenceType.isSetRole()) {
            referenceType.setRole(sosReferenceType.getRole());
        }
        return referenceType;
    }

    private CodeWithAuthorityType createCodeWithAuthorityType(CodeWithAuthority sosCodeWithAuthority) throws EncodingException {
        if (!sosCodeWithAuthority.isSetValue()) {
            throw GmlEncoderv321.missingValueParameter(CodeWithAuthorityType.class.getName());
        }
        CodeWithAuthorityType codeWithAuthority = CodeWithAuthorityType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        codeWithAuthority.setStringValue(sosCodeWithAuthority.getValue());
        codeWithAuthority.setCodeSpace(Optional.ofNullable(sosCodeWithAuthority.getCodeSpace()).filter(Predicates.not(String::isEmpty)).orElse("http://www.opengis.net/def/nil/OGC/0/unknown"));
        return codeWithAuthority;
    }

    private net.opengis.gml.x32.CodeType createCodeType(CodeType sosCodeType) throws EncodingException {
        if (!sosCodeType.isSetValue()) {
            throw GmlEncoderv321.missingValueParameter(net.opengis.gml.x32.CodeType.class.getName());
        }
        net.opengis.gml.x32.CodeType codeType = CodeType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        codeType.setStringValue(sosCodeType.getValue());
        codeType.setCodeSpace(Optional.ofNullable(sosCodeType.getCodeSpace()).map(URI::toString).filter(Predicates.not(String::isEmpty)).orElse("http://www.opengis.net/def/nil/OGC/0/unknown"));
        return codeType;
    }

    private XmlObject createGenericMetaData(GenericMetaData element, EncodingContext ctx) throws EncodingException {
        GenericMetaDataDocument gmdd = GenericMetaDataDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GenericMetaDataType gmdt = gmdd.addNewGenericMetaData();
        if (element.getContent() instanceof HasDefaultEncoding && ((HasDefaultEncoding)element.getContent()).isSetDefaultElementEncoding()) {
            gmdt.set(this.encodeObjectToXml(((HasDefaultEncoding)element.getContent()).getDefaultElementEncoding(), element.getContent(), new EncodingContext().with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE, (Object)true)));
        }
        if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            return gmdd;
        }
        return gmdt;
    }

    protected MeasureType createMeasureType(QuantityValue quantityValue) throws EncodingException {
        if (!quantityValue.isSetValue()) {
            throw GmlEncoderv321.missingValueParameter(MeasureType.class.getName());
        }
        MeasureType measureType = MeasureType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        measureType.setDoubleValue(quantityValue.getValue().doubleValue());
        measureType.setUom(Optional.ofNullable(quantityValue.getUnit()).filter(Predicates.not(String::isEmpty)).orElse("http://www.opengis.net/def/nil/OGC/0/unknown"));
        return measureType;
    }

    private XmlObject createVerticalDatum(VerticalDatum verticalDatum, EncodingContext ctx) throws EncodingException {
        VerticalDatumType vdt = VerticalDatumType.Factory.newInstance();
        this.addAbstractDatumValues((AbstractDatumType)vdt, (AbstractDatum)verticalDatum, ctx);
        if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            VerticalDatumDocument vdd = VerticalDatumDocument.Factory.newInstance();
            VerticalDatumPropertyType vdpt = VerticalDatumPropertyType.Factory.newInstance();
            vdpt.setVerticalDatum(vdt);
            vdd.setVerticalDatum(vdpt);
            return vdd;
        }
        if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            VerticalDatumPropertyType vdpt = VerticalDatumPropertyType.Factory.newInstance();
            vdpt.setVerticalDatum(vdt);
            return vdpt;
        }
        return vdt;
    }

    private void addAbstractDatumValues(AbstractDatumType adt, AbstractDatum abstractDatum, EncodingContext ctx) throws EncodingException {
        this.addDefinitonValues((DefinitionType)adt, (Definition)abstractDatum);
        if (abstractDatum.hasAnchorDefinition()) {
            adt.setAnchorDefinition(this.createCodeType(abstractDatum.getAnchorDefinition()));
        }
        if (abstractDatum.hasDomainOfValidity()) {
            DomainOfValidityDocument.DomainOfValidity dov = adt.addNewDomainOfValidity();
            Referenceable domainOfValidity = abstractDatum.getDomainOfValidity();
            if (domainOfValidity.isReference()) {
                Reference reference = domainOfValidity.getReference();
                reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setActuate(arg_0));
                reference.getArcrole().ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setArcrole(arg_0));
                reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setHref(arg_0));
                reference.getRole().ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setRole(arg_0));
                reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setShow(arg_0));
                reference.getTitle().ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setTitle(arg_0));
                reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setType(arg_0));
            } else if (domainOfValidity.isInstance()) {
                Nillable nillable = domainOfValidity.getInstance();
                if (nillable.isPresent()) {
                    DomainOfValidityDocument.DomainOfValidity xml = this.createDomainOfValidity((DomainOfValidity)nillable.get(), EncodingContext.empty());
                    if (xml != null) {
                        dov.set((XmlObject)xml);
                    } else {
                        dov.setNil();
                        dov.setNilReason(Nillable.missing().get());
                    }
                } else {
                    dov.setNil();
                    if (nillable.hasReason()) {
                        dov.setNilReason(nillable.getNilReason().get());
                    } else {
                        dov.setNilReason(Nillable.missing().get());
                    }
                }
            }
        }
        if (abstractDatum.hasRealizationEpoch()) {
            adt.setRealizationEpoch(abstractDatum.getRealizationEpoch().toCalendar(Locale.ROOT));
        }
        abstractDatum.getScope().forEach(scope -> adt.addNewScope().setStringValue(scope));
    }

    private DomainOfValidityDocument.DomainOfValidity createDomainOfValidity(DomainOfValidity domainOfValidity, EncodingContext ctx) throws EncodingException {
        DomainOfValidityDocument.DomainOfValidity dov = DomainOfValidityDocument.DomainOfValidity.Factory.newInstance();
        if (domainOfValidity.hasExExtent()) {
            EXExtentType exet = dov.addNewEXExtent();
            XmlObject xml = this.encodeObjectToXml(domainOfValidity.getExExtent().getDefaultElementEncoding(), domainOfValidity.getExExtent());
            if (xml != null) {
                exet.set(xml);
            }
        }
        return dov;
    }

    private XmlObject createVerticalCRS(VerticalCRS verticalCRS, EncodingContext ctx) throws EncodingException {
        VerticalCRSType vcrst = VerticalCRSType.Factory.newInstance();
        this.addAbstractCRSValues((AbstractCRSType)vcrst, (AbstractCRS)verticalCRS);
        Referenceable verticalCS = verticalCRS.getVerticalCS();
        VerticalCSPropertyType vcspt = vcrst.addNewVerticalCS();
        if (verticalCS.isReference()) {
            Reference reference = verticalCS.getReference();
            reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((VerticalCSPropertyType)vcspt).setActuate(arg_0));
            reference.getArcrole().ifPresent(arg_0 -> ((VerticalCSPropertyType)vcspt).setArcrole(arg_0));
            reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((VerticalCSPropertyType)vcspt).setHref(arg_0));
            reference.getRole().ifPresent(arg_0 -> ((VerticalCSPropertyType)vcspt).setRole(arg_0));
            reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((VerticalCSPropertyType)vcspt).setShow(arg_0));
            reference.getTitle().ifPresent(arg_0 -> ((VerticalCSPropertyType)vcspt).setTitle(arg_0));
            reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((VerticalCSPropertyType)vcspt).setType(arg_0));
        } else if (verticalCS.isInstance()) {
            Nillable nillable = verticalCS.getInstance();
            if (nillable.isPresent()) {
                XmlObject xml = this.createVerticalCS((VerticalCS)nillable.get(), EncodingContext.empty());
                if (xml != null && xml instanceof VerticalCSType) {
                    vcspt.set((XmlObject)((VerticalCSType)xml));
                } else {
                    vcspt.setNil();
                    vcspt.setNilReason(Nillable.missing().get());
                }
            } else {
                vcspt.setNil();
                if (nillable.hasReason()) {
                    vcspt.setNilReason(nillable.getNilReason().get());
                } else {
                    vcspt.setNilReason(Nillable.missing().get());
                }
            }
        }
        Referenceable verticalDatum = verticalCRS.getVerticalDatum();
        VerticalDatumPropertyType vdpt = vcrst.addNewVerticalDatum();
        if (verticalDatum.isReference()) {
            Reference reference = verticalDatum.getReference();
            reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setActuate(arg_0));
            reference.getArcrole().ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setArcrole(arg_0));
            reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setHref(arg_0));
            reference.getRole().ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setRole(arg_0));
            reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setShow(arg_0));
            reference.getTitle().ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setTitle(arg_0));
            reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((VerticalDatumPropertyType)vdpt).setType(arg_0));
        } else if (verticalDatum.isInstance()) {
            Nillable nillable = verticalDatum.getInstance();
            if (nillable.isPresent()) {
                XmlObject xml = this.createVerticalDatum((VerticalDatum)nillable.get(), EncodingContext.empty());
                if (xml != null && xml instanceof VerticalDatumType) {
                    vdpt.setVerticalDatum((VerticalDatumType)xml);
                } else {
                    vdpt.setNil();
                    vdpt.setNilReason(Nillable.missing().get());
                }
            } else {
                vdpt.setNil();
                if (nillable.hasReason()) {
                    vdpt.setNilReason(nillable.getNilReason().get());
                } else {
                    vdpt.setNilReason(Nillable.missing().get());
                }
            }
        }
        if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            VerticalCRSPropertyType vcrspt = VerticalCRSPropertyType.Factory.newInstance();
            vcrspt.setVerticalCRS(vcrst);
            return vcrspt;
        }
        return vcrst;
    }

    private void addDefinitonValues(DefinitionType dt, Definition definition) throws EncodingException {
        if (!definition.isSetGmlID()) {
            definition.setGmlId("id_" + IdGenerator.generate((String)definition.getGmlId()));
        }
        dt.setId(definition.getGmlId());
        if (!this.addIdentifier((AbstractGMLType)dt, (AbstractGML)definition)) {
            dt.setIdentifier(this.createCodeWithAuthorityType(new CodeWithAuthority(IdGenerator.generate((String)definition.toString()))));
        }
        this.addName((AbstractGMLType)dt, (AbstractGML)definition);
        this.addDescription((AbstractGMLType)dt, (AbstractGML)definition);
        if (definition.hasRemarks()) {
            dt.setRemarks(definition.getRemarks());
        }
    }

    private void addAbstractCRSValues(AbstractCRSType acrst, AbstractCRS abstractCRS) throws EncodingException {
        this.addDefinitonValues((DefinitionType)acrst, (Definition)abstractCRS);
        if (abstractCRS.hasDomainOfValidity()) {
            for (Referenceable domainOfValidity : abstractCRS.getDomainOfValidity()) {
                DomainOfValidityDocument.DomainOfValidity dov = acrst.addNewDomainOfValidity();
                if (domainOfValidity.isReference()) {
                    Reference reference = domainOfValidity.getReference();
                    reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setActuate(arg_0));
                    reference.getArcrole().ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setArcrole(arg_0));
                    reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setHref(arg_0));
                    reference.getRole().ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setRole(arg_0));
                    reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setShow(arg_0));
                    reference.getTitle().ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setTitle(arg_0));
                    reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((DomainOfValidityDocument.DomainOfValidity)dov).setType(arg_0));
                    continue;
                }
                if (!domainOfValidity.isInstance()) continue;
                Nillable nillable = domainOfValidity.getInstance();
                if (nillable.isPresent()) {
                    DomainOfValidityDocument.DomainOfValidity xml = this.createDomainOfValidity((DomainOfValidity)nillable.get(), EncodingContext.empty());
                    if (xml != null) {
                        dov.set((XmlObject)xml);
                        continue;
                    }
                    dov.setNil();
                    dov.setNilReason(Nillable.missing().get());
                    continue;
                }
                dov.setNil();
                if (nillable.hasReason()) {
                    dov.setNilReason(nillable.getNilReason().get());
                    continue;
                }
                dov.setNilReason(Nillable.missing().get());
            }
        }
        if (abstractCRS.hasScope()) {
            abstractCRS.getScope().forEach(scope -> acrst.addNewScope().setStringValue(scope));
        }
    }

    private XmlObject createVerticalCS(VerticalCS verticalCS, EncodingContext ctx) throws EncodingException {
        VerticalCSType vcst = VerticalCSType.Factory.newInstance();
        this.addAbstractCoordincateSystemValues((AbstractCoordinateSystemType)vcst, (AbstractCoordinateSystem)verticalCS);
        if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            VerticalCSDocument vcsd = VerticalCSDocument.Factory.newInstance();
            VerticalCSPropertyType vcdpt = VerticalCSPropertyType.Factory.newInstance();
            vcdpt.setVerticalCS(vcst);
            vcsd.setVerticalCS(vcdpt);
            return vcsd;
        }
        if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            VerticalCSPropertyType vcdpt = VerticalCSPropertyType.Factory.newInstance();
            vcdpt.setVerticalCS(vcst);
            return vcdpt;
        }
        return vcst;
    }

    private void addAbstractCoordincateSystemValues(AbstractCoordinateSystemType acst, AbstractCoordinateSystem abstractCoordinateSystem) throws EncodingException {
        this.addDefinitonValues((DefinitionType)acst, (Definition)abstractCoordinateSystem);
        acst.setAggregationType(AggregationType.Enum.forString((String)abstractCoordinateSystem.getAggregation().name()));
        for (Referenceable coordinateSystemAxis : abstractCoordinateSystem.getCoordinateSystemAxis()) {
            CoordinateSystemAxisPropertyType csapt = acst.addNewAxis();
            if (coordinateSystemAxis.isReference()) {
                Reference reference = coordinateSystemAxis.getReference();
                reference.getActuate().map(Actuate::toString).map(ActuateType.Enum::forString).ifPresent(arg_0 -> ((CoordinateSystemAxisPropertyType)csapt).setActuate(arg_0));
                reference.getArcrole().ifPresent(arg_0 -> ((CoordinateSystemAxisPropertyType)csapt).setArcrole(arg_0));
                reference.getHref().map(URI::toString).ifPresent(arg_0 -> ((CoordinateSystemAxisPropertyType)csapt).setHref(arg_0));
                reference.getRole().ifPresent(arg_0 -> ((CoordinateSystemAxisPropertyType)csapt).setRole(arg_0));
                reference.getShow().map(Show::toString).map(ShowType.Enum::forString).ifPresent(arg_0 -> ((CoordinateSystemAxisPropertyType)csapt).setShow(arg_0));
                reference.getTitle().ifPresent(arg_0 -> ((CoordinateSystemAxisPropertyType)csapt).setTitle(arg_0));
                reference.getType().map(Type::toString).map(TypeType.Enum::forString).ifPresent(arg_0 -> ((CoordinateSystemAxisPropertyType)csapt).setType(arg_0));
                continue;
            }
            if (!coordinateSystemAxis.isInstance()) continue;
            Nillable nillable = coordinateSystemAxis.getInstance();
            if (nillable.isPresent()) {
                XmlObject xml = this.createCoordinateSystemAxis((CoordinateSystemAxis)nillable.get(), EncodingContext.empty());
                if (xml != null && xml instanceof CoordinateSystemAxisType) {
                    csapt.addNewCoordinateSystemAxis().set(xml);
                    continue;
                }
                csapt.setNil();
                csapt.setNilReason(Nillable.missing().get());
                continue;
            }
            csapt.setNil();
            if (nillable.hasReason()) {
                csapt.setNilReason(nillable.getNilReason().get());
                continue;
            }
            csapt.setNilReason(Nillable.missing().get());
        }
    }

    private XmlObject createCoordinateSystemAxis(CoordinateSystemAxis coordinateSystemAxis, EncodingContext ctx) throws EncodingException {
        CoordinateSystemAxisType csat = CoordinateSystemAxisType.Factory.newInstance();
        this.addDefinitonValues((DefinitionType)csat, (Definition)coordinateSystemAxis);
        csat.setAxisAbbrev(this.createCodeType(coordinateSystemAxis.getAxisAbbrev()));
        csat.setAxisDirection(this.createCodeWithAuthorityType(coordinateSystemAxis.getAxisDirection()));
        if (coordinateSystemAxis.isSetMinimumValue()) {
            csat.setMinimumValue(coordinateSystemAxis.getMinimumValue().doubleValue());
        }
        if (coordinateSystemAxis.isSetMaximumValue()) {
            csat.setMaximumValue(coordinateSystemAxis.getMaximumValue().doubleValue());
        }
        if (coordinateSystemAxis.isSetRangeMeaning()) {
            csat.setRangeMeaning(this.createCodeWithAuthorityType(coordinateSystemAxis.getRangeMeaning()));
        }
        csat.setUom(coordinateSystemAxis.getUom());
        if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            CoordinateSystemAxisDocument csad = CoordinateSystemAxisDocument.Factory.newInstance();
            csad.setCoordinateSystemAxis(csat);
            return csad;
        }
        if (ctx.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            CoordinateSystemAxisPropertyType csapt = CoordinateSystemAxisPropertyType.Factory.newInstance();
            csapt.setCoordinateSystemAxis(csat);
            return csapt;
        }
        return csat;
    }

    protected String getSrsName(Geometry geom) {
        return this.getSrsName(geom.getSRID());
    }

    protected String getSrsName(int srid) {
        return this.srsNamePrefixURL.concat(String.valueOf(srid));
    }

    private static EncodingException missingValueParameter(String type) {
        return new EncodingException("The required 'value' parameter is empty for encoding %s!", type, new Object[0]);
    }
}

