/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.inspire.omso.InspireOMSOConstants;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.StreamingEncoder;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.PointTimeSeriesObservationXmlStreamWriter;

public class InspireOmObservationEncoder
extends AbstractXmlEncoder<XmlObject, Object>
implements ObservationEncoder<XmlObject, Object>,
StreamingEncoder<XmlObject, Object> {
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/omso/3.0", (Class[])new Class[]{OmObservation.class});
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://inspire.ec.europa.eu/schemas/omso/3.0")));

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public XmlObject encode(Object element, EncodingContext ec) throws EncodingException {
        if (element instanceof OmObservation) {
            return this.encodeInspireOmsoType((OmObservation)element, ec);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, element);
    }

    public void encode(Object objectToEncode, OutputStream outputStream) throws EncodingException {
        this.encode(objectToEncode, outputStream, EncodingContext.empty());
    }

    public void encode(Object element, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        try {
            if (element instanceof OmObservation && "http://inspire.ec.europa.eu/featureconcept/PointTimeSeriesObservation".equals(((OmObservation)element).getObservationConstellation().getObservationType())) {
                new PointTimeSeriesObservationXmlStreamWriter(ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions), outputStream, (OmObservation)element).write();
            } else {
                this.encode(element, ctx).save(outputStream, this.getXmlOptions());
            }
        }
        catch (IOException | XMLStreamException e) {
            throw new EncodingException("Error while writing element to stream!", (Throwable)e);
        }
    }

    protected XmlObject encodeInspireOmsoType(OmObservation o, EncodingContext ctx) throws EncodingException {
        return this.encodeObjectToXml("http://inspire.ec.europa.eu/schemas/omso/3.0", o, ctx);
    }

    public boolean isObservationAndMeasurmentV20Type() {
        return true;
    }

    public boolean shouldObservationsWithSameXBeMerged() {
        return false;
    }

    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        if (SUPPORTED_RESPONSE_FORMATS.get(service) != null && SUPPORTED_RESPONSE_FORMATS.get(service).get(version) != null) {
            return SUPPORTED_RESPONSE_FORMATS.get(service).get(version);
        }
        return new HashSet<String>(0);
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Maps.newHashMap();
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/omso/3.0", "omso");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{InspireOMSOConstants.OMSO_SCHEMA_LOCATION});
    }
}

