/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Set;
import net.opengis.sos.x10.CapabilitiesDocument;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CapabilitiesV1DocumentDecoder
extends AbstractXmlDecoder<CapabilitiesDocument, GetCapabilitiesResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CapabilitiesV1DocumentDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sos/1.0", (Class[])new Class[]{CapabilitiesDocument.class});

    public CapabilitiesV1DocumentDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public GetCapabilitiesResponse decode(CapabilitiesDocument cd) throws DecodingException {
        if (cd != null) {
            GetCapabilitiesResponse response = new GetCapabilitiesResponse();
            OwsCapabilities capabilities = (OwsCapabilities)this.decodeXmlObject((XmlObject)cd.getCapabilities());
            response.setCapabilities(capabilities);
            response.setXmlString(cd.xmlText(this.getXmlOptions()));
            return response;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)cd);
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }
}

