/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import net.opengis.sosdo.x10.DeleteObservationResponseDocument;
import net.opengis.sosdo.x10.DeleteObservationResponseType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationConstants;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractResponseEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;

public class DeleteObservationEncoder
extends AbstractResponseEncoder<DeleteObservationResponse> {
    public static final SchemaLocation SCHEMA_LOCATION = new SchemaLocation("http://www.opengis.net/sosdo/1.0", "http://52north.org/schema/sosdo/1.0/sosdo.xsd");

    public DeleteObservationEncoder() {
        super("SOS", "2.0.0", DeleteObservationConstants.Operations.DeleteObservation.name(), "http://www.opengis.net/sosdo/1.0", "sosdo", DeleteObservationResponse.class);
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(DeleteObservationConstants.CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    @Override
    protected XmlObject create(DeleteObservationResponse dor) throws EncodingException {
        if (dor == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, DeleteObservationResponse.class);
        }
        String observationId = dor.getObservationId();
        DeleteObservationResponseDocument xbDeleteObsDoc = DeleteObservationResponseDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        DeleteObservationResponseType xbDeleteObservationResponse = xbDeleteObsDoc.addNewDeleteObservationResponse();
        xbDeleteObservationResponse.setDeletedObservation(observationId);
        return xbDeleteObsDoc;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SCHEMA_LOCATION});
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet();
    }
}

