/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import net.opengis.sos.x20.GetCapabilitiesDocument;
import net.opengis.sos.x20.GetCapabilitiesType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.ows.OwsAcceptVersions;
import org.n52.shetland.ogc.ows.OwsSections;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosRequestEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public class GetCapabilitiesRequestEncoder
extends AbstractSosRequestEncoder<GetCapabilitiesRequest> {
    public GetCapabilitiesRequestEncoder() {
        super(SosConstants.Operations.GetCapabilities.name(), GetCapabilitiesRequest.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_GET_CAPABILITIES_SCHEMA_LOCATION});
    }

    @Override
    protected XmlObject create(GetCapabilitiesRequest request) throws EncodingException {
        GetCapabilitiesDocument doc = GetCapabilitiesDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetCapabilitiesType gct = doc.addNewGetCapabilities2();
        this.addService(gct, request);
        this.addAcceptVersion(gct, request);
        this.addSections(gct, request);
        return doc;
    }

    private void addService(GetCapabilitiesType gct, GetCapabilitiesRequest request) {
        if (request.isSetService()) {
            gct.setService(request.getService());
        } else {
            gct.setService("SOS");
        }
    }

    private void addAcceptVersion(GetCapabilitiesType gct, GetCapabilitiesRequest request) throws EncodingException {
        if (request.isSetAcceptVersions()) {
            gct.addNewAcceptVersions().set(this.encodeOws(new OwsAcceptVersions().setAcceptVersions((Collection)request.getAcceptVersions())));
        } else if (request.isSetVersion()) {
            gct.addNewAcceptVersions().addVersion(request.getVersion());
        } else {
            gct.addNewAcceptVersions().addVersion("2.0.0");
        }
    }

    private void addSections(GetCapabilitiesType gct, GetCapabilitiesRequest request) throws EncodingException {
        if (request.isSetSections()) {
            gct.addNewSections().set(this.encodeOws(new OwsSections().setSections((Collection)request.getSections())));
        }
    }
}

