/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import net.opengis.sosdo.x10.DeleteObservationDocument;
import net.opengis.sosdo.x10.DeleteObservationType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationConstants;
import org.n52.shetland.ogc.sos.delobs.DeleteObservationRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteObservationDecoder
extends AbstractXmlDecoder<XmlObject, DeleteObservationRequest> {
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sosdo/1.0", (Class[])new Class[]{DeleteObservationDocument.class}), CodingHelper.xmlDecoderKeysForOperation((String)"SOS", (String)"2.0.0", (Enum[])new Enum[]{DeleteObservationConstants.Operations.DeleteObservation})});
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteObservationDecoder.class);

    public DeleteObservationDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public DeleteObservationRequest decode(XmlObject xmlObject) throws DecodingException {
        LOGGER.debug("REQUESTTYPE: {}", xmlObject != null ? xmlObject.getClass() : "null recevied");
        if (xmlObject instanceof DeleteObservationDocument) {
            DeleteObservationDocument delObsDoc = (DeleteObservationDocument)xmlObject;
            DeleteObservationRequest decodedRequest = this.parseDeleteObservation(delObsDoc);
            LOGGER.debug("Decoded request: {}", (Object)decodedRequest);
            return decodedRequest;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }

    private DeleteObservationRequest parseDeleteObservation(DeleteObservationDocument xbDelObsDoc) throws DecodingException {
        DeleteObservationRequest delObsRequest = null;
        DeleteObservationType xbDelObsType = xbDelObsDoc.getDeleteObservation();
        if (xbDelObsType == null) {
            throw new DecodingException("Received XML document is not valid. Set log level to debug to get more details", new Object[0]);
        }
        delObsRequest = new DeleteObservationRequest("http://www.opengis.net/sosdo/1.0");
        delObsRequest.setVersion(xbDelObsType.getVersion());
        delObsRequest.setService(xbDelObsType.getService());
        delObsRequest.addObservationIdentifier(xbDelObsType.getObservation());
        return delObsRequest;
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.emptySet();
    }
}

