/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import eu.europa.ec.inspire.schemas.ompr.x30.ProcessDocument;
import java.util.Collections;
import java.util.Set;
import org.n52.shetland.inspire.ompr.Process;
import org.n52.svalbard.decode.AbstractProcessDecoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessDocumentDecoder
extends AbstractProcessDecoder<ProcessDocument> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessDocumentDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/ompr/3.0", (Class[])new Class[]{ProcessDocument.class});

    public ProcessDocumentDecoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Process decode(ProcessDocument pd) throws DecodingException {
        Process process = this.parseProcessType(pd.getProcess());
        process.setXml(pd.xmlText(this.getXmlOptions()));
        return process;
    }
}

