/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.opengis.gml.x32.AbstractFeatureType;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.gml.x32.ReferenceType;
import net.opengis.samplingSpatial.x20.SFSpatialSamplingFeatureDocument;
import net.opengis.samplingSpatial.x20.SFSpatialSamplingFeatureType;
import net.opengis.samplingSpatial.x20.ShapeType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.sos.FeatureType;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractGmlDecoderv321;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SamplingDecoderv20
extends AbstractGmlDecoderv321<XmlObject, AbstractFeature> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SamplingDecoderv20.class);
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new FeatureType("http://www.opengis.net/def/nil/OGC/0/unknown")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve")).add((Object)new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface")).build();
    private static final Set<String> CONFORMANCE_CLASSES = Sets.newHashSet((Object[])new String[]{"http://www.opengis.net/spec/OMXML/2.0/conf/spatialSampling", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingPoint", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingCurve", "http://www.opengis.net/spec/OMXML/2.0/conf/samplingSurface"});
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sampling/2.0", (Class[])new Class[]{SFSpatialSamplingFeatureDocument.class, SFSpatialSamplingFeatureType.class}), CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/samplingSpatial/2.0", (Class[])new Class[]{SFSpatialSamplingFeatureDocument.class, SFSpatialSamplingFeatureType.class})});

    public SamplingDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    public AbstractFeature decode(XmlObject element) throws DecodingException {
        XmlHelper.validateDocument((XmlObject)element);
        if (element instanceof SFSpatialSamplingFeatureDocument) {
            return this.parseSpatialSamplingFeature(((SFSpatialSamplingFeatureDocument)element).getSFSpatialSamplingFeature());
        }
        if (element instanceof SFSpatialSamplingFeatureType) {
            return this.parseSpatialSamplingFeature((SFSpatialSamplingFeatureType)element);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, element);
    }

    private AbstractFeature parseSpatialSamplingFeature(SFSpatialSamplingFeatureType spatialSamplingFeature) throws DecodingException {
        SamplingFeature sosFeat = new SamplingFeature(null, spatialSamplingFeature.getId());
        return this.parseSpatialSamplingFeature(spatialSamplingFeature, (AbstractSamplingFeature)sosFeat);
    }

    protected AbstractFeature parseSpatialSamplingFeature(SFSpatialSamplingFeatureType sfssft, AbstractSamplingFeature abstractSamplingFeature) throws DecodingException {
        this.parseAbstractFeatureType((AbstractFeatureType)sfssft, (AbstractFeature)abstractSamplingFeature);
        abstractSamplingFeature.setFeatureType(this.getFeatureType(sfssft.getType()));
        abstractSamplingFeature.setSampledFeatures(this.getSampledFeatures(sfssft.getSampledFeatureArray()));
        abstractSamplingFeature.setXml(this.getXmlDescription(sfssft));
        abstractSamplingFeature.setGeometry(this.getGeometry(sfssft.getShape()));
        this.checkTypeAndGeometry(abstractSamplingFeature);
        abstractSamplingFeature.setGmlId(sfssft.getId());
        return abstractSamplingFeature;
    }

    private String getXmlDescription(SFSpatialSamplingFeatureType spatialSamplingFeature) {
        SFSpatialSamplingFeatureDocument featureDoc = SFSpatialSamplingFeatureDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        featureDoc.setSFSpatialSamplingFeature(spatialSamplingFeature);
        return featureDoc.xmlText(this.getXmlOptions());
    }

    private String getFeatureType(ReferenceType type) {
        if (type != null && type.getHref() != null && !type.getHref().isEmpty()) {
            return type.getHref();
        }
        return null;
    }

    private List<AbstractFeature> getSampledFeatures(FeaturePropertyType[] sampledFeatureArray) throws DecodingException {
        ArrayList sampledFeatures = Lists.newArrayList();
        for (FeaturePropertyType featurePropertyType : sampledFeatureArray) {
            sampledFeatures.addAll(this.getSampledFeatures(featurePropertyType));
        }
        return sampledFeatures;
    }

    private List<AbstractFeature> getSampledFeatures(FeaturePropertyType sampledFeature) throws DecodingException {
        ArrayList<AbstractFeature> sampledFeatures = new ArrayList<AbstractFeature>(1);
        if (sampledFeature != null && !sampledFeature.isNil()) {
            if (sampledFeature.getHref() != null && !sampledFeature.getHref().isEmpty()) {
                if (sampledFeature.getHref().startsWith("#")) {
                    sampledFeatures.add((AbstractFeature)new SamplingFeature(null, sampledFeature.getHref().replace("#", "")));
                } else {
                    SamplingFeature sampFeat = new SamplingFeature(new CodeWithAuthority(sampledFeature.getHref()));
                    if (sampledFeature.getTitle() != null && !sampledFeature.getTitle().isEmpty()) {
                        sampFeat.addName(new CodeType(sampledFeature.getTitle()));
                    }
                    sampledFeatures.add((AbstractFeature)sampFeat);
                }
            } else {
                Object decodedObject;
                AbstractFeatureType abstractFeature = null;
                if (sampledFeature.getAbstractFeature() != null) {
                    abstractFeature = sampledFeature.getAbstractFeature();
                } else if (sampledFeature.getDomNode().hasChildNodes()) {
                    try {
                        abstractFeature = XmlObject.Factory.parse((Node)XmlHelper.getNodeFromNodeList((NodeList)sampledFeature.getDomNode().getChildNodes()));
                    }
                    catch (XmlException xmle) {
                        throw new DecodingException("Error while parsing feature request!", (Throwable)xmle);
                    }
                }
                if (abstractFeature != null && (decodedObject = this.decodeXmlObject((XmlObject)abstractFeature)) instanceof AbstractFeature) {
                    sampledFeatures.add((AbstractFeature)decodedObject);
                }
                throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested sampledFeature type is not supported by this service!", new Object[0]);
            }
        }
        return sampledFeatures;
    }

    private Geometry getGeometry(ShapeType shape) throws DecodingException {
        Object decodedObject = this.decodeXmlElement((XmlObject)shape.getAbstractGeometry());
        if (decodedObject instanceof Geometry) {
            return (Geometry)decodedObject;
        }
        throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested geometry type of featureOfInterest is not supported by this service!", new Object[0]);
    }

    private void checkTypeAndGeometry(AbstractSamplingFeature sosFeat) throws DecodingException {
        String featTypeForGeometry = this.getFeatTypeForGeometry(sosFeat.getGeometry());
        if (sosFeat.getFeatureType() == null) {
            sosFeat.setFeatureType(featTypeForGeometry);
        } else if (!featTypeForGeometry.equals(sosFeat.getFeatureType())) {
            throw new DecodingException("The requested observation is invalid! The featureOfInterest type does not comply with the defined type (%s)!", sosFeat.getFeatureType(), new Object[0]);
        }
    }

    private String getFeatTypeForGeometry(Geometry geometry) {
        if (geometry instanceof Point || geometry instanceof MultiPoint) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingPoint";
        }
        if (geometry instanceof LineString || geometry instanceof MultiLineString) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingCurve";
        }
        if (geometry instanceof Polygon || geometry instanceof MultiPolygon) {
            return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingSurface";
        }
        return "http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_SamplingFeature";
    }
}

