/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Set;
import net.opengis.fes.x20.SpatialOpsDocument;
import net.opengis.fes.x20.TemporalOpsDocument;
import net.opengis.sos.x20.GetObservationDocument;
import net.opengis.sos.x20.GetObservationType;
import net.opengis.swes.x20.ExtensibleRequestType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.request.GetObservationRequest;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosRequestEncoder;
import org.n52.svalbard.encode.ExtensibleRequestEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public class GetObservationRequestEncoder
extends AbstractSosRequestEncoder<GetObservationRequest>
implements ExtensibleRequestEncoder {
    public GetObservationRequestEncoder() {
        super(SosConstants.Operations.GetObservation.name(), GetObservationRequest.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_GET_OBSERVATION_SCHEMA_LOCATION});
    }

    @Override
    protected XmlObject create(GetObservationRequest request) throws EncodingException {
        GetObservationDocument doc = GetObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetObservationType got = doc.addNewGetObservation();
        this.addService((ExtensibleRequestType)got, (OwsServiceRequest)request);
        this.addVersion((ExtensibleRequestType)got, (OwsServiceRequest)request);
        this.addExtension((ExtensibleRequestType)got, (OwsServiceRequest)request);
        this.addProcedure(got, request);
        this.addOffering(got, request);
        this.addObservedProperty(got, request);
        this.addTemporalFilter(got, request);
        this.addFeatureOfInterest(got, request);
        this.addSpatialFilter(got, request);
        this.addResponseFormat(got, request);
        return doc;
    }

    private void addProcedure(GetObservationType got, GetObservationRequest request) {
        if (request.isSetProcedure()) {
            request.getProcedures().forEach(arg_0 -> ((GetObservationType)got).addProcedure(arg_0));
        }
    }

    private void addOffering(GetObservationType got, GetObservationRequest request) {
        if (request.isSetOffering()) {
            request.getOfferings().forEach(arg_0 -> ((GetObservationType)got).addOffering(arg_0));
        }
    }

    private void addObservedProperty(GetObservationType got, GetObservationRequest request) {
        if (request.isSetObservableProperty()) {
            request.getObservedProperties().forEach(arg_0 -> ((GetObservationType)got).addObservedProperty(arg_0));
        }
    }

    private void addTemporalFilter(GetObservationType got, GetObservationRequest request) throws EncodingException {
        if (request.isSetTemporalFilter()) {
            for (TemporalFilter temporalFilter : request.getTemporalFilters()) {
                XmlObject encodeFes = this.encodeFes(temporalFilter);
                if (!(encodeFes instanceof TemporalOpsDocument)) continue;
                this.substitute((XmlObject)got.addNewTemporalFilter().addNewTemporalOps(), (XmlObject)((TemporalOpsDocument)encodeFes).getTemporalOps());
            }
        }
    }

    private void addFeatureOfInterest(GetObservationType got, GetObservationRequest request) {
        if (request.isSetFeatureOfInterest()) {
            request.getFeatureIdentifiers().forEach(arg_0 -> ((GetObservationType)got).addFeatureOfInterest(arg_0));
        }
    }

    private void addSpatialFilter(GetObservationType got, GetObservationRequest request) throws EncodingException {
        XmlObject encodeFes;
        if (request.isSetSpatialFilter() && (encodeFes = this.encodeFes(request.getSpatialFilter())) instanceof SpatialOpsDocument) {
            this.substitute((XmlObject)got.addNewSpatialFilter().getSpatialOps(), (XmlObject)((SpatialOpsDocument)encodeFes).getSpatialOps());
        }
    }

    private void addResponseFormat(GetObservationType got, GetObservationRequest request) {
        if (request.isSetResponseFormat()) {
            got.setResponseFormat(request.getResponseFormat());
        }
    }
}

