/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import eu.europa.ec.inspire.schemas.omso.x30.ProfileObservationType;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.opengis.om.x20.OMObservationType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.inspire.omso.ProfileObservation;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.values.RectifiedGridCoverage;
import org.n52.shetland.ogc.om.values.ReferencableGridCoverage;
import org.n52.svalbard.encode.AbstractOmInspireEncoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProfileObservationTypeEncoder
extends AbstractOmInspireEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProfileObservationTypeEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://inspire.ec.europa.eu/schemas/omso/3.0", (Class[])new Class[]{ProfileObservation.class});

    public ProfileObservationTypeEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        return this.encodeResult(sosObservation.getValue());
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        if (observationValue.getValue() instanceof RectifiedGridCoverage) {
            return this.encodeGML(observationValue.getValue());
        }
        if (observationValue.getValue() instanceof ReferencableGridCoverage) {
            return this.encodeObjectToXmlPropertyType("http://www.opengis.net/gmlcov/1.0", observationValue.getValue());
        }
        return null;
    }

    @Override
    public <T> XmlObject encodeObjectToXmlPropertyType(String namespace, T object, EncodingContext helperValues) throws EncodingException {
        return super.encodeObjectToXmlPropertyType(namespace, object, helperValues);
    }

    @Override
    protected String getObservationType() {
        return "http://inspire.ec.europa.eu/featureconcept/ProfileObservation";
    }

    @Override
    public XmlObject encode(Object element, EncodingContext ec) throws EncodingException {
        return super.encode(element, ec);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext context) throws EncodingException {
        super.encode(objectToEncode, outputStream, context);
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return ProfileObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    @Override
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://www.opengis.net/gml/3.3/ce", "http://schemas.opengis.net/gml/3.3/geometryCompact.xsd");
    }
}

