/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.sensorML.AbstractProcess;
import org.n52.shetland.ogc.sensorML.SensorML;
import org.n52.shetland.ogc.sensorML.SensorMLConstants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.response.DescribeSensorResponse;
import org.n52.svalbard.encode.AbstractSosV1ResponseEncoder;
import org.n52.svalbard.encode.exception.EncodingException;

public class SosV1DescribeSensorResponseEncoder
extends AbstractSosV1ResponseEncoder<DescribeSensorResponse> {
    public SosV1DescribeSensorResponseEncoder() {
        super(SosConstants.Operations.DescribeSensor.name(), DescribeSensorResponse.class);
    }

    @Override
    protected XmlObject create(DescribeSensorResponse response) throws EncodingException {
        if (response.isSetProcedureDescriptions()) {
            AbstractFeature procedureDescription = ((SosProcedureDescription)response.getProcedureDescriptions().iterator().next()).getProcedureDescription();
            if (this.checkFormat(response.getOutputFormat()) && !(procedureDescription instanceof SensorML) && procedureDescription instanceof AbstractProcess) {
                procedureDescription = new SensorML().addMember((AbstractProcess)procedureDescription);
            }
            return this.encodeObjectToXml(response.getOutputFormat(), procedureDescription);
        }
        return null;
    }

    private boolean checkFormat(String outputFormat) {
        return this.checkForUrlVsMimeType(outputFormat).contains(SensorMLConstants.SENSORML_OUTPUT_FORMAT_MIME_TYPE);
    }

    private Set<String> checkForUrlVsMimeType(String procedureDescriptionFormat) {
        HashSet possibleFormats = Sets.newHashSet();
        possibleFormats.add(procedureDescriptionFormat);
        if (SensorMLConstants.SENSORML_OUTPUT_FORMAT_MIME_TYPE.equalsIgnoreCase(procedureDescriptionFormat)) {
            possibleFormats.add("http://www.opengis.net/sensorML/1.0.1");
        } else if ("http://www.opengis.net/sensorML/1.0.1".equalsIgnoreCase(procedureDescriptionFormat)) {
            possibleFormats.add(SensorMLConstants.SENSORML_OUTPUT_FORMAT_MIME_TYPE);
        }
        return possibleFormats;
    }
}

