/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.AbstractTimeObjectType;
import net.opengis.sosgda.x20.DataAvailabilityMemberType;
import net.opengis.sosgda.x20.FormatDescriptorType;
import net.opengis.sosgda.x20.GetDataAvailabilityResponseDocument;
import net.opengis.sosgda.x20.GetDataAvailabilityResponseType;
import net.opengis.sosgda.x20.ObservationFormatDescriptorType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.SosResponseDecoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataAvailabilityResponseDecoder
extends AbstractXmlDecoder<XmlObject, GetDataAvailabilityResponse>
implements SosResponseDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetDataAvailabilityResponseDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sosgda/1.0", (Class[])new Class[]{net.opengis.sosgda.x10.GetDataAvailabilityResponseDocument.class}), CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sosgda/2.0", (Class[])new Class[]{GetDataAvailabilityResponseDocument.class})});

    public GetDataAvailabilityResponseDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public GetDataAvailabilityResponse decode(XmlObject document) throws DecodingException {
        if (document instanceof net.opengis.sosgda.x10.GetDataAvailabilityResponseDocument) {
            return this.decodeV10((net.opengis.sosgda.x10.GetDataAvailabilityResponseDocument)document);
        }
        if (document instanceof GetDataAvailabilityResponseDocument) {
            return this.decodeV20((GetDataAvailabilityResponseDocument)document);
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)document);
    }

    private GetDataAvailabilityResponse decodeV10(net.opengis.sosgda.x10.GetDataAvailabilityResponseDocument document) throws DecodingException {
        GetDataAvailabilityResponse response = new GetDataAvailabilityResponse();
        this.setService((OwsServiceResponse)response);
        this.setVersions((OwsServiceResponse)response);
        response.setNamespace("http://www.opengis.net/sosgda/1.0");
        response.setDataAvailabilities(this.parseDataAvalabilities(document.getGetDataAvailabilityResponse()));
        return response;
    }

    private GetDataAvailabilityResponse decodeV20(GetDataAvailabilityResponseDocument document) throws DecodingException {
        GetDataAvailabilityResponse response = new GetDataAvailabilityResponse();
        this.setService((OwsServiceResponse)response);
        this.setVersions((OwsServiceResponse)response);
        response.setNamespace("http://www.opengis.net/sosgda/2.0");
        response.setDataAvailabilities(this.parseDataAvalabilities(document.getGetDataAvailabilityResponse()));
        return response;
    }

    private Collection<GetDataAvailabilityResponse.DataAvailability> parseDataAvalabilities(net.opengis.sosgda.x10.GetDataAvailabilityResponseType response) throws DecodingException {
        ArrayList availabilities = Lists.newArrayList();
        if (CollectionHelper.isNotNullOrEmpty((Object[])response.getDataAvailabilityMemberArray())) {
            HashMap periods = Maps.newHashMap();
            for (net.opengis.sosgda.x10.DataAvailabilityMemberType damt : response.getDataAvailabilityMemberArray()) {
                ReferenceType procedure = (ReferenceType)this.decodeXmlElement((XmlObject)damt.getProcedure());
                ReferenceType featureOfInterest = (ReferenceType)this.decodeXmlElement((XmlObject)damt.getFeatureOfInterest());
                ReferenceType observedProperty = (ReferenceType)this.decodeXmlElement((XmlObject)damt.getObservedProperty());
                TimePeriod phenomenonTime = this.getPhenomenonTime(damt.getPhenomenonTime().getAbstractTimeObject(), damt.getPhenomenonTime().getHref(), periods);
                availabilities.add(new GetDataAvailabilityResponse.DataAvailability(procedure, observedProperty, featureOfInterest, null, phenomenonTime));
            }
        }
        return availabilities;
    }

    private Collection<GetDataAvailabilityResponse.DataAvailability> parseDataAvalabilities(GetDataAvailabilityResponseType response) throws DecodingException {
        ArrayList availabilities = Lists.newArrayList();
        if (CollectionHelper.isNotNullOrEmpty((Object[])response.getDataAvailabilityMemberArray())) {
            HashMap periods = Maps.newHashMap();
            for (DataAvailabilityMemberType damt : response.getDataAvailabilityMemberArray()) {
                ReferenceType procedure = (ReferenceType)this.decodeXmlElement((XmlObject)damt.getProcedure());
                ReferenceType offering = (ReferenceType)this.decodeXmlElement((XmlObject)damt.getOffering());
                ReferenceType featureOfInterest = (ReferenceType)this.decodeXmlElement((XmlObject)damt.getFeatureOfInterest());
                ReferenceType observedProperty = (ReferenceType)this.decodeXmlElement((XmlObject)damt.getObservedProperty());
                TimePeriod phenomenonTime = this.getPhenomenonTime(damt.getPhenomenonTime().getAbstractTimeObject(), damt.getPhenomenonTime().getHref(), periods);
                GetDataAvailabilityResponse.DataAvailability dataAvailability = new GetDataAvailabilityResponse.DataAvailability(procedure, observedProperty, featureOfInterest, offering, phenomenonTime);
                GetDataAvailabilityResponse.FormatDescriptor formatDescriptor = this.createFormatDescriptor(damt.getFormatDescriptor());
                if (formatDescriptor != null) {
                    dataAvailability.setFormatDescriptor(formatDescriptor);
                }
                availabilities.add(dataAvailability);
            }
        }
        return availabilities;
    }

    private TimePeriod getPhenomenonTime(AbstractTimeObjectType atot, String href, Map<String, TimePeriod> periods) throws DecodingException {
        TimePeriod phenomenonTime;
        if (atot != null) {
            phenomenonTime = (TimePeriod)this.decodeXmlElement((XmlObject)atot);
            periods.put(phenomenonTime.getGmlId(), phenomenonTime);
        } else {
            String id = href.startsWith("#") ? href.substring(1) : href;
            phenomenonTime = periods.get(id);
        }
        return phenomenonTime;
    }

    private GetDataAvailabilityResponse.FormatDescriptor createFormatDescriptor(FormatDescriptorType fdt) {
        if (fdt != null) {
            String procDescFormatDescriptor = fdt.getProcedureDescriptionFormatDescriptor().getProcedureDescriptionFormat();
            HashSet obsFormDescs = Sets.newHashSet();
            for (ObservationFormatDescriptorType obsFormatDescriptor : fdt.getObservationFormatDescriptorArray()) {
                obsFormDescs.add(new GetDataAvailabilityResponse.ObservationFormatDescriptor(obsFormatDescriptor.getResponseFormat(), (Collection)Sets.newHashSet((Object[])obsFormatDescriptor.getObservationTypeArray())));
            }
            return new GetDataAvailabilityResponse.FormatDescriptor(new GetDataAvailabilityResponse.ProcedureDescriptionFormatDescriptor(procDescFormatDescriptor), (Set)obsFormDescs);
        }
        return null;
    }
}

