/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.sensorml.x20.AbstractPhysicalProcessType;
import net.opengis.sensorml.x20.AbstractProcessDocument;
import net.opengis.sensorml.x20.AbstractProcessType;
import net.opengis.sensorml.x20.AggregateProcessDocument;
import net.opengis.sensorml.x20.AggregateProcessPropertyType;
import net.opengis.sensorml.x20.AggregateProcessType;
import net.opengis.sensorml.x20.CapabilityListType;
import net.opengis.sensorml.x20.CharacteristicListPropertyType;
import net.opengis.sensorml.x20.CharacteristicListType;
import net.opengis.sensorml.x20.ClassifierListPropertyType;
import net.opengis.sensorml.x20.ClassifierListType;
import net.opengis.sensorml.x20.ComponentListPropertyType;
import net.opengis.sensorml.x20.ComponentListType;
import net.opengis.sensorml.x20.ConnectionListPropertyType;
import net.opengis.sensorml.x20.ConnectionListType;
import net.opengis.sensorml.x20.ContactListPropertyType;
import net.opengis.sensorml.x20.DataComponentOrObservablePropertyType;
import net.opengis.sensorml.x20.DataInterfaceType;
import net.opengis.sensorml.x20.DescribedObjectDocument;
import net.opengis.sensorml.x20.DescribedObjectType;
import net.opengis.sensorml.x20.IdentifierListPropertyType;
import net.opengis.sensorml.x20.IdentifierListType;
import net.opengis.sensorml.x20.InputListType;
import net.opengis.sensorml.x20.KeywordListPropertyType;
import net.opengis.sensorml.x20.LinkType;
import net.opengis.sensorml.x20.ObservablePropertyType;
import net.opengis.sensorml.x20.OutputListType;
import net.opengis.sensorml.x20.ParameterListType;
import net.opengis.sensorml.x20.PhysicalComponentDocument;
import net.opengis.sensorml.x20.PhysicalComponentPropertyType;
import net.opengis.sensorml.x20.PhysicalComponentType;
import net.opengis.sensorml.x20.PhysicalSystemDocument;
import net.opengis.sensorml.x20.PhysicalSystemPropertyType;
import net.opengis.sensorml.x20.PhysicalSystemType;
import net.opengis.sensorml.x20.PositionUnionPropertyType;
import net.opengis.sensorml.x20.SimpleProcessDocument;
import net.opengis.sensorml.x20.SimpleProcessPropertyType;
import net.opengis.sensorml.x20.SimpleProcessType;
import net.opengis.sensorml.x20.TermType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.isotc211.x2005.gmd.CIResponsiblePartyPropertyType;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.sensorML.AbstractProcess;
import org.n52.shetland.ogc.sensorML.AbstractSensorML;
import org.n52.shetland.ogc.sensorML.SmlContact;
import org.n52.shetland.ogc.sensorML.Term;
import org.n52.shetland.ogc.sensorML.elements.SmlCapabilities;
import org.n52.shetland.ogc.sensorML.elements.SmlCapability;
import org.n52.shetland.ogc.sensorML.elements.SmlCharacteristic;
import org.n52.shetland.ogc.sensorML.elements.SmlCharacteristics;
import org.n52.shetland.ogc.sensorML.elements.SmlClassifier;
import org.n52.shetland.ogc.sensorML.elements.SmlComponent;
import org.n52.shetland.ogc.sensorML.elements.SmlConnection;
import org.n52.shetland.ogc.sensorML.elements.SmlIdentifier;
import org.n52.shetland.ogc.sensorML.elements.SmlIo;
import org.n52.shetland.ogc.sensorML.elements.SmlLink;
import org.n52.shetland.ogc.sensorML.elements.SmlParameter;
import org.n52.shetland.ogc.sensorML.elements.SmlPosition;
import org.n52.shetland.ogc.sensorML.v20.AbstractPhysicalProcess;
import org.n52.shetland.ogc.sensorML.v20.AbstractProcessV20;
import org.n52.shetland.ogc.sensorML.v20.AggregateProcess;
import org.n52.shetland.ogc.sensorML.v20.DescribedObject;
import org.n52.shetland.ogc.sensorML.v20.PhysicalComponent;
import org.n52.shetland.ogc.sensorML.v20.PhysicalSystem;
import org.n52.shetland.ogc.sensorML.v20.SimpleProcess;
import org.n52.shetland.ogc.sensorML.v20.SmlDataInterface;
import org.n52.shetland.ogc.sensorML.v20.SmlFeatureOfInterest;
import org.n52.shetland.ogc.sos.ProcedureDescriptionFormat;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweDataStream;
import org.n52.shetland.ogc.swe.SweVector;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractSensorMLDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorMLDecoderV20
extends AbstractSensorMLDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorMLDecoderV20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sensorml/2.0", (Class[])new Class[]{DescribedObjectDocument.class, SimpleProcessDocument.class, PhysicalComponentDocument.class, PhysicalSystemDocument.class, AggregateProcessDocument.class, AbstractProcessDocument.class});
    private static final Set<String> REMOVABLE_CAPABILITIES_NAMES = Sets.newHashSet((Object[])new String[]{"offerings"});
    private static final Set<String> REMOVABLE_COMPONENTS_ROLES = Collections.singleton("childProcedure");
    private static final ImmutableSet<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new ProcedureDescriptionFormat("http://www.opengis.net/sensorml/2.0")).build();
    private static final Map<String, ImmutableMap<String, Set<String>>> SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS = ImmutableMap.of((Object)"SOS", (Object)ImmutableMap.builder().put((Object)"2.0.0", (Object)ImmutableSet.of((Object)"http://www.opengis.net/sensorML/1.0.1")).build());

    public SensorMLDecoderV20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        if (SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS.containsKey(service) && SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS.get(service).containsKey((Object)version)) {
            return (Set)SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS.get(service).get((Object)version);
        }
        return Collections.emptySet();
    }

    public AbstractSensorML decode(XmlObject element) throws DecodingException {
        XmlHelper.validateDocument((XmlObject)element);
        return this.parse(element);
    }

    private AbstractSensorML parse(XmlObject element) throws DecodingException {
        DescribedObject sml = null;
        if (element instanceof PhysicalSystemDocument) {
            sml = this.parsePhysicalSystem(((PhysicalSystemDocument)element).getPhysicalSystem());
        } else if (element instanceof PhysicalSystemPropertyType) {
            sml = this.parsePhysicalSystem(((PhysicalSystemPropertyType)element).getPhysicalSystem());
        } else if (element instanceof PhysicalSystemType) {
            sml = this.parsePhysicalSystem((PhysicalSystemType)element);
        } else if (element instanceof PhysicalComponentDocument) {
            sml = this.parsePhysicalComponent(((PhysicalComponentDocument)element).getPhysicalComponent());
        } else if (element instanceof PhysicalComponentPropertyType) {
            sml = this.parsePhysicalComponent(((PhysicalComponentPropertyType)element).getPhysicalComponent());
        } else if (element instanceof PhysicalComponentType) {
            sml = this.parsePhysicalComponent((PhysicalComponentType)element);
        } else if (element instanceof SimpleProcessDocument) {
            sml = this.parseSimpleProcess(((SimpleProcessDocument)element).getSimpleProcess());
        } else if (element instanceof SimpleProcessPropertyType) {
            sml = this.parseSimpleProcess(((SimpleProcessPropertyType)element).getSimpleProcess());
        } else if (element instanceof SimpleProcessType) {
            sml = this.parseSimpleProcess((SimpleProcessType)element);
        } else if (element instanceof AggregateProcessDocument) {
            sml = this.parseAggregateProcess(((AggregateProcessDocument)element).getAggregateProcess());
        } else if (element instanceof AggregateProcessPropertyType) {
            sml = this.parseAggregateProcess(((AggregateProcessPropertyType)element).getAggregateProcess());
        } else if (element instanceof AggregateProcessType) {
            sml = this.parseAggregateProcess((AggregateProcessType)element);
        } else {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, element);
        }
        if (sml != null) {
            this.setXmlDescription(element, (AbstractSensorML)sml);
        }
        return sml;
    }

    private void setXmlDescription(XmlObject xml, AbstractSensorML sml) {
        XmlObject xmlToString = null;
        if (xml.schemaType() != null && xml.schemaType().isDocumentType()) {
            xmlToString = xml;
        } else if (xml instanceof PhysicalSystemPropertyType) {
            PhysicalSystemDocument psd = PhysicalSystemDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            psd.setPhysicalSystem(((PhysicalSystemPropertyType)xml).getPhysicalSystem());
            xmlToString = psd;
        } else if (xml instanceof PhysicalSystemType) {
            PhysicalSystemDocument psd = PhysicalSystemDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            psd.setPhysicalSystem((PhysicalSystemType)xml);
            xmlToString = psd;
        } else if (xml instanceof PhysicalComponentPropertyType) {
            PhysicalComponentDocument pcd = PhysicalComponentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            pcd.setPhysicalComponent(((PhysicalComponentPropertyType)xml).getPhysicalComponent());
            xmlToString = pcd;
        } else if (xml instanceof PhysicalComponentType) {
            PhysicalComponentDocument pcd = PhysicalComponentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            pcd.setPhysicalComponent((PhysicalComponentType)xml);
            xmlToString = pcd;
        } else if (xml instanceof SimpleProcessPropertyType) {
            SimpleProcessDocument spd = SimpleProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            spd.setSimpleProcess(((SimpleProcessPropertyType)xml).getSimpleProcess());
            xmlToString = spd;
        } else if (xml instanceof SimpleProcessType) {
            SimpleProcessDocument spd = SimpleProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            spd.setSimpleProcess((SimpleProcessType)xml);
            xmlToString = spd;
        } else if (xml instanceof AggregateProcessPropertyType) {
            AggregateProcessDocument apd = AggregateProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            apd.setAggregateProcess(((AggregateProcessPropertyType)xml).getAggregateProcess());
            xmlToString = apd;
        } else if (xml instanceof AggregateProcessType) {
            AggregateProcessDocument apd = AggregateProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            apd.setAggregateProcess((AggregateProcessType)xml);
            xmlToString = apd;
        }
        if (xmlToString != null) {
            sml.setXml(xmlToString.xmlText(this.getXmlOptions()));
        }
    }

    private DescribedObject parsePhysicalSystem(PhysicalSystemType describedObject) throws DecodingException {
        PhysicalSystem ps = new PhysicalSystem();
        this.parseAbstractPhysicalProcess((AbstractPhysicalProcessType)describedObject, (AbstractPhysicalProcess)ps);
        this.parseAbstractProcess((AbstractProcessType)describedObject, (AbstractProcessV20)ps);
        this.parseDescribedObject((DescribedObjectType)describedObject, (DescribedObject)ps);
        if (describedObject.isSetComponents()) {
            ps.addComponents(this.parseComponents(describedObject.getComponents()));
            List<Integer> compsToRemove = this.checkComponentsForRemoval(describedObject.getComponents().getComponentList());
            compsToRemove.forEach(arg_0 -> ((ComponentListType)describedObject.getComponents().getComponentList()).removeComponent(arg_0));
            if (this.removeEmptyComponents(describedObject.getComponents())) {
                describedObject.unsetComponents();
            }
        }
        return ps;
    }

    private DescribedObject parsePhysicalComponent(PhysicalComponentType describedObject) throws DecodingException {
        PhysicalComponent pc = new PhysicalComponent();
        this.parseAbstractPhysicalProcess((AbstractPhysicalProcessType)describedObject, (AbstractPhysicalProcess)pc);
        this.parseAbstractProcess((AbstractProcessType)describedObject, (AbstractProcessV20)pc);
        this.parseDescribedObject((DescribedObjectType)describedObject, (DescribedObject)pc);
        return pc;
    }

    private DescribedObject parseSimpleProcess(SimpleProcessType describedObject) throws DecodingException {
        SimpleProcess sp = new SimpleProcess();
        this.parseAbstractProcess((AbstractProcessType)describedObject, (AbstractProcessV20)sp);
        this.parseDescribedObject((DescribedObjectType)describedObject, (DescribedObject)sp);
        return sp;
    }

    private DescribedObject parseAggregateProcess(AggregateProcessType describedObject) throws DecodingException {
        AggregateProcess ap = new AggregateProcess();
        this.parseAbstractProcess((AbstractProcessType)describedObject, (AbstractProcessV20)ap);
        this.parseDescribedObject((DescribedObjectType)describedObject, (DescribedObject)ap);
        if (describedObject.isSetComponents()) {
            ap.addComponents(this.parseComponents(describedObject.getComponents()));
            List<Integer> compsToRemove = this.checkComponentsForRemoval(describedObject.getComponents().getComponentList());
            compsToRemove.forEach(arg_0 -> ((ComponentListType)describedObject.getComponents().getComponentList()).removeComponent(arg_0));
            if (this.removeEmptyComponents(describedObject.getComponents())) {
                describedObject.unsetComponents();
            }
        }
        if (describedObject.isSetConnections()) {
            ap.setConnections(this.parseConnections(describedObject.getConnections()));
        }
        return ap;
    }

    private void parseDescribedObject(DescribedObjectType dot, DescribedObject describedObject) throws DecodingException {
        if (dot.getId() != null && !dot.getId().isEmpty()) {
            describedObject.setGmlId(dot.getId());
        }
        if (dot.isSetIdentifier()) {
            describedObject.setIdentifier((CodeWithAuthority)this.decodeXmlElement((XmlObject)dot.getIdentifier()));
            this.checkIdentifierCodeSpace((AbstractProcessV20)describedObject);
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getKeywordsArray())) {
            this.parseKeywords(dot.getKeywordsArray());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getIdentificationArray())) {
            this.parseIdentifications(describedObject, dot.getIdentificationArray());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getClassificationArray())) {
            this.parseClassification(dot.getClassificationArray());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getCharacteristicsArray())) {
            this.parseCharacteristics((CharacteristicListPropertyType[])dot.getCharacteristicsArray());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getCapabilitiesArray())) {
            this.parseCapabilities((AbstractProcess)describedObject, dot.getCapabilitiesArray());
            this.checkCapabilitiesForRemoval(dot.getCapabilitiesArray()).forEach(arg_0 -> ((DescribedObjectType)dot).removeCapabilities(arg_0));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])dot.getContactsArray())) {
            this.parseContact(dot.getContactsArray());
        }
    }

    private void parseAbstractProcess(AbstractProcessType apt, AbstractProcessV20 abstractProcess) throws DecodingException {
        Object decodedElement;
        if (apt.isSetTypeOf() && (decodedElement = this.decodeXmlElement((XmlObject)apt.getTypeOf())) instanceof ReferenceType) {
            abstractProcess.setTypeOf((ReferenceType)decodedElement);
        }
        if (apt.isSetFeaturesOfInterest()) {
            this.parseFeatureOfInterest(apt.getFeaturesOfInterest(), abstractProcess);
        }
        if (apt.isSetInputs()) {
            abstractProcess.setInputs(this.parseInputs(apt.getInputs()));
        }
        if (apt.isSetOutputs()) {
            abstractProcess.setOutputs(this.parseOutputs(apt.getOutputs()));
        }
        if (apt.isSetParameters()) {
            abstractProcess.setParameters(this.parseParameters(apt.getParameters()));
        }
    }

    private void parseAbstractPhysicalProcess(AbstractPhysicalProcessType appt, AbstractPhysicalProcess abstractPhysicalProcess) throws DecodingException {
        block1: {
            PositionUnionPropertyType[] positionUnionPropertyTypeArray;
            int n;
            int n2;
            Object decodeXmlElement;
            if (appt.isSetAttachedTo() && (decodeXmlElement = this.decodeXmlElement((XmlObject)appt.getAttachedTo())) != null && decodeXmlElement instanceof ReferenceType) {
                abstractPhysicalProcess.setAttachedTo((ReferenceType)decodeXmlElement);
            }
            if (!CollectionHelper.isNotNullOrEmpty((Object[])appt.getPositionArray()) || (n2 = 0) >= (n = (positionUnionPropertyTypeArray = appt.getPositionArray()).length)) break block1;
            PositionUnionPropertyType pupt = positionUnionPropertyTypeArray[n2];
            abstractPhysicalProcess.setPosition(this.parsePositionFrom(pupt));
        }
    }

    private List<String> parseKeywords(KeywordListPropertyType[] keywordsArray) {
        HashSet keywords = Sets.newHashSet();
        if (keywordsArray != null && keywordsArray.length > 0) {
            for (KeywordListPropertyType keyword : keywordsArray) {
                String[] array;
                if (!keyword.isSetKeywordList() || (array = keyword.getKeywordList().getKeywordArray()) == null || array.length <= 0) continue;
                keywords.addAll(Arrays.asList(array));
            }
        }
        return Lists.newArrayList((Iterable)keywords);
    }

    private void parseIdentifications(DescribedObject describedObject, IdentifierListPropertyType[] identificationArray) {
        for (IdentifierListPropertyType ilpt : identificationArray) {
            if (!ilpt.isSetIdentifierList() || !CollectionHelper.isNotNullOrEmpty((Object[])ilpt.getIdentifierList().getIdentifier2Array())) continue;
            for (IdentifierListType.Identifier i : ilpt.getIdentifierList().getIdentifier2Array()) {
                if (i.getTerm() == null) continue;
                SmlIdentifier identifier = new SmlIdentifier();
                this.parseTerm(i.getTerm(), (Term)identifier);
                describedObject.addIdentifier(identifier);
                if (!this.isIdentificationProcedureIdentifier(identifier)) continue;
                describedObject.setIdentifier(identifier.getValue());
            }
        }
    }

    private List<SmlClassifier> parseClassification(ClassifierListPropertyType[] clpts) {
        ArrayList<SmlClassifier> sosClassifiers = new ArrayList<SmlClassifier>(clpts.length);
        for (ClassifierListPropertyType clpt : clpts) {
            ClassifierListType clt;
            if (!clpt.isSetClassifierList() || !CollectionHelper.isNotNullOrEmpty((Object[])(clt = clpt.getClassifierList()).getClassifierArray())) continue;
            for (ClassifierListType.Classifier c : clt.getClassifierArray()) {
                if (c.getTerm() == null) continue;
                SmlClassifier smlClassifier = new SmlClassifier();
                this.parseTerm(c.getTerm(), (Term)smlClassifier);
                sosClassifiers.add(smlClassifier);
            }
        }
        return sosClassifiers;
    }

    private void parseTerm(TermType t, Term term) {
        term.setLabel(t.getLabel());
        term.setName(t.getLabel());
        if (t.isSetDefinition()) {
            term.setDefinition(t.getDefinition());
        }
        if (t.isSetCodeSpace()) {
            term.setCodeSpace(t.getCodeSpace().getHref());
        }
        term.setValue(t.getValue());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SmlCharacteristics> parseCharacteristics(CharacteristicListPropertyType[] clpts) throws DecodingException {
        ArrayList<SmlCharacteristics> sosCharacteristicsList = new ArrayList<SmlCharacteristics>(clpts.length);
        for (CharacteristicListPropertyType clpt : clpts) {
            CharacteristicListType clt;
            SmlCharacteristics sosCharacteristics = new SmlCharacteristics();
            if (clpt.isSetCharacteristicList() && CollectionHelper.isNotNullOrEmpty((Object[])(clt = clpt.getCharacteristicList()).getCharacteristicArray())) {
                for (CharacteristicListType.Characteristic c : clt.getCharacteristicArray()) {
                    SmlCharacteristic characteristic = new SmlCharacteristic(c.getName());
                    if (c.isSetAbstractDataComponent()) {
                        Object o = this.decodeXmlElement((XmlObject)c.getAbstractDataComponent());
                        if (!(o instanceof SweAbstractDataComponent)) throw new DecodingException(XmlHelper.getLocalName((XmlObject)clpt), "Error while parsing the characteristics of the SensorML (the characteristics' data record is not of type DataRecordPropertyType)!", new Object[0]);
                        characteristic.setAbstractDataComponent((SweAbstractDataComponent)o);
                    } else if (c.isSetHref()) {
                        characteristic.setHref(c.getHref());
                        if (c.isSetTitle()) {
                            characteristic.setTitle(c.getTitle());
                        }
                    }
                    sosCharacteristics.addCharacteristic(characteristic);
                }
            }
            sosCharacteristicsList.add(sosCharacteristics);
        }
        return sosCharacteristicsList;
    }

    private void parseCapabilities(AbstractProcess abstractProcess, DescribedObjectType.Capabilities[] capabilitiesArray) throws DecodingException {
        for (DescribedObjectType.Capabilities cs : capabilitiesArray) {
            CapabilityListType cl;
            SmlCapabilities capabilities = new SmlCapabilities(cs.getName());
            if (cs.isSetCapabilityList() && CollectionHelper.isNotNullOrEmpty((Object[])(cl = cs.getCapabilityList()).getCapabilityArray())) {
                for (CapabilityListType.Capability c : cl.getCapabilityArray()) {
                    SmlCapability capability = new SmlCapability(c.getName());
                    if (c.isSetAbstractDataComponent()) {
                        Object o = this.decodeXmlElement((XmlObject)c.getAbstractDataComponent());
                        if (o instanceof SweAbstractDataComponent) {
                            capability.setAbstractDataComponent((SweAbstractDataComponent)o);
                            capabilities.addCapability(capability);
                            continue;
                        }
                        throw new DecodingException(XmlHelper.getLocalName((XmlObject)cs), "Error while parsing the capabilities of the SensorML (the capabilities data record is not of type DataRecordPropertyType)!", new Object[0]);
                    }
                    if (!c.isSetHref()) continue;
                    capability.setHref(c.getHref());
                    if (!c.isSetTitle()) continue;
                    capability.setTitle(c.getTitle());
                }
            }
            abstractProcess.addCapabilities(capabilities);
        }
    }

    private List<SmlContact> parseContact(ContactListPropertyType[] clpts) throws DecodingException {
        ArrayList smlContacts = Lists.newArrayList();
        for (ContactListPropertyType clpt : clpts) {
            if (!clpt.isSetContactList() || !CollectionHelper.isNotNullOrEmpty((Object[])clpt.getContactList().getContactArray())) continue;
            for (CIResponsiblePartyPropertyType c : clpt.getContactList().getContactArray()) {
                Object o = this.decodeXmlElement((XmlObject)c);
                if (!(o instanceof SmlContact)) {
                    throw new DecodingException(XmlHelper.getLocalName((XmlObject)c), "Error while parsing the contacts of the SensorML!", new Object[0]);
                }
                smlContacts.add((SmlContact)o);
            }
        }
        return smlContacts;
    }

    private List<SmlParameter> parseParameters(AbstractProcessType.Parameters parameters) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])parameters.getParameterList().getParameterArray())) {
            ArrayList<SmlParameter> sweComponents = new ArrayList<SmlParameter>(parameters.getParameterList().getParameterArray().length);
            for (ParameterListType.Parameter sweComponent : parameters.getParameterList().getParameterArray()) {
                sweComponents.add(this.parseSweParameter(sweComponent));
            }
            return sweComponents;
        }
        return Collections.emptyList();
    }

    private List<SmlIo> parseInputs(AbstractProcessType.Inputs inputs) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])inputs.getInputList().getInputArray())) {
            ArrayList<SmlIo> sosInputs = new ArrayList<SmlIo>(inputs.getInputList().getInputArray().length);
            for (InputListType.Input xbInput : inputs.getInputList().getInputArray()) {
                sosInputs.add(this.parseInput(xbInput));
            }
            return sosInputs;
        }
        return Collections.emptyList();
    }

    private List<SmlIo> parseOutputs(AbstractProcessType.Outputs outputs) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])outputs.getOutputList().getOutputArray())) {
            ArrayList<SmlIo> sosOutputs = new ArrayList<SmlIo>(outputs.getOutputList().getOutputArray().length);
            for (OutputListType.Output xbOutput : outputs.getOutputList().getOutputArray()) {
                sosOutputs.add(this.parseOutput(xbOutput));
            }
            return sosOutputs;
        }
        return Collections.emptyList();
    }

    private void parseFeatureOfInterest(AbstractProcessType.FeaturesOfInterest featuresOfInterest, AbstractProcessV20 abstractProcess) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])featuresOfInterest.getFeatureList().getFeatureArray())) {
            SmlFeatureOfInterest smlFeatureOfInterest = new SmlFeatureOfInterest();
            for (FeaturePropertyType fpt : featuresOfInterest.getFeatureList().getFeatureArray()) {
                Object o = this.decodeXmlElement((XmlObject)fpt);
                if (!(o instanceof AbstractFeature)) continue;
                smlFeatureOfInterest.addFeatureOfInterest((AbstractFeature)o);
            }
            abstractProcess.setSmlFeatureOfInterest(smlFeatureOfInterest);
        }
    }

    private SmlPosition parsePositionFrom(PositionUnionPropertyType pupt) throws DecodingException {
        SmlPosition position = new SmlPosition();
        if (pupt.isSetVector()) {
            Object decodeXmlElement = this.decodeXmlElement((XmlObject)pupt.getVector());
            if (decodeXmlElement != null && decodeXmlElement instanceof SweVector) {
                position.setVector((SweVector)decodeXmlElement);
            }
        } else if (pupt.isSetDataRecord()) {
            Object decodeXmlElement = this.decodeXmlElement((XmlObject)pupt.getDataRecord());
            if (decodeXmlElement != null && decodeXmlElement instanceof SweDataRecord) {
                position.setAbstractDataComponent((SweAbstractDataComponent)((SweDataRecord)decodeXmlElement));
            }
        } else {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)pupt);
        }
        return position;
    }

    private List<SmlComponent> parseComponents(ComponentListPropertyType components) throws DecodingException {
        LinkedList sosSmlComponents = Lists.newLinkedList();
        if (components.isSetComponentList() && components.getComponentList().getComponentArray() != null) {
            for (ComponentListType.Component component : components.getComponentList().getComponentArray()) {
                AbstractSensorML abstractProcess;
                if (!component.isSetAbstractProcess() && !component.isSetHref() && !component.isSetTitle()) continue;
                SmlComponent sosSmlcomponent = new SmlComponent(component.getName());
                if (component.isSetAbstractProcess()) {
                    abstractProcess = this.parse((XmlObject)component.getAbstractProcess());
                } else {
                    if (component.isSetTitle()) {
                        sosSmlcomponent.setTitle(component.getTitle());
                    }
                    if (component.isSetHref()) {
                        sosSmlcomponent.setHref(component.getHref());
                    }
                    abstractProcess = new AbstractProcess();
                    if (sosSmlcomponent.isSetTitle()) {
                        abstractProcess.setIdentifier(sosSmlcomponent.getTitle());
                    } else if (!sosSmlcomponent.isSetTitle() && sosSmlcomponent.isSetHref()) {
                        abstractProcess.setIdentifier(sosSmlcomponent.getHref());
                    }
                }
                sosSmlcomponent.setProcess(abstractProcess);
                sosSmlComponents.add(sosSmlcomponent);
            }
        }
        return sosSmlComponents;
    }

    private SmlConnection parseConnections(ConnectionListPropertyType connections) throws DecodingException {
        SmlConnection sosSmlConnection = new SmlConnection();
        if (connections.isSetConnectionList() && connections.getConnectionList().getConnectionArray() != null) {
            for (ConnectionListType.Connection connection : connections.getConnectionList().getConnectionArray()) {
                if (connection.getLink() == null) continue;
                LinkType link = connection.getLink();
                sosSmlConnection.addConnection(new SmlLink(link.getDestination().getRef(), link.getSource().getRef()));
            }
        }
        return sosSmlConnection;
    }

    private boolean checkIdentifierCodeSpace(AbstractProcessV20 ap) throws DecodingException {
        if (ap.getIdentifierCodeWithAuthority().isSetCodeSpace() && "uniqueID".equals(ap.getIdentifierCodeWithAuthority().getCodeSpace())) {
            return true;
        }
        throw new DecodingException("gml:identifier[@codesSpace]", ap.getIdentifierCodeWithAuthority().getCodeSpace(), new Object[0]);
    }

    private List<Integer> checkCapabilitiesForRemoval(DescribedObjectType.Capabilities[] capabilitiesArray) {
        ArrayList<Integer> removeableCaps = new ArrayList<Integer>(capabilitiesArray.length);
        for (int i = 0; i < capabilitiesArray.length; ++i) {
            String name = capabilitiesArray[i].getName();
            if (name == null || !REMOVABLE_CAPABILITIES_NAMES.contains(name)) continue;
            removeableCaps.add(i);
        }
        Collections.sort(removeableCaps);
        Collections.reverse(removeableCaps);
        return removeableCaps;
    }

    private List<Integer> checkComponentsForRemoval(ComponentListType componentList) {
        ArrayList<Integer> removeableComponents = new ArrayList<Integer>(0);
        if (componentList != null && componentList.getComponentArray() != null) {
            ComponentListType.Component[] componentArray = componentList.getComponentArray();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i].getRole() == null || !REMOVABLE_COMPONENTS_ROLES.contains(componentArray[i].getRole())) continue;
                removeableComponents.add(i);
            }
        }
        return removeableComponents;
    }

    private boolean removeEmptyComponents(ComponentListPropertyType components) {
        boolean removeComponents = false;
        if (components != null) {
            if (components.getComponentList() == null) {
                removeComponents = true;
            } else if (components.getComponentList().getComponentArray() == null || components.getComponentList().getComponentArray() != null && components.getComponentList().getComponentArray().length == 0) {
                removeComponents = true;
            }
        }
        return removeComponents;
    }

    private SmlParameter parseSweParameter(ParameterListType.Parameter xbParameter) throws DecodingException {
        SmlParameter param = new SmlParameter();
        String name = xbParameter.getName();
        if (xbParameter.isSetHref()) {
            param.setHref(xbParameter.getHref());
            if (xbParameter.isSetTitle()) {
                param.setTitle(xbParameter.getTitle());
            }
            return param;
        }
        Object parameter = this.decodeXmlElement((XmlObject)xbParameter.getAbstractDataComponent());
        if (parameter instanceof SweAbstractDataComponent) {
            if (xbParameter.getName() != null && !xbParameter.getName().isEmpty()) {
                ((SweAbstractDataComponent)parameter).setName(name);
            }
            param.setName(name);
            param.setParameter((SweAbstractDataComponent)parameter);
            return param;
        }
        throw new DecodingException(XmlHelper.getLocalName((XmlObject)xbParameter), "An 'SweAbstractDataComponent' is not supported", new Object[0]);
    }

    private SmlIo parseInput(InputListType.Input xbInput) throws DecodingException {
        SmlIo sosIo = new SmlIo();
        sosIo.setIoName(xbInput.getName());
        if (xbInput.isSetHref()) {
            this.parseReference((DataComponentOrObservablePropertyType)xbInput, sosIo);
        } else {
            sosIo.setIoValue(this.parseDataComponentOrObservablePropertyType((DataComponentOrObservablePropertyType)xbInput));
        }
        return sosIo;
    }

    private void parseReference(DataComponentOrObservablePropertyType adcpt, SmlIo sosIo) {
        sosIo.setHref(adcpt.getHref());
        if (adcpt.isSetTitle()) {
            sosIo.setTitle(adcpt.getTitle());
        }
    }

    private SmlIo parseOutput(OutputListType.Output xbOutput) throws DecodingException {
        SmlIo sosIo = new SmlIo();
        sosIo.setIoName(xbOutput.getName());
        if (xbOutput.isSetHref()) {
            this.parseReference((DataComponentOrObservablePropertyType)xbOutput, sosIo);
        } else {
            sosIo.setIoValue(this.parseDataComponentOrObservablePropertyType((DataComponentOrObservablePropertyType)xbOutput));
        }
        return sosIo;
    }

    private SweAbstractDataComponent parseDataComponentOrObservablePropertyType(DataComponentOrObservablePropertyType adcpt) throws DecodingException {
        XmlObject toDecode = null;
        if (adcpt.isSetObservableProperty()) {
            return this.parseObservableProperty(adcpt.getObservableProperty());
        }
        if (adcpt.isSetAbstractDataComponent()) {
            Object decodedObject = this.decodeXmlElement((XmlObject)adcpt.getAbstractDataComponent());
            if (decodedObject instanceof SweAbstractDataComponent) {
                return (SweAbstractDataComponent)decodedObject;
            }
            throw new DecodingException(XmlHelper.getLocalName((XmlObject)adcpt), "The 'DataComponentOrObservablePropertyType' with type '%s' as value for '%s' is not supported.", new Object[]{XmlHelper.getLocalName(toDecode), XmlHelper.getLocalName((XmlObject)adcpt)});
        }
        if (adcpt.isSetDataInterface()) {
            return this.parseDataInterfaceType(adcpt.getDataInterface());
        }
        throw new DecodingException(XmlHelper.getLocalName((XmlObject)adcpt), "An 'DataComponentOrObservablePropertyType' is not supported", new Object[0]);
    }

    protected SmlDataInterface parseDataInterfaceType(DataInterfaceType xbDataInterface) throws DecodingException {
        Object parameter;
        SmlDataInterface dataInterface = new SmlDataInterface();
        Object data = this.decodeXmlElement((XmlObject)xbDataInterface.getData());
        if (data instanceof SweDataStream) {
            dataInterface.setData((SweDataStream)data);
        }
        if (xbDataInterface.isSetInterfaceParameters() && (parameter = this.decodeXmlElement((XmlObject)xbDataInterface.getInterfaceParameters())) instanceof SweDataRecord) {
            dataInterface.setInputParameters((SweDataRecord)parameter);
        }
        return dataInterface;
    }

    private SweObservableProperty parseObservableProperty(ObservablePropertyType opt) {
        SweObservableProperty observableProperty = new SweObservableProperty();
        observableProperty.setDefinition(opt.getDefinition());
        if (opt.isSetDescription()) {
            observableProperty.setDescription(opt.getDescription());
        }
        if (opt.isSetIdentifier()) {
            observableProperty.setIdentifier(opt.getIdentifier());
        }
        if (opt.isSetLabel()) {
            observableProperty.setLabel(opt.getLabel());
        }
        return observableProperty;
    }
}

