/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import eu.europa.ec.inspire.schemas.ef.x40.AbstractMonitoringObjectPropertyType;
import eu.europa.ec.inspire.schemas.ef.x40.AbstractMonitoringObjectType;
import java.net.URI;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.inspire.ef.AbstractMonitoringObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.encode.AbstractEnvironmentalFaciltityEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractMonitoringObjectEncoder
extends AbstractEnvironmentalFaciltityEncoder<XmlObject, AbstractFeature> {
    protected abstract String generateGmlId();

    protected void encodeAbstractMonitoringObject(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        this.setGmlId(amot, abstractMonitoringObject);
        this.setInspireId(amot, abstractMonitoringObject);
        this.setName(amot, abstractMonitoringObject);
        this.setAdditionalDescription(amot, abstractMonitoringObject);
        this.setMediaMonitored(amot, abstractMonitoringObject);
        this.setLegalBackground(amot, abstractMonitoringObject);
        this.setResponsibleParty(amot, abstractMonitoringObject);
        this.setGeometry(amot, abstractMonitoringObject);
        this.setOnlineResource(amot, abstractMonitoringObject);
        this.setPurpose(amot, abstractMonitoringObject);
        this.setObservingCapability(amot, abstractMonitoringObject);
        this.setBroader(amot, abstractMonitoringObject);
        this.setNarrower(amot, abstractMonitoringObject);
        this.setSupersedes(amot, abstractMonitoringObject);
        this.setSupersededBy(amot, abstractMonitoringObject);
    }

    private void setGmlId(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (!abstractMonitoringObject.isSetGmlID() && !abstractMonitoringObject.isSetGmlID()) {
            abstractMonitoringObject.setGmlId(this.generateGmlId());
        }
        amot.setId(abstractMonitoringObject.getGmlId());
    }

    private void setInspireId(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        amot.addNewInspireId().set(this.encodeBASEPropertyType(abstractMonitoringObject.getInspireId()));
    }

    private void setName(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (abstractMonitoringObject.isSetName()) {
            for (CodeType name : abstractMonitoringObject.getName()) {
                if (!name.isSetValue()) continue;
                amot.addNewName2().setStringValue(name.getValue());
            }
        }
    }

    private void setAdditionalDescription(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (abstractMonitoringObject.isSetAdditionalDescription()) {
            amot.addNewAdditionalDescription().setStringValue(abstractMonitoringObject.getAdditionalDescription());
        }
    }

    private void setMediaMonitored(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        for (ReferenceType mediaMonitored : abstractMonitoringObject.getMediaMonitored()) {
            amot.addNewMediaMonitored().set(this.encodeGML32(mediaMonitored));
        }
    }

    private void setLegalBackground(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetLegalBackground()) {
            for (Referenceable legislationCitation : abstractMonitoringObject.getLegalBackground()) {
                if (legislationCitation.isReference()) {
                    Reference reference = legislationCitation.getReference();
                    if (!reference.getHref().isPresent()) continue;
                    AbstractMonitoringObjectType.LegalBackground lb = amot.addNewLegalBackground();
                    lb.setHref(((URI)reference.getHref().get()).toString());
                    if (!reference.getTitle().isPresent()) continue;
                    lb.setTitle((String)reference.getTitle().get());
                    continue;
                }
                amot.addNewLegalBackground().addNewLegislationCitation().set(this.encodeEF(legislationCitation));
            }
        }
    }

    private void setResponsibleParty(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetResponsibleParty()) {
            amot.addNewResponsibleParty().addNewRelatedParty().set(this.encodeBASE2(abstractMonitoringObject.getResponsibleParty()));
        }
    }

    private void setGeometry(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetGeometry()) {
            if (abstractMonitoringObject.isSetGmlID()) {
                amot.addNewGeometry().set(this.encodeGML32(abstractMonitoringObject.getGeometry(), new EncodingContext().with((Enum)XmlBeansEncodingFlags.GMLID, (Object)abstractMonitoringObject.getGmlId())));
            } else {
                amot.addNewGeometry().set(this.encodeGML32(abstractMonitoringObject.getGeometry()));
            }
        }
    }

    private void setOnlineResource(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (abstractMonitoringObject.isSetOnlineResources()) {
            for (String onlineResource : abstractMonitoringObject.getOnlineResource()) {
                amot.addNewOnlineResource().setStringValue(onlineResource);
            }
        }
    }

    private void setPurpose(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetPurpose()) {
            for (ReferenceType purpose : abstractMonitoringObject.getPurpose()) {
                amot.addNewPurpose().set(this.encodeGML32(purpose));
            }
        }
    }

    private void setObservingCapability(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetObservingCapability()) {
            for (Referenceable observingCapability : abstractMonitoringObject.getObservingCapability()) {
                if (observingCapability.isReference() && observingCapability.getReference().getHref().isPresent()) {
                    AbstractMonitoringObjectType.ObservingCapability oc = amot.addNewObservingCapability();
                    oc.setHref(((URI)observingCapability.getReference().getHref().get()).toString());
                    if (!observingCapability.getReference().getTitle().isPresent()) continue;
                    oc.setTitle((String)observingCapability.getReference().getTitle().get());
                    continue;
                }
                amot.addNewObservingCapability().addNewObservingCapability().set(this.encodeEF(observingCapability));
            }
        }
    }

    private void setBroader(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetBroader()) {
            Referenceable broader = abstractMonitoringObject.getBroader();
            if (broader.isReference()) {
                AbstractMonitoringObjectType.Broader b = amot.addNewBroader();
                b.setHref(((URI)broader.getReference().getHref().get()).toString());
                if (broader.getReference().getTitle().isPresent()) {
                    b.setTitle((String)broader.getReference().getTitle().get());
                }
            } else {
                amot.addNewBroader().addNewHierarchy().set(this.encodeEF(broader.getInstance().get()));
            }
        }
    }

    private void setNarrower(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetNarrower()) {
            for (Referenceable narrower : abstractMonitoringObject.getNarrower()) {
                if (narrower.isReference()) {
                    AbstractMonitoringObjectType.Narrower n = amot.addNewNarrower();
                    n.setHref(((URI)narrower.getReference().getHref().get()).toString());
                    if (!narrower.getReference().getTitle().isPresent()) continue;
                    n.setTitle((String)narrower.getReference().getTitle().get());
                    continue;
                }
                amot.addNewNarrower().addNewHierarchy().set(this.encodeEF(narrower.getInstance().get()));
            }
        }
    }

    private void setSupersedes(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetSupersedes()) {
            for (Referenceable supersedes : abstractMonitoringObject.getSupersedes()) {
                if (supersedes.isReference()) {
                    AbstractMonitoringObjectType.Supersedes s = amot.addNewSupersedes();
                    s.setHref(((URI)supersedes.getReference().getHref().get()).toString());
                    if (!supersedes.getReference().getTitle().isPresent()) continue;
                    s.setTitle((String)supersedes.getReference().getTitle().get());
                    continue;
                }
                amot.addNewSupersedes().addNewAbstractMonitoringObject().set(this.encodeEF(supersedes.getInstance().get()));
            }
        }
    }

    private void setSupersededBy(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetSupersededBy()) {
            for (Referenceable supersededBy : abstractMonitoringObject.getSupersededBy()) {
                if (supersededBy.isReference()) {
                    AbstractMonitoringObjectPropertyType sb = amot.addNewSupersededBy();
                    sb.setHref(((URI)supersededBy.getReference().getHref().get()).toString());
                    if (!supersededBy.getReference().getTitle().isPresent()) continue;
                    sb.setTitle((String)supersededBy.getReference().getTitle().get());
                    continue;
                }
                amot.addNewSupersededBy().addNewAbstractMonitoringObject().set(this.encodeEF(supersededBy.getInstance().get()));
            }
        }
    }
}

