/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.util.function.Supplier;
import javax.inject.Inject;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.svalbard.encode.AbstractDelegatingEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.SchemaAwareEncoder;
import org.n52.svalbard.encode.XmlDocumentEncoderKey;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.XmlPropertyTypeEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.util.XmlHelper;

public abstract class AbstractXmlEncoder<T, S>
extends AbstractDelegatingEncoder<T, S>
implements SchemaAwareEncoder<T, S> {
    private Supplier<XmlOptions> xmlOptions;

    public XmlOptions getXmlOptions() {
        return this.xmlOptions.get();
    }

    @Inject
    public void setXmlOptions(Supplier<XmlOptions> xmlOptions) {
        this.xmlOptions = xmlOptions;
    }

    public T encode(S element) throws EncodingException {
        return (T)this.encode(element, EncodingContext.empty());
    }

    public MediaType getContentType() {
        return MediaTypes.TEXT_XML;
    }

    protected XmlObject substitute(XmlObject elementToSubstitute, XmlObject substitutionElement) {
        XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)elementToSubstitute, (XmlObject)substitutionElement);
        substituteElement.set(substitutionElement);
        return substituteElement;
    }

    public <T> Encoder<XmlObject, T> getEncoder(String namespace, T o) throws EncodingException {
        return this.getAndCheck(this.getEncoderKey(namespace, o));
    }

    public <T> Encoder<XmlObject, T> getEncoder(String namespace, Class<? super T> o) throws EncodingException {
        return this.getAndCheck(this.getEncoderKey(namespace, o));
    }

    public <T> Encoder<XmlObject, T> getDocumentEncoder(String namespace, T o) throws EncodingException {
        return this.getAndCheck(this.getDocumentEncoderKey(namespace, o));
    }

    public <T> Encoder<XmlObject, T> getDocumentEncoder(String namespace, Class<? super T> o) throws EncodingException {
        return this.getAndCheck(this.getDocumentEncoderKey(namespace, o));
    }

    public <T> Encoder<XmlObject, T> getPropertyTypeEncoder(String namespace, T o) throws EncodingException {
        return this.getAndCheck(this.getPropertyTypeEncoderKey(namespace, o));
    }

    public <T> Encoder<XmlObject, T> getPropertyTypeEncoder(String namespace, Class<? super T> o) throws EncodingException {
        return this.getAndCheck(this.getPropertyTypeEncoderKey(namespace, o));
    }

    public <T> Encoder<XmlObject, T> getAndCheck(EncoderKey key) throws NoEncoderForKeyException {
        Encoder encoder = this.getEncoder(key, new EncoderKey[0]);
        if (encoder == null) {
            throw new NoEncoderForKeyException((Object)key);
        }
        return encoder;
    }

    public <T> XmlObject encodeObjectToXml(String namespace, T object, EncodingContext helperValues) throws EncodingException {
        return (XmlObject)this.getEncoder(namespace, object).encode(object, helperValues == null ? EncodingContext.empty() : helperValues);
    }

    public XmlObject encodeObjectToXml(String namespace, Object object) throws EncodingException {
        return this.encodeObjectToXml(namespace, object, null);
    }

    public String encodeObjectToXmlText(String namespace, Object object, EncodingContext helperValues) throws EncodingException {
        return this.encodeObjectToXml(namespace, object, helperValues).xmlText(this.getXmlOptions());
    }

    public String encodeObjectToXmlText(String namespace, Object object) throws EncodingException {
        return this.encodeObjectToXmlText(namespace, object, null);
    }

    public <T> XmlObject encodeObjectToXmlDocument(String namespace, T object, EncodingContext helperValues) throws EncodingException {
        return (XmlObject)this.getDocumentEncoder(namespace, object).encode(object, helperValues == null ? EncodingContext.empty() : helperValues);
    }

    public XmlObject encodeObjectToXmlDocument(String namespace, Object object) throws EncodingException {
        return this.encodeObjectToXmlDocument(namespace, object, null);
    }

    public <T> XmlObject encodeObjectToXmlPropertyType(String namespace, T object, EncodingContext helperValues) throws EncodingException {
        return (XmlObject)this.getPropertyTypeEncoder(namespace, object).encode(object, helperValues == null ? EncodingContext.empty() : helperValues);
    }

    public XmlObject encodeObjectToXmlPropertyType(String namespace, Object object) throws EncodingException {
        return this.encodeObjectToXmlPropertyType(namespace, object, null);
    }

    public EncoderKey getEncoderKey(String namespace, Object o) {
        return new XmlEncoderKey(namespace, o.getClass());
    }

    public EncoderKey getEncoderKey(String namespace, Class<?> o) {
        return new XmlEncoderKey(namespace, o);
    }

    public EncoderKey getDocumentEncoderKey(String namespace, Object o) {
        return new XmlDocumentEncoderKey(namespace, o.getClass());
    }

    public EncoderKey getDocumentEncoderKey(String namespace, Class<?> o) {
        return new XmlDocumentEncoderKey(namespace, o);
    }

    public EncoderKey getPropertyTypeEncoderKey(String namespace, Object o) {
        return new XmlPropertyTypeEncoderKey(namespace, o.getClass());
    }

    public EncoderKey getPropertyTypeEncoderKey(String namespace, Class<?> o) {
        return new XmlPropertyTypeEncoderKey(namespace, o);
    }
}

