/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Set;
import net.opengis.sos.x20.CapabilitiesDocument;
import net.opengis.sos.x20.CapabilitiesType;
import net.opengis.sos.x20.ContentsType;
import net.opengis.sos.x20.InsertionCapabilitiesDocument;
import net.opengis.sos.x20.InsertionCapabilitiesType;
import net.opengis.sos.x20.ObservationOfferingType;
import net.opengis.swes.x20.AbstractContentsType;
import net.opengis.swes.x20.AbstractOfferingType;
import net.opengis.swes.x20.FeatureRelationshipType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.GenericMetaData;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.ows.OwsCapabilities;
import org.n52.shetland.ogc.ows.OwsCapabilitiesExtension;
import org.n52.shetland.ogc.ows.OwsOperationsMetadata;
import org.n52.shetland.ogc.ows.extension.Extension;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.ows.extension.StringBasedExtension;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosInsertionCapabilities;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.ogc.sos.SosOffering;
import org.n52.shetland.ogc.sos.extension.SosObservationOfferingExtension;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.W3CConstants;
import org.n52.svalbard.encode.AbstractSosResponseEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetCapabilitiesResponseEncoder
extends AbstractSosResponseEncoder<GetCapabilitiesResponse> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetCapabilitiesResponseEncoder.class);
    private static final String ID_FORMAT_STRING = "%s_%d";

    public GetCapabilitiesResponseEncoder() {
        super(SosConstants.Operations.GetCapabilities.name(), GetCapabilitiesResponse.class);
    }

    @Override
    protected void create(GetCapabilitiesResponse response, OutputStream outputStream, EncodingContext encodingValues) throws EncodingException {
        if (response.isStatic()) {
            try {
                outputStream.write(response.getStaticString().getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException ioe) {
                throw new EncodingException("Error while writing element to stream!", (Throwable)ioe);
            }
        } else {
            super.create(response, outputStream, encodingValues);
        }
    }

    @Override
    protected XmlObject create(GetCapabilitiesResponse response) throws EncodingException {
        CapabilitiesDocument doc = CapabilitiesDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        CapabilitiesType xbCaps = doc.addNewCapabilities();
        if (response.hasExtensions()) {
            this.createExtension(xbCaps, response.getExtensions());
        }
        if (response.isStatic()) {
            String xml = response.getStaticString();
            LOGGER.trace("Response is static. XML-String:\n{}\n", (Object)xml);
            try {
                doc.set(XmlObject.Factory.parse((String)xml));
                return doc;
            }
            catch (XmlException ex) {
                throw new EncodingException("Error encoding static capabilities", (Throwable)ex);
            }
        }
        if (response.getCapabilities().getVersion() != null) {
            xbCaps.setVersion(response.getCapabilities().getVersion());
        } else {
            xbCaps.setVersion(response.getVersion());
        }
        if (response.getCapabilities().getUpdateSequence().isPresent()) {
            xbCaps.setUpdateSequence((String)response.getCapabilities().getUpdateSequence().get());
        }
        this.encodeServiceIdentification(response.getCapabilities(), xbCaps);
        this.encodeServiceProvider(response.getCapabilities(), xbCaps);
        this.encodeOperationsMetadata(response.getCapabilities(), xbCaps);
        if (response.getCapabilities() instanceof SosCapabilities) {
            SosCapabilities caps = (SosCapabilities)response.getCapabilities();
            this.encodeFilterCapabilities(caps, xbCaps);
            this.encodeContents(caps, xbCaps, response.getVersion());
            this.encodeExtensions(caps, xbCaps);
        }
        return doc;
    }

    private void createExtension(CapabilitiesType xbCaps, Extensions extensions) throws EncodingException {
        for (Extension extension : extensions.getExtensions()) {
            if (!(extension.getValue() instanceof SweAbstractDataComponent)) continue;
            xbCaps.addNewExtension().set(this.encodeGML32(new GenericMetaData(extension.getValue())));
        }
    }

    private void setExtensions(XmlObject xml, OwsCapabilitiesExtension extension) throws EncodingException {
        if (extension instanceof SosInsertionCapabilities) {
            xml.set(this.createInsertionCapabilities((SosInsertionCapabilities)extension));
        } else if (extension instanceof StringBasedExtension) {
            try {
                xml.set(XmlObject.Factory.parse((String)((StringBasedExtension)extension).getExtension()));
            }
            catch (XmlException ex) {
                throw GetCapabilitiesResponseEncoder.errorEncodingSwesExtension(ex);
            }
        } else {
            throw new EncodingException("The extension element is not supported by this service!", new Object[0]);
        }
    }

    private XmlObject createInsertionCapabilities(SosInsertionCapabilities caps) {
        InsertionCapabilitiesDocument doc = InsertionCapabilitiesDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        InsertionCapabilitiesType xbCaps = doc.addNewInsertionCapabilities();
        caps.getFeatureOfInterestTypes().stream().filter(foiType -> !foiType.equals("NOT_DEFINED")).forEachOrdered(foiType -> xbCaps.addFeatureOfInterestType(foiType));
        caps.getObservationTypes().stream().filter(oType -> !oType.equals("NOT_DEFINED")).forEachOrdered(oType -> xbCaps.addObservationType(oType));
        caps.getProcedureDescriptionFormats().stream().filter(pdf -> !pdf.equals("NOT_DEFINED")).forEachOrdered(pdf -> xbCaps.addProcedureDescriptionFormat(pdf));
        caps.getSupportedEncodings().stream().filter(se -> !se.equals("NOT_DEFINED")).forEachOrdered(se -> xbCaps.addSupportedEncoding(se));
        return doc;
    }

    protected void setContents(CapabilitiesType.Contents xbContents, Collection<SosObservationOffering> offerings, String version) throws EncodingException {
        ContentsType xbContType = xbContents.addNewContents();
        int offeringCounter = 0;
        for (SosObservationOffering offering : offerings) {
            if (!offering.isValidObservationOffering()) continue;
            this.encodeObservationOffering(offering, ++offeringCounter, xbContType);
        }
        this.renameContentsElementNames(xbContents);
    }

    private void createRelatedFeature(FeatureRelationshipType featureRelationship, String relatedFeatureTarget, Collection<String> roles) {
        featureRelationship.addNewTarget().setHref(relatedFeatureTarget);
        if (roles != null) {
            roles.forEach(arg_0 -> ((FeatureRelationshipType)featureRelationship).setRole(arg_0));
        }
    }

    private void renameContentsElementNames(CapabilitiesType.Contents xbContents) {
        for (AbstractContentsType.Offering offering : xbContents.getContents().getOfferingArray()) {
            XmlCursor cursor = offering.getAbstractOffering().newCursor();
            cursor.setName(Sos2Constants.QN_OBSERVATION_OFFERING);
            cursor.removeAttribute(W3CConstants.QN_XSI_TYPE);
            if (cursor.toChild(Sos2Constants.QN_SOS_OBSERVED_AREA)) {
                cursor.setName(Sos2Constants.QN_SOS_OBSERVED_AREA);
                cursor.toParent();
            }
            if (cursor.toChild(Sos2Constants.QN_SOS_PHENOMENON_TIME)) {
                cursor.setName(Sos2Constants.QN_SOS_PHENOMENON_TIME);
                cursor.toParent();
            }
            if (cursor.toChild(Sos2Constants.QN_SOS_RESULT_TIME)) {
                cursor.setName(Sos2Constants.QN_SOS_RESULT_TIME);
                cursor.toParent();
            }
            if (cursor.toChild(Sos2Constants.QN_SOS_RESPONSE_FORMAT)) {
                cursor.setName(Sos2Constants.QN_SOS_RESPONSE_FORMAT);
                while (cursor.toNextSibling(Sos2Constants.QN_SOS_RESPONSE_FORMAT)) {
                    cursor.setName(Sos2Constants.QN_SOS_RESPONSE_FORMAT);
                }
                cursor.toParent();
            }
            if (cursor.toChild(Sos2Constants.QN_SOS_OBSERVATION_TYPE)) {
                cursor.setName(Sos2Constants.QN_SOS_OBSERVATION_TYPE);
                while (cursor.toNextSibling(Sos2Constants.QN_SOS_OBSERVATION_TYPE)) {
                    cursor.setName(Sos2Constants.QN_SOS_OBSERVATION_TYPE);
                }
                cursor.toParent();
            }
            if (cursor.toChild(Sos2Constants.QN_SOS_FEATURE_OF_INTEREST_TYPE)) {
                cursor.setName(Sos2Constants.QN_SOS_FEATURE_OF_INTEREST_TYPE);
                while (cursor.toNextSibling(Sos2Constants.QN_SOS_FEATURE_OF_INTEREST_TYPE)) {
                    cursor.setName(Sos2Constants.QN_SOS_FEATURE_OF_INTEREST_TYPE);
                }
            }
            cursor.dispose();
        }
    }

    @Override
    public Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_GET_CAPABILITIES_SCHEMA_LOCATION});
    }

    private void encodeServiceIdentification(OwsCapabilities caps, CapabilitiesType xbCaps) throws EncodingException {
        if (caps.getServiceIdentification().isPresent()) {
            xbCaps.addNewServiceIdentification().set(this.encodeOws(caps.getServiceIdentification().get()));
        }
    }

    private void encodeServiceProvider(OwsCapabilities caps, CapabilitiesType xbCaps) throws EncodingException {
        if (caps.getServiceProvider().isPresent()) {
            xbCaps.addNewServiceProvider().set(this.encodeOws(caps.getServiceProvider().get()));
        }
    }

    private void encodeOperationsMetadata(OwsCapabilities caps, CapabilitiesType xbCaps) throws EncodingException {
        if (caps.getOperationsMetadata().map(OwsOperationsMetadata::getOperations).filter(x -> !x.isEmpty()).isPresent()) {
            xbCaps.addNewOperationsMetadata().set(this.encodeOws(caps.getOperationsMetadata().get()));
        }
    }

    private void encodeFilterCapabilities(SosCapabilities caps, CapabilitiesType xbCaps) throws EncodingException {
        if (caps.getFilterCapabilities().isPresent()) {
            xbCaps.addNewFilterCapabilities().addNewFilterCapabilities().set(this.encodeFes(caps.getFilterCapabilities().get()));
        }
    }

    private void encodeContents(SosCapabilities caps, CapabilitiesType xbCaps, String version) throws EncodingException {
        if (caps.getContents().isPresent()) {
            this.setContents(xbCaps.addNewContents(), (Collection)caps.getContents().get(), version);
        }
    }

    private void encodeExtensions(SosCapabilities caps, CapabilitiesType xbCaps) throws EncodingException {
        for (OwsCapabilitiesExtension e : caps.getExtensions()) {
            this.setExtensions(xbCaps.addNewExtension(), e);
        }
    }

    private void encodeObservationOffering(SosObservationOffering offering, int offeringCounter, ContentsType xbContType) throws EncodingException {
        ObservationOfferingType xbObsOff = ObservationOfferingType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        SosOffering sosOffering = offering.getOffering();
        xbObsOff.setIdentifier(sosOffering.getIdentifier());
        if (sosOffering.isSetName()) {
            for (CodeType name : sosOffering.getName()) {
                xbObsOff.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml/3.2", name));
            }
        }
        if (sosOffering.isSetDescription()) {
            xbObsOff.setDescription(sosOffering.getDescription());
        }
        this.encodeOfferingExtension(offering, xbObsOff);
        offering.getProcedures().forEach(arg_0 -> ((ObservationOfferingType)xbObsOff).setProcedure(arg_0));
        this.encodeObservableProperties(offering, xbObsOff);
        this.encodeRelatedFeatures(offering, xbObsOff);
        this.encodeObservedArea(offering, xbObsOff);
        this.encodePhenomenonTime(offering, offeringCounter, xbObsOff);
        this.encodeResultTime(offering, offeringCounter, xbObsOff);
        this.encodeResponseFormat(offering, xbObsOff);
        this.encodeObservationType(offering, xbObsOff);
        this.encodeFeatureOfInterestTypes(offering, xbObsOff);
        this.encodeProcedureDescriptionFormats(offering, xbObsOff);
        xbContType.addNewOffering().setAbstractOffering((AbstractOfferingType)xbObsOff);
    }

    private void encodeOfferingExtension(SosObservationOffering sosOffering, ObservationOfferingType xbObsOff) throws EncodingException {
        for (Extension extention : sosOffering.getExtensions().getExtensions()) {
            if (extention.getValue() instanceof SosObservationOfferingExtension) {
                SosObservationOfferingExtension extension = (SosObservationOfferingExtension)extention.getValue();
                try {
                    xbObsOff.addNewExtension().set(XmlObject.Factory.parse((String)extension.getExtension()));
                    continue;
                }
                catch (XmlException ex) {
                    throw GetCapabilitiesResponseEncoder.errorEncodingSwesExtension(ex);
                }
            }
            xbObsOff.addNewExtension().set(this.encodeObjectToXml(extention.getNamespace(), extention));
        }
    }

    private void encodeObservableProperties(SosObservationOffering offering, ObservationOfferingType xbObsOff) {
        offering.getObservableProperties().forEach(arg_0 -> ((ObservationOfferingType)xbObsOff).addObservableProperty(arg_0));
    }

    private void encodeRelatedFeatures(SosObservationOffering offering, ObservationOfferingType xbObsOff) {
        if (offering.isSetRelatedFeature()) {
            offering.getRelatedFeatures().forEach((target, roles) -> this.createRelatedFeature(xbObsOff.addNewRelatedFeature().addNewFeatureRelationship(), (String)target, (Collection<String>)roles));
        }
    }

    private void encodeObservedArea(SosObservationOffering offering, ObservationOfferingType xbObsOff) throws EncodingException {
        if (offering.isSetObservedArea() && offering.getObservedArea().isSetEnvelope() && offering.getObservedArea().isSetSrid()) {
            XmlObject encodeObjectToXml = this.encodeGml(offering.getObservedArea());
            xbObsOff.addNewObservedArea().addNewEnvelope().set(encodeObjectToXml);
        }
    }

    private void encodePhenomenonTime(SosObservationOffering offering, int offeringCounter, ObservationOfferingType xbObsOff) throws EncodingException {
        TimePeriod tp;
        if (offering.getPhenomenonTime() instanceof TimePeriod && !(tp = (TimePeriod)offering.getPhenomenonTime()).isEmpty()) {
            tp.setGmlId(String.format(ID_FORMAT_STRING, "phenomenonTime", offeringCounter));
            XmlObject xmlObject = this.encodeGml(tp);
            xbObsOff.addNewPhenomenonTime().addNewTimePeriod().set(xmlObject);
            xbObsOff.getPhenomenonTime().substitute(Sos2Constants.QN_SOS_PHENOMENON_TIME, xbObsOff.getPhenomenonTime().schemaType());
        }
    }

    private void encodeResultTime(SosObservationOffering offering, int offeringCounter, ObservationOfferingType xbObsOff) throws EncodingException {
        if (offering.getResultTime() instanceof TimePeriod) {
            TimePeriod tp = (TimePeriod)offering.getResultTime();
            tp.setGmlId(String.format(ID_FORMAT_STRING, "resultTime", offeringCounter));
            if (!tp.isEmpty()) {
                XmlObject xmlObject = this.encodeGml(tp);
                xbObsOff.addNewResultTime().addNewTimePeriod().set(xmlObject);
                xbObsOff.getResultTime().substitute(Sos2Constants.QN_SOS_RESULT_TIME, xbObsOff.getResultTime().schemaType());
            }
        }
    }

    private void encodeResponseFormat(SosObservationOffering offering, ObservationOfferingType xbObsOff) {
        if (offering.isSetResponseFormats()) {
            offering.getResponseFormats().forEach(arg_0 -> ((ObservationOfferingType)xbObsOff).addResponseFormat(arg_0));
        }
    }

    private void encodeObservationType(SosObservationOffering offering, ObservationOfferingType xbObsOff) {
        if (offering.isSetObservationTypes()) {
            offering.getObservationTypes().forEach(arg_0 -> ((ObservationOfferingType)xbObsOff).addObservationType(arg_0));
        }
    }

    private void encodeFeatureOfInterestTypes(SosObservationOffering offering, ObservationOfferingType xbObsOff) {
        if (offering.isSetFeatureOfInterestTypes()) {
            offering.getFeatureOfInterestTypes().forEach(arg_0 -> ((ObservationOfferingType)xbObsOff).addFeatureOfInterestType(arg_0));
        }
    }

    private void encodeProcedureDescriptionFormats(SosObservationOffering offering, ObservationOfferingType xbObsOff) {
        if (offering.isSetProcedureDescriptionFormats()) {
            offering.getProcedureDescriptionFormats().forEach(arg_0 -> ((ObservationOfferingType)xbObsOff).addProcedureDescriptionFormat(arg_0));
        }
    }

    private static EncodingException errorEncodingSwesExtension(XmlException ex) {
        return new EncodingException("Error encoding SwesExtension", (Throwable)ex);
    }

    protected XmlObject encodeGML32(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }
}

