/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityConstants;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractResponseEncoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.XmlHelper;
import org.n52.svalbard.write.GetDataAvailabilityStreamWriter;
import org.n52.svalbard.write.GetDataAvailabilityV20StreamWriter;

public class GetDataAvailabilityXmlEncoder
extends AbstractResponseEncoder<GetDataAvailabilityResponse> {
    public GetDataAvailabilityXmlEncoder() {
        super("SOS", "2.0.0", "GetDataAvailability", "http://www.opengis.net/sos/2.0", "sos", GetDataAvailabilityResponse.class, false);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Collections.emptySet();
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations(String namespace) {
        if (!Strings.isNullOrEmpty((String)namespace)) {
            switch (namespace) {
                case "http://www.opengis.net/sosgda/1.0": {
                    return Sets.newHashSet((Object[])new SchemaLocation[]{GetDataAvailabilityConstants.GET_DATA_AVAILABILITY_SCHEMA_LOCATION});
                }
                case "http://www.opengis.net/sosgda/2.0": {
                    return Sets.newHashSet((Object[])new SchemaLocation[]{GetDataAvailabilityConstants.GET_DATA_AVAILABILITY_20_SCHEMA_LOCATION});
                }
            }
            return this.getConcreteSchemaLocations();
        }
        return this.getConcreteSchemaLocations();
    }

    @Override
    protected XmlObject create(GetDataAvailabilityResponse response) throws EncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            EncodingContext ctx = EncodingContext.empty().with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions);
            if ("http://www.opengis.net/sosgda/1.0".equals(response.getResponseFormat())) {
                new GetDataAvailabilityStreamWriter(ctx, (OutputStream)baos, response.getDataAvailabilities()).write();
            } else if ("http://www.opengis.net/sosgda/2.0".equals(response.getResponseFormat())) {
                new GetDataAvailabilityV20StreamWriter(ctx, (OutputStream)baos, response.getDataAvailabilities()).write();
            }
            XmlObject encodedObject = XmlObject.Factory.parse((String)baos.toString("UTF8"));
            XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
            return encodedObject;
        }
        catch (UnsupportedEncodingException | XMLStreamException | XmlException ex) {
            throw new EncodingException("Error encoding response", ex);
        }
    }
}

