/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.Set;
import net.opengis.gml.CodeType;
import net.opengis.gml.CoordinatesType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.EnvelopeDocument;
import net.opengis.gml.EnvelopeType;
import net.opengis.gml.PointType;
import net.opengis.gml.TimeInstantDocument;
import net.opengis.gml.TimeInstantType;
import net.opengis.gml.TimePeriodDocument;
import net.opengis.gml.TimePeriodType;
import net.opengis.gml.TimePositionType;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.n52.shetland.ogc.gml.time.IndeterminateValue;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.util.CRSHelper;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.DateTimeParseException;
import org.n52.shetland.util.JTSHelper;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GmlDecoderv311
implements Decoder<Object, XmlObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GmlDecoderv311.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/gml", (Class[])new Class[]{EnvelopeDocument.class, TimeInstantType.class, TimePeriodType.class, TimeInstantDocument.class, TimePeriodDocument.class, CodeType.class, PointType.class});
    private static final String CS = ",";
    private static final String DECIMAL = ".";
    private static final String TS = " ";

    public GmlDecoderv311() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof EnvelopeDocument) {
            return this.getGeometry4BBOX((EnvelopeDocument)xmlObject);
        }
        if (xmlObject instanceof TimeInstantType) {
            return this.parseTimeInstant((TimeInstantType)xmlObject);
        }
        if (xmlObject instanceof TimePeriodType) {
            return this.parseTimePeriod((TimePeriodType)xmlObject);
        }
        if (xmlObject instanceof TimeInstantDocument) {
            return this.parseTimeInstant(((TimeInstantDocument)xmlObject).getTimeInstant());
        }
        if (xmlObject instanceof TimePeriodDocument) {
            return this.parseTimePeriod(((TimePeriodDocument)xmlObject).getTimePeriod());
        }
        if (xmlObject instanceof CodeType) {
            return this.parseCodeType((CodeType)xmlObject);
        }
        if (xmlObject instanceof PointType) {
            return this.parsePointType((PointType)xmlObject);
        }
        throw new UnsupportedDecoderXmlInputException(this, xmlObject);
    }

    private Geometry getGeometry4BBOX(EnvelopeDocument xbBbox) throws DecodingException {
        EnvelopeType xbEnvelope = xbBbox.getEnvelope();
        int srid = CRSHelper.parseSrsName((String)xbEnvelope.getSrsName());
        String lower = xbEnvelope.getLowerCorner().getStringValue();
        String upper = xbEnvelope.getUpperCorner().getStringValue();
        String geomWKT = String.format("MULTIPOINT(%s, %s)", lower, upper);
        try {
            return JTSHelper.createGeometryFromWKT((String)geomWKT, (int)srid).getEnvelope();
        }
        catch (ParseException ex) {
            throw new DecodingException((Throwable)ex);
        }
    }

    private Object parseTimePeriod(TimePeriodType xbTimePeriod) throws DecodingException {
        TimePositionType xbBeginTPT = xbTimePeriod.getBeginPosition();
        TimeInstant begin = null;
        if (xbBeginTPT == null) {
            throw new DecodingException("gml:TimePeriod must contain gml:beginPosition Element with valid ISO:8601 String!", new Object[0]);
        }
        begin = this.parseTimePosition(xbBeginTPT);
        TimePositionType xbEndTPT = xbTimePeriod.getEndPosition();
        TimeInstant end = null;
        if (xbEndTPT == null) {
            throw new DecodingException("gml:TimePeriod must contain gml:endPosition Element with valid ISO:8601 String!", new Object[0]);
        }
        end = this.parseTimePosition(xbEndTPT);
        TimePeriod timePeriod = new TimePeriod(begin, end);
        timePeriod.setGmlId(xbTimePeriod.getId());
        return timePeriod;
    }

    private Object parseTimeInstant(TimeInstantType xbTimeIntant) throws DecodingException {
        TimeInstant ti = this.parseTimePosition(xbTimeIntant.getTimePosition());
        ti.setGmlId(xbTimeIntant.getId());
        return ti;
    }

    private TimeInstant parseTimePosition(TimePositionType xbTimePosition) throws DecodingException {
        TimeInstant ti = new TimeInstant();
        String timeString = xbTimePosition.getStringValue();
        if (timeString != null && !timeString.isEmpty()) {
            try {
                DateTime dateTime = DateTimeHelper.parseIsoString2DateTime((String)timeString);
                ti.setValue(dateTime);
                ti.setRequestedTimeLength(DateTimeHelper.getTimeLengthBeforeTimeZone((String)timeString));
            }
            catch (DateTimeParseException ex) {
                ti.setIndeterminateValue(new IndeterminateValue(timeString, new String[0]));
            }
        }
        if (xbTimePosition.getIndeterminatePosition() != null) {
            ti.setIndeterminateValue(new IndeterminateValue(xbTimePosition.getIndeterminatePosition().toString(), new String[0]));
        }
        return ti;
    }

    private org.n52.shetland.ogc.gml.CodeType parseCodeType(CodeType element) throws DecodingException {
        org.n52.shetland.ogc.gml.CodeType codeType = new org.n52.shetland.ogc.gml.CodeType(element.getStringValue());
        if (element.isSetCodeSpace()) {
            try {
                codeType.setCodeSpace(new URI(element.getCodeSpace()));
            }
            catch (URISyntaxException e) {
                throw new DecodingException((Throwable)e, "Error while creating URI from '{}'", element.getCodeSpace(), new Object[0]);
            }
        }
        return codeType;
    }

    private Object parsePointType(PointType xbPointType) throws DecodingException {
        String geomWKT = null;
        int srid = -1;
        if (xbPointType.getSrsName() != null) {
            srid = CRSHelper.parseSrsName((String)xbPointType.getSrsName());
        }
        if (xbPointType.getPos() != null) {
            DirectPositionType xbPos = xbPointType.getPos();
            if (srid == -1 && xbPos.getSrsName() != null) {
                srid = CRSHelper.parseSrsName((String)xbPos.getSrsName());
            }
            String directPosition = this.getString4Pos(xbPos);
            geomWKT = JTSHelper.createWKTPointFromCoordinateString((String)directPosition);
        } else if (xbPointType.getCoordinates() != null) {
            CoordinatesType xbCoords = xbPointType.getCoordinates();
            String directPosition = this.getString4Coordinates(xbCoords);
            geomWKT = JTSHelper.createWKTPointFromCoordinateString((String)directPosition);
        } else {
            throw new DecodingException("For geometry type 'gml:Point' only elements 'gml:pos' and 'gml:coordinates' are allowed", new Object[0]);
        }
        this.checkSrid(srid);
        if (srid == -1) {
            throw new DecodingException("No SrsName ist specified for geometry!", new Object[0]);
        }
        try {
            return JTSHelper.createGeometryFromWKT((String)geomWKT, (int)srid);
        }
        catch (ParseException ex) {
            throw new DecodingException((Throwable)ex);
        }
    }

    private String getString4Pos(DirectPositionType xbPos) {
        return xbPos.getStringValue();
    }

    private String getString4Coordinates(CoordinatesType xbCoordinates) {
        String coordinateString = xbCoordinates.getStringValue();
        if (!xbCoordinates.getCs().equals(CS)) {
            coordinateString = coordinateString.replace(xbCoordinates.getCs(), CS);
        }
        if (!xbCoordinates.getDecimal().equals(DECIMAL)) {
            coordinateString = coordinateString.replace(xbCoordinates.getDecimal(), DECIMAL);
        }
        if (!xbCoordinates.getTs().equals(TS)) {
            coordinateString = coordinateString.replace(xbCoordinates.getTs(), TS);
        }
        return coordinateString;
    }

    private void checkSrid(int srid) throws DecodingException {
        if (srid == 0 || srid == -1) {
            throw new DecodingException("No SrsName is specified for geometry!", new Object[0]);
        }
    }
}

