/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.opengis.gml.x32.AbstractTimeGeometricPrimitiveType;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.sos.x20.SosInsertionMetadataPropertyType;
import net.opengis.sos.x20.SosInsertionMetadataType;
import net.opengis.swes.x20.DeleteSensorDocument;
import net.opengis.swes.x20.DeleteSensorType;
import net.opengis.swes.x20.DescribeSensorDocument;
import net.opengis.swes.x20.DescribeSensorType;
import net.opengis.swes.x20.ExtensibleRequestType;
import net.opengis.swes.x20.InsertSensorDocument;
import net.opengis.swes.x20.InsertSensorType;
import net.opengis.swes.x20.SensorDescriptionType;
import net.opengis.swes.x20.UpdateSensorDescriptionDocument;
import net.opengis.swes.x20.UpdateSensorDescriptionType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosInsertionMetadata;
import org.n52.shetland.ogc.sos.SosProcedureDescription;
import org.n52.shetland.ogc.sos.request.DeleteSensorRequest;
import org.n52.shetland.ogc.sos.request.DescribeSensorRequest;
import org.n52.shetland.ogc.sos.request.InsertSensorRequest;
import org.n52.shetland.ogc.sos.request.UpdateSensorRequest;
import org.n52.shetland.ogc.swes.SwesFeatureRelationship;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractSwesDecoderv20;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.n52.svalbard.decode.exception.DecoderResponseUnsupportedException;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SwesDecoderv20
extends AbstractSwesDecoderv20<OwsServiceCommunicationObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SwesDecoderv20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/swes/2.0", (Class[])new Class[]{DescribeSensorDocument.class, InsertSensorDocument.class, UpdateSensorDescriptionDocument.class, DeleteSensorDocument.class}), CodingHelper.xmlDecoderKeysForOperation((String)"SOS", (String)"2.0.0", (Enum[])new Enum[]{SosConstants.Operations.DescribeSensor, Sos2Constants.Operations.InsertSensor, Sos2Constants.Operations.UpdateSensorDescription, Sos2Constants.Operations.DeleteSensor})});

    public SwesDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public OwsServiceRequest decode(XmlObject xmlObject) throws DecodingException {
        LOGGER.debug("REQUESTTYPE:" + xmlObject.getClass());
        XmlHelper.validateDocument((XmlObject)xmlObject);
        if (xmlObject instanceof DescribeSensorDocument) {
            return this.parseDescribeSensor((DescribeSensorDocument)xmlObject);
        }
        if (xmlObject instanceof InsertSensorDocument) {
            return this.parseInsertSensor((InsertSensorDocument)xmlObject);
        }
        if (xmlObject instanceof UpdateSensorDescriptionDocument) {
            return this.parseUpdateSensorDescription((UpdateSensorDescriptionDocument)xmlObject);
        }
        if (xmlObject instanceof DeleteSensorDocument) {
            return this.parseDeleteSensor((DeleteSensorDocument)xmlObject);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, xmlObject);
    }

    private OwsServiceRequest parseDescribeSensor(DescribeSensorDocument xbDescSenDoc) throws DecodingException {
        DescribeSensorRequest descSensorRequest = new DescribeSensorRequest();
        DescribeSensorType xbDescSensor = xbDescSenDoc.getDescribeSensor();
        descSensorRequest.setService(xbDescSensor.getService());
        descSensorRequest.setVersion(xbDescSensor.getVersion());
        descSensorRequest.setProcedure(xbDescSensor.getProcedure());
        descSensorRequest.setProcedureDescriptionFormat(xbDescSensor.getProcedureDescriptionFormat());
        if (xbDescSensor.isSetValidTime()) {
            descSensorRequest.setValidTime(this.getValidTime(xbDescSensor.getValidTime()));
        }
        descSensorRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)xbDescSensor));
        return descSensorRequest;
    }

    private OwsServiceRequest parseInsertSensor(InsertSensorDocument xbInsSensDoc) throws DecodingException {
        InsertSensorRequest request = new InsertSensorRequest();
        InsertSensorType xbInsertSensor = xbInsSensDoc.getInsertSensor();
        request.setService(xbInsertSensor.getService());
        request.setVersion(xbInsertSensor.getVersion());
        request.setProcedureDescriptionFormat(xbInsertSensor.getProcedureDescriptionFormat());
        if (CollectionHelper.isNotNullOrEmpty((Object[])xbInsertSensor.getObservablePropertyArray())) {
            request.setObservableProperty(Arrays.asList(xbInsertSensor.getObservablePropertyArray()));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])xbInsertSensor.getRelatedFeatureArray())) {
            request.setRelatedFeature(this.parseRelatedFeature(xbInsertSensor.getRelatedFeatureArray()));
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])xbInsertSensor.getMetadataArray())) {
            request.setMetadata(this.parseMetadata(xbInsertSensor.getMetadataArray()));
        }
        request.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)xbInsertSensor));
        try {
            XmlObject xbProcedureDescription = XmlObject.Factory.parse((Node)this.getNodeFromNodeList(xbInsertSensor.getProcedureDescription().getDomNode().getChildNodes()));
            this.checkFormatWithNamespace(xbInsertSensor.getProcedureDescriptionFormat(), XmlHelper.getNamespace((XmlObject)xbProcedureDescription));
            Decoder decoder = this.getDecoder((DecoderKey)new XmlNamespaceDecoderKey(xbInsertSensor.getProcedureDescriptionFormat(), xbProcedureDescription.getClass()), new DecoderKey[0]);
            if (decoder != null) {
                Object decodedProcedureDescription = decoder.decode((Object)xbProcedureDescription);
                if (decodedProcedureDescription instanceof SosProcedureDescription) {
                    request.setProcedureDescription((SosProcedureDescription)decodedProcedureDescription);
                } else if (decodedProcedureDescription instanceof AbstractFeature) {
                    request.setProcedureDescription(new SosProcedureDescription((AbstractFeature)decodedProcedureDescription));
                }
            }
        }
        catch (XmlException xmle) {
            throw new DecodingException("Error while parsing procedure description of InsertSensor request!", (Throwable)xmle);
        }
        return request;
    }

    private OwsServiceRequest parseDeleteSensor(DeleteSensorDocument xbDelSenDoc) throws DecodingException {
        DeleteSensorRequest request = new DeleteSensorRequest();
        DeleteSensorType deleteSensor = xbDelSenDoc.getDeleteSensor();
        request.setService(deleteSensor.getService());
        request.setVersion(deleteSensor.getVersion());
        request.setProcedureIdentifier(deleteSensor.getProcedure());
        request.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)deleteSensor));
        return request;
    }

    private OwsServiceRequest parseUpdateSensorDescription(UpdateSensorDescriptionDocument xbUpSenDoc) throws DecodingException {
        UpdateSensorRequest request = new UpdateSensorRequest();
        UpdateSensorDescriptionType xbUpdateSensor = xbUpSenDoc.getUpdateSensorDescription();
        request.setService(xbUpdateSensor.getService());
        request.setVersion(xbUpdateSensor.getVersion());
        request.setProcedureIdentifier(xbUpdateSensor.getProcedure());
        request.setProcedureDescriptionFormat(xbUpdateSensor.getProcedureDescriptionFormat());
        request.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)xbUpdateSensor));
        for (UpdateSensorDescriptionType.Description description : xbUpdateSensor.getDescriptionArray()) {
            SensorDescriptionType sensorDescription = description.getSensorDescription();
            try {
                XmlObject xmlObject = XmlObject.Factory.parse((Node)this.getNodeFromNodeList(sensorDescription.getData().getDomNode().getChildNodes()));
                Decoder decoder = this.getDecoder(this.getDecoderKey(xmlObject), new DecoderKey[0]);
                if (decoder == null) {
                    throw new DecodingException((Enum)Sos2Constants.UpdateSensorDescriptionParams.procedureDescriptionFormat, "The requested procedureDescritpionFormat is not supported!", new Object[0]);
                }
                Object decodedObject = decoder.decode((Object)xmlObject);
                SosProcedureDescription sosProcedureDescription = null;
                if (decodedObject instanceof SosProcedureDescription) {
                    sosProcedureDescription = (SosProcedureDescription)decodedObject;
                } else if (decodedObject instanceof AbstractFeature) {
                    sosProcedureDescription = new SosProcedureDescription((AbstractFeature)decodedObject);
                }
                if (sosProcedureDescription != null && sensorDescription.isSetValidTime()) {
                    sosProcedureDescription.setValidTime(this.getValidTime(sensorDescription.getValidTime()));
                }
                request.addProcedureDescriptionString(sosProcedureDescription);
            }
            catch (XmlException xmle) {
                throw new DecodingException("Error while parsing procedure description of UpdateSensor request!", (Throwable)xmle);
            }
        }
        return request;
    }

    private SosInsertionMetadata parseMetadata(InsertSensorType.Metadata[] metadataArray) throws DecodingException {
        SosInsertionMetadata sosMetadata = new SosInsertionMetadata();
        try {
            for (InsertSensorType.Metadata metadata : metadataArray) {
                SosInsertionMetadataType xbSosInsertionMetadata = null;
                if (metadata.getInsertionMetadata() != null && metadata.getInsertionMetadata().schemaType() == SosInsertionMetadataType.type) {
                    xbSosInsertionMetadata = (SosInsertionMetadataType)metadata.getInsertionMetadata();
                } else if (metadata.getDomNode().hasChildNodes()) {
                    Node node = this.getNodeFromNodeList(metadata.getDomNode().getChildNodes());
                    SosInsertionMetadataPropertyType xbMetadata = SosInsertionMetadataPropertyType.Factory.parse((Node)node);
                    xbSosInsertionMetadata = xbMetadata.getSosInsertionMetadata();
                }
                if (xbSosInsertionMetadata == null) continue;
                if (xbSosInsertionMetadata.getFeatureOfInterestTypeArray() != null) {
                    sosMetadata.setFeatureOfInterestTypes(Arrays.asList(xbSosInsertionMetadata.getFeatureOfInterestTypeArray()));
                }
                if (xbSosInsertionMetadata.getObservationTypeArray() == null) continue;
                sosMetadata.setObservationTypes(Arrays.asList(xbSosInsertionMetadata.getObservationTypeArray()));
            }
        }
        catch (XmlException xmle) {
            throw new DecodingException("An error occurred while parsing the metadata in the http post request", (Throwable)xmle);
        }
        return sosMetadata;
    }

    private List<SwesFeatureRelationship> parseRelatedFeature(InsertSensorType.RelatedFeature[] relatedFeatureArray) throws DecodingException {
        ArrayList<SwesFeatureRelationship> sosRelatedFeatures = new ArrayList<SwesFeatureRelationship>(relatedFeatureArray.length);
        for (InsertSensorType.RelatedFeature relatedFeature : relatedFeatureArray) {
            SwesFeatureRelationship sosFeatureRelationship = new SwesFeatureRelationship();
            FeaturePropertyType fpt = relatedFeature.getFeatureRelationship().getTarget();
            if (fpt.getHref() != null && !fpt.getHref().isEmpty()) {
                String identifier = fpt.getHref();
                SamplingFeature feature = new SamplingFeature(new CodeWithAuthority(identifier));
                if (fpt.getTitle() != null && !fpt.getTitle().isEmpty()) {
                    feature.setName((List)Lists.newArrayList((Object[])new CodeType[]{new CodeType(fpt.getTitle())}));
                }
                if (this.checkForRequestUrl(fpt.getHref())) {
                    feature.setUrl(fpt.getHref());
                }
                feature.setFeatureType("http://www.opengis.net/def/nil/OGC/0/unknown");
                sosFeatureRelationship.setFeature((AbstractFeature)feature);
            } else {
                Object decodedObject = this.decodeXmlElement((XmlObject)fpt);
                if (decodedObject instanceof AbstractSamplingFeature) {
                    sosFeatureRelationship.setFeature((AbstractFeature)((AbstractSamplingFeature)decodedObject));
                } else {
                    throw new DecoderResponseUnsupportedException(fpt.xmlText(), decodedObject);
                }
            }
            sosFeatureRelationship.setRole(relatedFeature.getFeatureRelationship().getRole());
            sosRelatedFeatures.add(sosFeatureRelationship);
        }
        return sosRelatedFeatures;
    }

    private boolean checkForRequestUrl(String href) {
        return href.toLowerCase(Locale.ROOT).contains("request=");
    }

    private void checkFormatWithNamespace(String procedureDescriptionFormat, String namespace) throws DecodingException {
        if (!procedureDescriptionFormat.equals(namespace)) {
            throw new DecodingException("The procedure description namespace '%s' does not match the procedureDescriptionFormat '%s'", namespace, new Object[]{procedureDescriptionFormat});
        }
    }

    private Node getNodeFromNodeList(NodeList nodeList) {
        if (nodeList != null && nodeList.getLength() > 0) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                if (nodeList.item(i).getNodeType() != 1) continue;
                return nodeList.item(i);
            }
        }
        return null;
    }

    private Time getValidTime(DescribeSensorType.ValidTime validTime) throws DecodingException {
        Object decodeXmlElement = this.decodeXmlElement((XmlObject)validTime.getAbstractTimeGeometricPrimitive());
        if (decodeXmlElement instanceof Time) {
            return (Time)decodeXmlElement;
        }
        throw SwesDecoderv20.unsupportedValidTime(Sos2Constants.DescribeSensorParams.validTime, validTime.getAbstractTimeGeometricPrimitive());
    }

    private Time getValidTime(SensorDescriptionType.ValidTime validTime) throws DecodingException {
        Object decodeXmlElement = this.decodeXmlElement((XmlObject)validTime.getAbstractTimeGeometricPrimitive());
        if (decodeXmlElement instanceof Time) {
            return (Time)decodeXmlElement;
        }
        throw SwesDecoderv20.unsupportedValidTime(Sos2Constants.UpdateSensorDescriptionParams.validTime, validTime.getAbstractTimeGeometricPrimitive());
    }

    private static DecodingException unsupportedValidTime(Enum<?> parameter, AbstractTimeGeometricPrimitiveType validTime) {
        return new DecodingException(parameter, "The validTime element ({}) is not supported", new Object[]{validTime.schemaType()});
    }
}

