/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import java.util.Collections;
import java.util.Set;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractRequestEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractSosRequestEncoder<T extends OwsServiceRequest>
extends AbstractRequestEncoder<T> {
    public AbstractSosRequestEncoder(String operation, Class<T> responseType) {
        super("SOS", "2.0.0", operation, "http://www.opengis.net/sos/2.0", "sos", responseType);
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Collections.singleton(Sos2Constants.SOS_SCHEMA_LOCATION);
    }

    protected XmlObject encodeGml(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeGml(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, context);
    }

    protected XmlObject encodeOws(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/ows/1.1", o);
    }

    protected XmlObject encodeOws(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/ows/1.1", o, context);
    }

    protected XmlObject encodeFes(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/fes/2.0", o);
    }

    protected XmlObject encodeFes(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/fes/2.0", o, context);
    }

    protected XmlObject encodeSwe(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSwe(EncodingContext context, Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, context);
    }
}

