/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.gml.x32.AbstractCRSType;
import net.opengis.gml.x32.BaseUnitType;
import net.opengis.gml.x32.CodeType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.isotc211.x2005.gco.AbstractObjectType;
import org.isotc211.x2005.gco.CharacterStringPropertyType;
import org.isotc211.x2005.gco.CodeListValueType;
import org.isotc211.x2005.gco.RealPropertyType;
import org.isotc211.x2005.gco.UnitOfMeasurePropertyType;
import org.isotc211.x2005.gmd.AbstractMDIdentificationType;
import org.isotc211.x2005.gmd.CIAddressPropertyType;
import org.isotc211.x2005.gmd.CIAddressType;
import org.isotc211.x2005.gmd.CICitationPropertyType;
import org.isotc211.x2005.gmd.CICitationType;
import org.isotc211.x2005.gmd.CIContactPropertyType;
import org.isotc211.x2005.gmd.CIContactType;
import org.isotc211.x2005.gmd.CIDateType;
import org.isotc211.x2005.gmd.CIOnlineResourceDocument;
import org.isotc211.x2005.gmd.CIOnlineResourcePropertyType;
import org.isotc211.x2005.gmd.CIOnlineResourceType;
import org.isotc211.x2005.gmd.CIResponsiblePartyDocument;
import org.isotc211.x2005.gmd.CIResponsiblePartyPropertyType;
import org.isotc211.x2005.gmd.CIResponsiblePartyType;
import org.isotc211.x2005.gmd.CIRoleCodePropertyType;
import org.isotc211.x2005.gmd.CITelephonePropertyType;
import org.isotc211.x2005.gmd.CITelephoneType;
import org.isotc211.x2005.gmd.DQConformanceResultType;
import org.isotc211.x2005.gmd.DQDomainConsistencyDocument;
import org.isotc211.x2005.gmd.DQDomainConsistencyPropertyType;
import org.isotc211.x2005.gmd.DQDomainConsistencyType;
import org.isotc211.x2005.gmd.DQQuantitativeResultType;
import org.isotc211.x2005.gmd.DQResultPropertyType;
import org.isotc211.x2005.gmd.EXExtentDocument;
import org.isotc211.x2005.gmd.EXExtentPropertyType;
import org.isotc211.x2005.gmd.EXExtentType;
import org.isotc211.x2005.gmd.EXVerticalExtentDocument;
import org.isotc211.x2005.gmd.EXVerticalExtentPropertyType;
import org.isotc211.x2005.gmd.EXVerticalExtentType;
import org.isotc211.x2005.gmd.LocalisedCharacterStringPropertyType;
import org.isotc211.x2005.gmd.LocalisedCharacterStringType;
import org.isotc211.x2005.gmd.MDDataIdentificationDocument;
import org.isotc211.x2005.gmd.MDDataIdentificationPropertyType;
import org.isotc211.x2005.gmd.MDDataIdentificationType;
import org.isotc211.x2005.gmd.MDIdentificationPropertyType;
import org.isotc211.x2005.gmd.MDMetadataDocument;
import org.isotc211.x2005.gmd.MDMetadataPropertyType;
import org.isotc211.x2005.gmd.MDMetadataType;
import org.isotc211.x2005.gmd.PTFreeTextType;
import org.isotc211.x2005.gsr.SCCRSPropertyType;
import org.n52.shetland.iso.gmd.AbstractMDIdentification;
import org.n52.shetland.iso.gmd.AbstractObject;
import org.n52.shetland.iso.gmd.CiAddress;
import org.n52.shetland.iso.gmd.CiContact;
import org.n52.shetland.iso.gmd.CiOnlineResource;
import org.n52.shetland.iso.gmd.CiResponsibleParty;
import org.n52.shetland.iso.gmd.CiTelephone;
import org.n52.shetland.iso.gmd.EXExtent;
import org.n52.shetland.iso.gmd.EXVerticalExtent;
import org.n52.shetland.iso.gmd.GmdCitation;
import org.n52.shetland.iso.gmd.GmdCitationDate;
import org.n52.shetland.iso.gmd.GmdConformanceResult;
import org.n52.shetland.iso.gmd.GmdConstants;
import org.n52.shetland.iso.gmd.GmdDateType;
import org.n52.shetland.iso.gmd.GmdDomainConsistency;
import org.n52.shetland.iso.gmd.GmdQuantitativeResult;
import org.n52.shetland.iso.gmd.GmlBaseUnit;
import org.n52.shetland.iso.gmd.LocalisedCharacterString;
import org.n52.shetland.iso.gmd.MDDataIdentification;
import org.n52.shetland.iso.gmd.MDMetadata;
import org.n52.shetland.iso.gmd.PT_FreeText;
import org.n52.shetland.iso.gmd.ScCRS;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.sensorML.Role;
import org.n52.shetland.ogc.sensorML.SmlResponsibleParty;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.encode.AbstractIso19139GcoEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.ActuateType;
import org.w3.x1999.xlink.ShowType;
import org.w3.x1999.xlink.TypeType;

public class Iso19139GmdEncoder
extends AbstractIso19139GcoEncoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(Iso19139GmdEncoder.class);
    private static final QName QN_GCO_DATE = new QName("http://www.isotc211.org/2005/gco", "Date", "gco");
    private static final QName QN_GMD_CONFORMANCE_RESULT = new QName("http://www.isotc211.org/2005/gmd", "DQ_ConformanceResult", "gmd");
    private static final QName QN_GMD_QUANTITATIVE_RESULT = new QName("http://www.isotc211.org/2005/gmd", "DQ_QuantitativeResult", "gmd");
    private static final QName QN_GML_BASE_UNIT = new QName("http://www.opengis.net/gml/3.2", "BaseUnit", "gml");
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.isotc211.org/2005/gmd", (Class[])new Class[]{SmlResponsibleParty.class, GmdQuantitativeResult.class, GmdConformanceResult.class}), CodingHelper.encoderKeysForElements(null, (Class[])new Class[]{GmdQuantitativeResult.class, GmdConformanceResult.class})});

    public Iso19139GmdEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.emptySet();
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.isotc211.org/2005/gmd", "gmd");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{GmdConstants.GMD_SCHEMA_LOCATION});
    }

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException, UnsupportedEncoderInputException {
        XmlObject encodedObject = null;
        if (element instanceof SmlResponsibleParty) {
            encodedObject = this.encodeResponsibleParty((SmlResponsibleParty)element, additionalValues);
        } else if (element instanceof CiResponsibleParty) {
            encodedObject = this.encodeResponsibleParty((CiResponsibleParty)element, additionalValues);
        } else if (element instanceof MDMetadata) {
            encodedObject = this.encodeMDMetadata((MDMetadata)element, additionalValues);
        } else if (element instanceof MDDataIdentification) {
            encodedObject = this.encodeMDDataIdentification((MDDataIdentification)element, additionalValues);
        } else if (element instanceof PT_FreeText) {
            encodedObject = this.encodePTFreeText((PT_FreeText)element, additionalValues);
        } else if (element instanceof CiOnlineResource) {
            encodedObject = this.encodeCiOnlineResource((CiOnlineResource)element, additionalValues);
        } else if (element instanceof EXExtent) {
            encodedObject = this.encodeEXExtent((EXExtent)element, additionalValues);
        } else if (element instanceof EXVerticalExtent) {
            encodedObject = this.encodeEXVerticalExtent((EXVerticalExtent)element, additionalValues);
        } else if (element instanceof GmdDomainConsistency) {
            encodedObject = this.encodeGmdDomainConsistency((GmdDomainConsistency)element, additionalValues);
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, element);
        }
        if (encodedObject != null) {
            XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        }
        return encodedObject;
    }

    private XmlObject encodeMDMetadata(MDMetadata mdMetadata, EncodingContext context) throws EncodingException {
        if (mdMetadata.isSetSimpleAttrs()) {
            MDMetadataPropertyType mdmpt = MDMetadataPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            mdmpt.setHref(mdMetadata.getSimpleAttrs().getHref());
            if (mdMetadata.getSimpleAttrs().isSetTitle()) {
                mdmpt.setTitle(mdMetadata.getSimpleAttrs().getTitle());
            }
            if (mdMetadata.getSimpleAttrs().isSetRole()) {
                mdmpt.setRole(mdMetadata.getSimpleAttrs().getRole());
            }
            return mdmpt;
        }
        MDMetadataType mdmt = MDMetadataType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.encodeAbstractObject((AbstractObjectType)mdmt, (AbstractObject)mdMetadata);
        for (CiResponsibleParty contact : mdMetadata.getContact()) {
            mdmt.addNewContact().set(this.encodeResponsibleParty(contact, EncodingContext.of((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE, (Object)true)));
        }
        mdmt.addNewDateStamp().setDateTime(mdMetadata.getDateStamp().toCalendar(null));
        for (AbstractMDIdentification identificationInfo : mdMetadata.getIdentificationInfo()) {
            if (identificationInfo.isSetSimpleAttrs()) {
                MDIdentificationPropertyType mdipt = mdmt.addNewIdentificationInfo();
                mdipt.setHref(identificationInfo.getSimpleAttrs().getHref());
                if (identificationInfo.getSimpleAttrs().isSetTitle()) {
                    mdipt.setTitle(identificationInfo.getSimpleAttrs().getTitle());
                }
                if (!identificationInfo.getSimpleAttrs().isSetRole()) continue;
                mdipt.setRole(identificationInfo.getSimpleAttrs().getRole());
                continue;
            }
            mdmt.addNewIdentificationInfo().addNewAbstractMDIdentification().set((XmlObject)this.encode(identificationInfo));
        }
        if (context.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            MDMetadataPropertyType mdmpt = MDMetadataPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            mdmpt.setMDMetadata(mdmt);
            return mdmpt;
        }
        if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            MDMetadataDocument mdmd = MDMetadataDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            mdmd.setMDMetadata(mdmt);
            return mdmd;
        }
        return mdmt;
    }

    private void encodeIdentificationInfo(AbstractMDIdentificationType amdit, AbstractMDIdentification abstractMDIdentification) {
        this.encodeAbstractObject((AbstractObjectType)amdit, (AbstractObject)abstractMDIdentification);
        this.encodeCiCitation(amdit.addNewCitation(), abstractMDIdentification.getCitation());
        amdit.addNewAbstract().setCharacterString(abstractMDIdentification.getAbstrakt());
    }

    private void encodeCiCitation(CICitationPropertyType cicpt, GmdCitation citation) {
        if (citation.isSetSimpleAttrs()) {
            cicpt.setHref(citation.getSimpleAttrs().getHref());
            if (citation.getSimpleAttrs().isSetTitle()) {
                cicpt.setTitle(citation.getSimpleAttrs().getTitle());
            }
            if (citation.getSimpleAttrs().isSetRole()) {
                cicpt.setRole(citation.getSimpleAttrs().getRole());
            }
        } else {
            CICitationType cict = cicpt.addNewCICitation();
            cict.addNewTitle().setCharacterString(citation.getTitle());
            CIDateType cidt = cict.addNewDate().addNewCIDate();
            CodeListValueType clvt = cidt.addNewDateType().addNewCIDateTypeCode();
            GmdCitationDate gmdCitationDate = citation.getDate();
            GmdDateType gmdDateType = gmdCitationDate.getDateType();
            clvt.setCodeList(gmdDateType.getCodeList());
            clvt.setCodeListValue(gmdDateType.getCodeListValue());
            if (gmdDateType.getCodeSpace() != null && !gmdDateType.getCodeSpace().isEmpty()) {
                clvt.setCodeSpace(gmdDateType.getCodeSpace());
            }
            clvt.setStringValue(gmdDateType.getValue());
            XmlCursor newCursor = cidt.addNewDate().newCursor();
            newCursor.toNextToken();
            newCursor.beginElement(QN_GCO_DATE);
            newCursor.insertChars(gmdCitationDate.getDate());
            newCursor.dispose();
        }
    }

    private XmlObject encodeMDDataIdentification(MDDataIdentification mdDataIdentification, EncodingContext context) {
        if (mdDataIdentification.isSetSimpleAttrs()) {
            MDDataIdentificationPropertyType mddipt = MDDataIdentificationPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            mddipt.setHref(mdDataIdentification.getSimpleAttrs().getHref());
            if (mdDataIdentification.getSimpleAttrs().isSetTitle()) {
                mddipt.setTitle(mdDataIdentification.getSimpleAttrs().getTitle());
            }
            if (mdDataIdentification.getSimpleAttrs().isSetRole()) {
                mddipt.setRole(mdDataIdentification.getSimpleAttrs().getRole());
            }
            return mddipt;
        }
        MDDataIdentificationType mddit = MDDataIdentificationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.encodeIdentificationInfo((AbstractMDIdentificationType)mddit, (AbstractMDIdentification)mdDataIdentification);
        mddit.addNewLanguage().setCharacterString(mdDataIdentification.getLanguage());
        if (context.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            MDDataIdentificationPropertyType mddipt = MDDataIdentificationPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            mddipt.setMDDataIdentification(mddit);
            return mddipt;
        }
        if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            MDDataIdentificationDocument mddid = MDDataIdentificationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            mddid.setMDDataIdentification(mddit);
            return mddit;
        }
        return mddit;
    }

    private XmlObject encodeResponsibleParty(CiResponsibleParty responsibleParty, EncodingContext context) throws EncodingException {
        if (responsibleParty.isSetSimpleAttrs()) {
            CIResponsiblePartyPropertyType cirppt = CIResponsiblePartyPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            cirppt.setHref(responsibleParty.getSimpleAttrs().getHref());
            if (responsibleParty.getSimpleAttrs().isSetTitle()) {
                cirppt.setTitle(responsibleParty.getSimpleAttrs().getTitle());
            }
            if (responsibleParty.getSimpleAttrs().isSetRole()) {
                cirppt.setRole(responsibleParty.getSimpleAttrs().getRole());
            }
            return cirppt;
        }
        CIResponsiblePartyType cirpt = CIResponsiblePartyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (responsibleParty.isSetIndividualName()) {
            cirpt.addNewIndividualName().setCharacterString(responsibleParty.getIndividualName());
        }
        if (responsibleParty.isSetOrganizationName()) {
            cirpt.addNewOrganisationName().setCharacterString(responsibleParty.getOrganizationName());
        }
        if (responsibleParty.isSetPositionName()) {
            cirpt.addNewPositionName().setCharacterString(responsibleParty.getPositionName());
        }
        if (responsibleParty.isSetContactInfo()) {
            this.encodeContact(cirpt.addNewContactInfo(), (Referenceable<CiContact>)responsibleParty.getContactInfo());
        }
        this.encodeRole(cirpt.addNewRole(), (Nillable<org.n52.shetland.iso.gco.Role>)responsibleParty.getRoleNillable());
        if (responsibleParty.isSetId()) {
            cirpt.setId(responsibleParty.getId());
        }
        if (responsibleParty.isSetUuid()) {
            cirpt.setUuid(responsibleParty.getUuid());
        }
        if (context.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            CIResponsiblePartyPropertyType cirppt = CIResponsiblePartyPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            cirppt.setCIResponsibleParty(cirpt);
            return cirppt;
        }
        if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            CIResponsiblePartyDocument cirpd = CIResponsiblePartyDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            cirpd.setCIResponsibleParty(cirpt);
            return cirpd;
        }
        return cirpt;
    }

    private XmlObject encodeResponsibleParty(SmlResponsibleParty responsibleParty, EncodingContext additionalValues) throws EncodingException {
        if (responsibleParty.isSetHref()) {
            CIResponsiblePartyPropertyType cirppt = CIResponsiblePartyPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            cirppt.setHref(responsibleParty.getHref());
            if (responsibleParty.isSetTitle()) {
                cirppt.setTitle(responsibleParty.getTitle());
            }
            if (responsibleParty.isSetRole()) {
                cirppt.setRole(responsibleParty.getRole());
            }
            return cirppt;
        }
        CIResponsiblePartyType cirpt = CIResponsiblePartyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (responsibleParty.isSetIndividualName()) {
            cirpt.addNewIndividualName().setCharacterString(responsibleParty.getIndividualName());
        }
        if (responsibleParty.isSetOrganizationName()) {
            cirpt.addNewOrganisationName().setCharacterString(responsibleParty.getOrganizationName());
        }
        if (responsibleParty.isSetPositionName()) {
            cirpt.addNewPositionName().setCharacterString(responsibleParty.getPositionName());
        }
        this.encodeContact(cirpt.addNewContactInfo().addNewCIContact(), responsibleParty);
        this.encodeRole(cirpt.addNewRole(), responsibleParty.getRoleObject());
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            CIResponsiblePartyPropertyType cirppt = CIResponsiblePartyPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            cirppt.setCIResponsibleParty(cirpt);
            return cirppt;
        }
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            CIResponsiblePartyDocument cirpd = CIResponsiblePartyDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            cirpd.setCIResponsibleParty(cirpt);
        }
        return cirpt;
    }

    private void encodeContact(CIContactPropertyType cicpt, Referenceable<CiContact> referenceable) {
        if (referenceable.isReference()) {
            Reference reference = referenceable.getReference();
            if (reference.getActuate().isPresent()) {
                cicpt.setActuate(ActuateType.Enum.forString((String)((String)reference.getActuate().get())));
            }
            if (reference.getArcrole().isPresent()) {
                cicpt.setHref((String)reference.getArcrole().get());
            }
            if (reference.getHref().isPresent()) {
                cicpt.setHref(((URI)reference.getHref().get()).toString());
            }
            if (reference.getRole().isPresent()) {
                cicpt.setRole((String)reference.getRole().get());
            }
            if (reference.getShow().isPresent()) {
                cicpt.setShow(ShowType.Enum.forString((String)((String)reference.getShow().get())));
            }
            if (reference.getTitle().isPresent()) {
                cicpt.setTitle((String)reference.getTitle().get());
            }
            if (reference.getType().isPresent()) {
                cicpt.setType(TypeType.Enum.forString((String)((String)reference.getType().get())));
            }
        } else if (referenceable.isInstance()) {
            Nillable nillable = referenceable.getInstance();
            if (nillable.isPresent()) {
                CiContact ciContact = (CiContact)referenceable.getInstance().get();
                CIContactType cict = cicpt.addNewCIContact();
                if (ciContact.getAddress() != null) {
                    this.encodeCiAddress(cict.addNewAddress(), (Referenceable<CiAddress>)ciContact.getAddress());
                }
                if (ciContact.getContactInstructionsNillable() != null) {
                    if (ciContact.getContactInstructionsNillable().isPresent()) {
                        cict.addNewContactInstructions().setCharacterString(ciContact.getContactInstructions());
                    } else if (ciContact.getContactInstructionsNillable().hasReason()) {
                        cict.addNewContactInstructions().setNilReason(ciContact.getContactInstructionsNillable().getNilReason().get());
                    }
                }
                if (ciContact.isSetHoursOfService()) {
                    if (ciContact.getHoursOfServiceNillable().isPresent()) {
                        cict.addNewHoursOfService().setCharacterString(ciContact.getHoursOfService());
                    } else if (ciContact.getHoursOfServiceNillable().hasReason()) {
                        cict.addNewHoursOfService().setNilReason(ciContact.getHoursOfServiceNillable().getNilReason().get());
                    }
                }
                if (ciContact.getOnlineResourceReferenceable() != null) {
                    this.encodeOnlineResource(cict.addNewOnlineResource(), (Referenceable<CiOnlineResource>)ciContact.getOnlineResourceReferenceable());
                }
                if (ciContact.isSetPhone()) {
                    this.encodePhone(cict.addNewPhone(), (Referenceable<CiTelephone>)ciContact.getPhone());
                }
            } else if (nillable.hasReason()) {
                cicpt.setNilReason(nillable.getNilReason().get());
            }
        }
    }

    private void encodeContact(CIContactType cic, SmlResponsibleParty responsibleParty) {
        if (responsibleParty.isSetAddress()) {
            this.encodeCiAddress(cic.addNewAddress().addNewCIAddress(), responsibleParty);
        }
        if (responsibleParty.isSetContactInstructions()) {
            cic.addNewContactInstructions().setCharacterString(responsibleParty.getContactInstructions());
        }
        if (responsibleParty.isSetHoursOfService()) {
            cic.addNewHoursOfService().setCharacterString(responsibleParty.getHoursOfService());
        }
        if (responsibleParty.isSetOnlineResources()) {
            cic.addNewOnlineResource().setHref((String)responsibleParty.getOnlineResources().get(0));
        }
        if (responsibleParty.isSetPhone()) {
            this.encodePhone(cic.addNewPhone().addNewCITelephone(), responsibleParty);
        }
    }

    private void encodeCiAddress(CIAddressPropertyType ciapt, Referenceable<CiAddress> referenceable) {
        if (referenceable.isReference()) {
            Reference reference = referenceable.getReference();
            if (reference.getActuate().isPresent()) {
                ciapt.setActuate(ActuateType.Enum.forString((String)((String)reference.getActuate().get())));
            }
            if (reference.getArcrole().isPresent()) {
                ciapt.setHref((String)reference.getArcrole().get());
            }
            if (reference.getHref().isPresent()) {
                ciapt.setHref(((URI)reference.getHref().get()).toString());
            }
            if (reference.getRole().isPresent()) {
                ciapt.setRole((String)reference.getRole().get());
            }
            if (reference.getShow().isPresent()) {
                ciapt.setShow(ShowType.Enum.forString((String)((String)reference.getShow().get())));
            }
            if (reference.getTitle().isPresent()) {
                ciapt.setTitle((String)reference.getTitle().get());
            }
            if (reference.getType().isPresent()) {
                ciapt.setType(TypeType.Enum.forString((String)((String)reference.getType().get())));
            }
        } else if (referenceable.isInstance()) {
            Nillable nillable = referenceable.getInstance();
            if (nillable.isPresent()) {
                CiAddress ciAddress = (CiAddress)referenceable.getInstance().get();
                CIAddressType ciat = ciapt.addNewCIAddress();
                if (ciAddress.isSetAdministrativeArea()) {
                    ciat.addNewAdministrativeArea().setCharacterString(ciAddress.getAdministrativeArea());
                }
                if (ciAddress.isSetCity()) {
                    ciat.addNewCity().setCharacterString(ciAddress.getCity());
                }
                if (ciAddress.isSetCountry()) {
                    ciat.addNewCountry().setCharacterString(ciAddress.getCountry());
                }
                if (ciAddress.isSetPostalCode()) {
                    ciat.addNewPostalCode().setCharacterString(ciAddress.getPostalCode());
                }
                if (ciAddress.hasDeliveryPoints()) {
                    ciat.setDeliveryPointArray(this.listToCharacterStringPropertyTypeArray(ciAddress.getDeliveryPoints()));
                }
                if (ciAddress.hasElectronicMailAddresses()) {
                    ciat.setElectronicMailAddressArray(this.listToCharacterStringPropertyTypeArray(Lists.newArrayList((Iterable)ciAddress.getElectronicMailAddresses())));
                }
                if (ciAddress.isSetId()) {
                    ciat.setId(ciAddress.getId());
                }
                if (ciAddress.isSetUuid()) {
                    ciat.setUuid(ciAddress.getUuid());
                }
            } else if (nillable.hasReason()) {
                ciapt.setNilReason(nillable.getNilReason().get());
            }
        }
    }

    private void encodeCiAddress(CIAddressType ciat, SmlResponsibleParty responsibleParty) {
        if (responsibleParty.isSetAdministrativeArea()) {
            ciat.addNewAdministrativeArea().setCharacterString(responsibleParty.getAdministrativeArea());
        }
        if (responsibleParty.isSetCity()) {
            ciat.addNewCity().setCharacterString(responsibleParty.getCity());
        }
        if (responsibleParty.isSetCountry()) {
            ciat.addNewCountry().setCharacterString(responsibleParty.getCountry());
        }
        if (responsibleParty.isSetPostalCode()) {
            ciat.addNewPostalCode().setCharacterString(responsibleParty.getPostalCode());
        }
        if (responsibleParty.isSetDeliveryPoint()) {
            ciat.setDeliveryPointArray(this.listToCharacterStringPropertyTypeArray(responsibleParty.getDeliveryPoint()));
        }
        if (responsibleParty.isSetEmail()) {
            ciat.setElectronicMailAddressArray(this.listToCharacterStringPropertyTypeArray(Lists.newArrayList((Object[])new String[]{responsibleParty.getEmail()})));
        }
    }

    private void encodePhone(CITelephonePropertyType citpt, Referenceable<CiTelephone> referenceable) {
        if (referenceable.isReference()) {
            Reference reference = referenceable.getReference();
            if (reference.getActuate().isPresent()) {
                citpt.setActuate(ActuateType.Enum.forString((String)((String)reference.getActuate().get())));
            }
            if (reference.getArcrole().isPresent()) {
                citpt.setHref((String)reference.getArcrole().get());
            }
            if (reference.getHref().isPresent()) {
                citpt.setHref(((URI)reference.getHref().get()).toString());
            }
            if (reference.getRole().isPresent()) {
                citpt.setRole((String)reference.getRole().get());
            }
            if (reference.getShow().isPresent()) {
                citpt.setShow(ShowType.Enum.forString((String)((String)reference.getShow().get())));
            }
            if (reference.getTitle().isPresent()) {
                citpt.setTitle((String)reference.getTitle().get());
            }
            if (reference.getType().isPresent()) {
                citpt.setType(TypeType.Enum.forString((String)((String)reference.getType().get())));
            }
        } else if (referenceable.isInstance()) {
            Nillable nillable = referenceable.getInstance();
            if (nillable.isPresent()) {
                CiTelephone ciTelephone = (CiTelephone)referenceable.getInstance().get();
                CITelephoneType citt = citpt.addNewCITelephone();
                if (ciTelephone.isSetVoice()) {
                    citt.setVoiceArray(this.listToCharacterStringPropertyTypeArray(ciTelephone.getVoice()));
                }
                if (ciTelephone.isSetFacsimile()) {
                    citt.setFacsimileArray(this.listToCharacterStringPropertyTypeArray(ciTelephone.getFacsimile()));
                }
                if (ciTelephone.isSetId()) {
                    citt.setId(ciTelephone.getId());
                }
                if (ciTelephone.isSetUuid()) {
                    citt.setUuid(ciTelephone.getUuid());
                }
            } else if (nillable.hasReason()) {
                citpt.setNilReason(nillable.getNilReason().get());
            }
        }
    }

    private void encodePhone(CITelephoneType citt, SmlResponsibleParty responsibleParty) {
        if (responsibleParty.isSetPhoneVoice()) {
            citt.setVoiceArray(this.listToCharacterStringPropertyTypeArray(responsibleParty.getPhoneVoice()));
        }
        if (responsibleParty.isSetPhoneFax()) {
            citt.setFacsimileArray(this.listToCharacterStringPropertyTypeArray(responsibleParty.getPhoneFax()));
        }
    }

    private void encodeRole(CIRoleCodePropertyType circpt, Nillable<org.n52.shetland.iso.gco.Role> nillable) throws EncodingException {
        if (nillable.isPresent()) {
            XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.isotc211.org/2005/gco", nillable.get());
            if (encodeObjectToXml != null) {
                circpt.addNewCIRoleCode().set(encodeObjectToXml);
            }
        } else if (nillable.hasReason()) {
            circpt.setNilReason(nillable.getNilReason().get());
        }
    }

    private void encodeRole(CIRoleCodePropertyType circpt, Role role) throws EncodingException {
        XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.isotc211.org/2005/gco", role);
        if (encodeObjectToXml != null) {
            circpt.addNewCIRoleCode().set(encodeObjectToXml);
        }
    }

    private XmlObject encodeGmdDomainConsistency(GmdDomainConsistency element, EncodingContext additionalValues) throws EncodingException {
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            DQDomainConsistencyDocument document = DQDomainConsistencyDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            DQResultPropertyType addNewResult = document.addNewDQDomainConsistency().addNewResult();
            this.encodeGmdDomainConsistency(addNewResult, element);
            return document;
        }
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            DQDomainConsistencyPropertyType propertyType = DQDomainConsistencyPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            DQResultPropertyType addNewResult = propertyType.addNewDQDomainConsistency().addNewResult();
            this.encodeGmdDomainConsistency(addNewResult, element);
            return propertyType;
        }
        DQDomainConsistencyType type = DQDomainConsistencyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        DQResultPropertyType addNewResult = type.addNewResult();
        this.encodeGmdDomainConsistency(addNewResult, element);
        return type;
    }

    private void encodeGmdDomainConsistency(DQResultPropertyType xbResult, GmdDomainConsistency domainConsistency) throws EncodingException {
        if (domainConsistency instanceof GmdConformanceResult) {
            this.encodeGmdConformanceResult(xbResult, (GmdConformanceResult)domainConsistency);
        } else if (domainConsistency instanceof GmdQuantitativeResult) {
            this.encodeGmdQuantitativeResult(xbResult, (GmdQuantitativeResult)domainConsistency);
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)domainConsistency);
        }
    }

    private void encodeGmdConformanceResult(DQResultPropertyType xbResult, GmdConformanceResult gmdConformanceResult) {
        DQConformanceResultType dqConformanceResultType = (DQConformanceResultType)xbResult.addNewAbstractDQResult().substitute(QN_GMD_CONFORMANCE_RESULT, DQConformanceResultType.type);
        if (gmdConformanceResult.isSetPassNilReason()) {
            dqConformanceResultType.addNewPass().setNilReason((Object)gmdConformanceResult.getPassNilReason().name());
        } else {
            dqConformanceResultType.addNewPass().setBoolean(gmdConformanceResult.isPass());
        }
        dqConformanceResultType.addNewExplanation().setCharacterString(gmdConformanceResult.getSpecification().getExplanation());
        this.encodeCiCitation(dqConformanceResultType.addNewSpecification(), gmdConformanceResult.getSpecification().getCitation());
    }

    private void encodeGmdQuantitativeResult(DQResultPropertyType xbResult, GmdQuantitativeResult gmdQuantitativeResult) {
        DQQuantitativeResultType dqQuantitativeResultType = (DQQuantitativeResultType)xbResult.addNewAbstractDQResult().substitute(QN_GMD_QUANTITATIVE_RESULT, DQQuantitativeResultType.type);
        GmlBaseUnit unit = gmdQuantitativeResult.getUnit();
        UnitOfMeasurePropertyType valueUnit = dqQuantitativeResultType.addNewValueUnit();
        BaseUnitType xbBaseUnit = (BaseUnitType)valueUnit.addNewUnitDefinition().substitute(QN_GML_BASE_UNIT, BaseUnitType.type);
        CodeType xbCatalogSymbol = xbBaseUnit.addNewCatalogSymbol();
        xbCatalogSymbol.setCodeSpace(unit.getCatalogSymbol().getCodeSpace().toString());
        xbCatalogSymbol.setStringValue(unit.getCatalogSymbol().getValue());
        xbBaseUnit.setId(unit.getId());
        xbBaseUnit.addNewUnitsSystem().setHref(unit.getUnitSystem());
        xbBaseUnit.addNewIdentifier().setCodeSpace(unit.getIdentifier());
        if (gmdQuantitativeResult.isSetValueNilReason()) {
            dqQuantitativeResultType.addNewValue().setNilReason((Object)gmdQuantitativeResult.getValueNilReason().name());
        } else {
            XmlCursor cursor = dqQuantitativeResultType.addNewValue().addNewRecord().newCursor();
            cursor.toNextToken();
            cursor.insertChars(gmdQuantitativeResult.getValue());
            cursor.dispose();
        }
    }

    private PTFreeTextType encodePTFreeText(PT_FreeText element, EncodingContext context) {
        PTFreeTextType ptftt = PTFreeTextType.Factory.newInstance();
        for (LocalisedCharacterString localisedCharacterString : element.getTextGroup()) {
            ptftt.addNewTextGroup().set((XmlObject)this.encodeLocalisedCharacterStringPropertyType(localisedCharacterString));
        }
        return ptftt;
    }

    private LocalisedCharacterStringPropertyType encodeLocalisedCharacterStringPropertyType(LocalisedCharacterString localisedCharacterString) {
        LocalisedCharacterStringPropertyType lcspt = LocalisedCharacterStringPropertyType.Factory.newInstance();
        lcspt.setLocalisedCharacterString(this.encodeLocalisedCharacterStringType(localisedCharacterString));
        return lcspt;
    }

    private LocalisedCharacterStringType encodeLocalisedCharacterStringType(LocalisedCharacterString localisedCharacterString) {
        LocalisedCharacterStringType lcst = LocalisedCharacterStringType.Factory.newInstance();
        lcst.setStringValue(localisedCharacterString.getValue());
        if (localisedCharacterString.isSetLocale()) {
            lcst.setLocale(localisedCharacterString.getLocale());
        }
        return lcst;
    }

    private CharacterStringPropertyType[] listToCharacterStringPropertyTypeArray(List<String> list) {
        return (CharacterStringPropertyType[])list.stream().map(string -> {
            CharacterStringPropertyType cspt = CharacterStringPropertyType.Factory.newInstance();
            cspt.setCharacterString(string);
            return cspt;
        }).toArray(CharacterStringPropertyType[]::new);
    }

    private void encodeOnlineResource(CIOnlineResourcePropertyType ciorpt, Referenceable<CiOnlineResource> referenceable) {
        if (referenceable.isReference()) {
            Reference reference = referenceable.getReference();
            if (reference.getActuate().isPresent()) {
                ciorpt.setActuate(ActuateType.Enum.forString((String)((String)reference.getActuate().get())));
            }
            if (reference.getArcrole().isPresent()) {
                ciorpt.setHref((String)reference.getArcrole().get());
            }
            if (reference.getHref().isPresent()) {
                ciorpt.setHref(((URI)reference.getHref().get()).toString());
            }
            if (reference.getRole().isPresent()) {
                ciorpt.setRole((String)reference.getRole().get());
            }
            if (reference.getShow().isPresent()) {
                ciorpt.setShow(ShowType.Enum.forString((String)((String)reference.getShow().get())));
            }
            if (reference.getTitle().isPresent()) {
                ciorpt.setTitle((String)reference.getTitle().get());
            }
            if (reference.getType().isPresent()) {
                ciorpt.setType(TypeType.Enum.forString((String)((String)reference.getType().get())));
            }
        } else if (referenceable.isInstance()) {
            Nillable nillable = referenceable.getInstance();
            if (nillable.isPresent()) {
                CIOnlineResourceType ciort = ciorpt.addNewCIOnlineResource();
                this.encodeOnlineResource(ciort, (CiOnlineResource)referenceable.getInstance().get());
            } else if (nillable.hasReason()) {
                ciorpt.setNilReason(nillable.getNilReason().get());
            }
        }
    }

    private void encodeOnlineResource(CIOnlineResourceType ciort, CiOnlineResource onlineResource) {
        if (onlineResource.getLinkage().isPresent()) {
            ciort.addNewLinkage().setURL(((URI)onlineResource.getLinkage().get()).toString());
        } else if (onlineResource.getLinkage().hasReason()) {
            ciort.addNewLinkage().setNilReason(onlineResource.getLinkage().getNilReason().get());
        }
        if (onlineResource.isSetProtocol()) {
            if (onlineResource.getProtocol().isPresent()) {
                ciort.addNewProtocol().setCharacterString(((String)onlineResource.getProtocol().get()).toString());
            } else if (onlineResource.getProtocol().getNilReason().isPresent()) {
                ciort.addNewProtocol().setNilReason(onlineResource.getProtocol().getNilReason().get());
            }
        }
        if (onlineResource.isSetApplicationProfile()) {
            ciort.addNewApplicationProfile().setCharacterString(onlineResource.getApplicationProfile());
        }
        if (onlineResource.isSetDescription()) {
            ciort.addNewDescription().setCharacterString(onlineResource.getDescription());
        }
        if (onlineResource.isSetName()) {
            ciort.addNewName().setCharacterString(onlineResource.getName());
        }
        if (onlineResource.isSetFunction()) {
            ciort.addNewFunction().addNewCIOnLineFunctionCode().setStringValue(onlineResource.getFunction());
        }
        if (onlineResource.isSetId()) {
            ciort.setId(onlineResource.getId());
        }
        if (onlineResource.isSetUuid()) {
            ciort.setUuid(onlineResource.getUuid());
        }
    }

    private XmlObject encodeCiOnlineResource(CiOnlineResource element, EncodingContext context) {
        CIOnlineResourceType ciort = CIOnlineResourceType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.encodeOnlineResource(ciort, element);
        if (context.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            CIOnlineResourcePropertyType ciorpt = CIOnlineResourcePropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            ciorpt.setCIOnlineResource(ciort);
            return ciorpt;
        }
        if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            CIOnlineResourceDocument ciord = CIOnlineResourceDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            ciord.setCIOnlineResource(ciort);
            return ciord;
        }
        return ciort;
    }

    private XmlObject encodeEXExtent(EXExtent exExtent, EncodingContext context) throws EncodingException {
        EXExtentType exet = EXExtentType.Factory.newInstance();
        if (exExtent.hasDescription()) {
            exet.addNewDescription().setCharacterString(exExtent.getDescription());
        }
        if (exExtent.hasVerticalExtent()) {
            for (Referenceable verticalExtent : exExtent.getExVerticalExtent()) {
                EXVerticalExtentPropertyType exvept = exet.addNewVerticalElement();
                if (verticalExtent.isReference()) {
                    Reference reference = verticalExtent.getReference();
                    if (reference.getActuate().isPresent()) {
                        exvept.setActuate(ActuateType.Enum.forString((String)((String)reference.getActuate().get())));
                    }
                    if (reference.getArcrole().isPresent()) {
                        exvept.setHref((String)reference.getArcrole().get());
                    }
                    if (reference.getHref().isPresent()) {
                        exvept.setHref(((URI)reference.getHref().get()).toString());
                    }
                    if (reference.getRole().isPresent()) {
                        exvept.setRole((String)reference.getRole().get());
                    }
                    if (reference.getShow().isPresent()) {
                        exvept.setShow(ShowType.Enum.forString((String)((String)reference.getShow().get())));
                    }
                    if (reference.getTitle().isPresent()) {
                        exvept.setTitle((String)reference.getTitle().get());
                    }
                    if (!reference.getType().isPresent()) continue;
                    exvept.setType(TypeType.Enum.forString((String)((String)reference.getType().get())));
                    continue;
                }
                if (!verticalExtent.isInstance()) continue;
                Nillable nillable = verticalExtent.getInstance();
                if (nillable.isPresent()) {
                    XmlObject xml = this.encodeEXVerticalExtent((EXVerticalExtent)nillable.get(), EncodingContext.empty());
                    if (xml != null && xml instanceof EXVerticalExtentType) {
                        exvept.setEXVerticalExtent((EXVerticalExtentType)xml);
                        continue;
                    }
                    exvept.setNil();
                    exvept.setNilReason(Nillable.missing().get());
                    continue;
                }
                exvept.setNil();
                if (nillable.hasReason()) {
                    exvept.setNilReason(nillable.getNilReason().get());
                    continue;
                }
                exvept.setNilReason(Nillable.missing().get());
            }
        }
        if (context.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            EXExtentPropertyType exept = EXExtentPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            exept.setEXExtent(exet);
            return exept;
        }
        if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            EXExtentDocument exed = EXExtentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            exed.setEXExtent(exet);
            return exed;
        }
        return exet;
    }

    private XmlObject encodeEXVerticalExtent(EXVerticalExtent exVerticalExtent, EncodingContext context) throws EncodingException {
        EXVerticalExtentType exvet = EXVerticalExtentType.Factory.newInstance();
        if (exVerticalExtent.isSetId()) {
            exvet.setId(exVerticalExtent.getId());
        }
        if (exVerticalExtent.isSetUuid()) {
            exvet.setUuid(exVerticalExtent.getUuid());
        }
        Nillable minNillable = exVerticalExtent.getMinimumValue();
        RealPropertyType rptMinValue = exvet.addNewMinimumValue();
        if (minNillable.isPresent()) {
            rptMinValue.setReal(((Double)minNillable.get()).doubleValue());
        } else {
            rptMinValue.setNil();
            if (minNillable.hasReason()) {
                rptMinValue.setNilReason(minNillable.getNilReason().get());
            } else {
                rptMinValue.setNilReason(Nillable.missing().get());
            }
        }
        Nillable maxNillable = exVerticalExtent.getMaximumValue();
        RealPropertyType rptMinMaxValue = exvet.addNewMaximumValue();
        if (maxNillable.isPresent()) {
            rptMinMaxValue.setReal(((Double)maxNillable.get()).doubleValue());
        } else {
            rptMinMaxValue.setNil();
            if (maxNillable.hasReason()) {
                rptMinMaxValue.setNilReason(maxNillable.getNilReason().get());
            } else {
                rptMinMaxValue.setNilReason(Nillable.missing().get());
            }
        }
        SCCRSPropertyType sccrspt = exvet.addNewVerticalCRS();
        Referenceable verticalCRS = exVerticalExtent.getVerticalCRS();
        if (verticalCRS.isReference()) {
            Reference reference = verticalCRS.getReference();
            if (reference.getActuate().isPresent()) {
                sccrspt.setActuate(ActuateType.Enum.forString((String)((String)reference.getActuate().get())));
            }
            if (reference.getArcrole().isPresent()) {
                sccrspt.setHref((String)reference.getArcrole().get());
            }
            if (reference.getHref().isPresent()) {
                sccrspt.setHref(((URI)reference.getHref().get()).toString());
            }
            if (reference.getRole().isPresent()) {
                sccrspt.setRole((String)reference.getRole().get());
            }
            if (reference.getShow().isPresent()) {
                sccrspt.setShow(ShowType.Enum.forString((String)((String)reference.getShow().get())));
            }
            if (reference.getTitle().isPresent()) {
                sccrspt.setTitle((String)reference.getTitle().get());
            }
            if (reference.getType().isPresent()) {
                sccrspt.setType(TypeType.Enum.forString((String)((String)reference.getType().get())));
            }
        } else if (verticalCRS.isInstance()) {
            Nillable nillable = verticalCRS.getInstance();
            if (nillable.isPresent()) {
                XmlObject xml = this.encodeObjectToXml("http://www.opengis.net/gml/3.2", ((ScCRS)nillable.get()).getAbstractCrs());
                if (xml != null && xml instanceof AbstractCRSType) {
                    XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)sccrspt.addNewAbstractCRS(), (XmlObject)xml);
                    substituteElement.set(xml);
                } else {
                    sccrspt.setNil();
                    sccrspt.setNilReason(Nillable.missing().get());
                }
            } else {
                sccrspt.setNil();
                if (nillable.hasReason()) {
                    sccrspt.setNilReason(nillable.getNilReason().get());
                } else {
                    sccrspt.setNilReason(Nillable.missing().get());
                }
            }
        }
        if (context.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE)) {
            EXVerticalExtentPropertyType exvept = EXVerticalExtentPropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            exvept.setEXVerticalExtent(exvet);
            return exvept;
        }
        if (context.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            EXVerticalExtentDocument exved = EXVerticalExtentDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            exved.setEXVerticalExtent(exvet);
            return exved;
        }
        return exvet;
    }
}

