/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import net.opengis.gml.x32.FeaturePropertyType;
import net.opengis.gml.x32.TimeInstantPropertyType;
import net.opengis.om.x20.OMObservationType;
import net.opengis.om.x20.OMProcessPropertyType;
import net.opengis.om.x20.TimeObjectPropertyType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.om.AbstractObservationValue;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.NamedValue;
import org.n52.shetland.ogc.om.ObservationType;
import org.n52.shetland.ogc.om.ObservationValue;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.OmObservationConstellation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.ComplexValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.CvDiscretePointCoverage;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.HrefAttributeValue;
import org.n52.shetland.ogc.om.values.MultiPointCoverage;
import org.n52.shetland.ogc.om.values.NilTemplateValue;
import org.n52.shetland.ogc.om.values.ProfileValue;
import org.n52.shetland.ogc.om.values.QuantityRangeValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.RectifiedGridCoverage;
import org.n52.shetland.ogc.om.values.ReferenceValue;
import org.n52.shetland.ogc.om.values.SweDataArrayValue;
import org.n52.shetland.ogc.om.values.TLVTValue;
import org.n52.shetland.ogc.om.values.TVPValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.TimeRangeValue;
import org.n52.shetland.ogc.om.values.UnknownValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.om.values.XmlValue;
import org.n52.shetland.ogc.om.values.visitor.ValueVisitor;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.util.OMHelper;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractOmEncoderv20;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.SweHelper;
import org.n52.svalbard.write.OmV20XmlStreamWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OmEncoderv20
extends AbstractOmEncoderv20 {
    private static final String NIL_REASON_TEMPLATE = "template";
    private static final String OBSERVATION_GML_ID_TEMPLATE = "template";
    private static final Logger LOGGER = LoggerFactory.getLogger(OmEncoderv20.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/om/2.0", (Class[])new Class[]{MultiObservationValues.class, NamedValue.class, SingleObservationValue.class, OmObservation.class, OmObservationConstellation.class});
    private static final Set<String> CONFORMANCE_CLASSES = new HashSet<String>(Arrays.asList("http://www.opengis.net/spec/OMXML/2.0/conf/measurement", "http://www.opengis.net/spec/OMXML/2.0/conf/categoryObservation", "http://www.opengis.net/spec/OMXML/2.0/conf/countObservation", "http://www.opengis.net/spec/OMXML/2.0/conf/truthObservation", "http://www.opengis.net/spec/OMXML/2.0/conf/geometryObservation", "http://www.opengis.net/spec/OMXML/2.0/conf/textObservation", "http://www.opengis.net/spec/OMXML/2.0/conf/complexObservation"));
    private static final Set<SupportedType> SUPPORTED_TYPES = new HashSet<ObservationType>(Arrays.asList(OmConstants.OBS_TYPE_SWE_ARRAY_OBSERVATION_TYPE, OmConstants.OBS_TYPE_COMPLEX_OBSERVATION_TYPE, OmConstants.OBS_TYPE_GEOMETRY_OBSERVATION_TYPE, OmConstants.OBS_TYPE_CATEGORY_OBSERVATION_TYPE, OmConstants.OBS_TYPE_COUNT_OBSERVATION_TYPE, OmConstants.OBS_TYPE_MEASUREMENT_TYPE, OmConstants.OBS_TYPE_TEXT_OBSERVATION_TYPE, OmConstants.OBS_TYPE_TRUTH_OBSERVATION_TYPE, OmConstants.OBS_TYPE_REFERENCE_OBSERVATION_TYPE));
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("2.0.0", Collections.singleton("http://www.opengis.net/om/2.0")));

    public OmEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap("http://www.opengis.net/om/2.0", this.getSupportedTypes());
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    public boolean isObservationAndMeasurmentV20Type() {
        return true;
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        if (SUPPORTED_RESPONSE_FORMATS.get(service) != null && SUPPORTED_RESPONSE_FORMATS.get(service).get(version) != null) {
            return SUPPORTED_RESPONSE_FORMATS.get(service).get(version);
        }
        return Collections.emptySet();
    }

    public boolean shouldObservationsWithSameXBeMerged() {
        return false;
    }

    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    @Override
    public String getDefaultFeatureEncodingNamespace() {
        return null;
    }

    @Override
    public MediaType getContentType() {
        return OmConstants.CONTENT_TYPE_OM_2;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{OmConstants.OM_20_SCHEMA_LOCATION});
    }

    @Override
    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        if (element instanceof ObservationValue) {
            return this.encodeResult((ObservationValue)element);
        }
        if (element instanceof OmObservationConstellation) {
            return this.encodeObservationTemplate((OmObservationConstellation)element);
        }
        return super.encode(element, additionalValues);
    }

    @Override
    public void encode(Object objectToEncode, OutputStream outputStream, EncodingContext ctx) throws EncodingException {
        if (objectToEncode instanceof OmObservation) {
            try {
                new OmV20XmlStreamWriter(ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions), outputStream, (OmObservation)objectToEncode).write();
            }
            catch (XMLStreamException xmlse) {
                throw new EncodingException("Error while writing element to stream!", (Throwable)xmlse);
            }
        } else {
            super.encode(objectToEncode, ctx);
        }
    }

    @Override
    protected OMObservationType createOmObservationType() {
        return OMObservationType.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    @Override
    protected XmlObject createResult(OmObservation sosObservation) throws EncodingException {
        ObservationValue value = sosObservation.getValue();
        if (value instanceof AbstractObservationValue) {
            AbstractObservationValue abstractObservationValue = (AbstractObservationValue)value;
            abstractObservationValue.setValuesForResultEncoding(sosObservation);
            return this.encodeResult((ObservationValue<?>)abstractObservationValue);
        }
        return null;
    }

    @Override
    protected XmlObject encodeResult(ObservationValue<?> observationValue) throws EncodingException {
        if (observationValue instanceof SingleObservationValue) {
            return this.createSingleObservationToResult((SingleObservationValue)observationValue);
        }
        if (observationValue instanceof MultiObservationValues) {
            return this.createMultiObservationValueToResult((MultiObservationValues)observationValue);
        }
        return null;
    }

    @Override
    protected void addObservationType(OMObservationType xbObservation, String observationType) {
        if (!Strings.isNullOrEmpty((String)observationType)) {
            xbObservation.addNewType().setHref(observationType);
        }
    }

    @Override
    protected String getDefaultProcedureEncodingNamspace() {
        return "http://www.opengis.net/sensorML/1.0.1";
    }

    @Override
    protected boolean convertEncodedProcedure() {
        return false;
    }

    @Override
    protected void addAddtitionalInformation(OMObservationType omot, OmObservation observation) throws EncodingException {
    }

    private OMObservationType encodeObservationTemplate(OmObservationConstellation observationTemplate) throws EncodingException {
        this.validateInput(observationTemplate);
        OMObservationType xbObservationTemplate = this.createOmObservationType();
        this.addGmlId(xbObservationTemplate);
        this.addObservationType(xbObservationTemplate, observationTemplate.getObservationType());
        this.addNilPhenomenonTime(xbObservationTemplate);
        this.addNilResultTime(xbObservationTemplate);
        this.addProcedure(xbObservationTemplate, (Nillable<AbstractFeature>)observationTemplate.getNillableProcedure());
        this.addObservedProperty(xbObservationTemplate, observationTemplate.getObservablePropertyIdentifier());
        this.addFeature(xbObservationTemplate, (Nillable<AbstractFeature>)observationTemplate.getNillableFeatureOfInterest());
        this.addResult(xbObservationTemplate);
        return xbObservationTemplate;
    }

    private void addResult(OMObservationType xbObservationTemplate) {
        xbObservationTemplate.addNewResult();
    }

    private void addGmlId(OMObservationType xbObservationTemplate) {
        xbObservationTemplate.setId("template");
    }

    private void addObservedProperty(OMObservationType xbObservationTemplate, String observablePropertyIdentifier) {
        xbObservationTemplate.addNewObservedProperty().setHref(observablePropertyIdentifier);
    }

    private void addFeature(OMObservationType xbObservationTemplate, Nillable<AbstractFeature> featureOfInterest) throws EncodingException {
        FeaturePropertyType xbFeatureOfInterest = xbObservationTemplate.addNewFeatureOfInterest();
        if (featureOfInterest.isNil() || featureOfInterest.isAbsent()) {
            xbFeatureOfInterest.setNilReason((Object)"template");
        } else {
            XmlObject xbEncodedFeature = this.encodeObjectToXmlPropertyType(((AbstractFeature)featureOfInterest.get()).getDefaultElementEncoding(), featureOfInterest.get(), EncodingContext.empty());
            xbFeatureOfInterest.set(xbEncodedFeature);
        }
    }

    private void addProcedure(OMObservationType xbObservationTemplate, Nillable<AbstractFeature> procedure) {
        OMProcessPropertyType xbProcedure = xbObservationTemplate.addNewProcedure();
        if (procedure.isNil() || procedure.isAbsent() || !((AbstractFeature)procedure.get()).isSetIdentifier()) {
            xbProcedure.setNil();
            xbProcedure.setNilReason((Object)"template");
        } else {
            xbProcedure.setHref(((AbstractFeature)procedure.get()).getIdentifier());
        }
    }

    private void validateInput(OmObservationConstellation observationTemplate) throws UnsupportedEncoderInputException {
        if (!observationTemplate.isSetObservationType() || observationTemplate.getObservationType().isEmpty()) {
            throw new UnsupportedEncoderInputException((Encoder)this, "missing type in OM_Observation");
        }
    }

    private void addNilResultTime(OMObservationType xbObservationTemplate) {
        TimeInstantPropertyType xbResultTime = xbObservationTemplate.addNewResultTime();
        xbResultTime.setNilReason((Object)"template");
    }

    private void addNilPhenomenonTime(OMObservationType xbObservationTemplate) {
        TimeObjectPropertyType xbPhenomenonTime = xbObservationTemplate.addNewPhenomenonTime();
        xbPhenomenonTime.setNilReason((Object)"template");
    }

    private XmlObject createSingleObservationToResult(SingleObservationValue<?> observationValue) throws EncodingException {
        String observationType = observationValue.isSetObservationType() ? observationValue.getObservationType() : OMHelper.getObservationTypeFor((Value)observationValue.getValue());
        if (observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_SWEArrayObservation")) {
            SweDataArray dataArray = new SweHelper().createSosSweDataArray(observationValue);
            return this.encodeSWE(dataArray, EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT));
        }
        return (XmlObject)observationValue.getValue().accept((ValueVisitor)new ResultValueVisitor(observationType, observationValue.getObservationID()));
    }

    private XmlObject createMultiObservationValueToResult(MultiObservationValues<?> observationValue) throws EncodingException {
        SweDataArray dataArray = new SweHelper().createSosSweDataArray(observationValue);
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", dataArray, EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT));
    }

    protected XmlString createXmlString() {
        return XmlString.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    protected XmlInteger createXmlInteger() {
        return XmlInteger.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    protected XmlBoolean createXmlBoolean() {
        return XmlBoolean.Factory.newInstance((XmlOptions)this.getXmlOptions());
    }

    protected XmlObject encodeSWE(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSWE(Object o, EncodingContext additionalValues) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, additionalValues);
    }

    private class ResultValueVisitor
    implements ValueVisitor<XmlObject, EncodingException> {
        private final String observationType;
        private final String observationId;

        ResultValueVisitor(String observationType, String observationId) {
            this.observationType = observationType;
            this.observationId = observationId;
        }

        public XmlObject visit(BooleanValue value) throws EncodingException {
            if (this.observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TruthObservation")) {
                XmlBoolean xbBoolean = OmEncoderv20.this.createXmlBoolean();
                if (value.isSetValue()) {
                    xbBoolean.setBooleanValue(value.getValue().booleanValue());
                } else {
                    xbBoolean.setNil();
                }
                return xbBoolean;
            }
            return null;
        }

        public XmlObject visit(CategoryValue value) throws EncodingException {
            if (this.observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation") && value.isSetValue() && !value.getValue().isEmpty()) {
                return OmEncoderv20.this.encodeGML(value, EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)("o_" + this.observationId)));
            }
            return null;
        }

        public XmlObject visit(ComplexValue value) throws EncodingException {
            if (this.observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ComplexObservation") && value.isSetValue()) {
                return OmEncoderv20.this.encodeSWE(value.getValue(), EncodingContext.of((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION));
            }
            return null;
        }

        public XmlObject visit(CountValue value) throws EncodingException {
            if (this.observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation")) {
                XmlInteger xbInteger = OmEncoderv20.this.createXmlInteger();
                if (value.isSetValue() && value.getValue() != Integer.MIN_VALUE) {
                    xbInteger.setBigIntegerValue(new BigInteger(value.getValue().toString()));
                } else {
                    xbInteger.setNil();
                }
                return xbInteger;
            }
            return null;
        }

        public XmlObject visit(GeometryValue value) throws EncodingException {
            if (this.observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_GeometryObservation")) {
                if (value.isSetValue()) {
                    return OmEncoderv20.this.encodeGML(value.getValue(), EncodingContext.empty().with((Enum)XmlBeansEncodingFlags.GMLID, (Object)("o_" + this.observationId)).with((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE));
                }
                return null;
            }
            return null;
        }

        public XmlObject visit(HrefAttributeValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(NilTemplateValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(QuantityValue value) throws EncodingException {
            if ((this.observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement") || this.observationType.equals("http://www.opengis.net/def/observationType/waterml/2.0/MeasurementTimeseriesTVPObservation") || this.observationType.equals("http://www.opengis.net/def/observationType/waterml/2.0/measurementDRTimeseriesObservation")) && value.isSetValue()) {
                return OmEncoderv20.this.encodeGML(value);
            }
            return null;
        }

        public XmlObject visit(QuantityRangeValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(ReferenceValue value) throws EncodingException {
            if (value.isSetValue()) {
                return OmEncoderv20.this.encodeGML(value.getValue());
            }
            return null;
        }

        public XmlObject visit(SweDataArrayValue value) throws EncodingException {
            return OmEncoderv20.this.encodeSWE(value.getValue(), EncodingContext.of((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION));
        }

        public XmlObject visit(TVPValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(TextValue value) throws EncodingException {
            if (this.observationType.equals("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TextObservation")) {
                XmlString xbString = OmEncoderv20.this.createXmlString();
                if (value.isSetValue()) {
                    xbString.setStringValue(value.getValue());
                } else {
                    xbString.setNil();
                }
                return xbString;
            }
            return null;
        }

        public XmlObject visit(UnknownValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(TLVTValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(CvDiscretePointCoverage value) throws EncodingException {
            return null;
        }

        public XmlObject visit(MultiPointCoverage value) throws EncodingException {
            return null;
        }

        public XmlObject visit(RectifiedGridCoverage value) throws EncodingException {
            return null;
        }

        public XmlObject visit(ProfileValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(TimeRangeValue value) throws EncodingException {
            return null;
        }

        public XmlObject visit(XmlValue<?> value) throws EncodingException {
            if (value.getValue() instanceof XmlObject) {
                return (XmlObject)value.getValue();
            }
            return null;
        }
    }
}

