/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.AbstractGMLType;
import net.opengis.sampling.x20.SFProcessPropertyType;
import net.opengis.sampling.x20.SFSamplingFeatureType;
import net.opengis.samplingSpecimen.x20.LocationPropertyType;
import net.opengis.samplingSpecimen.x20.SFSpecimenDocument;
import net.opengis.samplingSpecimen.x20.SFSpecimenType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.AbstractGML;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.om.features.SfConstants;
import org.n52.shetland.ogc.om.features.samplingFeatures.AbstractSamplingFeature;
import org.n52.shetland.ogc.om.features.samplingFeatures.SfSpecimen;
import org.n52.shetland.ogc.sos.FeatureType;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.SamplingEncoderv20;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.GmlHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.ActuateType;
import org.w3.x1999.xlink.ShowType;
import org.w3.x1999.xlink.TypeType;
import org.w3c.dom.Node;

public class SpecimenEncoderv20
extends SamplingEncoderv20 {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpecimenEncoderv20.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/samplingSpecimen/2.0", (Class[])new Class[]{AbstractFeature.class, SfSpecimen.class}), CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/sampling/2.0", (Class[])new Class[]{AbstractFeature.class, SfSpecimen.class})});
    private static final Set<SupportedType> SUPPORTED_TYPES = Sets.newHashSet((Object[])new SupportedType[]{new FeatureType("http://www.opengis.net/def/nil/OGC/0/unknown"), new FeatureType("http://www.opengis.net/def/samplingFeatureType/OGC-OM/2.0/SF_Specimen")});

    public SpecimenEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    @Override
    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    @Override
    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    @Override
    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/samplingSpecimen/2.0", "spec");
        nameSpacePrefixMap.put("http://www.opengis.net/sampling/2.0", "sf");
    }

    @Override
    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{SfConstants.SF_SCHEMA_LOCATION, SfConstants.SPEC_SCHEMA_LOCATION});
    }

    @Override
    public XmlObject encode(AbstractFeature abstractFeature, EncodingContext ec) throws EncodingException {
        XmlObject encodedObject = abstractFeature instanceof SfSpecimen ? this.createSpecimen((SfSpecimen)abstractFeature) : this.createFeature(abstractFeature);
        return encodedObject;
    }

    private XmlObject createSpecimen(SfSpecimen specimen) throws EncodingException {
        SFSpecimenDocument sfsd = SFSpecimenDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (specimen.isSetXml()) {
            try {
                XmlObject feature = XmlObject.Factory.parse((String)specimen.getXml(), (XmlOptions)this.getXmlOptions());
                XmlHelper.updateGmlIDs((Node)feature.getDomNode().getFirstChild(), (String)specimen.getGmlId(), null);
                if (XmlHelper.getNamespace((XmlObject)feature).equals("http://www.opengis.net/samplingSpecimen/2.0") && feature instanceof SFSpecimenType) {
                    sfsd.setSFSpecimen((SFSpecimenType)feature);
                    this.addName((AbstractGMLType)sfsd.getSFSpecimen(), (AbstractGML)specimen);
                    this.addDescription((AbstractGMLType)sfsd.getSFSpecimen(), (AbstractGML)specimen);
                    return sfsd;
                }
                this.addName((AbstractGMLType)((SFSpecimenDocument)feature).getSFSpecimen(), (AbstractGML)specimen);
                this.addDescription((AbstractGMLType)((SFSpecimenDocument)feature).getSFSpecimen(), (AbstractGML)specimen);
                return feature;
            }
            catch (XmlException xmle) {
                throw new EncodingException("Error while encoding GetFeatureOfInterest response, invalid specimen description!", (Throwable)xmle);
            }
        }
        SFSpecimenType sfst = sfsd.addNewSFSpecimen();
        this.addId((AbstractGMLType)sfst, (AbstractFeature)specimen);
        this.addIdentifier((AbstractGMLType)sfst, (AbstractGML)specimen);
        this.addFeatureType((SFSamplingFeatureType)sfst, (AbstractSamplingFeature)specimen);
        this.addName((AbstractGMLType)sfst, (AbstractGML)specimen);
        this.addDescription((AbstractGMLType)sfst, (AbstractGML)specimen);
        this.addSampledFeatures((SFSamplingFeatureType)sfst, (AbstractSamplingFeature)specimen);
        this.addParameter((SFSamplingFeatureType)sfst, (AbstractSamplingFeature)specimen);
        this.addMaterialClass(sfst, specimen);
        this.addSamplingTime(sfst, specimen);
        this.addSamplingMethod(sfst, specimen);
        this.addSamplingLocation(sfst, specimen);
        this.addProcessingDetails(sfst, specimen);
        this.addSize(sfst, specimen);
        this.addCurrentLocation(sfst, specimen);
        this.addSpecimenType(sfst, specimen);
        specimen.wasEncoded();
        return sfsd;
    }

    private void addMaterialClass(SFSpecimenType sfst, SfSpecimen specimen) throws EncodingException {
        sfst.addNewMaterialClass().set(this.encodeGML32(specimen.getMaterialClass()));
    }

    private void addSamplingTime(SFSpecimenType sfst, SfSpecimen specimen) throws EncodingException {
        XmlObject xmlObject = this.encodeGML32(specimen.getSamplingTime());
        XmlObject substitution = sfst.addNewSamplingTime().addNewAbstractTimeObject().substitute(GmlHelper.getGml321QnameForITime((Time)specimen.getSamplingTime()), xmlObject.schemaType());
        substitution.set(xmlObject);
    }

    private void addSamplingMethod(SFSpecimenType sfst, SfSpecimen specimen) {
        if (specimen.isSetSamplingMethod() && !specimen.getSamplingMethod().getInstance().isPresent()) {
            sfst.addNewSamplingMethod().setHref(((URI)specimen.getSamplingMethod().getReference().getHref().get()).toString());
            Reference ref = specimen.getCurrentLocation().getReference();
            SFProcessPropertyType sfppt = sfst.addNewSamplingMethod();
            if (ref.getHref().isPresent()) {
                sfppt.setHref(((URI)ref.getHref().get()).toString());
            }
            if (ref.getTitle().isPresent()) {
                sfppt.setTitle((String)ref.getTitle().get());
            }
            if (ref.getActuate().isPresent()) {
                sfppt.setActuate(ActuateType.Enum.forString((String)((String)ref.getActuate().get())));
            }
            if (ref.getArcrole().isPresent()) {
                sfppt.setArcrole((String)ref.getArcrole().get());
            }
            if (ref.getRole().isPresent()) {
                sfppt.setRole((String)ref.getRole().get());
            }
            if (ref.getShow().isPresent()) {
                sfppt.setShow(ShowType.Enum.forString((String)((String)ref.getShow().get())));
            }
            if (ref.getType().isPresent()) {
                sfppt.setType(TypeType.Enum.forString((String)((String)ref.getType().get())));
            }
        }
    }

    private void addSamplingLocation(SFSpecimenType sfst, SfSpecimen specimen) throws EncodingException {
        if (specimen.isSetSamplingLocation()) {
            sfst.addNewSamplingLocation().set(this.encodeGML32(specimen.getSamplingLocation(), EncodingContext.of((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE, (Object)"true")));
        }
    }

    private void addProcessingDetails(SFSpecimenType sfst, SfSpecimen specimen) {
    }

    private void addSize(SFSpecimenType sfst, SfSpecimen specimen) {
        if (specimen.isSetSize()) {
            SFSpecimenType.Size size = sfst.addNewSize();
            size.setDoubleValue(specimen.getSize().getValue().doubleValue());
            if (specimen.getSize().isSetUnit()) {
                size.setUom(specimen.getSize().getUnit());
            }
        }
    }

    private void addCurrentLocation(SFSpecimenType sfst, SfSpecimen specimen) {
        if (specimen.isSetCurrentLocation() && !specimen.getCurrentLocation().getInstance().isPresent()) {
            Reference ref = specimen.getCurrentLocation().getReference();
            LocationPropertyType lpt = sfst.addNewCurrentLocation();
            if (ref.getHref().isPresent()) {
                lpt.setHref(((URI)ref.getHref().get()).toString());
            }
            if (ref.getTitle().isPresent()) {
                lpt.setTitle((String)ref.getTitle().get());
            }
            if (ref.getActuate().isPresent()) {
                lpt.setActuate(ActuateType.Enum.forString((String)((String)ref.getActuate().get())));
            }
            if (ref.getArcrole().isPresent()) {
                lpt.setArcrole((String)ref.getArcrole().get());
            }
            if (ref.getRole().isPresent()) {
                lpt.setRole((String)ref.getRole().get());
            }
            if (ref.getShow().isPresent()) {
                lpt.setShow(ShowType.Enum.forString((String)((String)ref.getShow().get())));
            }
            if (ref.getType().isPresent()) {
                lpt.setType(TypeType.Enum.forString((String)((String)ref.getType().get())));
            }
        }
    }

    private void addSpecimenType(SFSpecimenType sfst, SfSpecimen specimen) throws EncodingException {
        if (specimen.isSetSpecimenType()) {
            sfst.addNewSpecimenType().set(this.encodeGML32(specimen.getSpecimenType()));
        }
    }

    private XmlObject encodeGML32(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, ec);
    }

    private XmlObject encodeGML32(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }
}

