/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.opengis.swe.x20.AbstractDataComponentType;
import net.opengis.swe.x20.AbstractEncodingDocument;
import net.opengis.swe.x20.AbstractEncodingType;
import net.opengis.swe.x20.AllowedTimesPropertyType;
import net.opengis.swe.x20.AllowedTimesType;
import net.opengis.swe.x20.AllowedTokensPropertyType;
import net.opengis.swe.x20.AllowedTokensType;
import net.opengis.swe.x20.AllowedValuesPropertyType;
import net.opengis.swe.x20.AllowedValuesType;
import net.opengis.swe.x20.BooleanDocument;
import net.opengis.swe.x20.BooleanPropertyType;
import net.opengis.swe.x20.BooleanType;
import net.opengis.swe.x20.CategoryDocument;
import net.opengis.swe.x20.CategoryPropertyType;
import net.opengis.swe.x20.CategoryRangeDocument;
import net.opengis.swe.x20.CategoryRangePropertyType;
import net.opengis.swe.x20.CategoryRangeType;
import net.opengis.swe.x20.CategoryType;
import net.opengis.swe.x20.CountDocument;
import net.opengis.swe.x20.CountPropertyType;
import net.opengis.swe.x20.CountRangeDocument;
import net.opengis.swe.x20.CountRangePropertyType;
import net.opengis.swe.x20.CountRangeType;
import net.opengis.swe.x20.CountType;
import net.opengis.swe.x20.DataArrayDocument;
import net.opengis.swe.x20.DataArrayPropertyType;
import net.opengis.swe.x20.DataArrayType;
import net.opengis.swe.x20.DataChoiceDocument;
import net.opengis.swe.x20.DataChoicePropertyType;
import net.opengis.swe.x20.DataChoiceType;
import net.opengis.swe.x20.DataRecordDocument;
import net.opengis.swe.x20.DataRecordPropertyType;
import net.opengis.swe.x20.DataRecordType;
import net.opengis.swe.x20.MatrixDocument;
import net.opengis.swe.x20.MatrixPropertyType;
import net.opengis.swe.x20.MatrixType;
import net.opengis.swe.x20.QualityPropertyType;
import net.opengis.swe.x20.QuantityDocument;
import net.opengis.swe.x20.QuantityPropertyType;
import net.opengis.swe.x20.QuantityRangeDocument;
import net.opengis.swe.x20.QuantityRangePropertyType;
import net.opengis.swe.x20.QuantityRangeType;
import net.opengis.swe.x20.QuantityType;
import net.opengis.swe.x20.TextDocument;
import net.opengis.swe.x20.TextEncodingDocument;
import net.opengis.swe.x20.TextEncodingType;
import net.opengis.swe.x20.TextPropertyType;
import net.opengis.swe.x20.TextType;
import net.opengis.swe.x20.TimeDocument;
import net.opengis.swe.x20.TimePropertyType;
import net.opengis.swe.x20.TimeRangeDocument;
import net.opengis.swe.x20.TimeRangePropertyType;
import net.opengis.swe.x20.TimeRangeType;
import net.opengis.swe.x20.TimeType;
import net.opengis.swe.x20.UnitReference;
import net.opengis.swe.x20.VectorDocument;
import net.opengis.swe.x20.VectorPropertyType;
import net.opengis.swe.x20.VectorType;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.joda.time.DateTime;
import org.n52.janmayen.NcName;
import org.n52.shetland.ogc.UoM;
import org.n52.shetland.ogc.sensorML.elements.SmlPosition;
import org.n52.shetland.ogc.sensorML.v20.SmlDataInterface;
import org.n52.shetland.ogc.sensorML.v20.SmlFeatureOfInterest;
import org.n52.shetland.ogc.swe.RangeValue;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweConstants;
import org.n52.shetland.ogc.swe.SweCoordinate;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataComponentVisitor;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweEnvelope;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.SweSimpleDataRecord;
import org.n52.shetland.ogc.swe.SweVector;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.shetland.ogc.swe.encoding.SweTextEncoding;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTimes;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTokens;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedValues;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCategoryRange;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweCountRange;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.ogc.swe.simpleType.SweQuality;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweQuantityRange;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.ogc.swe.simpleType.SweTimeRange;
import org.n52.shetland.ogc.swe.stream.StreamingSweDataArray;
import org.n52.shetland.ogc.swes.SwesConstants;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.w3c.Nillable;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.ConformanceClass;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NotYetSupportedEncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3.x1999.xlink.ActuateType;
import org.w3.x1999.xlink.ShowType;
import org.w3.x1999.xlink.TypeType;

public class SweCommonEncoderv20
extends AbstractXmlEncoder<XmlObject, Object>
implements ConformanceClass {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweCommonEncoderv20.class);
    private static final String URN = "urn:";
    private static final String HTTP = "http://";
    private static final String DATA_RECORD_HAS_NO_FIELDS = "DataRecord contained no fields1";
    private static final String DATA_RECORD_FIELD_IS_NULL = "DataRcord field is null!";
    private static final String QUALITY_NOT_SUPPORTED = "Quality encoding is not supported for {}!";
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/swe/2.0", (Class[])new Class[]{SweCoordinate.class, SweAbstractEncoding.class, SweAbstractDataComponent.class});
    private static final Set<String> CONFORMANCE_CLASSES = new HashSet<String>(Arrays.asList("http://www.opengis.net/spec/SWE/2.0/conf/core", "http://www.opengis.net/spec/SWE/2.0/conf/uml-simple-components", "http://www.opengis.net/spec/SWE/2.0/conf/uml-record-components", "http://www.opengis.net/spec/SWE/2.0/conf/uml-block-components", "http://www.opengis.net/spec/SWE/2.0/conf/uml-simple-encodings", "http://www.opengis.net/spec/SWE/2.0/conf/xsd-simple-components", "http://www.opengis.net/spec/SWE/2.0/conf/xsd-record-components", "http://www.opengis.net/spec/SWE/2.0/conf/xsd-block-components", "http://www.opengis.net/spec/SWE/2.0/conf/xsd-simple-encodings", "http://www.opengis.net/spec/SWE/2.0/conf/general-encoding-rules", "http://www.opengis.net/spec/SWE/2.0/conf/text-encoding-rules"));
    private static final String DEFAULT_ELEMENT_TYPE_NAME = "Components";

    public SweCommonEncoderv20() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)ENCODER_KEYS.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/swe/2.0", "swe");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Collections.singleton(SwesConstants.SWES_20_SCHEMA_LOCATION);
    }

    public XmlObject encode(Object sosSweType, EncodingContext additionalValues) throws EncodingException {
        return XmlHelper.validateDocument((XmlObject)this.encode1(sosSweType, additionalValues), EncodingException::new);
    }

    private XmlObject encode1(Object sosSweType, EncodingContext additionalValues) throws EncodingException {
        if (sosSweType instanceof SweCoordinate) {
            return this.createCoordinate((SweCoordinate)sosSweType);
        }
        if (sosSweType instanceof SweAbstractEncoding) {
            AbstractEncodingType encoding = this.createAbstractEncoding((SweAbstractEncoding)sosSweType);
            if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                if (encoding instanceof TextEncodingType) {
                    TextEncodingDocument doc = TextEncodingDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                    doc.setTextEncoding((TextEncodingType)encoding);
                    return doc;
                }
                AbstractEncodingDocument doc = AbstractEncodingDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
                doc.setAbstractEncoding(encoding);
                return doc;
            }
            return encoding;
        }
        if (sosSweType instanceof SweAbstractDataComponent) {
            return this.createAbstractDataComponent((SweAbstractDataComponent)sosSweType, additionalValues);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, sosSweType);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    private XmlObject createAbstractDataComponent(SweAbstractDataComponent component, EncodingContext additionalValues) throws EncodingException {
        if (component == null) {
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)component);
        }
        AbstractDataComponentType xmlComponent = (AbstractDataComponentType)component.accept((SweDataComponentVisitor)new SweDataComponentVisitorImpl());
        if (component.isSetDefinition()) {
            xmlComponent.setDefinition(component.getDefinition());
        }
        if (component.isSetDescription()) {
            xmlComponent.setDescription(component.getDescription());
        }
        if (component.isSetIdentifier()) {
            xmlComponent.setIdentifier(component.getIdentifier());
        }
        if (component.isSetLabel()) {
            xmlComponent.setLabel(component.getLabel());
        }
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.PROPERTY_TYPE) || additionalValues.has((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION)) {
            return this.asPropertyType(xmlComponent);
        }
        if (additionalValues.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
            return this.asDocument(xmlComponent);
        }
        return xmlComponent;
    }

    private XmlObject asPropertyType(AbstractDataComponentType type) throws NotYetSupportedEncodingException {
        if (type instanceof BooleanType) {
            BooleanPropertyType propertyType = BooleanPropertyType.Factory.newInstance();
            propertyType.setBoolean((BooleanType)type);
            return propertyType;
        }
        if (type instanceof CountType) {
            CountPropertyType propertyType = CountPropertyType.Factory.newInstance();
            propertyType.setCount((CountType)type);
            return propertyType;
        }
        if (type instanceof CountRangeType) {
            CountRangePropertyType propertyType = CountRangePropertyType.Factory.newInstance();
            propertyType.setCountRange((CountRangeType)type);
            return propertyType;
        }
        if (type instanceof QuantityType) {
            QuantityPropertyType propertyType = QuantityPropertyType.Factory.newInstance();
            propertyType.setQuantity((QuantityType)type);
            return propertyType;
        }
        if (type instanceof QuantityRangeType) {
            QuantityRangePropertyType propertyType = QuantityRangePropertyType.Factory.newInstance();
            propertyType.setQuantityRange((QuantityRangeType)type);
            return propertyType;
        }
        if (type instanceof TimeType) {
            TimePropertyType propertyType = TimePropertyType.Factory.newInstance();
            propertyType.setTime((TimeType)type);
            return propertyType;
        }
        if (type instanceof TimeRangeType) {
            TimeRangePropertyType propertyType = TimeRangePropertyType.Factory.newInstance();
            propertyType.setTimeRange((TimeRangeType)type);
            return propertyType;
        }
        if (type instanceof CategoryType) {
            CategoryPropertyType propertyType = CategoryPropertyType.Factory.newInstance();
            propertyType.setCategory((CategoryType)type);
            return propertyType;
        }
        if (type instanceof CategoryRangeType) {
            CategoryRangePropertyType propertyType = CategoryRangePropertyType.Factory.newInstance();
            propertyType.setCategoryRange((CategoryRangeType)type);
            return propertyType;
        }
        if (type instanceof MatrixType) {
            MatrixPropertyType propertyType = MatrixPropertyType.Factory.newInstance();
            propertyType.setMatrix((MatrixType)type);
            return propertyType;
        }
        if (type instanceof DataArrayType) {
            DataArrayPropertyType propertyType = DataArrayPropertyType.Factory.newInstance();
            propertyType.setDataArray1((DataArrayType)type);
            return propertyType;
        }
        if (type instanceof DataChoiceType) {
            DataChoicePropertyType propertyType = DataChoicePropertyType.Factory.newInstance();
            propertyType.setDataChoice((DataChoiceType)type);
            return propertyType;
        }
        if (type instanceof DataRecordType) {
            DataRecordPropertyType propertyType = DataRecordPropertyType.Factory.newInstance();
            propertyType.setDataRecord((DataRecordType)type);
            return propertyType;
        }
        if (type instanceof TextType) {
            TextPropertyType propertyType = TextPropertyType.Factory.newInstance();
            propertyType.setText((TextType)type);
            return propertyType;
        }
        if (type instanceof VectorType) {
            VectorPropertyType propertyType = VectorPropertyType.Factory.newInstance();
            propertyType.setVector((VectorType)type);
            return propertyType;
        }
        throw new NotYetSupportedEncodingException(type.getClass().getName(), (Object)type);
    }

    private XmlObject asDocument(AbstractDataComponentType type) throws NotYetSupportedEncodingException {
        if (type instanceof BooleanType) {
            BooleanDocument document = BooleanDocument.Factory.newInstance();
            document.setBoolean((BooleanType)type);
            return document;
        }
        if (type instanceof CountType) {
            CountDocument document = CountDocument.Factory.newInstance();
            document.setCount((CountType)type);
            return document;
        }
        if (type instanceof CountRangeType) {
            CountRangeDocument document = CountRangeDocument.Factory.newInstance();
            document.setCountRange((CountRangeType)type);
            return document;
        }
        if (type instanceof QuantityType) {
            QuantityDocument document = QuantityDocument.Factory.newInstance();
            document.setQuantity((QuantityType)type);
            return document;
        }
        if (type instanceof QuantityRangeType) {
            QuantityRangeDocument document = QuantityRangeDocument.Factory.newInstance();
            document.setQuantityRange((QuantityRangeType)type);
            return document;
        }
        if (type instanceof TimeType) {
            TimeDocument document = TimeDocument.Factory.newInstance();
            document.setTime((TimeType)type);
            return document;
        }
        if (type instanceof TimeRangeType) {
            TimeRangeDocument document = TimeRangeDocument.Factory.newInstance();
            document.setTimeRange((TimeRangeType)type);
            return document;
        }
        if (type instanceof CategoryType) {
            CategoryDocument document = CategoryDocument.Factory.newInstance();
            document.setCategory((CategoryType)type);
            return document;
        }
        if (type instanceof CategoryRangeType) {
            CategoryRangeDocument document = CategoryRangeDocument.Factory.newInstance();
            document.setCategoryRange((CategoryRangeType)type);
            return document;
        }
        if (type instanceof MatrixType) {
            MatrixDocument document = MatrixDocument.Factory.newInstance();
            document.setMatrix((MatrixType)type);
            return document;
        }
        if (type instanceof DataArrayType) {
            DataArrayDocument document = DataArrayDocument.Factory.newInstance();
            document.setDataArray1((DataArrayType)type);
            return document;
        }
        if (type instanceof DataChoiceType) {
            DataChoiceDocument document = DataChoiceDocument.Factory.newInstance();
            document.setDataChoice((DataChoiceType)type);
            return document;
        }
        if (type instanceof DataRecordType) {
            DataRecordDocument document = DataRecordDocument.Factory.newInstance();
            document.setDataRecord((DataRecordType)type);
            return document;
        }
        if (type instanceof TextType) {
            TextDocument document = TextDocument.Factory.newInstance();
            document.setText((TextType)type);
            return document;
        }
        if (type instanceof VectorType) {
            VectorDocument document = VectorDocument.Factory.newInstance();
            document.setVector((VectorType)type);
            return document;
        }
        throw new NotYetSupportedEncodingException(type.getClass().getName(), (Object)type);
    }

    private XmlString createValues(List<List<String>> values, SweAbstractEncoding encoding) {
        SweTextEncoding textEncoding = (SweTextEncoding)encoding;
        String valueString = values.stream().map(block -> String.join((CharSequence)textEncoding.getTokenSeparator(), block)).collect(Collectors.joining(textEncoding.getBlockSeparator()));
        XmlString xmlString = XmlString.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xmlString.setStringValue(valueString);
        return xmlString;
    }

    private DataRecordType.Field createField(SweField field) throws EncodingException {
        SweAbstractDataComponent element = field.getElement();
        DataRecordType.Field xmlField = DataRecordType.Field.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (field.isSetName()) {
            xmlField.setName(NcName.makeValid((String)field.getName().getValue()));
        }
        XmlObject encodeObjectToXml = this.createAbstractDataComponent(element, EncodingContext.empty());
        XmlObject substituteElement = XmlHelper.substituteElement((XmlObject)xmlField.addNewAbstractDataComponent(), (XmlObject)encodeObjectToXml);
        substituteElement.set(encodeObjectToXml);
        return xmlField;
    }

    private VectorType.Coordinate createCoordinate(SweCoordinate<?> coordinate) throws EncodingException {
        VectorType.Coordinate xbCoordinate = VectorType.Coordinate.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xbCoordinate.setName(coordinate.getName());
        xbCoordinate.setQuantity((QuantityType)this.createAbstractDataComponent((SweAbstractDataComponent)((SweQuantity)coordinate.getValue()), EncodingContext.empty()));
        return xbCoordinate;
    }

    private AbstractEncodingType createAbstractEncoding(SweAbstractEncoding encoding) throws EncodingException {
        if (encoding instanceof SweTextEncoding) {
            return this.createTextEncoding((SweTextEncoding)encoding);
        }
        try {
            XmlObject xmlObject;
            String xml = encoding.getXml();
            if (xml != null && !xml.isEmpty() && (xmlObject = XmlObject.Factory.parse((String)xml, (XmlOptions)this.getXmlOptions())) instanceof AbstractEncodingType) {
                return (AbstractEncodingType)xmlObject;
            }
            throw new EncodingException("AbstractEncoding can not be encoded!", new Object[0]);
        }
        catch (XmlException e) {
            throw new EncodingException("Error while encoding AbstractEncoding!", (Throwable)e);
        }
    }

    private TextEncodingType createTextEncoding(SweTextEncoding encoding) {
        TextEncodingType xml = TextEncodingType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (encoding.getBlockSeparator() != null) {
            xml.setBlockSeparator(encoding.getBlockSeparator());
        }
        if (encoding.isSetCollapseWhiteSpaces()) {
            xml.setCollapseWhiteSpaces(encoding.isCollapseWhiteSpaces());
        }
        if (encoding.getDecimalSeparator() != null) {
            xml.setDecimalSeparator(encoding.getDecimalSeparator());
        }
        if (encoding.getTokenSeparator() != null) {
            xml.setTokenSeparator(encoding.getTokenSeparator());
        }
        return xml;
    }

    private UnitReference createUnitReference(UoM uom) {
        UnitReference unitReference = UnitReference.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (!uom.isSetLink() && (uom.getUom().startsWith(URN) || uom.getUom().startsWith(HTTP))) {
            unitReference.setHref(uom.getUom());
        } else {
            unitReference.setCode(uom.getUom());
        }
        if (uom.isSetName()) {
            unitReference.setTitle(uom.getName());
        }
        if (uom.isSetLink()) {
            unitReference.setHref(uom.getLink());
        }
        return unitReference;
    }

    private UnitReference createUnitReference(String uom) {
        UnitReference unitReference = UnitReference.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (uom.startsWith(URN) || uom.startsWith(HTTP)) {
            unitReference.setHref(uom);
        } else {
            unitReference.setCode(uom);
        }
        return unitReference;
    }

    private AllowedValuesPropertyType createConstraint(AllowedValuesPropertyType avpt, Referenceable<SweAllowedValues> constraint) {
        if (constraint.isInstance()) {
            this.createAllowedValues(avpt.addNewAllowedValues(), (Nillable<SweAllowedValues>)constraint.getInstance());
        } else if (constraint.isReference()) {
            Reference ref = constraint.getReference();
            if (ref.getHref().isPresent()) {
                avpt.setHref(((URI)ref.getHref().get()).toString());
            }
            if (ref.getTitle().isPresent()) {
                avpt.setTitle((String)ref.getTitle().get());
            }
            if (ref.getActuate().isPresent()) {
                avpt.setActuate(ActuateType.Enum.forString((String)((String)ref.getActuate().get())));
            }
            if (ref.getArcrole().isPresent()) {
                avpt.setArcrole((String)ref.getArcrole().get());
            }
            if (ref.getRole().isPresent()) {
                avpt.setRole((String)ref.getRole().get());
            }
            if (ref.getShow().isPresent()) {
                avpt.setShow(ShowType.Enum.forString((String)((String)ref.getShow().get())));
            }
            if (ref.getType().isPresent()) {
                avpt.setType(TypeType.Enum.forString((String)((String)ref.getType().get())));
            }
        }
        return avpt;
    }

    private AllowedTimesPropertyType createConstraint(AllowedTimesPropertyType atpt, Referenceable<SweAllowedTimes> constraint) {
        if (constraint.isInstance()) {
            this.createAllowedTimes(atpt.addNewAllowedTimes(), (Nillable<SweAllowedTimes>)constraint.getInstance());
        } else if (constraint.isReference()) {
            Reference ref = constraint.getReference();
            if (ref.getHref().isPresent()) {
                atpt.setHref(((URI)ref.getHref().get()).toString());
            }
            if (ref.getTitle().isPresent()) {
                atpt.setTitle((String)ref.getTitle().get());
            }
            if (ref.getActuate().isPresent()) {
                atpt.setActuate(ActuateType.Enum.forString((String)((String)ref.getActuate().get())));
            }
            if (ref.getArcrole().isPresent()) {
                atpt.setArcrole((String)ref.getArcrole().get());
            }
            if (ref.getRole().isPresent()) {
                atpt.setRole((String)ref.getRole().get());
            }
            if (ref.getShow().isPresent()) {
                atpt.setShow(ShowType.Enum.forString((String)((String)ref.getShow().get())));
            }
            if (ref.getType().isPresent()) {
                atpt.setType(TypeType.Enum.forString((String)((String)ref.getType().get())));
            }
        }
        return atpt;
    }

    private AllowedTokensPropertyType createConstraint(AllowedTokensPropertyType atpt, Referenceable<SweAllowedTokens> constraint) {
        if (constraint.isInstance()) {
            this.createAllowedTokens(atpt.addNewAllowedTokens(), (Nillable<SweAllowedTokens>)constraint.getInstance());
        } else if (constraint.isReference()) {
            Reference ref = constraint.getReference();
            if (ref.getHref().isPresent()) {
                atpt.setHref(((URI)ref.getHref().get()).toString());
            }
            if (ref.getTitle().isPresent()) {
                atpt.setTitle((String)ref.getTitle().get());
            }
            if (ref.getActuate().isPresent()) {
                atpt.setActuate(ActuateType.Enum.forString((String)((String)ref.getActuate().get())));
            }
            if (ref.getArcrole().isPresent()) {
                atpt.setArcrole((String)ref.getArcrole().get());
            }
            if (ref.getRole().isPresent()) {
                atpt.setRole((String)ref.getRole().get());
            }
            if (ref.getShow().isPresent()) {
                atpt.setShow(ShowType.Enum.forString((String)((String)ref.getShow().get())));
            }
            if (ref.getType().isPresent()) {
                atpt.setType(TypeType.Enum.forString((String)((String)ref.getType().get())));
            }
        }
        return atpt;
    }

    private AllowedValuesType createAllowedValues(AllowedValuesType avt, Nillable<SweAllowedValues> instance) {
        if (instance.isPresent()) {
            if (((SweAllowedValues)instance.get()).isSetGmlID()) {
                avt.setId(((SweAllowedValues)instance.get()).getGmlId());
            }
            if (((SweAllowedValues)instance.get()).isSetValue()) {
                for (Double value : ((SweAllowedValues)instance.get()).getValue()) {
                    avt.addNewValue().setDoubleValue(value.doubleValue());
                }
            }
            if (((SweAllowedValues)instance.get()).isSetInterval()) {
                for (RangeValue interval : ((SweAllowedValues)instance.get()).getInterval()) {
                    avt.addInterval(interval.getRangeAsList());
                }
            }
            if (((SweAllowedValues)instance.get()).isSetSignificantFigures()) {
                avt.setSignificantFigures(((SweAllowedValues)instance.get()).getSignificantFigures());
            }
        }
        return avt;
    }

    private AllowedTokensType createAllowedTokens(AllowedTokensType att, Nillable<SweAllowedTokens> instance) {
        if (instance.isPresent()) {
            if (((SweAllowedTokens)instance.get()).isSetGmlID()) {
                att.setId(((SweAllowedTokens)instance.get()).getGmlId());
            }
            if (((SweAllowedTokens)instance.get()).isSetValue()) {
                for (String value : ((SweAllowedTokens)instance.get()).getValue()) {
                    att.addNewValue().setStringValue(value);
                }
            }
            if (((SweAllowedTokens)instance.get()).isSetPattern()) {
                att.setPattern(((SweAllowedTokens)instance.get()).getPattern());
            }
        }
        return att;
    }

    private AllowedTimesType createAllowedTimes(AllowedTimesType att, Nillable<SweAllowedTimes> instance) {
        if (instance.isPresent()) {
            if (((SweAllowedTimes)instance.get()).isSetGmlID()) {
                att.setId(((SweAllowedTimes)instance.get()).getGmlId());
            }
            if (((SweAllowedTimes)instance.get()).isSetValue()) {
                for (DateTime value : ((SweAllowedTimes)instance.get()).getValue()) {
                    att.addNewValue().setStringValue(DateTimeHelper.formatDateTime2IsoString((DateTime)value));
                }
            }
            if (((SweAllowedTimes)instance.get()).isSetInterval()) {
                for (RangeValue interval : ((SweAllowedTimes)instance.get()).getInterval()) {
                    ArrayList list = Lists.newArrayListWithCapacity((int)2);
                    list.add(DateTimeHelper.formatDateTime2IsoString((DateTime)((DateTime)interval.getRangeStart())));
                    if (interval.isSetEndValue()) {
                        list.add(DateTimeHelper.formatDateTime2IsoString((DateTime)((DateTime)interval.getRangeEnd())));
                    }
                    att.addInterval((List)list);
                }
            }
            if (((SweAllowedTimes)instance.get()).isSetSignificantFigures()) {
                att.setSignificantFigures(((SweAllowedTimes)instance.get()).getSignificantFigures());
            }
        }
        return att;
    }

    private QualityPropertyType[] createQuality(Collection<SweQuality> quality) throws EncodingException {
        if (!quality.isEmpty()) {
            ArrayList xbQualities = Lists.newArrayListWithCapacity((int)quality.size());
            for (SweQuality sweQuality : quality) {
                QualityPropertyType xbQuality = QualityPropertyType.Factory.newInstance();
                if (sweQuality instanceof SweText) {
                    xbQuality.addNewText().set((XmlObject)((SweText)sweQuality).accept((SweDataComponentVisitor)new SweDataComponentVisitorImpl()));
                } else if (sweQuality instanceof SweCategory) {
                    xbQuality.addNewCategory().set((XmlObject)((SweCategory)sweQuality).accept((SweDataComponentVisitor)new SweDataComponentVisitorImpl()));
                } else if (sweQuality instanceof SweQuantity) {
                    xbQuality.addNewQuantity().set((XmlObject)((SweQuantity)sweQuality).accept((SweDataComponentVisitor)new SweDataComponentVisitorImpl()));
                } else if (sweQuality instanceof SweQuantityRange) {
                    xbQuality.addNewQuantityRange().set((XmlObject)((SweQuantityRange)sweQuality).accept((SweDataComponentVisitor)new SweDataComponentVisitorImpl()));
                }
                xbQualities.add(xbQuality);
            }
            return xbQualities.toArray(new QualityPropertyType[xbQualities.size()]);
        }
        QualityPropertyType[] result = new QualityPropertyType[]{QualityPropertyType.Factory.newInstance()};
        return result;
    }

    private UnitReference createUnknownUnitReference() {
        UnitReference unitReference = UnitReference.Factory.newInstance((XmlOptions)this.getXmlOptions());
        unitReference.setHref("http://www.opengis.net/def/nil/OGC/0/unknown");
        return unitReference;
    }

    public class SweDataComponentVisitorImpl
    implements SweDataComponentVisitor<AbstractDataComponentType, EncodingException> {
        public AbstractDataComponentType visit(SweField component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        public AbstractDataComponentType visit(SweDataRecord component) throws EncodingException {
            List sosFields = component.getFields();
            DataRecordType xbDataRecord = DataRecordType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (sosFields == null) {
                LOGGER.error(SweCommonEncoderv20.DATA_RECORD_HAS_NO_FIELDS);
            } else {
                ArrayList<DataRecordType.Field> xbFields = new ArrayList<DataRecordType.Field>(sosFields.size());
                for (SweField sosSweField : sosFields) {
                    if (sosSweField == null) {
                        LOGGER.error(SweCommonEncoderv20.DATA_RECORD_FIELD_IS_NULL);
                        continue;
                    }
                    xbFields.add(SweCommonEncoderv20.this.createField(sosSweField));
                }
                xbDataRecord.setFieldArray(xbFields.toArray(new DataRecordType.Field[xbFields.size()]));
            }
            return xbDataRecord;
        }

        public AbstractDataComponentType visit(SweDataArray component) throws EncodingException {
            if (component == null) {
                return null;
            }
            if (component.isSetXml()) {
                try {
                    XmlObject parse = XmlObject.Factory.parse((String)component.getXml());
                    if (parse instanceof DataArrayType) {
                        return (DataArrayType)parse;
                    }
                    if (parse instanceof DataArrayDocument) {
                        return ((DataArrayDocument)parse).getDataArray1();
                    }
                }
                catch (XmlException e) {
                    LOGGER.warn("Error while parsing XML representation of DataArray^", (Throwable)e);
                }
            }
            DataArrayType xmlDataArray = DataArrayType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetElementCount()) {
                CountType xbCount = CountType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
                if (component.getElementCount().isSetValue()) {
                    xbCount.setValue(new BigInteger(Integer.toString(component.getElementCount().getValue())));
                }
                xmlDataArray.addNewElementCount().setCount(xbCount);
            } else {
                xmlDataArray.addNewElementCount().addNewCount();
            }
            if (component.isSetElementTyp()) {
                DataArrayType.ElementType elementType = xmlDataArray.addNewElementType();
                if (component.getElementType().isSetDefinition()) {
                    elementType.setName(component.getElementType().getDefinition());
                } else {
                    elementType.setName(SweCommonEncoderv20.DEFAULT_ELEMENT_TYPE_NAME);
                }
                List sosFields = ((SweDataRecord)component.getElementType()).getFields();
                DataRecordType xbDataRecord = DataRecordType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
                if (sosFields == null) {
                    LOGGER.error(SweCommonEncoderv20.DATA_RECORD_HAS_NO_FIELDS);
                } else {
                    ArrayList<DataRecordType.Field> xbFields = new ArrayList<DataRecordType.Field>(sosFields.size());
                    for (SweField sosSweField : sosFields) {
                        if (sosSweField == null) {
                            LOGGER.error(SweCommonEncoderv20.DATA_RECORD_FIELD_IS_NULL);
                            continue;
                        }
                        xbFields.add(SweCommonEncoderv20.this.createField(sosSweField));
                    }
                    xbDataRecord.setFieldArray(xbFields.toArray(new DataRecordType.Field[xbFields.size()]));
                }
                elementType.addNewAbstractDataComponent().set((XmlObject)xbDataRecord);
                elementType.getAbstractDataComponent().substitute(SweConstants.QN_DATA_RECORD_SWE_200, DataRecordType.type);
            }
            if (component.isSetEncoding()) {
                DataArrayType.Encoding xbEncoding = xmlDataArray.addNewEncoding();
                xbEncoding.setAbstractEncoding(SweCommonEncoderv20.this.createAbstractEncoding(component.getEncoding()));
                xbEncoding.getAbstractEncoding().substitute(SweConstants.QN_TEXT_ENCODING_SWE_200, TextEncodingType.type);
            }
            if (component.isSetValues()) {
                xmlDataArray.addNewValues().set((XmlObject)SweCommonEncoderv20.this.createValues(component.getValues(), component.getEncoding()));
            }
            return xmlDataArray;
        }

        public AbstractDataComponentType visit(SweCount component) throws EncodingException {
            CountType xml = CountType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetValue()) {
                xml.setValue(new BigInteger(Integer.toString(component.getValue())));
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweCountRange component) throws EncodingException {
            CountRangeType xml = CountRangeType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetValue()) {
                xml.setValue(component.getValue().getRangeAsList());
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweBoolean component) throws EncodingException {
            BooleanType xbBoolean = BooleanType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetValue()) {
                xbBoolean.setValue(component.getValue().booleanValue());
            }
            return xbBoolean;
        }

        public AbstractDataComponentType visit(SweCategory component) throws EncodingException {
            CategoryType xml = CategoryType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.getCodeSpace() != null) {
                xml.addNewCodeSpace().setHref(component.getCodeSpace());
            }
            if (component.isSetValue()) {
                xml.setValue(component.getValue());
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedTokens>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweCategoryRange component) throws EncodingException {
            CategoryRangeType xml = CategoryRangeType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetUom()) {
                xml.addNewCodeSpace().setHref(component.getUom());
            }
            if (component.isSetValue()) {
                xml.setValue(component.getValue().getRangeAsList());
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedTokens>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweObservableProperty component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        public AbstractDataComponentType visit(SweQuantity component) throws EncodingException {
            QuantityType xml = QuantityType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetAxisID()) {
                xml.setAxisID(component.getAxisID());
            }
            if (component.isSetValue()) {
                xml.setValue(component.getValue().doubleValue());
            }
            if (component.isSetUom()) {
                xml.setUom(SweCommonEncoderv20.this.createUnitReference(component.getUomObject()));
            } else {
                xml.setUom(SweCommonEncoderv20.this.createUnknownUnitReference());
            }
            if (component.getQuality() != null) {
                LOGGER.warn(SweCommonEncoderv20.QUALITY_NOT_SUPPORTED, (Object)xml.schemaType());
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweQuantityRange component) throws EncodingException {
            QuantityRangeType xml = QuantityRangeType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetAxisID()) {
                xml.setAxisID(component.getAxisID());
            }
            if (component.isSetValue()) {
                xml.setValue(component.getValue().getRangeAsList());
            }
            if (component.isSetUom()) {
                xml.setUom(SweCommonEncoderv20.this.createUnitReference(component.getUom()));
            } else {
                xml.setUom(SweCommonEncoderv20.this.createUnknownUnitReference());
            }
            if (component.isSetQuality()) {
                LOGGER.warn(SweCommonEncoderv20.QUALITY_NOT_SUPPORTED, (Object)xml.schemaType());
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedValues>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweText component) throws EncodingException {
            TextType xml = TextType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetValue()) {
                xml.setValue(component.getValue());
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedTokens>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweTime component) throws EncodingException {
            TimeType xml = TimeType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetValue()) {
                xml.setValue((Object)component.getValue());
            }
            if (component.isSetUom()) {
                xml.setUom(SweCommonEncoderv20.this.createUnitReference(component.getUom()));
            }
            if (component.getQuality() != null) {
                LOGGER.warn(SweCommonEncoderv20.QUALITY_NOT_SUPPORTED, (Object)xml.schemaType());
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedTimes>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweTimeRange component) throws EncodingException {
            TimeRangeType xml = TimeRangeType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetUom()) {
                xml.addNewUom().setHref(component.getUom());
            }
            if (component.isSetValue()) {
                xml.setValue(component.getValue().getRangeAsStringList());
            }
            if (component.isSetQuality()) {
                xml.setQualityArray(SweCommonEncoderv20.this.createQuality(component.getQuality()));
            }
            if (component.isSetContstraint()) {
                SweCommonEncoderv20.this.createConstraint(xml.addNewConstraint(), (Referenceable<SweAllowedTimes>)component.getConstraint());
            }
            return xml;
        }

        public AbstractDataComponentType visit(SweEnvelope component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        public AbstractDataComponentType visit(SweVector component) throws EncodingException {
            VectorType xbVector = VectorType.Factory.newInstance((XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
            if (component.isSetReferenceFrame()) {
                xbVector.setReferenceFrame(component.getReferenceFrame());
            }
            if (component.isSetLocalFrame()) {
                xbVector.setLocalFrame(component.getLocalFrame());
            }
            if (component.isSetCoordinates()) {
                for (SweCoordinate coordinate : component.getCoordinates()) {
                    xbVector.addNewCoordinate().set((XmlObject)SweCommonEncoderv20.this.createCoordinate(coordinate));
                }
            }
            return xbVector;
        }

        public AbstractDataComponentType visit(SweSimpleDataRecord component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        public AbstractDataComponentType visit(SmlPosition component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        public AbstractDataComponentType visit(SmlDataInterface component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        public AbstractDataComponentType visit(SmlFeatureOfInterest component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        public AbstractDataComponentType visit(StreamingSweDataArray component) throws EncodingException {
            return this.unsupported((SweAbstractDataComponent)component);
        }

        @SuppressFBWarnings(value={"VA_FORMAT_STRING_USES_NEWLINE"})
        private AbstractDataComponentType unsupported(SweAbstractDataComponent component) throws EncodingException {
            String xml = component.getXml();
            if (!Strings.isNullOrEmpty((String)xml)) {
                try {
                    return (AbstractDataComponentType)XmlObject.Factory.parse((String)xml, (XmlOptions)SweCommonEncoderv20.this.getXmlOptions());
                }
                catch (XmlException ex) {
                    String message = String.format("Error while decoding %s:\n%s", SweAbstractDataComponent.class.getName(), xml);
                    throw new EncodingException((Throwable)ex, message);
                }
            }
            throw new NotYetSupportedEncodingException(SweAbstractDataComponent.class.getName(), (Object)component);
        }
    }
}

