/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.util;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class W3cHelper {
    private W3cHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String nodeToXmlString(Node node) throws IOException {
        try (StringWriter sw = new StringWriter();){
            Transformer t = TransformerFactory.newInstance().newTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.setOutputProperty("encoding", "UTF-8");
            t.transform(new DOMSource(node), new StreamResult(sw));
            String string = sw.toString();
            return string;
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    public static String getContentFromElement(Element element, String namespaceURI, String localName) {
        String elementContent = null;
        NodeList nodes = element.getElementsByTagNameNS(namespaceURI, localName);
        for (int i = 0; i < nodes.getLength(); ++i) {
            elementContent = nodes.item(i).getTextContent();
        }
        return elementContent;
    }
}

