/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.opengis.swe.x20.AbstractDataComponentDocument;
import net.opengis.swe.x20.AbstractDataComponentType;
import net.opengis.swe.x20.AbstractEncodingType;
import net.opengis.swe.x20.AllowedTimesPropertyType;
import net.opengis.swe.x20.AllowedTimesType;
import net.opengis.swe.x20.AllowedTokensPropertyType;
import net.opengis.swe.x20.AllowedTokensType;
import net.opengis.swe.x20.AllowedValuesPropertyType;
import net.opengis.swe.x20.AllowedValuesType;
import net.opengis.swe.x20.AnyScalarPropertyType;
import net.opengis.swe.x20.BooleanPropertyType;
import net.opengis.swe.x20.BooleanType;
import net.opengis.swe.x20.CategoryPropertyType;
import net.opengis.swe.x20.CategoryType;
import net.opengis.swe.x20.CountPropertyType;
import net.opengis.swe.x20.CountRangeType;
import net.opengis.swe.x20.CountType;
import net.opengis.swe.x20.DataArrayDocument;
import net.opengis.swe.x20.DataArrayPropertyType;
import net.opengis.swe.x20.DataArrayType;
import net.opengis.swe.x20.DataRecordDocument;
import net.opengis.swe.x20.DataRecordPropertyType;
import net.opengis.swe.x20.DataRecordType;
import net.opengis.swe.x20.EncodedValuesPropertyType;
import net.opengis.swe.x20.QualityPropertyType;
import net.opengis.swe.x20.QuantityPropertyType;
import net.opengis.swe.x20.QuantityRangeType;
import net.opengis.swe.x20.QuantityType;
import net.opengis.swe.x20.TextEncodingDocument;
import net.opengis.swe.x20.TextEncodingType;
import net.opengis.swe.x20.TextPropertyType;
import net.opengis.swe.x20.TextType;
import net.opengis.swe.x20.TimeRangeType;
import net.opengis.swe.x20.TimeType;
import net.opengis.swe.x20.UnitReference;
import net.opengis.swe.x20.VectorType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.UoM;
import org.n52.shetland.ogc.swe.RangeValue;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweCoordinate;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.SweVector;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.shetland.ogc.swe.encoding.SweTextEncoding;
import org.n52.shetland.ogc.swe.simpleType.SweAbstractSimpleType;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTimes;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTokens;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedValues;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweCountRange;
import org.n52.shetland.ogc.swe.simpleType.SweQuality;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweQuantityRange;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.ogc.swe.simpleType.SweTimeRange;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.DateTimeParseException;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NotYetSupportedDecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SweCommonDecoderV20
extends AbstractXmlDecoder<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweCommonDecoderV20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/swe/2.0", (Class[])new Class[]{AbstractDataComponentDocument.class, AbstractDataComponentType.class, AnyScalarPropertyType[].class, BooleanPropertyType.class, BooleanType.class, VectorType.Coordinate[].class, CategoryPropertyType.class, CategoryType.class, CountPropertyType.class, CountType.class, DataArrayDocument.class, DataArrayPropertyType.class, DataArrayType.class, DataRecordDocument.class, DataRecordPropertyType.class, DataRecordType.class, QuantityPropertyType.class, QuantityType.class, TextEncodingDocument.class, TextEncodingType.class, TextPropertyType.class, TextType.class});

    public SweCommonDecoderV20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(Object element) throws DecodingException {
        if (element instanceof DataArrayPropertyType) {
            DataArrayPropertyType dataArrayPropertyType = (DataArrayPropertyType)element;
            return this.parseAbstractDataComponent((AbstractDataComponentType)dataArrayPropertyType.getDataArray1());
        }
        if (element instanceof DataRecordPropertyType) {
            DataRecordPropertyType dataRecordPropertyType = (DataRecordPropertyType)element;
            return this.parseAbstractDataComponent((AbstractDataComponentType)dataRecordPropertyType.getDataRecord());
        }
        if (element instanceof AbstractDataComponentDocument) {
            return this.parseAbstractDataComponentDocument((AbstractDataComponentDocument)element);
        }
        if (element instanceof AbstractDataComponentType) {
            return this.parseAbstractDataComponent((AbstractDataComponentType)element);
        }
        if (element instanceof VectorType.Coordinate[]) {
            return this.parseCoordinates((VectorType.Coordinate[])element);
        }
        if (element instanceof AnyScalarPropertyType[]) {
            return this.parseAnyScalarPropertyTypeArray((AnyScalarPropertyType[])element);
        }
        if (element instanceof TextEncodingDocument) {
            TextEncodingDocument textEncodingDoc = (TextEncodingDocument)element;
            SweTextEncoding sosTextEncoding = this.parseTextEncoding(textEncodingDoc.getTextEncoding());
            sosTextEncoding.setXml(textEncodingDoc.xmlText(this.getXmlOptions()));
            return sosTextEncoding;
        }
        if (element instanceof TextEncodingType) {
            TextEncodingDocument textEncodingDoc = TextEncodingDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            TextEncodingType textEncoding = (TextEncodingType)element;
            textEncodingDoc.setTextEncoding(textEncoding);
            SweTextEncoding sosTextEncoding = this.parseTextEncoding(textEncoding);
            sosTextEncoding.setXml(textEncodingDoc.xmlText(this.getXmlOptions()));
            return sosTextEncoding;
        }
        if (element instanceof TextPropertyType) {
            return this.parseAbstractDataComponent((AbstractDataComponentType)((TextPropertyType)element).getText());
        }
        if (element instanceof CountPropertyType) {
            return this.parseAbstractDataComponent((AbstractDataComponentType)((CountPropertyType)element).getCount());
        }
        if (element instanceof BooleanPropertyType) {
            return this.parseAbstractDataComponent((AbstractDataComponentType)((BooleanPropertyType)element).getBoolean());
        }
        if (element instanceof CategoryPropertyType) {
            return this.parseAbstractDataComponent((AbstractDataComponentType)((CategoryPropertyType)element).getCategory());
        }
        if (element instanceof QuantityPropertyType) {
            return this.parseAbstractDataComponent((AbstractDataComponentType)((QuantityPropertyType)element).getQuantity());
        }
        if (element instanceof XmlObject) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)element);
        }
        throw new UnsupportedDecoderInputException((Decoder)this, element);
    }

    private SweAbstractDataComponent parseAbstractDataComponent(AbstractDataComponentType abstractDataComponent) throws DecodingException {
        SweBoolean sosAbstractDataComponent = null;
        if (abstractDataComponent instanceof BooleanType) {
            sosAbstractDataComponent = this.parseBoolean((BooleanType)abstractDataComponent);
        } else if (abstractDataComponent instanceof CategoryType) {
            sosAbstractDataComponent = this.parseCategory((CategoryType)abstractDataComponent);
        } else if (abstractDataComponent instanceof CountRangeType) {
            sosAbstractDataComponent = this.parseCountRange((CountRangeType)abstractDataComponent);
        } else if (abstractDataComponent instanceof CountType) {
            sosAbstractDataComponent = this.parseCount((CountType)abstractDataComponent);
        } else if (abstractDataComponent instanceof QuantityType) {
            sosAbstractDataComponent = this.parseQuantity((QuantityType)abstractDataComponent);
        } else if (abstractDataComponent instanceof QuantityRangeType) {
            sosAbstractDataComponent = this.parseQuantityRange((QuantityRangeType)abstractDataComponent);
        } else if (abstractDataComponent instanceof TextType) {
            sosAbstractDataComponent = this.parseText((TextType)abstractDataComponent);
        } else if (abstractDataComponent instanceof TimeType) {
            sosAbstractDataComponent = this.parseTime((TimeType)abstractDataComponent);
        } else if (abstractDataComponent instanceof TimeRangeType) {
            sosAbstractDataComponent = this.parseTimeRange((TimeRangeType)abstractDataComponent);
        } else if (abstractDataComponent instanceof VectorType) {
            sosAbstractDataComponent = this.parseVector((VectorType)abstractDataComponent);
        } else if (abstractDataComponent instanceof DataRecordType) {
            SweDataRecord sosDataRecord = this.parseDataRecord((DataRecordType)abstractDataComponent);
            DataRecordDocument dataRecordDoc = DataRecordDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            dataRecordDoc.setDataRecord((DataRecordType)abstractDataComponent);
            sosDataRecord.setXml(dataRecordDoc.xmlText(this.getXmlOptions()));
            sosAbstractDataComponent = sosDataRecord;
        } else if (abstractDataComponent instanceof DataArrayType) {
            SweDataArray sosDataArray = this.parseDataArray((DataArrayType)abstractDataComponent);
            DataArrayDocument dataArrayDoc = DataArrayDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
            dataArrayDoc.setDataArray1((DataArrayType)abstractDataComponent);
            sosDataArray.setXml(dataArrayDoc.xmlText(this.getXmlOptions()));
            sosAbstractDataComponent = sosDataArray;
        } else {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)abstractDataComponent);
        }
        if (sosAbstractDataComponent != null) {
            if (abstractDataComponent.isSetDefinition()) {
                sosAbstractDataComponent.setDefinition(abstractDataComponent.getDefinition());
            }
            if (abstractDataComponent.isSetDescription()) {
                sosAbstractDataComponent.setDescription(abstractDataComponent.getDescription());
            }
            if (abstractDataComponent.isSetIdentifier()) {
                sosAbstractDataComponent.setIdentifier(abstractDataComponent.getIdentifier());
            }
            if (abstractDataComponent.isSetLabel()) {
                sosAbstractDataComponent.setLabel(abstractDataComponent.getLabel());
            }
        }
        return sosAbstractDataComponent;
    }

    private Object parseAbstractDataComponentDocument(AbstractDataComponentDocument abstractDataComponentDoc) throws DecodingException {
        SweAbstractDataComponent sosAbstractDataComponent = this.parseAbstractDataComponent(abstractDataComponentDoc.getAbstractDataComponent());
        sosAbstractDataComponent.setXml(abstractDataComponentDoc.xmlText(this.getXmlOptions()));
        return sosAbstractDataComponent;
    }

    private SweDataArray parseDataArray(DataArrayType xbDataArray) throws DecodingException {
        DataArrayType.ElementType xbElementType;
        SweDataArray sosSweDataArray = new SweDataArray();
        CountPropertyType elementCount = xbDataArray.getElementCount();
        if (elementCount != null) {
            sosSweDataArray.setElementCount(this.parseElementCount(elementCount));
        }
        if ((xbElementType = xbDataArray.getElementType()) != null && xbElementType.getAbstractDataComponent() != null) {
            sosSweDataArray.setElementType(this.parseAbstractDataComponent(xbElementType.getAbstractDataComponent()));
        }
        if (xbDataArray.isSetEncoding()) {
            sosSweDataArray.setEncoding(this.parseEncoding(xbDataArray.getEncoding().getAbstractEncoding()));
        }
        if (xbDataArray.isSetValues()) {
            sosSweDataArray.setValues(this.parseValues(sosSweDataArray.getElementCount(), sosSweDataArray.getElementType(), sosSweDataArray.getEncoding(), xbDataArray.getValues()));
        }
        DataArrayDocument dataArrayDoc = DataArrayDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        dataArrayDoc.setDataArray1(xbDataArray);
        sosSweDataArray.setXml(dataArrayDoc.xmlText(this.getXmlOptions()));
        return sosSweDataArray;
    }

    private List<List<String>> parseValues(SweCount elementCount, SweAbstractDataComponent elementType, SweAbstractEncoding encoding, EncodedValuesPropertyType encodedValuesPropertyType) throws DecodingException {
        if (this.checkParameterTypes(elementType, encoding)) {
            XmlCursor xbCursor = encodedValuesPropertyType.newCursor();
            xbCursor.toFirstContentToken();
            if (xbCursor.isText()) {
                String values = xbCursor.getTextValue().trim();
                xbCursor.dispose();
                if (values != null && !values.isEmpty()) {
                    SweTextEncoding textEncoding = (SweTextEncoding)encoding;
                    String[] blocks = values.split(textEncoding.getBlockSeparator());
                    ArrayList<List<String>> resultValues = new ArrayList<List<String>>(blocks.length);
                    for (String block : blocks) {
                        String[] tokens = block.split(textEncoding.getTokenSeparator());
                        List<String> tokenList = Arrays.asList(tokens);
                        resultValues.add(tokenList);
                    }
                    return resultValues;
                }
            }
        }
        assert (false);
        return null;
    }

    private boolean checkParameterTypes(SweAbstractDataComponent elementType, SweAbstractEncoding encoding) throws DecodingException {
        if (!(encoding instanceof SweTextEncoding)) {
            throw new NotYetSupportedDecodingException("encodingType", (Object)encoding);
        }
        if (!(elementType instanceof SweDataRecord)) {
            throw new NotYetSupportedDecodingException("encodingType", (Object)elementType);
        }
        return true;
    }

    private SweAbstractEncoding parseEncoding(AbstractEncodingType abstractEncodingType) throws DecodingException {
        if (abstractEncodingType instanceof TextEncodingType) {
            return this.parseTextEncoding((TextEncodingType)abstractEncodingType);
        }
        throw new NotYetSupportedDecodingException("encodingType", (Object)abstractEncodingType, new Object[]{TextEncodingType.type.getName()});
    }

    private SweDataRecord parseDataRecord(DataRecordType dataRecord) throws DecodingException {
        SweDataRecord sosSweDataRecord = new SweDataRecord();
        for (DataRecordType.Field field : dataRecord.getFieldArray()) {
            sosSweDataRecord.addField(new SweField(field.getName(), this.parseAbstractDataComponent(field.getAbstractDataComponent())));
        }
        return sosSweDataRecord;
    }

    private SweBoolean parseBoolean(BooleanType xbBoolean) throws DecodingException {
        SweBoolean sosBoolean = new SweBoolean();
        if (xbBoolean.isSetValue()) {
            sosBoolean.setValue(Boolean.valueOf(xbBoolean.getValue()));
        }
        if (xbBoolean.getQualityArray() != null) {
            sosBoolean.setQuality(this.parseQuality(xbBoolean.getQualityArray()));
        }
        return sosBoolean;
    }

    private SweCategory parseCategory(CategoryType xbCategory) throws DecodingException {
        SweCategory sosSweCategory = new SweCategory();
        if (xbCategory.isSetCodeSpace() && xbCategory.getCodeSpace().isSetHref()) {
            sosSweCategory.setCodeSpace(xbCategory.getCodeSpace().getHref());
        }
        if (xbCategory.isSetValue()) {
            sosSweCategory.setValue(xbCategory.getValue());
        }
        if (xbCategory.isSetConstraint()) {
            sosSweCategory.setConstraint(this.parseConstraint(xbCategory.getConstraint()));
        }
        if (xbCategory.getQualityArray() != null) {
            sosSweCategory.setQuality(this.parseQuality(xbCategory.getQualityArray()));
        }
        return sosSweCategory;
    }

    private SweCount parseCount(CountType count) throws DecodingException {
        SweCount sosCount = new SweCount();
        if (count.getQualityArray() != null) {
            sosCount.setQuality(this.parseQuality(count.getQualityArray()));
        }
        if (count.isSetValue()) {
            sosCount.setValue(Integer.valueOf(count.getValue().intValue()));
        }
        if (count.isSetConstraint()) {
            sosCount.setConstraint(this.parseConstraint(count.getConstraint()));
        }
        return sosCount;
    }

    private SweCountRange parseCountRange(CountRangeType countRange) throws DecodingException {
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)countRange);
    }

    private SweQuantity parseQuantity(QuantityType xbQuantity) throws DecodingException {
        SweQuantity sosQuantity = new SweQuantity();
        if (xbQuantity.isSetAxisID()) {
            sosQuantity.setAxisID(xbQuantity.getAxisID());
        }
        if (xbQuantity.getQualityArray() != null) {
            sosQuantity.setQuality(this.parseQuality(xbQuantity.getQualityArray()));
        }
        if (xbQuantity.getUom() != null) {
            sosQuantity.setUom(this.parseUnitOfReference(xbQuantity.getUom()));
        }
        if (xbQuantity.isSetValue()) {
            sosQuantity.setValue(Double.valueOf(xbQuantity.getValue()));
        }
        if (xbQuantity.isSetConstraint()) {
            sosQuantity.setConstraint(this.parseConstraint(xbQuantity.getConstraint()));
        }
        return sosQuantity;
    }

    private SweQuantityRange parseQuantityRange(QuantityRangeType quantityRange) throws DecodingException {
        SweQuantityRange sweQuantityRange = new SweQuantityRange();
        if (quantityRange.isSetDefinition()) {
            sweQuantityRange.setDefinition(quantityRange.getDefinition());
        }
        if (quantityRange.isSetLabel()) {
            sweQuantityRange.setLabel(quantityRange.getLabel());
        }
        if (!quantityRange.getUom().isNil() && quantityRange.getUom().isSetCode()) {
            sweQuantityRange.setUom(this.parseUnitOfReference(quantityRange.getUom()));
        }
        if (quantityRange.getValue() != null) {
            sweQuantityRange.setValue(this.parseRangeValue(quantityRange.getValue()));
        }
        if (quantityRange.isSetConstraint()) {
            sweQuantityRange.setConstraint(this.parseConstraint(quantityRange.getConstraint()));
        }
        if (quantityRange.getQualityArray() != null) {
            sweQuantityRange.setQuality(this.parseQuality(quantityRange.getQualityArray()));
        }
        return sweQuantityRange;
    }

    private UoM parseUnitOfReference(UnitReference ur) {
        UoM uom = null;
        uom = ur.isSetCode() ? new UoM(ur.getCode()) : (ur.isSetHref() ? new UoM(ur.getHref()) : new UoM("http://www.opengis.net/def/nil/OGC/0/unknown"));
        if (ur.isSetHref()) {
            uom.setLink(ur.getHref());
        }
        if (ur.isSetTitle()) {
            uom.setName(ur.getTitle());
        }
        return uom;
    }

    private RangeValue<Double> parseRangeValue(List<?> value) throws DecodingException {
        if (value == null || value.isEmpty() || value.size() != 2) {
            throw new DecodingException("?:QuantityRange/?:value", "The 'swe:value' element of an 'swe:QuantityRange' is not set correctly", new Object[0]);
        }
        return new RangeValue((Object)Double.parseDouble(value.get(0).toString()), (Object)Double.parseDouble(value.get(1).toString()));
    }

    private SweText parseText(TextType xbText) {
        SweText sosText = new SweText();
        if (xbText.isSetValue()) {
            sosText.setValue(xbText.getValue());
        }
        if (xbText.isSetConstraint()) {
            sosText.setConstraint(this.parseConstraint(xbText.getConstraint()));
        }
        return sosText;
    }

    private SweTime parseTime(TimeType xbTime) throws DecodingException {
        SweTime sosTime = new SweTime();
        if (xbTime.isSetValue()) {
            sosTime.setValue(DateTimeHelper.parseIsoString2DateTime((String)xbTime.getValue().toString()));
        }
        if (xbTime.getUom() != null) {
            sosTime.setUom(this.parseUnitOfReference(xbTime.getUom()));
        }
        if (xbTime.isSetConstraint()) {
            sosTime.setConstraint(this.parseConstraint(xbTime.getConstraint()));
        }
        if (xbTime.getQualityArray() != null) {
            sosTime.setQuality(this.parseQuality(xbTime.getQualityArray()));
        }
        return sosTime;
    }

    private SweTimeRange parseTimeRange(TimeRangeType xbTime) throws DecodingException {
        List value;
        SweTimeRange sosTimeRange = new SweTimeRange();
        if (xbTime.isSetValue() && (value = xbTime.getValue()) != null && !value.isEmpty()) {
            RangeValue range = new RangeValue();
            Iterator iter = value.iterator();
            if (iter.hasNext()) {
                range.setRangeStart((Object)DateTimeHelper.parseIsoString2DateTime((String)iter.next().toString()));
            }
            if (iter.hasNext()) {
                range.setRangeEnd((Object)DateTimeHelper.parseIsoString2DateTime((String)iter.next().toString()));
            }
            sosTimeRange.setValue(range);
        }
        if (xbTime.getUom() != null) {
            sosTimeRange.setUom(xbTime.getUom().getHref());
        }
        if (xbTime.isSetConstraint()) {
            sosTimeRange.setConstraint(this.parseConstraint(xbTime.getConstraint()));
        }
        if (xbTime.getQualityArray() != null) {
            sosTimeRange.setQuality(this.parseQuality(xbTime.getQualityArray()));
        }
        return sosTimeRange;
    }

    private Referenceable<SweAllowedValues> parseConstraint(AllowedValuesPropertyType avpt) {
        if (avpt.isSetAllowedValues()) {
            return Referenceable.of((Object)this.parseAllowedValues(avpt.getAllowedValues()));
        }
        Reference ref = new Reference();
        if (avpt.isSetHref()) {
            ref.setHref(URI.create(avpt.getHref()));
        }
        if (avpt.isSetTitle()) {
            ref.setTitle(avpt.getTitle());
        }
        if (avpt.isSetActuate()) {
            ref.setActuate(avpt.getActuate().toString());
        }
        if (avpt.isSetArcrole()) {
            ref.setArcrole(avpt.getArcrole());
        }
        if (avpt.isSetRole()) {
            ref.setRole(avpt.getRole());
        }
        if (avpt.isSetShow()) {
            ref.setShow(avpt.getShow().toString());
        }
        if (avpt.isSetType()) {
            ref.setType(avpt.getType().toString());
        }
        return Referenceable.of((Reference)ref);
    }

    private Referenceable<SweAllowedTokens> parseConstraint(AllowedTokensPropertyType atpt) {
        if (atpt.isSetAllowedTokens()) {
            return Referenceable.of((Object)this.parseAllowedTokens(atpt.getAllowedTokens()));
        }
        Reference ref = new Reference();
        if (atpt.isSetHref()) {
            ref.setHref(URI.create(atpt.getHref()));
        }
        if (atpt.isSetTitle()) {
            ref.setTitle(atpt.getTitle());
        }
        if (atpt.isSetActuate()) {
            ref.setActuate(atpt.getActuate().toString());
        }
        if (atpt.isSetArcrole()) {
            ref.setArcrole(atpt.getArcrole());
        }
        if (atpt.isSetRole()) {
            ref.setRole(atpt.getRole());
        }
        if (atpt.isSetShow()) {
            ref.setShow(atpt.getShow().toString());
        }
        if (atpt.isSetType()) {
            ref.setType(atpt.getType().toString());
        }
        return Referenceable.of((Reference)ref);
    }

    private Referenceable<SweAllowedTimes> parseConstraint(AllowedTimesPropertyType atpt) throws DateTimeParseException {
        if (atpt.isSetAllowedTimes()) {
            return Referenceable.of((Object)this.parseAllowedTimes(atpt.getAllowedTimes()));
        }
        Reference ref = new Reference();
        if (atpt.isSetHref()) {
            ref.setHref(URI.create(atpt.getHref()));
        }
        if (atpt.isSetTitle()) {
            ref.setTitle(atpt.getTitle());
        }
        if (atpt.isSetActuate()) {
            ref.setActuate(atpt.getActuate().toString());
        }
        if (atpt.isSetArcrole()) {
            ref.setArcrole(atpt.getArcrole());
        }
        if (atpt.isSetRole()) {
            ref.setRole(atpt.getRole());
        }
        if (atpt.isSetShow()) {
            ref.setShow(atpt.getShow().toString());
        }
        if (atpt.isSetType()) {
            ref.setType(atpt.getType().toString());
        }
        return Referenceable.of((Reference)ref);
    }

    private SweAllowedValues parseAllowedValues(AllowedValuesType avt) {
        SweAllowedValues allowedValues = new SweAllowedValues();
        if (avt.isSetId()) {
            allowedValues.setGmlId(avt.getId());
        }
        if (avt.getValueArray() != null && avt.getValueArray().length > 0) {
            for (double value : avt.getValueArray()) {
                allowedValues.addValue(value);
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])avt.getIntervalArray())) {
            for (List interval : avt.getIntervalArray()) {
                RangeValue rangeValue = new RangeValue();
                Iterator iterator = interval.iterator();
                if (iterator.hasNext()) {
                    rangeValue.setRangeStart(iterator.next());
                }
                if (iterator.hasNext()) {
                    rangeValue.setRangeEnd(iterator.next());
                }
                allowedValues.addInterval(rangeValue);
            }
        }
        if (avt.isSetSignificantFigures()) {
            allowedValues.setSignificantFigures(avt.getSignificantFigures());
        }
        return allowedValues;
    }

    private SweAllowedTokens parseAllowedTokens(AllowedTokensType att) {
        SweAllowedTokens allowedTokens = new SweAllowedTokens();
        if (att.isSetId()) {
            allowedTokens.setGmlId(att.getId());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])att.getValueArray())) {
            allowedTokens.setValue(Arrays.asList(att.getValueArray()));
        }
        if (att.isSetPattern()) {
            allowedTokens.setPattern(att.getPattern());
        }
        return allowedTokens;
    }

    private SweAllowedTimes parseAllowedTimes(AllowedTimesType att) throws DateTimeParseException {
        SweAllowedTimes allowedTimes = new SweAllowedTimes();
        if (att.isSetId()) {
            allowedTimes.setGmlId(att.getId());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])att.getValueArray())) {
            for (Object value : att.getValueArray()) {
                allowedTimes.addValue(DateTimeHelper.parseIsoString2DateTime((String)value.toString()));
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])att.getIntervalArray())) {
            for (List interval : att.getIntervalArray()) {
                RangeValue rangeValue = new RangeValue();
                Iterator iterator = interval.iterator();
                if (iterator.hasNext()) {
                    rangeValue.setRangeStart((Object)DateTimeHelper.parseIsoString2DateTime((String)iterator.next().toString()));
                }
                if (iterator.hasNext()) {
                    rangeValue.setRangeEnd((Object)DateTimeHelper.parseIsoString2DateTime((String)iterator.next().toString()));
                }
                allowedTimes.addInterval(rangeValue);
            }
        }
        if (att.isSetSignificantFigures()) {
            allowedTimes.setSignificantFigures(att.getSignificantFigures());
        }
        return allowedTimes;
    }

    private Collection<SweQuality> parseQuality(QualityPropertyType ... qualityArray) throws DecodingException {
        if (qualityArray != null && qualityArray.length > 0) {
            ArrayList sosQualities = Lists.newArrayListWithCapacity((int)qualityArray.length);
            for (QualityPropertyType quality : qualityArray) {
                if (quality.isSetQuantity()) {
                    sosQualities.add(this.parseQuantity(quality.getQuantity()));
                    continue;
                }
                if (quality.isSetQuantityRange()) {
                    sosQualities.add(this.parseQuantityRange(quality.getQuantityRange()));
                    continue;
                }
                if (quality.isSetCategory()) {
                    sosQualities.add(this.parseCategory(quality.getCategory()));
                    continue;
                }
                if (!quality.isSetText()) continue;
                sosQualities.add(this.parseText(quality.getText()));
            }
            return sosQualities;
        }
        return Collections.emptyList();
    }

    private SweAbstractDataComponent parseVector(VectorType vector) throws DecodingException {
        SweVector sweVector = new SweVector();
        if (vector.isSetLocalFrame()) {
            sweVector.setLocalFrame(vector.getLocalFrame());
        }
        sweVector.setReferenceFrame(vector.getReferenceFrame());
        sweVector.setCoordinates(this.parseCoordinates(vector.getCoordinateArray()));
        return sweVector;
    }

    private List<SweCoordinate<?>> parseCoordinates(VectorType.Coordinate[] coordinateArray) throws DecodingException {
        ArrayList sosCoordinates = new ArrayList(coordinateArray.length);
        for (VectorType.Coordinate xbCoordinate : coordinateArray) {
            XmlHelper.validateDocument((XmlObject)xbCoordinate);
            if (!xbCoordinate.isSetQuantity()) {
                throw new DecodingException("Position", "Error when parsing the Coordinates of Position: It must be of type Quantity!", new Object[0]);
            }
            sosCoordinates.add(new SweCoordinate(xbCoordinate.getName(), (SweAbstractSimpleType)this.parseAbstractDataComponent((AbstractDataComponentType)xbCoordinate.getQuantity())));
        }
        return sosCoordinates;
    }

    private List<SweField> parseAnyScalarPropertyTypeArray(AnyScalarPropertyType[] fieldArray) throws DecodingException {
        ArrayList<SweField> sosFields = new ArrayList<SweField>(fieldArray.length);
        for (AnyScalarPropertyType xbField : fieldArray) {
            XmlHelper.validateDocument((XmlObject)xbField);
        }
        return sosFields;
    }

    private SweTextEncoding parseTextEncoding(TextEncodingType textEncoding) {
        SweTextEncoding sosTextEncoding = new SweTextEncoding();
        sosTextEncoding.setBlockSeparator(textEncoding.getBlockSeparator());
        sosTextEncoding.setTokenSeparator(textEncoding.getTokenSeparator());
        if (textEncoding.isSetDecimalSeparator()) {
            sosTextEncoding.setDecimalSeparator(textEncoding.getDecimalSeparator());
        }
        if (textEncoding.isSetCollapseWhiteSpaces()) {
            sosTextEncoding.setCollapseWhiteSpaces(textEncoding.getCollapseWhiteSpaces());
        }
        return sosTextEncoding;
    }

    private SweCount parseElementCount(CountPropertyType elementCount) throws DecodingException {
        if (elementCount.isSetCount()) {
            return (SweCount)this.parseAbstractDataComponent((AbstractDataComponentType)elementCount.getCount());
        }
        return null;
    }
}

