/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opengis.gml.x32.AbstractFeatureType;
import net.opengis.waterml.x20.ObservationProcessDocument;
import net.opengis.waterml.x20.ObservationProcessPropertyType;
import net.opengis.waterml.x20.ObservationProcessType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.ogc.om.series.wml.ObservationProcess;
import org.n52.shetland.ogc.sos.ProcedureDescriptionFormat;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractWmlDecoderv20;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.ProcedureDecoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WmlObservationProcessDecoderv20
extends AbstractWmlDecoderv20
implements ProcedureDecoder<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WmlObservationProcessDecoderv20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/waterml/2.0/observationProcess", (Class[])new Class[]{ObservationProcessDocument.class, ObservationProcessPropertyType.class, ObservationProcessType.class}), CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/waterml/2.0", (Class[])new Class[]{ObservationProcessDocument.class, ObservationProcessPropertyType.class, ObservationProcessType.class})});
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS = ImmutableMap.of((Object)"SOS", (Object)ImmutableMap.of((Object)"2.0.0", (Object)ImmutableSet.of((Object)"http://www.opengis.net/waterml/2.0/observationProcess")));
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.of((Object)new ProcedureDescriptionFormat("http://www.opengis.net/waterml/2.0/observationProcess"));

    public WmlObservationProcessDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        return SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS.getOrDefault(service, Collections.emptyMap()).getOrDefault(version, Collections.emptySet());
    }

    @Override
    public Object decode(Object object) throws DecodingException {
        if (object instanceof ObservationProcessDocument) {
            return this.parseObservationProcess(((ObservationProcessDocument)object).getObservationProcess());
        }
        if (object instanceof ObservationProcessPropertyType) {
            return this.parseObservationProcess(((ObservationProcessPropertyType)object).getObservationProcess());
        }
        if (object instanceof ObservationProcessType) {
            return this.parseObservationProcess((ObservationProcessType)object);
        }
        return super.decode(object);
    }

    private Object parseObservationProcess(ObservationProcessType opt) throws DecodingException {
        ObservationProcess observationProcess = new ObservationProcess();
        observationProcess.setGmlId(opt.getId());
        this.parseAbstractFeatureType((AbstractFeatureType)opt, (AbstractFeature)observationProcess);
        this.parseProcessType(opt, observationProcess);
        this.parseOriginatingProcess(opt, observationProcess);
        this.parseAggregatingDuration(opt, observationProcess);
        this.parseVerticalDatum(opt, observationProcess);
        this.parseComment(opt, observationProcess);
        this.parseProcessReference(opt, observationProcess);
        this.parseInput(opt, observationProcess);
        this.parseParameter(opt, observationProcess);
        this.setDescriptionXml(opt, observationProcess);
        return observationProcess;
    }

    private void setDescriptionXml(ObservationProcessType opt, ObservationProcess observationProcess) {
        ObservationProcessDocument doc = ObservationProcessDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        doc.setObservationProcess(opt);
        observationProcess.setXml(doc.xmlText(this.getXmlOptions()));
    }

    private void parseProcessType(ObservationProcessType opt, ObservationProcess observationProcess) {
        observationProcess.setProcessType(this.parseReferenceType(opt.getProcessType()));
    }

    private void parseOriginatingProcess(ObservationProcessType opt, ObservationProcess observationProcess) throws DecodingException {
        if (opt.isSetOriginatingProcess()) {
            observationProcess.setOriginatingProcess(this.parseReferenceType(opt.getOriginatingProcess()));
        }
    }

    private void parseAggregatingDuration(ObservationProcessType opt, ObservationProcess observationProcess) {
        if (opt.isSetAggregationDuration()) {
            observationProcess.setAggregationDuration(opt.getAggregationDuration().toString());
        }
    }

    private void parseVerticalDatum(ObservationProcessType opt, ObservationProcess observationProcess) throws DecodingException {
        Object decodeXmlElement;
        if (opt.isSetVerticalDatum() && (decodeXmlElement = this.decodeXmlElement((XmlObject)opt.getVerticalDatum())) instanceof ReferenceType) {
            observationProcess.setVerticalDatum((ReferenceType)decodeXmlElement);
        }
    }

    private void parseComment(ObservationProcessType opt, ObservationProcess observationProcess) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])opt.getCommentArray())) {
            observationProcess.setComments((List)Lists.newArrayList((Object[])opt.getCommentArray()));
        }
    }

    private void parseProcessReference(ObservationProcessType opt, ObservationProcess observationProcess) {
        if (opt.isSetProcessReference()) {
            observationProcess.setProcessReference(this.parseReferenceType(opt.getProcessReference()));
        }
    }

    private void parseInput(ObservationProcessType opt, ObservationProcess observationProcess) {
        if (CollectionHelper.isNotNullOrEmpty((Object[])opt.getInputArray())) {
            this.parseReferenceType(opt.getInputArray());
        }
    }

    private void parseParameter(ObservationProcessType opt, ObservationProcess observationProcess) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])opt.getParameterArray())) {
            observationProcess.setParameters(this.parseNamedValueTypeArray(opt.getParameterArray()));
        }
    }
}

