/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Set;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.svalbard.encode.AbstractResponseEncoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.VersionedOperationEncoderKey;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbtractVersionedResponseEncoder<T extends OwsServiceResponse>
extends AbstractResponseEncoder<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbtractVersionedResponseEncoder.class);
    private final Set<EncoderKey> encoderKeys;

    public AbtractVersionedResponseEncoder(String service, String version, String operation, String namespace, String prefix, Class<T> responseType, boolean validationEnabled, String operationVersion) {
        super(service, version, operationVersion, namespace, prefix, responseType, validationEnabled);
        OwsOperationKey key = new OwsOperationKey(service, version, operation);
        this.encoderKeys = Sets.newHashSet((Object[])new EncoderKey[]{new XmlEncoderKey(namespace, responseType), new VersionedOperationEncoderKey(key, MediaTypes.TEXT_XML, operationVersion), new VersionedOperationEncoderKey(key, MediaTypes.APPLICATION_XML, operationVersion)});
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(this.encoderKeys));
    }

    public AbtractVersionedResponseEncoder(String service, String version, String operation, String namespace, String prefix, Class<T> responseType, String operationVersion) {
        this(service, version, operation, namespace, prefix, responseType, true, operationVersion);
    }

    @Override
    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(this.encoderKeys);
    }
}

