/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.Set;
import net.opengis.sos.x20.GetObservationByIdResponseDocument;
import net.opengis.sos.x20.GetObservationByIdResponseType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.StreamingValue;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.response.AbstractStreaming;
import org.n52.shetland.ogc.sos.response.GetObservationByIdResponse;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractObservationResponseEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.XmlHelper;
import org.w3c.dom.Node;

public class GetObservationByIdResponseEncoder
extends AbstractObservationResponseEncoder<GetObservationByIdResponse> {
    public static final String GML_ID = "sf_1";

    public GetObservationByIdResponseEncoder() {
        super(SosConstants.Operations.GetObservationById.name(), GetObservationByIdResponse.class);
    }

    @Override
    protected XmlObject createResponse(ObservationEncoder<XmlObject, OmObservation> encoder, GetObservationByIdResponse response) throws EncodingException {
        GetObservationByIdResponseDocument doc = GetObservationByIdResponseDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GetObservationByIdResponseType xbResponse = doc.addNewGetObservationByIdResponse();
        ObservationStream observations = this.getObservationsAndCheckForStreaming(response, encoder);
        HashMap<CodeWithAuthority, String> gmlID4sfIdentifier = new HashMap<CodeWithAuthority, String>();
        try {
            while (observations.hasNext()) {
                OmObservation observation = (OmObservation)observations.next();
                EncodingContext codingContext = EncodingContext.empty();
                CodeWithAuthority foiId = observation.getObservationConstellation().getFeatureOfInterest().getIdentifierCodeWithAuthority();
                if (gmlID4sfIdentifier.containsKey(foiId)) {
                    codingContext = codingContext.with((Enum)XmlBeansEncodingFlags.EXIST_FOI_IN_DOC, (Object)true);
                } else {
                    gmlID4sfIdentifier.put(foiId, GML_ID);
                    codingContext = codingContext.with((Enum)XmlBeansEncodingFlags.EXIST_FOI_IN_DOC, (Object)false);
                }
                codingContext = codingContext.with((Enum)XmlBeansEncodingFlags.GMLID, gmlID4sfIdentifier.get(foiId));
                xbResponse.addNewObservation().addNewOMObservation().set((XmlObject)encoder.encode((Object)observation, codingContext));
            }
        }
        catch (OwsExceptionReport ex) {
            throw new EncodingException((Throwable)ex);
        }
        XmlHelper.makeGmlIdsUnique((Node)xbResponse.getDomNode());
        return doc;
    }

    private ObservationStream getObservationsAndCheckForStreaming(GetObservationByIdResponse response, ObservationEncoder<XmlObject, OmObservation> encoder) throws NoSuchElementException, EncodingException {
        try {
            if (response.getObservationCollection() != null && response.getObservationCollection().hasNext()) {
                if (encoder.shouldObservationsWithSameXBeMerged()) {
                    return response.getObservationCollection().merge();
                }
                ArrayList observations = Lists.newArrayList();
                while (response.getObservationCollection().hasNext()) {
                    OmObservation observation = (OmObservation)response.getObservationCollection().next();
                    if (observation.getValue() instanceof StreamingValue) {
                        while (((AbstractStreaming)observation.getValue()).hasNext()) {
                            observations.add(((AbstractStreaming)observation.getValue()).next());
                        }
                        continue;
                    }
                    observations.add(observation);
                }
                return ObservationStream.of((Iterable)observations);
            }
            return response.getObservationCollection();
        }
        catch (OwsExceptionReport e) {
            throw new EncodingException((Throwable)e);
        }
    }

    @Override
    public Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos2Constants.SOS_GET_OBSERVATION_BY_ID_SCHEMA_LOCATION});
    }
}

