/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opengis.om.x10.CategoryObservationDocument;
import net.opengis.om.x10.CategoryObservationType;
import net.opengis.om.x10.CountObservationDocument;
import net.opengis.om.x10.CountObservationType;
import net.opengis.om.x10.GeometryObservationDocument;
import net.opengis.om.x10.GeometryObservationType;
import net.opengis.om.x10.MeasurementDocument;
import net.opengis.om.x10.MeasurementType;
import net.opengis.om.x10.ObservationCollectionDocument;
import net.opengis.om.x10.ObservationCollectionType;
import net.opengis.om.x10.ObservationDocument;
import net.opengis.om.x10.ObservationPropertyType;
import net.opengis.om.x10.ObservationType;
import net.opengis.om.x10.TruthObservationDocument;
import net.opengis.om.x10.TruthObservationType;
import org.apache.xmlbeans.XmlBoolean;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlString;
import org.joda.time.DateTime;
import org.n52.janmayen.http.MediaType;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.MultiObservationValues;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmCompositePhenomenon;
import org.n52.shetland.ogc.om.OmConstants;
import org.n52.shetland.ogc.om.OmObservableProperty;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.SingleObservationValue;
import org.n52.shetland.ogc.om.StreamingValue;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.om.values.BooleanValue;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.GeometryValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.om.values.TextValue;
import org.n52.shetland.ogc.om.values.Value;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.sos.response.GetObservationByIdResponse;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.OMHelper;
import org.n52.shetland.util.ReferencedEnvelope;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.GmlHelper;
import org.n52.svalbard.util.N52XmlHelper;
import org.n52.svalbard.util.SweHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

public class OmEncoderv100
extends AbstractXmlEncoder<XmlObject, Object>
implements ObservationEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OmEncoderv100.class);
    private static final Set<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)OmConstants.OBS_TYPE_SWE_ARRAY_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_CATEGORY_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_COUNT_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_MEASUREMENT_TYPE).add((Object)OmConstants.OBS_TYPE_TEXT_OBSERVATION_TYPE).add((Object)OmConstants.OBS_TYPE_TRUTH_OBSERVATION_TYPE).build();
    private static final Set<String> CONFORMANCE_CLASSES = ImmutableSet.of((Object)"http://www.opengis.net/spec/OMXML/1.0/conf/measurement", (Object)"http://www.opengis.net/spec/OMXML/1.0/conf/categoryObservation", (Object)"http://www.opengis.net/spec/OMXML/1.0/conf/countObservation", (Object)"http://www.opengis.net/spec/OMXML/1.0/conf/truthObservation", (Object)"http://www.opengis.net/spec/OMXML/1.0/conf/geometryObservation", (Object)"http://www.opengis.net/spec/OMXML/1.0/conf/textObservation", (Object[])new String[0]);
    private static final Map<String, Map<String, Set<String>>> SUPPORTED_RESPONSE_FORMATS = Collections.singletonMap("SOS", Collections.singletonMap("1.0.0", ImmutableSet.of((Object)OmConstants.CONTENT_TYPE_OM.toString())));
    private static final Set<EncoderKey> ENCODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/om/1.0", (Class[])new Class[]{OmObservation.class, GetObservationResponse.class, GetObservationByIdResponse.class}), CodingHelper.encoderKeysForElements((String)OmConstants.CONTENT_TYPE_OM.toString(), (Class[])new Class[]{OmObservation.class, GetObservationResponse.class, GetObservationByIdResponse.class})});
    private static final String RESULT_TIME_ID_PREFIX = "resultTime_";
    private static final String OBSERVATION_ID_PREFIX = "o_";

    public OmEncoderv100() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.singletonMap(OmConstants.CONTENT_TYPE_OM.toString(), this.getSupportedTypes());
    }

    public Set<String> getConformanceClasses(String service, String version) {
        if ("SOS".equals(service) && "2.0.0".equals(version)) {
            return Collections.unmodifiableSet(CONFORMANCE_CLASSES);
        }
        return Collections.emptySet();
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/om/1.0", "om");
    }

    public boolean isObservationAndMeasurmentV20Type() {
        return false;
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        if (SUPPORTED_RESPONSE_FORMATS.get(service) != null && SUPPORTED_RESPONSE_FORMATS.get(service).get(version) != null) {
            return SUPPORTED_RESPONSE_FORMATS.get(service).get(version);
        }
        return Collections.emptySet();
    }

    public boolean shouldObservationsWithSameXBeMerged() {
        return true;
    }

    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    @Override
    public MediaType getContentType() {
        return OmConstants.CONTENT_TYPE_OM;
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{OmConstants.OM_100_SCHEMA_LOCATION});
    }

    public XmlObject encode(Object element, EncodingContext additionalValues) throws EncodingException {
        XmlObject encodedObject = null;
        if (element instanceof OmObservation) {
            encodedObject = this.createObservation((OmObservation)element, additionalValues);
        } else if (element instanceof GetObservationResponse) {
            GetObservationResponse response = (GetObservationResponse)element;
            encodedObject = this.createObservationCollection(response.getObservationCollection(), response.getResultModel());
        } else if (element instanceof GetObservationByIdResponse) {
            GetObservationByIdResponse response = (GetObservationByIdResponse)element;
            encodedObject = this.createObservationCollection(response.getObservationCollection(), response.getResultModel());
        } else {
            throw new UnsupportedEncoderInputException((Encoder)this, element);
        }
        XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        return encodedObject;
    }

    private XmlObject createObservation(OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        String observationType = this.checkObservationType(sosObservation);
        if (null != observationType) {
            switch (observationType) {
                case "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement": {
                    return this.createMeasurement(sosObservation, additionalValues);
                }
                case "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation": {
                    return this.createCategoryObservation(sosObservation, additionalValues);
                }
                case "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation": {
                    return this.createCountObservation(sosObservation, additionalValues);
                }
                case "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TruthObservation": {
                    return this.createTruthObservation(sosObservation, additionalValues);
                }
                case "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_GeometryObservation": {
                    return this.createGeometryObservation(sosObservation, additionalValues);
                }
            }
            return this.createOmObservation(sosObservation, additionalValues);
        }
        return this.createOmObservation(sosObservation, additionalValues);
    }

    private String checkObservationType(OmObservation sosObservation) throws EncodingException {
        if (sosObservation.isSetResultType()) {
            return sosObservation.getResultType();
        }
        if (sosObservation.getValue() instanceof SingleObservationValue) {
            SingleObservationValue observationValue = (SingleObservationValue)sosObservation.getValue();
            return OMHelper.getObservationTypeFor((Value)observationValue.getValue());
        }
        return "http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation";
    }

    private XmlObject createObservationCollection(ObservationStream sosObservationCollectionIterable, String resultModel) throws EncodingException {
        ObservationCollectionDocument xbObservationCollectionDoc = ObservationCollectionDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ObservationCollectionType xbObservationCollection = xbObservationCollectionDoc.addNewObservationCollection();
        xbObservationCollection.setId("oc_" + new DateTime().getMillis());
        if (sosObservationCollectionIterable != null) {
            LinkedList<OmObservation> sosObservationCollection = new LinkedList<OmObservation>();
            try {
                sosObservationCollectionIterable.forEachRemaining(sosObservationCollection::add);
                ReferencedEnvelope sosEnvelope = this.getEnvelope(sosObservationCollection);
                Encoder<XmlObject, ReferencedEnvelope> envEncoder = this.getEncoder("http://www.opengis.net/gml", sosEnvelope);
                xbObservationCollection.addNewBoundedBy().addNewEnvelope().set((XmlObject)envEncoder.encode((Object)sosEnvelope));
                for (OmObservation sosObservation : sosObservationCollection) {
                    String observationType = this.checkObservationType(sosObservation);
                    if (Strings.isNullOrEmpty((String)resultModel) || !Strings.isNullOrEmpty((String)resultModel) && observationType.equals(resultModel)) {
                        if (sosObservation.getValue() instanceof StreamingValue) {
                            StreamingValue streamingValue = (StreamingValue)sosObservation.getValue();
                            while (streamingValue.hasNext()) {
                                xbObservationCollection.addNewMember().set(this.createObservation(streamingValue.next(), null));
                            }
                            continue;
                        }
                        xbObservationCollection.addNewMember().set(this.createObservation(sosObservation, null));
                        continue;
                    }
                    throw new EncodingException("The requested resultModel '%s' is invalid for the resulting observations!", new Object[]{OMHelper.getEncodedResultModelFor((String)resultModel)});
                }
            }
            catch (OwsExceptionReport owse) {
                throw new EncodingException((Throwable)owse);
            }
        }
        ObservationPropertyType xbObservation = xbObservationCollection.addNewMember();
        xbObservation.setHref("urn:ogc:def:nil:OGC:inapplicable");
        XmlHelper.makeGmlIdsUnique((Node)xbObservationCollectionDoc.getDomNode());
        N52XmlHelper.setSchemaLocationsToDocument((XmlObject)xbObservationCollectionDoc, (Collection)Sets.newHashSet((Object[])new SchemaLocation[]{N52XmlHelper.getSchemaLocationForSOS100(), N52XmlHelper.getSchemaLocationForOM100(), N52XmlHelper.getSchemaLocationForSA100()}));
        return xbObservationCollectionDoc;
    }

    private ReferencedEnvelope getEnvelope(List<OmObservation> sosObservationCollection) {
        ReferencedEnvelope sosEnvelope = new ReferencedEnvelope();
        sosObservationCollection.stream().map(o -> (SamplingFeature)o.getObservationConstellation().getFeatureOfInterest()).forEach(f -> {
            sosEnvelope.setSrid(f.getGeometry().getSRID());
            sosEnvelope.expandToInclude(f.getGeometry().getEnvelopeInternal());
        });
        return sosEnvelope;
    }

    private XmlObject createMeasurement(OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        MeasurementDocument xbMeasurementDoc = MeasurementDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        MeasurementType xbObs = xbMeasurementDoc.addNewMeasurement();
        this.addValuesToObservation((ObservationType)xbObs, sosObservation, additionalValues);
        this.addSingleObservationToResult(xbObs.addNewResult(), sosObservation);
        return xbMeasurementDoc;
    }

    private XmlObject createCategoryObservation(OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        CategoryObservationDocument xbCategoryObservationDoc = CategoryObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        CategoryObservationType xbObs = xbCategoryObservationDoc.addNewCategoryObservation();
        this.addValuesToObservation((ObservationType)xbObs, sosObservation, additionalValues);
        this.addSingleObservationToResult(xbObs.addNewResult(), sosObservation);
        return xbCategoryObservationDoc;
    }

    private XmlObject createCountObservation(OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        CountObservationDocument xbCountObservationDoc = CountObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        CountObservationType xbObs = xbCountObservationDoc.addNewCountObservation();
        this.addValuesToObservation((ObservationType)xbObs, sosObservation, additionalValues);
        this.addSingleObservationToResult(xbObs.addNewResult(), sosObservation);
        return xbCountObservationDoc;
    }

    private XmlObject createTruthObservation(OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        TruthObservationDocument xbTruthObservationDoc = TruthObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        TruthObservationType xbObs = xbTruthObservationDoc.addNewTruthObservation();
        this.addValuesToObservation((ObservationType)xbObs, sosObservation, additionalValues);
        this.addSingleObservationToResult(xbObs.addNewResult(), sosObservation);
        return xbTruthObservationDoc;
    }

    private XmlObject createGeometryObservation(OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        GeometryObservationDocument xbGeometryObservationDoc = GeometryObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        GeometryObservationType xbObs = xbGeometryObservationDoc.addNewGeometryObservation();
        this.addValuesToObservation((ObservationType)xbObs, sosObservation, additionalValues);
        this.addSingleObservationToResult(xbObs.addNewResult(), sosObservation);
        return xbGeometryObservationDoc;
    }

    private XmlObject createOmObservation(OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        ObservationDocument xbObservationDoc = ObservationDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        ObservationType xbObs = xbObservationDoc.addNewObservation();
        List<OmObservableProperty> phenComponents = this.addValuesToObservation(xbObs, sosObservation, additionalValues);
        this.addResultToObservation(xbObs.addNewResult(), sosObservation, phenComponents);
        return xbObservationDoc;
    }

    private List<OmObservableProperty> addValuesToObservation(ObservationType xbObs, OmObservation sosObservation, EncodingContext additionalValues) throws EncodingException {
        xbObs.setId(OBSERVATION_ID_PREFIX + Long.toString(System.currentTimeMillis()));
        if (!sosObservation.isSetObservationID()) {
            sosObservation.setObservationID(xbObs.getId().replace(OBSERVATION_ID_PREFIX, ""));
        }
        String observationID = sosObservation.getObservationID();
        Time samplingTime = sosObservation.getPhenomenonTime();
        if (samplingTime.getGmlId() == null) {
            samplingTime.setGmlId("phenomenonTime_" + observationID);
        }
        this.addSamplingTime(xbObs, samplingTime);
        this.addResultTime(xbObs, sosObservation);
        xbObs.addNewProcedure().setHref(sosObservation.getObservationConstellation().getProcedure().getIdentifier());
        List<Object> phenComponents = null;
        if (sosObservation.getObservationConstellation().getObservableProperty() instanceof OmObservableProperty) {
            xbObs.addNewObservedProperty().setHref(sosObservation.getObservationConstellation().getObservableProperty().getIdentifier());
            phenComponents = new ArrayList<OmObservableProperty>(1);
            phenComponents.add((OmObservableProperty)sosObservation.getObservationConstellation().getObservableProperty());
        } else if (sosObservation.getObservationConstellation().getObservableProperty() instanceof OmCompositePhenomenon) {
            OmCompositePhenomenon compPhen = (OmCompositePhenomenon)sosObservation.getObservationConstellation().getObservableProperty();
            xbObs.addNewObservedProperty().setHref(compPhen.getIdentifier());
            phenComponents = compPhen.getPhenomenonComponents();
        }
        this.addFeatureOfInterest(xbObs, sosObservation.getObservationConstellation().getFeatureOfInterest());
        return phenComponents;
    }

    private void addSamplingTime(ObservationType xbObservation, Time iTime) throws EncodingException {
        XmlObject xmlObject = this.encodeObjectToXml("http://www.opengis.net/gml", iTime);
        XmlObject substitution = xbObservation.addNewSamplingTime().addNewTimeObject().substitute(GmlHelper.getGml311QnameForITime((Time)iTime), xmlObject.schemaType());
        substitution.set(xmlObject);
    }

    private void addResultTime(ObservationType xbObs, OmObservation sosObservation) throws EncodingException {
        Time phenomenonTime = sosObservation.getPhenomenonTime();
        if (sosObservation.isSetResultTime()) {
            if (sosObservation.getResultTime().equals((Object)phenomenonTime)) {
                xbObs.addNewResultTime().setHref("#".concat(phenomenonTime.getGmlId()));
            } else {
                TimeInstant resultTime = sosObservation.getResultTime();
                if (!resultTime.isSetGmlId()) {
                    resultTime.setGmlId(RESULT_TIME_ID_PREFIX.concat(sosObservation.getObservationID()));
                }
                this.addResultTime(xbObs, resultTime);
            }
        } else if (phenomenonTime instanceof TimeInstant) {
            xbObs.addNewResultTime().setHref("#".concat(phenomenonTime.getGmlId()));
        } else if (phenomenonTime instanceof TimePeriod) {
            TimeInstant resultTime = new TimeInstant(((TimePeriod)sosObservation.getPhenomenonTime()).getEnd());
            resultTime.setGmlId(RESULT_TIME_ID_PREFIX + sosObservation.getObservationID());
            this.addResultTime(xbObs, resultTime);
        }
    }

    private void addResultTime(ObservationType xbObs, TimeInstant iTime) throws EncodingException {
        XmlObject xmlObject = this.encodeObjectToXml("http://www.opengis.net/gml", iTime);
        XmlObject substitution = xbObs.addNewResultTime().addNewTimeObject().substitute(GmlHelper.getGml311QnameForITime((Time)iTime), xmlObject.schemaType());
        substitution.set(xmlObject);
    }

    private void addResultToObservation(XmlObject xbResult, OmObservation sosObservation, List<OmObservableProperty> phenComponents) throws EncodingException {
        if (sosObservation.getValue() instanceof SingleObservationValue) {
            this.addSingleObservationToResult(xbResult, sosObservation);
        } else if (sosObservation.getValue() instanceof MultiObservationValues) {
            this.addMultiObservationValueToResult(xbResult, sosObservation);
        }
    }

    private void addSingleObservationToResult(XmlObject xbResult, OmObservation sosObservation) throws EncodingException {
        String observationType = sosObservation.getObservationConstellation().getObservationType();
        SingleObservationValue observationValue = (SingleObservationValue)sosObservation.getValue();
        if (observationValue.getValue() instanceof QuantityValue) {
            QuantityValue quantityValue = (QuantityValue)observationValue.getValue();
            xbResult.set(this.encodeObjectToXml("http://www.opengis.net/gml", quantityValue));
        } else if (observationValue.getValue() instanceof CountValue) {
            CountValue countValue = (CountValue)observationValue.getValue();
            XmlInteger xbInteger = XmlInteger.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (countValue.getValue() != null && countValue.getValue() != Integer.MIN_VALUE) {
                xbInteger.setBigIntegerValue(new BigInteger(countValue.getValue().toString()));
            } else {
                xbInteger.setNil();
            }
            xbResult.set((XmlObject)xbInteger);
        } else if (observationValue.getValue() instanceof TextValue) {
            TextValue textValue = (TextValue)observationValue.getValue();
            XmlString xbString = XmlString.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (textValue.getValue() != null && !textValue.getValue().isEmpty()) {
                xbString.setStringValue(textValue.getValue());
            } else {
                xbString.setNil();
            }
            xbResult.set((XmlObject)xbString);
        } else if (observationValue.getValue() instanceof BooleanValue) {
            BooleanValue booleanValue = (BooleanValue)observationValue.getValue();
            XmlBoolean xbBoolean = XmlBoolean.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (booleanValue.getValue() != null) {
                xbBoolean.setBooleanValue(booleanValue.getValue().booleanValue());
            } else {
                xbBoolean.setNil();
            }
            xbResult.set((XmlObject)xbBoolean);
        } else if (observationValue.getValue() instanceof CategoryValue) {
            CategoryValue categoryValue = (CategoryValue)observationValue.getValue();
            if (categoryValue.getValue() != null && !categoryValue.getValue().isEmpty()) {
                xbResult.set(this.encodeObjectToXml("http://www.opengis.net/gml", categoryValue, EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)(OBSERVATION_ID_PREFIX + sosObservation.getObservationID()))));
            } else {
                xbResult.setNil();
            }
        } else if (observationValue.getValue() instanceof GeometryValue) {
            GeometryValue geometryValue = (GeometryValue)observationValue.getValue();
            if (geometryValue.getValue() != null) {
                xbResult.set(this.encodeObjectToXml("http://www.opengis.net/gml", geometryValue.getValue(), EncodingContext.of((Enum)XmlBeansEncodingFlags.GMLID, (Object)(OBSERVATION_ID_PREFIX + sosObservation.getObservationID()))));
            } else {
                xbResult.setNil();
            }
        } else if ("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_SWEArrayObservation".equals(observationType) || OmConstants.RESULT_MODEL_OBSERVATION.getLocalPart().equals(observationType)) {
            SweDataArray dataArray = new SweHelper().createSosSweDataArray(sosObservation);
            xbResult.set(this.encodeObjectToXml("http://www.opengis.net/swe/1.0.1", dataArray, EncodingContext.of((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION)));
        }
    }

    private void addMultiObservationValueToResult(XmlObject xbResult, OmObservation sosObservation) throws EncodingException {
        SweDataArray dataArray = new SweHelper().createSosSweDataArray(sosObservation);
        xbResult.set(this.encodeObjectToXml("http://www.opengis.net/swe/1.0.1", dataArray, EncodingContext.of((Enum)XmlBeansEncodingFlags.FOR_OBSERVATION)));
    }

    private void addFeatureOfInterest(ObservationType observation, AbstractFeature feature) throws EncodingException {
        EncodingContext ctx = EncodingContext.of((Enum)XmlBeansEncodingFlags.ENCODE, (Object)feature.getDefaultElementEncoding());
        XmlObject encodeObjectToXml = this.encodeObjectToXml("http://www.opengis.net/gml", feature, ctx);
        observation.addNewFeatureOfInterest().set(encodeObjectToXml);
    }
}

