/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import java.util.Collections;
import java.util.Set;
import net.opengis.sosrf.x10.ResultFilterDocument;
import net.opengis.sosrf.x10.ResultFilterPropertyType;
import net.opengis.sosrf.x10.ResultFilterType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.filter.ComparisonFilter;
import org.n52.shetland.ogc.sos.ResultFilter;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultFilterDecoder
extends AbstractXmlDecoder<XmlObject, ResultFilter> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultFilterDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sosrf/1.0", (Class[])new Class[]{ResultFilterDocument.class, ResultFilterPropertyType.class, ResultFilterType.class});

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public ResultFilter decode(XmlObject xmlObject) throws DecodingException {
        if (xmlObject instanceof ResultFilterType) {
            return this.parseType((ResultFilterType)xmlObject);
        }
        if (xmlObject instanceof ResultFilterPropertyType) {
            return this.parseType(((ResultFilterPropertyType)xmlObject).getResultFilter());
        }
        if (xmlObject instanceof ResultFilterDocument) {
            return this.parseType(((ResultFilterDocument)xmlObject).getResultFilter());
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }

    private ResultFilter parseType(ResultFilterType xmlObject) throws DecodingException {
        return new ResultFilter((ComparisonFilter)this.decodeXmlElement((XmlObject)xmlObject.getComparisonOps()));
    }
}

