/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.math.BigDecimal;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.opengis.swe.x101.AbstractDataArrayType;
import net.opengis.swe.x101.AbstractDataComponentType;
import net.opengis.swe.x101.AbstractDataRecordDocument;
import net.opengis.swe.x101.AbstractDataRecordType;
import net.opengis.swe.x101.AllowedTimesDocument;
import net.opengis.swe.x101.AllowedTimesPropertyType;
import net.opengis.swe.x101.AllowedTokensDocument;
import net.opengis.swe.x101.AllowedTokensPropertyType;
import net.opengis.swe.x101.AllowedValuesDocument;
import net.opengis.swe.x101.AllowedValuesPropertyType;
import net.opengis.swe.x101.AnyScalarPropertyType;
import net.opengis.swe.x101.BlockEncodingPropertyType;
import net.opengis.swe.x101.BooleanDocument;
import net.opengis.swe.x101.CategoryDocument;
import net.opengis.swe.x101.CountDocument;
import net.opengis.swe.x101.CountRangeDocument;
import net.opengis.swe.x101.DataArrayDocument;
import net.opengis.swe.x101.DataArrayType;
import net.opengis.swe.x101.DataComponentPropertyType;
import net.opengis.swe.x101.DataRecordPropertyType;
import net.opengis.swe.x101.DataRecordType;
import net.opengis.swe.x101.EnvelopeType;
import net.opengis.swe.x101.ObservablePropertyDocument;
import net.opengis.swe.x101.PositionType;
import net.opengis.swe.x101.QualityPropertyType;
import net.opengis.swe.x101.QuantityDocument;
import net.opengis.swe.x101.QuantityRangeDocument;
import net.opengis.swe.x101.SimpleDataRecordType;
import net.opengis.swe.x101.TextBlockDocument;
import net.opengis.swe.x101.TextDocument;
import net.opengis.swe.x101.TimeDocument;
import net.opengis.swe.x101.TimeRangeDocument;
import net.opengis.swe.x101.VectorPropertyType;
import net.opengis.swe.x101.VectorType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.shetland.ogc.sensorML.elements.SmlPosition;
import org.n52.shetland.ogc.swe.RangeValue;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.SweCoordinate;
import org.n52.shetland.ogc.swe.SweDataArray;
import org.n52.shetland.ogc.swe.SweDataRecord;
import org.n52.shetland.ogc.swe.SweEnvelope;
import org.n52.shetland.ogc.swe.SweField;
import org.n52.shetland.ogc.swe.SweSimpleDataRecord;
import org.n52.shetland.ogc.swe.SweVector;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.shetland.ogc.swe.encoding.SweTextEncoding;
import org.n52.shetland.ogc.swe.simpleType.SweAbstractSimpleType;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTimes;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedTokens;
import org.n52.shetland.ogc.swe.simpleType.SweAllowedValues;
import org.n52.shetland.ogc.swe.simpleType.SweBoolean;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.ogc.swe.simpleType.SweCount;
import org.n52.shetland.ogc.swe.simpleType.SweCountRange;
import org.n52.shetland.ogc.swe.simpleType.SweObservableProperty;
import org.n52.shetland.ogc.swe.simpleType.SweQuality;
import org.n52.shetland.ogc.swe.simpleType.SweQuantity;
import org.n52.shetland.ogc.swe.simpleType.SweQuantityRange;
import org.n52.shetland.ogc.swe.simpleType.SweText;
import org.n52.shetland.ogc.swe.simpleType.SweTime;
import org.n52.shetland.ogc.swe.simpleType.SweTimeRange;
import org.n52.shetland.util.CollectionHelper;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.DateTimeParseException;
import org.n52.shetland.w3c.xlink.Reference;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.NotYetSupportedDecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SweCommonDecoderV101
extends AbstractXmlDecoder<Object, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SweCommonDecoderV101.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/swe/1.0.1", (Class[])new Class[]{DataArrayDocument.class, DataArrayType.class, AbstractDataComponentType.class, BooleanDocument.class, BooleanDocument.Boolean.class, CategoryDocument.Category.class, CategoryDocument.class, CountDocument.Count.class, CountDocument.class, CountRangeDocument.CountRange.class, CountRangeDocument.class, ObservablePropertyDocument.ObservableProperty.class, ObservablePropertyDocument.class, QuantityDocument.Quantity.class, QuantityDocument.class, QuantityRangeDocument.QuantityRange.class, QuantityRangeDocument.class, TextDocument.Text.class, TextDocument.class, TimeDocument.Time.class, TimeDocument.class, TimeRangeDocument.TimeRange.class, TimeRangeDocument.class, DataComponentPropertyType[].class, PositionType.class, VectorType.Coordinate[].class, AnyScalarPropertyType[].class, AbstractDataRecordDocument.class, AbstractDataRecordType.class});

    public SweCommonDecoderV101() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Object decode(Object element) throws DecodingException {
        if (element instanceof DataArrayDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((DataArrayDocument)element).getDataArray1());
        }
        if (element instanceof AbstractDataComponentType) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)element);
        }
        if (element instanceof BooleanDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((BooleanDocument)element).getBoolean());
        }
        if (element instanceof CategoryDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((CategoryDocument)element).getCategory());
        }
        if (element instanceof CountDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((CountDocument)element).getCount());
        }
        if (element instanceof CountRangeDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((CountRangeDocument)element).getCountRange());
        }
        if (element instanceof ObservablePropertyDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((ObservablePropertyDocument)element).getObservableProperty());
        }
        if (element instanceof QuantityDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((QuantityDocument)element).getQuantity());
        }
        if (element instanceof QuantityRangeDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((QuantityRangeDocument)element).getQuantityRange());
        }
        if (element instanceof TextDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((TextDocument)element).getText());
        }
        if (element instanceof TimeDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((TimeDocument)element).getTime());
        }
        if (element instanceof TimeRangeDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((TimeRangeDocument)element).getTimeRange());
        }
        if (element instanceof DataComponentPropertyType[]) {
            return this.parseDataComponentPropertyArray((DataComponentPropertyType[])element);
        }
        if (element instanceof VectorType.Coordinate[]) {
            return this.parseCoordinates((VectorType.Coordinate[])element);
        }
        if (element instanceof AnyScalarPropertyType[]) {
            return this.parseAnyScalarPropertyArray((AnyScalarPropertyType[])element);
        }
        if (element instanceof AbstractDataRecordDocument) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)((AbstractDataRecordDocument)element).getAbstractDataRecord());
        }
        if (element instanceof XmlObject) {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)element);
        }
        throw new UnsupportedDecoderInputException((Decoder)this, element);
    }

    private SweAbstractDataComponent parseAbstractDataComponentType(AbstractDataComponentType abstractDataComponent) throws DecodingException {
        SweCategory component = null;
        if (abstractDataComponent instanceof BooleanDocument.Boolean) {
            component = this.parseBoolean((BooleanDocument.Boolean)abstractDataComponent);
        } else if (abstractDataComponent instanceof CategoryDocument.Category) {
            component = this.parseCategory((CategoryDocument.Category)abstractDataComponent);
        } else if (abstractDataComponent instanceof CountDocument.Count) {
            component = this.parseCount((CountDocument.Count)abstractDataComponent);
        } else if (abstractDataComponent instanceof CountRangeDocument.CountRange) {
            component = this.parseCountRange((CountRangeDocument.CountRange)abstractDataComponent);
        } else if (abstractDataComponent instanceof ObservablePropertyDocument.ObservableProperty) {
            component = this.parseObservableProperty((ObservablePropertyDocument.ObservableProperty)abstractDataComponent);
        } else if (abstractDataComponent instanceof QuantityDocument.Quantity) {
            component = this.parseQuantity((QuantityDocument.Quantity)abstractDataComponent);
        } else if (abstractDataComponent instanceof QuantityRangeDocument.QuantityRange) {
            component = this.parseQuantityRange((QuantityRangeDocument.QuantityRange)abstractDataComponent);
        } else if (abstractDataComponent instanceof TextDocument.Text) {
            component = this.parseText((TextDocument.Text)abstractDataComponent);
        } else if (abstractDataComponent instanceof TimeDocument.Time) {
            component = this.parseTime((TimeDocument.Time)abstractDataComponent);
        } else if (abstractDataComponent instanceof TimeRangeDocument.TimeRange) {
            component = this.parseTimeRange((TimeRangeDocument.TimeRange)abstractDataComponent);
        } else if (abstractDataComponent instanceof PositionType) {
            component = this.parsePosition((PositionType)abstractDataComponent);
        } else if (abstractDataComponent instanceof DataRecordPropertyType) {
            component = this.parseDataRecordProperty((DataRecordPropertyType)abstractDataComponent);
        } else if (abstractDataComponent instanceof SimpleDataRecordType) {
            component = this.parseSimpleDataRecord((SimpleDataRecordType)abstractDataComponent);
        } else if (abstractDataComponent instanceof DataArrayType) {
            component = this.parseSweDataArrayType((DataArrayType)abstractDataComponent);
        } else if (abstractDataComponent instanceof DataRecordType) {
            component = this.parseDataRecord((DataRecordType)abstractDataComponent);
        } else if (abstractDataComponent instanceof EnvelopeType) {
            component = this.parseEnvelope((EnvelopeType)abstractDataComponent);
        } else {
            throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)abstractDataComponent);
        }
        if (abstractDataComponent.isSetDefinition()) {
            component.setDefinition(abstractDataComponent.getDefinition());
        }
        if (abstractDataComponent.isSetDescription()) {
            component.setDescription(abstractDataComponent.getDescription().getStringValue());
        }
        return component;
    }

    private SweDataRecord parseDataRecordProperty(DataRecordPropertyType dataRecordProperty) throws DecodingException {
        DataRecordType dataRecord = dataRecordProperty.getDataRecord();
        return this.parseDataRecord(dataRecord);
    }

    private SweDataRecord parseDataRecord(DataRecordType dataRecord) throws DecodingException {
        SweDataRecord sosDataRecord = new SweDataRecord();
        if (dataRecord.getFieldArray() != null) {
            sosDataRecord.setFields(this.parseDataComponentPropertyArray(dataRecord.getFieldArray()));
        }
        return sosDataRecord;
    }

    private SweAbstractDataComponent parseEnvelope(EnvelopeType envelopeType) throws DecodingException {
        String referenceFrame = null;
        SweVector lowerCorner = null;
        SweVector upperCorner = null;
        SweTimeRange time = null;
        if (envelopeType.isSetReferenceFrame()) {
            referenceFrame = envelopeType.getReferenceFrame();
        }
        if (envelopeType.getLowerCorner() != null) {
            lowerCorner = this.parseVectorProperty(envelopeType.getLowerCorner());
        }
        if (envelopeType.getUpperCorner() != null) {
            upperCorner = this.parseVectorProperty(envelopeType.getUpperCorner());
        }
        if (envelopeType.isSetTime()) {
            time = this.parseTimeRange(envelopeType.getTime().getTimeRange());
        }
        boolean northingFirst = false;
        return new SweEnvelope(referenceFrame, upperCorner, lowerCorner, time, northingFirst);
    }

    private SweVector parseVectorProperty(VectorPropertyType vectorPropertyType) throws DecodingException {
        return this.parseVector(vectorPropertyType.getVector());
    }

    private SweVector parseVector(VectorType vectorType) throws DecodingException {
        return new SweVector(this.parseCoordinates(vectorType.getCoordinateArray()));
    }

    private SweSimpleDataRecord parseSimpleDataRecord(SimpleDataRecordType simpleDataRecord) throws DecodingException {
        SweSimpleDataRecord sosSimpleDataRecord = new SweSimpleDataRecord();
        if (simpleDataRecord.getFieldArray() != null) {
            sosSimpleDataRecord.setFields(this.parseAnyScalarPropertyArray(simpleDataRecord.getFieldArray()));
        }
        return sosSimpleDataRecord;
    }

    private SweDataArray parseSweDataArrayType(DataArrayType xbDataArray) throws DecodingException {
        DataComponentPropertyType elementType;
        if (!xbDataArray.getElementType().isSetAbstractDataRecord()) {
            throw new DecodingException("The swe:DataArray contains a not yet supported elementType element. Currently only 'swe:DataRecord' is supported as elementType element.", new Object[0]);
        }
        SweDataArray dataArray = new SweDataArray();
        if (xbDataArray.getElementCount() != null) {
            dataArray.setElementCount(this.parseElementCount(xbDataArray.getElementCount()));
        }
        if ((elementType = xbDataArray.getElementType()) != null) {
            dataArray.setElementType(this.parseDataComponentProperty(elementType));
        }
        if (xbDataArray.isSetEncoding()) {
            dataArray.setEncoding(this.parseEncoding(xbDataArray.getEncoding()));
        }
        DataArrayDocument xbDataArrayDoc = DataArrayDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        xbDataArrayDoc.setDataArray1(xbDataArray);
        dataArray.setXml(xbDataArrayDoc.xmlText());
        return dataArray;
    }

    private List<SweField> parseDataComponentPropertyArray(DataComponentPropertyType[] fieldArray) throws DecodingException {
        ArrayList<SweField> sosFields = new ArrayList<SweField>(fieldArray.length);
        for (DataComponentPropertyType xbField : fieldArray) {
            sosFields.add(new SweField(xbField.getName(), this.parseDataComponentProperty(xbField)));
        }
        return sosFields;
    }

    private SweAbstractSimpleType<Boolean> parseBoolean(BooleanDocument.Boolean xbBoolean) throws DecodingException {
        SweBoolean sosBoolean = new SweBoolean();
        if (xbBoolean.isSetDefinition()) {
            sosBoolean.setDefinition(xbBoolean.getDefinition());
        }
        if (xbBoolean.isSetDescription()) {
            sosBoolean.setDescription(xbBoolean.getDescription().getStringValue());
        }
        if (xbBoolean.isSetValue()) {
            sosBoolean.setValue(Boolean.valueOf(xbBoolean.getValue()));
        }
        if (xbBoolean.isSetQuality()) {
            sosBoolean.setQuality(this.parseQuality(xbBoolean.getQuality()));
        }
        return sosBoolean;
    }

    private SweCategory parseCategory(CategoryDocument.Category category) throws DecodingException {
        SweCategory sosCategory = new SweCategory();
        if (category.isSetValue()) {
            sosCategory.setValue(category.getValue());
        }
        if (category.isSetCodeSpace()) {
            sosCategory.setCodeSpace(category.getCodeSpace().getHref());
        }
        if (category.isSetQuality()) {
            sosCategory.setQuality(this.parseQuality(category.getQuality()));
        }
        return sosCategory;
    }

    private SweCount parseCount(CountDocument.Count xbCount) throws DecodingException {
        SweCount sosCount = new SweCount();
        if (xbCount.getQualityArray() != null) {
            sosCount.setQuality(this.parseQuality(xbCount.getQualityArray()));
        }
        if (xbCount.isSetValue()) {
            sosCount.setValue(Integer.valueOf(xbCount.getValue().intValue()));
        }
        return sosCount;
    }

    private SweCountRange parseCountRange(CountRangeDocument.CountRange xbCountRange) throws DecodingException {
        SweCountRange sosCountRange = new SweCountRange();
        if (xbCountRange.getQualityArray() != null) {
            sosCountRange.setQuality(this.parseQuality(xbCountRange.getQualityArray()));
        }
        if (xbCountRange.isSetDefinition()) {
            sosCountRange.setDefinition(xbCountRange.getDefinition());
        }
        if (xbCountRange.isSetDescription()) {
            sosCountRange.setDescription(xbCountRange.getDescription().getStringValue());
        }
        if (xbCountRange.isSetValue()) {
            List value = xbCountRange.getValue();
            Integer rangeStart = Integer.parseInt(value.get(0).toString());
            Integer rangeEnd = Integer.parseInt(value.get(1).toString());
            sosCountRange.setValue(new RangeValue((Object)rangeStart, (Object)rangeEnd));
        }
        return sosCountRange;
    }

    private SweObservableProperty parseObservableProperty(ObservablePropertyDocument.ObservableProperty observableProperty) {
        return new SweObservableProperty();
    }

    private SweQuantity parseQuantity(QuantityDocument.Quantity xbQuantity) throws DecodingException {
        SweQuantity sosQuantity = new SweQuantity();
        if (xbQuantity.isSetAxisID()) {
            sosQuantity.setAxisID(xbQuantity.getAxisID());
        }
        if (xbQuantity.getQualityArray() != null) {
            sosQuantity.setQuality(this.parseQuality(xbQuantity.getQualityArray()));
        }
        if (xbQuantity.isSetUom() && xbQuantity.getUom().isSetCode()) {
            sosQuantity.setUom(xbQuantity.getUom().getCode());
        }
        if (xbQuantity.isSetValue()) {
            sosQuantity.setValue(Double.valueOf(xbQuantity.getValue()));
        }
        return sosQuantity;
    }

    private SweQuantityRange parseQuantityRange(QuantityRangeDocument.QuantityRange xbQuantityRange) throws DecodingException {
        SweQuantityRange sosQuantityRange = new SweQuantityRange();
        if (xbQuantityRange.isSetAxisID()) {
            sosQuantityRange.setAxisID(xbQuantityRange.getAxisID());
        }
        if (xbQuantityRange.isSetDefinition()) {
            sosQuantityRange.setDefinition(xbQuantityRange.getDefinition());
        }
        if (xbQuantityRange.isSetDescription()) {
            sosQuantityRange.setDescription(xbQuantityRange.getDescription().getStringValue());
        }
        if (xbQuantityRange.isSetUom() && xbQuantityRange.getUom().isSetCode()) {
            sosQuantityRange.setUom(xbQuantityRange.getUom().getCode());
        }
        if (xbQuantityRange.isSetValue()) {
            try {
                List value = xbQuantityRange.getValue();
                BigDecimal rangeStart = new BigDecimal(value.get(0).toString());
                BigDecimal rangeEnd = new BigDecimal(value.get(1).toString());
                sosQuantityRange.setValue(new RangeValue((Object)rangeStart, (Object)rangeEnd));
            }
            catch (IndexOutOfBoundsException | NullPointerException | NumberFormatException nfe) {
                throw this.createParsingException(nfe);
            }
        }
        if (xbQuantityRange.isSetConstraint()) {
            LOGGER.error("Decoding of swe:QuantityRange/swe:constraint is not implemented");
        }
        if (xbQuantityRange.getQualityArray() != null && xbQuantityRange.getQualityArray().length > 0) {
            LOGGER.error("Decoding of swe:QuantityRange/swe:quality is not implemented");
        }
        return sosQuantityRange;
    }

    private DecodingException createParsingException(Exception e) {
        return new DecodingException((Throwable)e, "QuantityRange", "Error when parsing 'swe:QuantityRange/swe:value': It must be of type 'double double!", new Object[0]);
    }

    private SweText parseText(TextDocument.Text xbText) {
        SweText sosText = new SweText();
        if (xbText.isSetValue()) {
            sosText.setValue(xbText.getValue());
        }
        return sosText;
    }

    private SweTime parseTime(TimeDocument.Time time) throws DecodingException {
        SweTime sosTime = new SweTime();
        if (time.isSetValue()) {
            sosTime.setValue(DateTimeHelper.parseIsoString2DateTime((String)time.getValue().toString()));
        }
        if (time.getUom() != null) {
            sosTime.setUom(time.getUom().getHref());
        }
        return sosTime;
    }

    private SweTimeRange parseTimeRange(TimeRangeDocument.TimeRange timeRange) throws DecodingException {
        SweTimeRange sosTimeRange = new SweTimeRange();
        if (timeRange.isSetValue()) {
            RangeValue range = new RangeValue();
            Iterator iter = timeRange.getValue().iterator();
            if (iter.hasNext()) {
                range.setRangeStart((Object)DateTimeHelper.parseIsoString2DateTime((String)iter.next().toString()));
                while (iter.hasNext()) {
                    range.setRangeEnd((Object)DateTimeHelper.parseIsoString2DateTime((String)iter.next().toString()));
                }
            }
            sosTimeRange.setValue(range);
        }
        if (timeRange.getUom() != null) {
            sosTimeRange.setUom(timeRange.getUom().getHref());
        }
        return sosTimeRange;
    }

    private Referenceable<SweAllowedValues> parseConstraint(AllowedValuesPropertyType avpt) {
        if (avpt.isSetAllowedValues()) {
            return Referenceable.of((Object)this.parseAllowedValues(avpt.getAllowedValues()));
        }
        Reference ref = new Reference();
        if (avpt.isSetHref()) {
            ref.setHref(URI.create(avpt.getHref()));
        }
        if (avpt.isSetTitle()) {
            ref.setTitle(avpt.getTitle());
        }
        if (avpt.isSetActuate()) {
            ref.setActuate(avpt.getActuate().toString());
        }
        if (avpt.isSetArcrole()) {
            ref.setArcrole(avpt.getArcrole());
        }
        if (avpt.isSetRole()) {
            ref.setRole(avpt.getRole());
        }
        if (avpt.isSetShow()) {
            ref.setShow(avpt.getShow().toString());
        }
        if (avpt.isSetType()) {
            ref.setType(avpt.getType().toString());
        }
        return Referenceable.of((Reference)ref);
    }

    private Referenceable<SweAllowedTokens> parseConstraint(AllowedTokensPropertyType atpt) {
        if (atpt.isSetAllowedTokens()) {
            return Referenceable.of((Object)this.parseAllowedTokens(atpt.getAllowedTokens()));
        }
        Reference ref = new Reference();
        if (atpt.isSetHref()) {
            ref.setHref(URI.create(atpt.getHref()));
        }
        if (atpt.isSetTitle()) {
            ref.setTitle(atpt.getTitle());
        }
        if (atpt.isSetActuate()) {
            ref.setActuate(atpt.getActuate().toString());
        }
        if (atpt.isSetArcrole()) {
            ref.setArcrole(atpt.getArcrole());
        }
        if (atpt.isSetRole()) {
            ref.setRole(atpt.getRole());
        }
        if (atpt.isSetShow()) {
            ref.setShow(atpt.getShow().toString());
        }
        if (atpt.isSetType()) {
            ref.setType(atpt.getType().toString());
        }
        return Referenceable.of((Reference)ref);
    }

    private Referenceable<SweAllowedTimes> parseConstraint(AllowedTimesPropertyType atpt) throws DateTimeParseException {
        if (atpt.isSetAllowedTimes()) {
            return Referenceable.of((Object)this.parseAllowedTimes(atpt.getAllowedTimes()));
        }
        Reference ref = new Reference();
        if (atpt.isSetHref()) {
            ref.setHref(URI.create(atpt.getHref()));
        }
        if (atpt.isSetTitle()) {
            ref.setTitle(atpt.getTitle());
        }
        if (atpt.isSetActuate()) {
            ref.setActuate(atpt.getActuate().toString());
        }
        if (atpt.isSetArcrole()) {
            ref.setArcrole(atpt.getArcrole());
        }
        if (atpt.isSetRole()) {
            ref.setRole(atpt.getRole());
        }
        if (atpt.isSetShow()) {
            ref.setShow(atpt.getShow().toString());
        }
        if (atpt.isSetType()) {
            ref.setType(atpt.getType().toString());
        }
        return Referenceable.of((Reference)ref);
    }

    private SweAllowedValues parseAllowedValues(AllowedValuesDocument.AllowedValues avt) {
        SweAllowedValues allowedValues = new SweAllowedValues();
        if (avt.isSetId()) {
            allowedValues.setGmlId(avt.getId());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])avt.getValueListArray())) {
            for (List list : avt.getValueListArray()) {
                if (!CollectionHelper.isNotEmpty((Collection)list)) continue;
                for (Object value : list) {
                    allowedValues.addValue(Double.parseDouble(value.toString()));
                }
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])avt.getIntervalArray())) {
            for (List interval : avt.getIntervalArray()) {
                RangeValue rangeValue = new RangeValue();
                Iterator iterator = interval.iterator();
                if (iterator.hasNext()) {
                    rangeValue.setRangeStart(iterator.next());
                }
                if (iterator.hasNext()) {
                    rangeValue.setRangeEnd(iterator.next());
                }
                allowedValues.addInterval(rangeValue);
            }
        }
        return allowedValues;
    }

    private SweAllowedTokens parseAllowedTokens(AllowedTokensDocument.AllowedTokens att) {
        SweAllowedTokens allowedTokens = new SweAllowedTokens();
        if (att.isSetId()) {
            allowedTokens.setGmlId(att.getId());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])att.getValueListArray())) {
            for (List list : att.getValueListArray()) {
                if (!CollectionHelper.isNotEmpty((Collection)list)) continue;
                allowedTokens.setValue(list);
            }
        }
        return allowedTokens;
    }

    private SweAllowedTimes parseAllowedTimes(AllowedTimesDocument.AllowedTimes att) throws DateTimeParseException {
        SweAllowedTimes allowedTimes = new SweAllowedTimes();
        if (att.isSetId()) {
            allowedTimes.setGmlId(att.getId());
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])att.getValueListArray())) {
            for (List list : att.getValueListArray()) {
                if (!CollectionHelper.isNotEmpty((Collection)list)) continue;
                for (Object value : list) {
                    allowedTimes.addValue(DateTimeHelper.parseIsoString2DateTime((String)value.toString()));
                }
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])att.getIntervalArray())) {
            for (List interval : att.getIntervalArray()) {
                RangeValue rangeValue = new RangeValue();
                Iterator iterator = interval.iterator();
                if (iterator.hasNext()) {
                    rangeValue.setRangeStart((Object)DateTimeHelper.parseIsoString2DateTime((String)iterator.next().toString()));
                }
                if (iterator.hasNext()) {
                    rangeValue.setRangeEnd((Object)DateTimeHelper.parseIsoString2DateTime((String)iterator.next().toString()));
                }
                allowedTimes.addInterval(rangeValue);
            }
        }
        return allowedTimes;
    }

    private Collection<SweQuality> parseQuality(QualityPropertyType ... qualityArray) throws DecodingException {
        if (qualityArray != null && qualityArray.length > 0) {
            ArrayList<SweQuality> sosQualities = new ArrayList<SweQuality>(qualityArray.length);
            for (QualityPropertyType quality : qualityArray) {
                this.parseQualityPropertyType(quality).ifPresent(sosQualities::add);
            }
            return sosQualities;
        }
        return Collections.emptyList();
    }

    private SmlPosition parsePosition(PositionType position) throws DecodingException {
        SmlPosition sosSMLPosition = new SmlPosition();
        if (position.isSetReferenceFrame()) {
            sosSMLPosition.setReferenceFrame(position.getReferenceFrame());
        }
        if (position.isSetLocation() && position.getLocation().isSetVector()) {
            if (position.getLocation().getVector().isSetReferenceFrame()) {
                sosSMLPosition.setReferenceFrame(position.getLocation().getVector().getReferenceFrame());
            }
            sosSMLPosition.setPosition(this.parseCoordinates(position.getLocation().getVector().getCoordinateArray()));
        }
        return sosSMLPosition;
    }

    private List<SweCoordinate<?>> parseCoordinates(VectorType.Coordinate[] coordinateArray) throws DecodingException {
        ArrayList sosCoordinates = new ArrayList(coordinateArray.length);
        for (VectorType.Coordinate xbCoordinate : coordinateArray) {
            if (!xbCoordinate.isSetQuantity()) {
                throw new DecodingException("Position", "Error when parsing the Coordinates of Position: It must be of type Quantity!", new Object[0]);
            }
            sosCoordinates.add(new SweCoordinate(xbCoordinate.getName(), (SweAbstractSimpleType)this.parseQuantity(xbCoordinate.getQuantity())));
        }
        return sosCoordinates;
    }

    private List<SweField> parseAnyScalarPropertyArray(AnyScalarPropertyType[] fieldArray) throws DecodingException {
        ArrayList<SweField> sosFields = new ArrayList<SweField>(fieldArray.length);
        for (AnyScalarPropertyType xbField : fieldArray) {
            sosFields.add(new SweField(xbField.getName(), this.parseAnyScalarProperty(xbField)));
        }
        return sosFields;
    }

    private SweCount parseElementCount(AbstractDataArrayType.ElementCount elementCount) throws DecodingException {
        if (elementCount.isSetCount()) {
            return this.parseCount(elementCount.getCount());
        }
        return null;
    }

    private SweAbstractEncoding parseEncoding(BlockEncodingPropertyType abstractEncodingType) throws DecodingException {
        if (abstractEncodingType.isSetTextBlock()) {
            return this.parseTextEncoding(abstractEncodingType.getTextBlock());
        }
        throw new NotYetSupportedDecodingException("encodingType", (Object)abstractEncodingType, new Object[]{TextBlockDocument.TextBlock.type.getName()});
    }

    private SweTextEncoding parseTextEncoding(TextBlockDocument.TextBlock textEncoding) {
        SweTextEncoding sosTextEncoding = new SweTextEncoding();
        sosTextEncoding.setBlockSeparator(textEncoding.getBlockSeparator());
        sosTextEncoding.setTokenSeparator(textEncoding.getTokenSeparator());
        sosTextEncoding.setDecimalSeparator(textEncoding.getDecimalSeparator());
        return sosTextEncoding;
    }

    private SweAbstractDataComponent parseAnyScalarProperty(AnyScalarPropertyType xbField) throws DecodingException {
        if (xbField.isSetBoolean()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getBoolean());
        }
        if (xbField.isSetCategory()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getCategory());
        }
        if (xbField.isSetCount()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getCount());
        }
        if (xbField.isSetQuantity()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getQuantity());
        }
        if (xbField.isSetText()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getText());
        }
        if (xbField.isSetTime()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getTime());
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)xbField);
    }

    private SweAbstractDataComponent parseDataComponentProperty(DataComponentPropertyType xbField) throws DecodingException {
        if (xbField.isSetBoolean()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getBoolean());
        }
        if (xbField.isSetCategory()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getCategory());
        }
        if (xbField.isSetCount()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getCount());
        }
        if (xbField.isSetCountRange()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getCountRange());
        }
        if (xbField.isSetQuantity()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getQuantity());
        }
        if (xbField.isSetQuantityRange()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getQuantityRange());
        }
        if (xbField.isSetText()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getText());
        }
        if (xbField.isSetTime()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getTime());
        }
        if (xbField.isSetTimeRange()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getTimeRange());
        }
        if (xbField.isSetAbstractDataRecord()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getAbstractDataRecord());
        }
        if (xbField.isSetAbstractDataArray1()) {
            return this.parseAbstractDataComponentType((AbstractDataComponentType)xbField.getAbstractDataArray1());
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, (XmlObject)xbField);
    }

    private Optional<SweQuality> parseQualityPropertyType(QualityPropertyType quality) throws DecodingException {
        if (quality.isSetQuantity()) {
            return Optional.of(this.parseQuantity(quality.getQuantity()));
        }
        if (quality.isSetQuantityRange()) {
            return Optional.of(this.parseQuantityRange(quality.getQuantityRange()));
        }
        if (quality.isSetCategory()) {
            return Optional.of(this.parseCategory(quality.getCategory()));
        }
        if (quality.isSetText()) {
            return Optional.of(this.parseText(quality.getText()));
        }
        return Optional.empty();
    }
}

