/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import eu.europa.ec.inspire.schemas.omso.x30.CategoricalTimeLocationValueTripleType;
import eu.europa.ec.inspire.schemas.omso.x30.MeasurementTimeLocationValueTripleType;
import java.math.BigDecimal;
import java.util.Map;
import net.opengis.waterml.x20.TimeValuePairType;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.TimeLocationValueTriple;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.CountValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.ogc.swe.simpleType.SweCategory;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractTimeLocationValueTripleTypeEncoder<T>
extends AbstractXmlEncoder<T, TimeLocationValueTriple> {
    private static final String MISSING = "missing";

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        super.addNamespacePrefixToMap(nameSpacePrefixMap);
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/base/3.3", "base");
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/omor/3.0", "omor");
        nameSpacePrefixMap.put("http://inspire.ec.europa.eu/schemas/omso/3.0", "omso");
    }

    protected TimeValuePairType encodeTimeLocationValueTriple(TimeLocationValueTriple timeLocationValueTriple) throws EncodingException {
        if (timeLocationValueTriple.getValue() instanceof QuantityValue || timeLocationValueTriple.getValue() instanceof CountValue) {
            return this.createMeasurementTimeLocationValueTripleType(timeLocationValueTriple);
        }
        if (timeLocationValueTriple.getValue() instanceof CategoryValue) {
            return this.createCategoricalTimeLocationValueTripleType(timeLocationValueTriple);
        }
        return null;
    }

    private TimeValuePairType createMeasurementTimeLocationValueTripleType(TimeLocationValueTriple timeLocationValueTriple) throws EncodingException {
        CountValue countValue;
        MeasurementTimeLocationValueTripleType mtlvtt = MeasurementTimeLocationValueTripleType.Factory.newInstance();
        mtlvtt.addNewTime().setStringValue(this.getTimeString(timeLocationValueTriple.getTime()));
        mtlvtt.addNewLocation().addNewPoint().set(this.encodeGML(timeLocationValueTriple.getLocation()));
        String value = null;
        if (timeLocationValueTriple.getValue() instanceof QuantityValue) {
            QuantityValue quantityValue = (QuantityValue)timeLocationValueTriple.getValue();
            if (!quantityValue.getValue().equals(BigDecimal.valueOf(Double.NaN))) {
                value = Double.toString(quantityValue.getValue().doubleValue());
            }
        } else if (timeLocationValueTriple.getValue() instanceof CountValue && (countValue = (CountValue)timeLocationValueTriple.getValue()).getValue() != null) {
            value = Integer.toString(countValue.getValue());
        }
        if (value != null && !value.isEmpty()) {
            mtlvtt.addNewValue().setStringValue(value);
        } else {
            mtlvtt.addNewValue().setNil();
            mtlvtt.addNewMetadata().addNewTVPMeasurementMetadata().addNewNilReason().setNilReason((Object)MISSING);
        }
        return mtlvtt;
    }

    private TimeValuePairType createCategoricalTimeLocationValueTripleType(TimeLocationValueTriple timeLocationValueTriple) throws EncodingException {
        CategoricalTimeLocationValueTripleType ctlvtt = CategoricalTimeLocationValueTripleType.Factory.newInstance();
        ctlvtt.addNewTime().setStringValue(this.getTimeString(timeLocationValueTriple.getTime()));
        ctlvtt.addNewLocation().addNewPoint().set(this.encodeGML(timeLocationValueTriple.getLocation()));
        if (timeLocationValueTriple.getValue() instanceof CategoryValue) {
            CategoryValue categoryValue = (CategoryValue)timeLocationValueTriple.getValue();
            if (categoryValue.isSetValue()) {
                ctlvtt.addNewValue().addNewCategory().set(this.encodeSweCommon(this.convertToSweCategory(categoryValue)));
            } else {
                ctlvtt.addNewValue().setNil();
                ctlvtt.addNewMetadata().addNewTVPMetadata().addNewNilReason().setNilReason((Object)MISSING);
            }
        }
        return ctlvtt;
    }

    private SweCategory convertToSweCategory(CategoryValue categoryValue) {
        SweCategory sweCategory = new SweCategory();
        sweCategory.setValue(categoryValue.getValue());
        sweCategory.setCodeSpace(categoryValue.getUnit());
        return sweCategory;
    }

    protected String getTimeString(Time time) throws DateTimeFormatException {
        DateTime dateTime = this.getTime(time);
        return DateTimeHelper.formatDateTime2String((DateTime)dateTime, (Time.TimeFormat)time.getTimeFormat());
    }

    private DateTime getTime(Time time) {
        if (time instanceof TimeInstant) {
            return ((TimeInstant)time).getValue();
        }
        if (time instanceof TimePeriod) {
            TimePeriod timePeriod = (TimePeriod)time;
            if (timePeriod.getEnd() != null) {
                return timePeriod.getEnd();
            }
            return timePeriod.getStart();
        }
        return new DateTime().minusYears(1000);
    }

    protected XmlObject encodeGML(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o);
    }

    protected XmlObject encodeGML(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", o, ec);
    }

    protected XmlObject encodeSweCommon(Object o) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o);
    }

    protected XmlObject encodeSweCommon(Object o, EncodingContext ec) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/swe/2.0", o, ec);
    }
}

