/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.xml.namespace.QName;
import net.opengis.gml.AbstractRingPropertyType;
import net.opengis.gml.AbstractRingType;
import net.opengis.gml.CodeType;
import net.opengis.gml.DirectPositionListType;
import net.opengis.gml.DirectPositionType;
import net.opengis.gml.EnvelopeType;
import net.opengis.gml.FeatureCollectionDocument2;
import net.opengis.gml.FeatureCollectionType;
import net.opengis.gml.FeaturePropertyType;
import net.opengis.gml.LineStringType;
import net.opengis.gml.LinearRingType;
import net.opengis.gml.MeasureType;
import net.opengis.gml.PointType;
import net.opengis.gml.PolygonType;
import net.opengis.gml.ReferenceType;
import net.opengis.gml.TimeIndeterminateValueType;
import net.opengis.gml.TimeInstantDocument;
import net.opengis.gml.TimeInstantType;
import net.opengis.gml.TimePeriodDocument;
import net.opengis.gml.TimePeriodType;
import net.opengis.gml.TimePositionType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlRuntimeException;
import org.apache.xmlbeans.impl.values.XmlValueDisconnectedException;
import org.joda.time.DateTime;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.shetland.ogc.HasDefaultEncoding;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.GenericMetaData;
import org.n52.shetland.ogc.gml.GmlConstants;
import org.n52.shetland.ogc.gml.time.IndeterminateValue;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.gml.time.TimePosition;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.om.features.samplingFeatures.SamplingFeature;
import org.n52.shetland.ogc.om.values.CategoryValue;
import org.n52.shetland.ogc.om.values.QuantityValue;
import org.n52.shetland.util.CRSHelper;
import org.n52.shetland.util.DateTimeFormatException;
import org.n52.shetland.util.DateTimeHelper;
import org.n52.shetland.util.EnvelopeOrGeometry;
import org.n52.shetland.util.JTSHelper;
import org.n52.shetland.util.JavaHelper;
import org.n52.shetland.util.MinMax;
import org.n52.shetland.util.ReferencedEnvelope;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class GmlEncoderv311
extends AbstractXmlEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(GmlEncoderv311.class);
    private static final Set<EncoderKey> ENCODER_KEYS = CodingHelper.encoderKeysForElements((String)"http://www.opengis.net/gml", (Class[])new Class[]{Time.class, Geometry.class, CategoryValue.class, org.n52.shetland.ogc.gml.ReferenceType.class, QuantityValue.class, CodeWithAuthority.class, org.n52.shetland.ogc.gml.CodeType.class, AbstractFeature.class, ReferencedEnvelope.class, EnvelopeOrGeometry.class});
    private String srsNamePrefix;

    public GmlEncoderv311() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEYS));
    }

    @Setting(value="coding.srsNamePrefixURN")
    public void setSrsNamePrefix(String prefix) {
        this.srsNamePrefix = CRSHelper.asUrnPrefix((String)prefix);
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEYS);
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://www.opengis.net/gml", "gml");
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{GmlConstants.GML_311_SCHEMAL_LOCATION});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XmlObject encode(Object element, EncodingContext ctx) throws EncodingException {
        XmlObject encodedObject = null;
        if (element instanceof Time) {
            encodedObject = this.createTime((Time)element, ctx);
        } else if (element instanceof Geometry) {
            encodedObject = this.createPosition((Geometry)element, ctx.get((Enum)XmlBeansEncodingFlags.GMLID));
        } else if (element instanceof CategoryValue) {
            encodedObject = this.createReferenceTypeForCategroyValue((CategoryValue)element);
        } else if (element instanceof org.n52.shetland.ogc.gml.ReferenceType) {
            encodedObject = this.createReferencType((org.n52.shetland.ogc.gml.ReferenceType)element);
        } else if (element instanceof CodeWithAuthority) {
            encodedObject = this.createCodeWithAuthorityType((CodeWithAuthority)element);
        } else if (element instanceof QuantityValue) {
            encodedObject = this.createMeasureType((QuantityValue)element);
        } else if (element instanceof org.n52.shetland.ogc.gml.CodeType) {
            encodedObject = this.createCodeType((org.n52.shetland.ogc.gml.CodeType)element);
        } else if (element instanceof AbstractFeature) {
            encodedObject = this.createFeature((AbstractFeature)element);
        } else if (element instanceof ReferencedEnvelope) {
            encodedObject = this.createEnvelope((ReferencedEnvelope)element);
        } else if (element instanceof EnvelopeOrGeometry) {
            EnvelopeOrGeometry geom = (EnvelopeOrGeometry)element;
            if (geom.getGeometry().isPresent()) {
                encodedObject = this.createPosition((Geometry)geom.getGeometry().get(), ctx.get((Enum)XmlBeansEncodingFlags.GMLID));
            } else {
                if (!geom.getEnvelope().isPresent()) throw new UnsupportedEncoderInputException((Encoder)this, element);
                encodedObject = this.createEnvelope((ReferencedEnvelope)geom.getEnvelope().get());
            }
        } else {
            if (!(element instanceof GenericMetaData)) throw new UnsupportedEncoderInputException((Encoder)this, element);
            encodedObject = this.createGenericMetaData((GenericMetaData)element, ctx);
        }
        XmlHelper.validateDocument((XmlObject)encodedObject, EncodingException::new);
        return encodedObject;
    }

    private XmlObject createTime(Time time, EncodingContext ctx) throws EncodingException {
        if (time != null) {
            if (time instanceof TimeInstant) {
                if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                    return this.createTimeInstantDocument((TimeInstant)time);
                }
                return this.createTimeInstantType((TimeInstant)time, null);
            }
            if (time instanceof TimePeriod) {
                if (ctx.has((Enum)XmlBeansEncodingFlags.DOCUMENT)) {
                    return this.createTimePeriodDocument((TimePeriod)time);
                }
                return this.createTimePeriodType((TimePeriod)time, null);
            }
            throw new UnsupportedEncoderInputException((Encoder)this, (Object)time);
        }
        return null;
    }

    private XmlObject createTimePeriodDocument(TimePeriod time) throws EncodingException {
        TimePeriodDocument timePeriodDoc = TimePeriodDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimePeriodType(time, timePeriodDoc.addNewTimePeriod());
        return timePeriodDoc;
    }

    private TimePeriodType createTimePeriodType(TimePeriod timePeriod, TimePeriodType timePeriodType) throws EncodingException {
        try {
            TimePeriodType tpt = timePeriodType == null ? TimePeriodType.Factory.newInstance((XmlOptions)this.getXmlOptions()) : timePeriodType;
            if (timePeriod.getGmlId() != null && !timePeriod.getGmlId().isEmpty()) {
                tpt.setId(timePeriod.getGmlId());
            }
            tpt.setBeginPosition(this.createTimePositionType(timePeriod.getStartTimePosition()));
            tpt.setEndPosition(this.createTimePositionType(timePeriod.getEndTimePosition()));
            return tpt;
        }
        catch (XmlRuntimeException | XmlValueDisconnectedException x) {
            throw new EncodingException("Error while creating TimePeriod!", x);
        }
    }

    private XmlObject createTimeInstantDocument(TimeInstant time) {
        TimeInstantDocument timeInstantDoc = TimeInstantDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        this.createTimeInstantType(time, timeInstantDoc.addNewTimeInstant());
        return timeInstantDoc;
    }

    private TimeInstantType createTimeInstantType(TimeInstant timeInstant, TimeInstantType timeInstantType) {
        TimeInstantType tit = timeInstantType == null ? TimeInstantType.Factory.newInstance((XmlOptions)this.getXmlOptions()) : timeInstantType;
        if (timeInstant.isSetGmlId()) {
            tit.setId(timeInstant.getGmlId());
        }
        tit.setTimePosition(this.createTimePositionType(timeInstant.getTimePosition()));
        return tit;
    }

    private TimePositionType createTimePositionType(TimePosition timePosition) throws DateTimeFormatException {
        TimePositionType xbTimePosition = TimePositionType.Factory.newInstance();
        if (!timePosition.isSetTime()) {
            if (timePosition.isSetIndeterminateValue()) {
                xbTimePosition.setIndeterminatePosition(TimeIndeterminateValueType.Enum.forString((String)timePosition.getIndeterminateValue().getValue()));
            } else {
                xbTimePosition.setIndeterminatePosition(TimeIndeterminateValueType.Enum.forString((String)IndeterminateValue.UNKNOWN.getValue()));
            }
        } else {
            String endString = DateTimeHelper.formatDateTime2String((DateTime)timePosition.getTime(), (Time.TimeFormat)timePosition.getTimeFormat());
            xbTimePosition.setStringValue(endString);
        }
        return xbTimePosition;
    }

    private XmlObject createPosition(Geometry geom, Optional<Object> optional) throws UnsupportedEncoderInputException {
        String gmlId;
        String string = gmlId = optional != null && optional.isPresent() && optional.get() instanceof String ? (String)optional.get() : null;
        if (geom instanceof Point) {
            PointType xbPoint = PointType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (gmlId != null) {
                xbPoint.setId(geom.getGeometryType() + "_" + gmlId);
            }
            this.createPointFromJtsGeometry((Point)geom, xbPoint);
            return xbPoint;
        }
        if (geom instanceof LineString) {
            LineStringType xbLineString = LineStringType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (gmlId != null) {
                xbLineString.setId(geom.getGeometryType() + "_" + gmlId);
            }
            this.createLineStringFromJtsGeometry((LineString)geom, xbLineString);
            return xbLineString;
        }
        if (geom instanceof Polygon) {
            PolygonType xbPolygon = PolygonType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            if (gmlId != null) {
                xbPolygon.setId(geom.getGeometryType() + "_" + gmlId);
            }
            this.createPolygonFromJtsGeometry((Polygon)geom, xbPolygon);
            return xbPolygon;
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)geom);
    }

    private void createPointFromJtsGeometry(Point jtsPoint, PointType xbPoint) {
        DirectPositionType xbPos = xbPoint.addNewPos();
        xbPos.setSrsName(this.getSrsName((Geometry)jtsPoint));
        xbPos.setStringValue(JTSHelper.getCoordinatesString((Geometry)jtsPoint));
    }

    private void createLineStringFromJtsGeometry(LineString jtsLineString, LineStringType xbLst) {
        DirectPositionListType xbPosList = xbLst.addNewPosList();
        xbPosList.setSrsName(this.getSrsName((Geometry)jtsLineString));
        xbPosList.setStringValue(JTSHelper.getCoordinatesString((Geometry)jtsLineString));
    }

    private void createPolygonFromJtsGeometry(Polygon jtsPolygon, PolygonType xbPolType) {
        List jtsPolygons = PolygonExtracter.getPolygons((Geometry)jtsPolygon);
        for (int i = 0; i < jtsPolygons.size(); ++i) {
            Polygon pol = (Polygon)jtsPolygons.get(i);
            AbstractRingPropertyType xbArpt = xbPolType.addNewExterior();
            AbstractRingType xbArt = xbArpt.addNewRing();
            LinearRingType xbLrt = LinearRingType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            LineString ring = pol.getExteriorRing();
            String coords = JTSHelper.getCoordinatesString((Geometry)ring);
            DirectPositionListType xbPosList = xbLrt.addNewPosList();
            xbPosList.setSrsName(this.getSrsName((Geometry)jtsPolygon));
            xbPosList.setStringValue(coords);
            xbArt.set((XmlObject)xbLrt);
            XmlCursor cursor = xbArpt.newCursor();
            if (cursor.toChild(GmlConstants.QN_ABSTRACT_RING)) {
                cursor.setName(GmlConstants.QN_LINEAR_RING);
            }
            int numberOfInteriorRings = pol.getNumInteriorRing();
            for (int ringNumber = 0; ringNumber < numberOfInteriorRings; ++ringNumber) {
                xbArpt = xbPolType.addNewInterior();
                xbArt = xbArpt.addNewRing();
                xbLrt = LinearRingType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                ring = pol.getInteriorRingN(ringNumber);
                xbPosList = xbLrt.addNewPosList();
                xbPosList.setSrsName(this.getSrsName((Geometry)jtsPolygon));
                xbPosList.setStringValue(JTSHelper.getCoordinatesString((Geometry)ring));
                xbArt.set((XmlObject)xbLrt);
                cursor = xbArpt.newCursor();
                if (!cursor.toChild(GmlConstants.QN_ABSTRACT_RING)) continue;
                cursor.setName(GmlConstants.QN_LINEAR_RING);
            }
        }
    }

    private XmlObject createReferenceTypeForCategroyValue(CategoryValue categoryValue) {
        ReferenceType xbRef = ReferenceType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (categoryValue.getValue() != null && !categoryValue.getValue().isEmpty()) {
            if (categoryValue.getValue().startsWith("http://")) {
                xbRef.setHref(categoryValue.getValue());
            } else {
                xbRef.setTitle(categoryValue.getValue());
            }
        } else {
            xbRef.setNil();
        }
        return xbRef;
    }

    private XmlObject createReferencType(org.n52.shetland.ogc.gml.ReferenceType sosReferenceType) {
        if (sosReferenceType.isSetHref()) {
            ReferenceType referenceType = ReferenceType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            referenceType.setHref(sosReferenceType.getHref());
            if (sosReferenceType.isSetTitle()) {
                referenceType.setTitle(sosReferenceType.getTitle());
            }
            if (sosReferenceType.isSetRole()) {
                referenceType.setRole(sosReferenceType.getRole());
            }
            return referenceType;
        }
        return null;
    }

    private XmlObject createCodeWithAuthorityType(CodeWithAuthority sosCodeWithAuthority) {
        if (sosCodeWithAuthority.isSetValue()) {
            CodeType codeType = CodeType.Factory.newInstance((XmlOptions)this.getXmlOptions());
            String value = sosCodeWithAuthority.getValue();
            codeType.setStringValue(value);
            codeType.setCodeSpace(sosCodeWithAuthority.getCodeSpace());
            return codeType;
        }
        return null;
    }

    private XmlObject createCodeType(org.n52.shetland.ogc.gml.CodeType sosCodeType) {
        CodeType codeType = CodeType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (sosCodeType.isSetCodeSpace()) {
            codeType.setCodeSpace(sosCodeType.getCodeSpace().toString());
        }
        codeType.setStringValue(sosCodeType.getValue());
        return codeType;
    }

    protected XmlObject createMeasureType(QuantityValue quantityValue) {
        MeasureType measureType = MeasureType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        if (quantityValue.getUnit() != null) {
            measureType.setUom(quantityValue.getUnit());
        } else {
            measureType.setUom("");
        }
        if (quantityValue.getValue() != null) {
            measureType.setDoubleValue(quantityValue.getValue().doubleValue());
        } else {
            measureType.setNil();
        }
        return measureType;
    }

    private XmlObject createFeature(AbstractFeature sosAbstractFeature) throws EncodingException {
        if (sosAbstractFeature instanceof SamplingFeature) {
            SamplingFeature sampFeat = (SamplingFeature)sosAbstractFeature;
            if (sosAbstractFeature.isSetGmlID()) {
                FeaturePropertyType featureProperty = FeaturePropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                featureProperty.setHref("#" + sosAbstractFeature.getGmlId());
                return featureProperty;
            }
            if (!sampFeat.isSetGeometry()) {
                FeaturePropertyType featureProperty = FeaturePropertyType.Factory.newInstance((XmlOptions)this.getXmlOptions());
                featureProperty.setHref(sosAbstractFeature.getIdentifierCodeWithAuthority().getValue());
                if (sampFeat.isSetName()) {
                    featureProperty.setTitle(sampFeat.getFirstName().getValue());
                }
                return featureProperty;
            }
            StringBuilder builder = new StringBuilder();
            builder.append("sf_");
            builder.append(JavaHelper.generateID((String)sosAbstractFeature.getIdentifierCodeWithAuthority().getValue()));
            sosAbstractFeature.setGmlId(builder.toString());
            Encoder<XmlObject, SamplingFeature> encoder = this.getEncoder("http://www.opengis.net/sampling/1.0", sampFeat);
            return (XmlObject)encoder.encode((Object)sampFeat);
        }
        if (sosAbstractFeature instanceof FeatureCollection) {
            return this.createFeatureCollection((FeatureCollection)sosAbstractFeature);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, (Object)sosAbstractFeature);
    }

    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH"})
    private XmlObject createFeatureCollection(FeatureCollection sosFeatureCollection) throws EncodingException {
        Map members = sosFeatureCollection.getMembers();
        FeatureCollectionDocument2 xmlObject = null;
        if (sosFeatureCollection.isSetMembers()) {
            if (members.size() == 1) {
                Iterator iterator = members.entrySet().iterator();
                if (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String member = (String)entry.getKey();
                    if (members.get(member) instanceof SamplingFeature) {
                        return this.createFeature((AbstractFeature)((SamplingFeature)members.get(member)));
                    }
                    throw GmlEncoderv311.missingFeatureEncoder();
                }
            } else {
                FeatureCollectionDocument2 xbFeatureColllectionDoc = FeatureCollectionDocument2.Factory.newInstance((XmlOptions)this.getXmlOptions());
                FeatureCollectionType xbFeatCol = xbFeatureColllectionDoc.addNewFeatureCollection();
                StringBuilder builder = new StringBuilder();
                builder.append("sfc_");
                builder.append(JavaHelper.generateID((String)Long.toString(System.currentTimeMillis())));
                xbFeatCol.setId(builder.toString());
                for (Map.Entry entry : members.entrySet()) {
                    String member = (String)entry.getKey();
                    if (members.get(member) instanceof SamplingFeature) {
                        XmlObject xmlFeature = this.createFeature((AbstractFeature)((SamplingFeature)members.get(member)));
                        xbFeatCol.addNewFeatureMember().set(xmlFeature);
                        continue;
                    }
                    throw GmlEncoderv311.missingFeatureEncoder();
                }
                xmlObject = xbFeatureColllectionDoc;
            }
        } else {
            FeatureCollectionDocument2 xbFeatColDoc = FeatureCollectionDocument2.Factory.newInstance((XmlOptions)this.getXmlOptions());
            xbFeatColDoc.addNewFeatureCollection();
            xmlObject = xbFeatColDoc;
        }
        XmlCursor cursor = xmlObject.newCursor();
        boolean isAFC = cursor.toChild(new QName("http://www.opengis.net/gml", "_FeatureCollection"));
        if (isAFC) {
            cursor.setName(new QName("http://www.opengis.net/gml", "FeatureCollection"));
        }
        cursor.dispose();
        return xmlObject;
    }

    private XmlObject createEnvelope(ReferencedEnvelope sosEnvelope) {
        EnvelopeType envelopeType = EnvelopeType.Factory.newInstance((XmlOptions)this.getXmlOptions());
        MinMax minmax = sosEnvelope.getMinMaxFromEnvelope();
        envelopeType.addNewLowerCorner().setStringValue((String)minmax.getMinimum());
        envelopeType.addNewUpperCorner().setStringValue((String)minmax.getMaximum());
        envelopeType.setSrsName(this.srsNamePrefix + sosEnvelope.getSrid());
        return envelopeType;
    }

    protected String getSrsName(Geometry geom) {
        return this.srsNamePrefix + geom.getSRID();
    }

    private XmlObject createGenericMetaData(GenericMetaData element, EncodingContext context) throws EncodingException {
        if (element.getContent() instanceof HasDefaultEncoding && ((HasDefaultEncoding)element.getContent()).isSetDefaultElementEncoding()) {
            EncodingContext ec = EncodingContext.of((Enum)XmlBeansEncodingFlags.DOCUMENT, (Object)true);
            if ("http://www.opengis.net/swe/2.0".equals(((HasDefaultEncoding)element.getContent()).getDefaultElementEncoding())) {
                return this.encodeObjectToXml("http://www.opengis.net/swe/1.0.1", element.getContent(), ec);
            }
            return this.encodeObjectToXml(((HasDefaultEncoding)element.getContent()).getDefaultElementEncoding(), element.getContent(), ec);
        }
        return null;
    }

    private static EncodingException missingFeatureEncoder() {
        return new EncodingException("No encoder found for featuretype", new Object[0]);
    }
}

