/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import java.util.SortedSet;
import net.opengis.ogc.ComparisonOperatorType;
import net.opengis.ogc.ComparisonOperatorsType;
import net.opengis.ogc.GeometryOperandsType;
import net.opengis.ogc.IdCapabilitiesType;
import net.opengis.ogc.ScalarCapabilitiesType;
import net.opengis.ogc.SpatialCapabilitiesType;
import net.opengis.ogc.SpatialOperatorNameType;
import net.opengis.ogc.SpatialOperatorType;
import net.opengis.ogc.SpatialOperatorsType;
import net.opengis.ogc.TemporalCapabilitiesType;
import net.opengis.ogc.TemporalOperandsType;
import net.opengis.ogc.TemporalOperatorNameType;
import net.opengis.ogc.TemporalOperatorType;
import net.opengis.ogc.TemporalOperatorsType;
import net.opengis.sos.x10.CapabilitiesDocument;
import net.opengis.sos.x10.ContentsDocument;
import net.opengis.sos.x10.FilterCapabilitiesDocument;
import net.opengis.sos.x10.ObservationOfferingType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.n52.janmayen.NcName;
import org.n52.shetland.ogc.filter.FilterCapabilities;
import org.n52.shetland.ogc.filter.FilterConstants;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesResponse;
import org.n52.shetland.ogc.sos.Sos1Constants;
import org.n52.shetland.ogc.sos.SosCapabilities;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosObservationOffering;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.svalbard.encode.AbstractSosV1ResponseEncoder;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.util.N52XmlHelper;

public class SosV1GetCapabilitiesResponseEncoder
extends AbstractSosV1ResponseEncoder<GetCapabilitiesResponse> {
    public SosV1GetCapabilitiesResponseEncoder() {
        super(SosConstants.Operations.GetCapabilities.name(), GetCapabilitiesResponse.class);
    }

    @Override
    protected Set<SchemaLocation> getConcreteSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{Sos1Constants.GET_CAPABILITIES_SOS1_SCHEMA_LOCATION});
    }

    @Override
    protected XmlObject create(GetCapabilitiesResponse response) throws EncodingException {
        CapabilitiesDocument xbCapsDoc = CapabilitiesDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        CapabilitiesDocument.Capabilities xbCaps = xbCapsDoc.addNewCapabilities();
        xbCaps.setVersion(response.getVersion());
        SosCapabilities sosCapabilities = (SosCapabilities)response.getCapabilities();
        if (sosCapabilities.getServiceIdentification().isPresent()) {
            xbCaps.addNewServiceIdentification().set(this.encodeObjectToXml("http://www.opengis.net/ows/1.1", sosCapabilities.getServiceIdentification().get()));
        }
        if (sosCapabilities.getServiceProvider().isPresent()) {
            xbCaps.addNewServiceProvider().set(this.encodeObjectToXml("http://www.opengis.net/ows/1.1", sosCapabilities.getServiceProvider().get()));
        }
        if (sosCapabilities.getOperationsMetadata().isPresent()) {
            xbCaps.addNewOperationsMetadata().set(this.encodeObjectToXml("http://www.opengis.net/ows/1.1", sosCapabilities.getOperationsMetadata().get()));
        }
        if (sosCapabilities.getFilterCapabilities().isPresent()) {
            this.setFilterCapabilities(xbCaps.addNewFilterCapabilities(), (FilterCapabilities)sosCapabilities.getFilterCapabilities().get());
        }
        if (sosCapabilities.getContents().isPresent()) {
            this.setContents(xbCaps.addNewContents(), (Collection)sosCapabilities.getContents().get(), response.getVersion());
        }
        N52XmlHelper.setSchemaLocationsToDocument((XmlObject)xbCapsDoc, (Collection)Sets.newHashSet((Object[])new SchemaLocation[]{N52XmlHelper.getSchemaLocationForSOS100()}));
        return xbCapsDoc;
    }

    protected void setFilterCapabilities(FilterCapabilitiesDocument.FilterCapabilities filterCapabilities, FilterCapabilities sosFilterCaps) {
        this.setScalarFilterCapabilities(filterCapabilities.addNewScalarCapabilities(), sosFilterCaps);
        this.setSpatialFilterCapabilities(filterCapabilities.addNewSpatialCapabilities(), sosFilterCaps);
        this.setTemporalFilterCapabilities(filterCapabilities.addNewTemporalCapabilities(), sosFilterCaps);
        this.setIdFilterCapabilities(filterCapabilities.addNewIdCapabilities());
    }

    protected void setContents(ContentsDocument.Contents xbContents, Collection<SosObservationOffering> offerings, String version) throws EncodingException {
        ContentsDocument.Contents.ObservationOfferingList xbObservationOfferings = xbContents.addNewObservationOfferingList();
        for (SosObservationOffering offering : offerings) {
            ObservationOfferingType xbObservationOffering = xbObservationOfferings.addNewObservationOffering();
            xbObservationOffering.setId(NcName.makeValid((String)offering.getOffering().getIdentifier()));
            if (offering.isSetObservedArea()) {
                xbObservationOffering.addNewBoundedBy().addNewEnvelope().set(this.encodeObjectToXml("http://www.opengis.net/gml", offering.getObservedArea()));
            }
            for (CodeType name : offering.getOffering().getName()) {
                xbObservationOffering.addNewName().set(this.encodeObjectToXml("http://www.opengis.net/gml", name));
            }
            if (offering.getPhenomenonTime() instanceof TimePeriod) {
                xbObservationOffering.addNewTime().set(this.encodeObjectToXml("http://www.opengis.net/swe/1.0.1", offering.getPhenomenonTime()));
            }
            offering.getObservableProperties().forEach(phenomenon -> xbObservationOffering.addNewObservedProperty().setHref(phenomenon));
            offering.getFeatureOfInterestTypes().forEach(featureOfInterestType -> xbObservationOffering.addNewFeatureOfInterest().setHref(featureOfInterestType));
            offering.getProcedureDescriptionFormats().forEach(procedureDescriptionFormat -> xbObservationOffering.addNewProcedure().setHref(procedureDescriptionFormat));
            offering.getProcedures().forEach(procedure -> xbObservationOffering.addNewProcedure().setHref(procedure));
            offering.getFeatureOfInterest().forEach(featureOfInterest -> xbObservationOffering.addNewFeatureOfInterest().setHref(featureOfInterest));
            offering.getResultModels().forEach(arg_0 -> ((ObservationOfferingType)xbObservationOffering).addResultModel(arg_0));
            offering.getResponseFormats().forEach(responseFormat -> xbObservationOffering.addNewResponseFormat().setStringValue(responseFormat));
            offering.getResponseModes().forEach(responseMode -> xbObservationOffering.addNewResponseMode().setStringValue(responseMode));
        }
    }

    protected void setIdFilterCapabilities(IdCapabilitiesType idCapabilities) {
        idCapabilities.addNewFID();
        idCapabilities.addNewEID();
    }

    protected void setSpatialFilterCapabilities(SpatialCapabilitiesType spatialCapabilities, FilterCapabilities sosFilterCaps) {
        if (!sosFilterCaps.getSpatialOperands().isEmpty()) {
            sosFilterCaps.getSpatialOperands().forEach(arg_0 -> ((GeometryOperandsType)spatialCapabilities.addNewGeometryOperands()).addGeometryOperand(arg_0));
        }
        if (!sosFilterCaps.getSpatialOperators().isEmpty()) {
            SpatialOperatorsType spatialOps = spatialCapabilities.addNewSpatialOperators();
            Set keys = sosFilterCaps.getSpatialOperators().keySet();
            keys.forEach(spatialOperator -> {
                SpatialOperatorType operator = spatialOps.addNewSpatialOperator();
                operator.setName(this.getEnum4SpatialOperator((FilterConstants.SpatialOperator)spatialOperator));
                GeometryOperandsType bboxGeomOps = operator.addNewGeometryOperands();
                ((SortedSet)sosFilterCaps.getSpatialOperators().get(spatialOperator)).forEach(arg_0 -> ((GeometryOperandsType)bboxGeomOps).addGeometryOperand(arg_0));
            });
        }
    }

    protected void setTemporalFilterCapabilities(TemporalCapabilitiesType temporalCapabilities, FilterCapabilities sosFilterCaps) {
        if (!sosFilterCaps.getTemporalOperands().isEmpty()) {
            TemporalOperandsType tempOperands = temporalCapabilities.addNewTemporalOperands();
            sosFilterCaps.getTemporalOperands().forEach(arg_0 -> ((TemporalOperandsType)tempOperands).addTemporalOperand(arg_0));
        }
        if (!sosFilterCaps.getTemporalOperators().isEmpty()) {
            TemporalOperatorsType temporalOps = temporalCapabilities.addNewTemporalOperators();
            sosFilterCaps.getTemporalOperators().forEach((operator, operands) -> {
                TemporalOperatorType xbOperator = temporalOps.addNewTemporalOperator();
                xbOperator.setName(this.getEnum4TemporalOperator((FilterConstants.TimeOperator)operator));
                TemporalOperandsType bboxGeomOps = xbOperator.addNewTemporalOperands();
                operands.forEach(arg_0 -> ((TemporalOperandsType)bboxGeomOps).addTemporalOperand(arg_0));
            });
        }
    }

    protected void setScalarFilterCapabilities(ScalarCapabilitiesType scalarCapabilities, FilterCapabilities sosFilterCaps) {
        if (!sosFilterCaps.getComparisonOperators().isEmpty()) {
            sosFilterCaps.getComparisonOperators().stream().map(this::getEnum4ComparisonOperator).forEachOrdered(arg_0 -> ((ComparisonOperatorsType)scalarCapabilities.addNewComparisonOperators()).addComparisonOperator(arg_0));
        }
    }

    protected SpatialOperatorNameType.Enum getEnum4SpatialOperator(FilterConstants.SpatialOperator spatialOperator) {
        switch (spatialOperator) {
            case BBOX: {
                return SpatialOperatorNameType.BBOX;
            }
            case Beyond: {
                return SpatialOperatorNameType.BEYOND;
            }
            case Contains: {
                return SpatialOperatorNameType.CONTAINS;
            }
            case Crosses: {
                return SpatialOperatorNameType.CROSSES;
            }
            case Disjoint: {
                return SpatialOperatorNameType.DISJOINT;
            }
            case DWithin: {
                return SpatialOperatorNameType.D_WITHIN;
            }
            case Equals: {
                return SpatialOperatorNameType.EQUALS;
            }
            case Intersects: {
                return SpatialOperatorNameType.INTERSECTS;
            }
            case Overlaps: {
                return SpatialOperatorNameType.OVERLAPS;
            }
            case Touches: {
                return SpatialOperatorNameType.TOUCHES;
            }
            case Within: {
                return SpatialOperatorNameType.WITHIN;
            }
        }
        return null;
    }

    protected TemporalOperatorNameType.Enum getEnum4TemporalOperator(FilterConstants.TimeOperator temporalOperator) {
        switch (temporalOperator) {
            case TM_After: {
                return TemporalOperatorNameType.TM_AFTER;
            }
            case TM_Before: {
                return TemporalOperatorNameType.TM_BEFORE;
            }
            case TM_Begins: {
                return TemporalOperatorNameType.TM_BEGINS;
            }
            case TM_BegunBy: {
                return TemporalOperatorNameType.TM_BEGUN_BY;
            }
            case TM_Contains: {
                return TemporalOperatorNameType.TM_CONTAINS;
            }
            case TM_During: {
                return TemporalOperatorNameType.TM_DURING;
            }
            case TM_EndedBy: {
                return TemporalOperatorNameType.TM_ENDED_BY;
            }
            case TM_Ends: {
                return TemporalOperatorNameType.TM_ENDS;
            }
            case TM_Equals: {
                return TemporalOperatorNameType.TM_EQUALS;
            }
            case TM_Meets: {
                return TemporalOperatorNameType.TM_MEETS;
            }
            case TM_MetBy: {
                return TemporalOperatorNameType.TM_MET_BY;
            }
            case TM_OverlappedBy: {
                return TemporalOperatorNameType.TM_OVERLAPPED_BY;
            }
            case TM_Overlaps: {
                return TemporalOperatorNameType.TM_OVERLAPS;
            }
        }
        return null;
    }

    protected ComparisonOperatorType.Enum getEnum4ComparisonOperator(FilterConstants.ComparisonOperator comparisonOperator) {
        switch (comparisonOperator) {
            case PropertyIsBetween: {
                return ComparisonOperatorType.BETWEEN;
            }
            case PropertyIsEqualTo: {
                return ComparisonOperatorType.EQUAL_TO;
            }
            case PropertyIsGreaterThan: {
                return ComparisonOperatorType.GREATER_THAN;
            }
            case PropertyIsGreaterThanOrEqualTo: {
                return ComparisonOperatorType.GREATER_THAN_EQUAL_TO;
            }
            case PropertyIsLessThan: {
                return ComparisonOperatorType.LESS_THAN;
            }
            case PropertyIsLessThanOrEqualTo: {
                return ComparisonOperatorType.LESS_THAN_EQUAL_TO;
            }
            case PropertyIsLike: {
                return ComparisonOperatorType.LIKE;
            }
            case PropertyIsNotEqualTo: {
                return ComparisonOperatorType.NOT_EQUAL_TO;
            }
            case PropertyIsNull: {
                return ComparisonOperatorType.NULL_CHECK;
            }
        }
        return null;
    }
}

