/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import net.opengis.drt.x10.DeleteResultTemplateDocument;
import net.opengis.drt.x10.DeleteResultTemplateType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.sos.drt.DeleteResultTemplateRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeleteResultTemplateDecoder
extends AbstractXmlDecoder<XmlObject, DeleteResultTemplateRequest> {
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/drt/1.0", (Class[])new Class[]{DeleteResultTemplateDocument.class}), CodingHelper.xmlDecoderKeysForOperation((String)"SOS", (String)"2.0.0", (String[])new String[]{"DeleteResultTemplate"})});
    private static final Logger LOGGER = LoggerFactory.getLogger(DeleteResultTemplateDecoder.class);

    public DeleteResultTemplateDecoder() {
        LOGGER.info("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public DeleteResultTemplateRequest decode(XmlObject xmlObject) throws DecodingException {
        LOGGER.debug(String.format("REQUESTTYPE: %s", xmlObject != null ? xmlObject.getClass() : "null recevied"));
        XmlHelper.validateDocument((XmlObject)xmlObject);
        if (xmlObject instanceof DeleteResultTemplateDocument) {
            DeleteResultTemplateDocument drtd = (DeleteResultTemplateDocument)xmlObject;
            DeleteResultTemplateRequest decodedRequest = this.parseDeleteResultTemplate(drtd);
            LOGGER.debug(String.format("Decoded request: %s", decodedRequest));
            return decodedRequest;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)xmlObject);
    }

    private DeleteResultTemplateRequest parseDeleteResultTemplate(DeleteResultTemplateDocument drtd) throws DecodingException {
        DeleteResultTemplateRequest request = null;
        DeleteResultTemplateType drtt = drtd.getDeleteResultTemplate();
        request = new DeleteResultTemplateRequest();
        request.setVersion(drtt.getVersion());
        request.setService(drtt.getService());
        if (drtt.sizeOfResultTemplateArray() > 0) {
            this.parseResultTemplates(drtt.getResultTemplateArray(), request);
        }
        if (drtt.sizeOfTupleArray() > 0) {
            this.parseObservedPropertyOfferingPairs(drtt.getTupleArray(), request);
        }
        return request;
    }

    private void parseResultTemplates(String[] resultTemplateArray, DeleteResultTemplateRequest request) {
        for (String resultTemplateId : resultTemplateArray) {
            request.addResultTemplate(resultTemplateId);
        }
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.emptySet();
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    private void parseObservedPropertyOfferingPairs(DeleteResultTemplateType.Tuple[] tuples, DeleteResultTemplateRequest request) {
        for (DeleteResultTemplateType.Tuple tuple : tuples) {
            request.addObservedPropertyOfferingPair(tuple.getObservedProperty(), tuple.getOffering());
        }
    }
}

