/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.util.Collections;
import java.util.Set;
import net.opengis.sosgda.x20.GetDataAvailabilityDocument;
import net.opengis.sosgda.x20.GetDataAvailabilityType;
import net.opengis.swes.x20.ExtensibleRequestType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.sos.gda.GetDataAvailabilityRequest;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractGetDataAvailabilityXmlDecoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetDataAvailabilityV20XmlDecoder
extends AbstractGetDataAvailabilityXmlDecoder {
    private static final Logger LOG = LoggerFactory.getLogger(GetDataAvailabilityV20XmlDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sosgda/2.0", (Class[])new Class[]{XmlObject.class});

    public GetDataAvailabilityV20XmlDecoder() {
        LOG.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    @Override
    public GetDataAvailabilityRequest parseGetDataAvailability(XmlObject xml) throws DecodingException {
        if (xml instanceof GetDataAvailabilityDocument) {
            return this.parseGetDataAvailability((GetDataAvailabilityDocument)xml);
        }
        return new GetDataAvailabilityRequest().setNamespace("http://www.opengis.net/sosgda/2.0");
    }

    private GetDataAvailabilityRequest parseGetDataAvailability(GetDataAvailabilityDocument xml) throws DecodingException {
        GetDataAvailabilityRequest request = new GetDataAvailabilityRequest();
        GetDataAvailabilityType gdat = xml.getGetDataAvailability();
        request.setNamespace(XmlHelper.getNamespace((XmlObject)xml));
        request.setResponseFormat(XmlHelper.getNamespace((XmlObject)xml));
        request.setService(gdat.getService());
        request.setVersion(gdat.getVersion());
        if (CollectionHelper.isNotNullOrEmpty((Object[])gdat.getObservedPropertyArray())) {
            for (String s : gdat.getObservedPropertyArray()) {
                request.addObservedProperty(s);
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])gdat.getProcedureArray())) {
            for (String s : gdat.getProcedureArray()) {
                request.addProcedure(s);
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])gdat.getFeatureOfInterestArray())) {
            for (String s : gdat.getFeatureOfInterestArray()) {
                request.addFeatureOfInterest(s);
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])gdat.getOfferingArray())) {
            for (String s : gdat.getOfferingArray()) {
                request.addOffering(s);
            }
        }
        if (CollectionHelper.isNotNullOrEmpty((Object[])gdat.getResponseFormatArray())) {
            for (String s : gdat.getResponseFormatArray()) {
                request.setResponseFormat(s);
            }
        }
        request.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)gdat));
        return request;
    }
}

