/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.opengis.sos.x20.GetObservationByIdResponseDocument;
import net.opengis.sos.x20.GetObservationByIdResponseType;
import net.opengis.swes.x20.ExtensibleResponseType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.response.GetObservationByIdResponse;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractXmlDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.SosResponseDecoder;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetObservationByIdResponseDocumentDecoder
extends AbstractXmlDecoder<GetObservationByIdResponseDocument, GetObservationByIdResponse>
implements SosResponseDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(GetObservationByIdResponseDocumentDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sos/2.0", (Class[])new Class[]{GetObservationByIdResponseDocument.class});

    public GetObservationByIdResponseDocumentDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    @SuppressFBWarnings(value={"NP_LOAD_OF_KNOWN_NULL_VALUE"})
    public GetObservationByIdResponse decode(GetObservationByIdResponseDocument doc) throws DecodingException {
        if (doc != null) {
            GetObservationByIdResponse response = new GetObservationByIdResponse();
            this.setService((OwsServiceResponse)response);
            this.setVersions((OwsServiceResponse)response);
            GetObservationByIdResponseType type = doc.getGetObservationByIdResponse();
            response.setExtensions((Extensions)this.parseExtensibleResponse((ExtensibleResponseType)type));
            response.setObservationCollection(ObservationStream.of(this.parseObservations(type)));
            return response;
        }
        throw new UnsupportedDecoderInputException((Decoder)this, (Object)doc);
    }

    private List<OmObservation> parseObservations(GetObservationByIdResponseType type) throws DecodingException {
        if (CollectionHelper.isNotNullOrEmpty((Object[])type.getObservationArray())) {
            ArrayList observations = Lists.newArrayList();
            for (GetObservationByIdResponseType.Observation observation : type.getObservationArray()) {
                observations.add(this.decodeXmlObject((XmlObject)observation.getOMObservation()));
            }
            return observations;
        }
        return Collections.emptyList();
    }
}

