/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import net.opengis.sensorML.x101.AbstractComponentType;
import net.opengis.sensorML.x101.AbstractDerivableComponentType;
import net.opengis.sensorML.x101.AbstractProcessType;
import net.opengis.sensorML.x101.AbstractPureProcessType;
import net.opengis.sensorML.x101.CapabilitiesDocument;
import net.opengis.sensorML.x101.CharacteristicsDocument;
import net.opengis.sensorML.x101.ClassificationDocument;
import net.opengis.sensorML.x101.ComponentType;
import net.opengis.sensorML.x101.ComponentsDocument;
import net.opengis.sensorML.x101.ContactDocument;
import net.opengis.sensorML.x101.ContactInfoDocument;
import net.opengis.sensorML.x101.ContactListDocument;
import net.opengis.sensorML.x101.DocumentationDocument;
import net.opengis.sensorML.x101.HistoryDocument;
import net.opengis.sensorML.x101.IdentificationDocument;
import net.opengis.sensorML.x101.InputsDocument;
import net.opengis.sensorML.x101.IoComponentPropertyType;
import net.opengis.sensorML.x101.KeywordsDocument;
import net.opengis.sensorML.x101.MethodPropertyType;
import net.opengis.sensorML.x101.OnlineResourceDocument;
import net.opengis.sensorML.x101.OutputsDocument;
import net.opengis.sensorML.x101.ParametersDocument;
import net.opengis.sensorML.x101.PersonDocument;
import net.opengis.sensorML.x101.PositionDocument;
import net.opengis.sensorML.x101.ProcessMethodType;
import net.opengis.sensorML.x101.ProcessModelType;
import net.opengis.sensorML.x101.ResponsiblePartyDocument;
import net.opengis.sensorML.x101.SensorMLDocument;
import net.opengis.sensorML.x101.SmlLocation;
import net.opengis.sensorML.x101.SystemDocument;
import net.opengis.sensorML.x101.SystemType;
import net.opengis.sensorML.x101.TermDocument;
import net.opengis.sensorML.x101.ValidTimeDocument;
import net.opengis.swe.x101.BooleanDocument;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.locationtech.jts.geom.Point;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.sensorML.AbstractComponent;
import org.n52.shetland.ogc.sensorML.AbstractProcess;
import org.n52.shetland.ogc.sensorML.AbstractSensorML;
import org.n52.shetland.ogc.sensorML.Component;
import org.n52.shetland.ogc.sensorML.ProcessMethod;
import org.n52.shetland.ogc.sensorML.ProcessModel;
import org.n52.shetland.ogc.sensorML.RulesDefinition;
import org.n52.shetland.ogc.sensorML.SensorML;
import org.n52.shetland.ogc.sensorML.SensorMLConstants;
import org.n52.shetland.ogc.sensorML.SmlContact;
import org.n52.shetland.ogc.sensorML.SmlContactList;
import org.n52.shetland.ogc.sensorML.SmlPerson;
import org.n52.shetland.ogc.sensorML.SmlReferencedContact;
import org.n52.shetland.ogc.sensorML.SmlResponsibleParty;
import org.n52.shetland.ogc.sensorML.System;
import org.n52.shetland.ogc.sensorML.elements.AbstractSmlDocumentation;
import org.n52.shetland.ogc.sensorML.elements.SmlCapabilities;
import org.n52.shetland.ogc.sensorML.elements.SmlCharacteristics;
import org.n52.shetland.ogc.sensorML.elements.SmlClassifier;
import org.n52.shetland.ogc.sensorML.elements.SmlComponent;
import org.n52.shetland.ogc.sensorML.elements.SmlIdentifier;
import org.n52.shetland.ogc.sensorML.elements.SmlIo;
import org.n52.shetland.ogc.sensorML.elements.SmlLocation;
import org.n52.shetland.ogc.sensorML.elements.SmlPosition;
import org.n52.shetland.ogc.sos.ProcedureDescriptionFormat;
import org.n52.shetland.ogc.swe.DataRecord;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.svalbard.decode.AbstractSensorMLDecoder;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorMLDecoderV101
extends AbstractSensorMLDecoder {
    private static final Logger LOGGER = LoggerFactory.getLogger(SensorMLDecoderV101.class);
    private static final Set<DecoderKey> DECODER_KEYS = CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sensorML/1.0.1", (Class[])new Class[]{SensorMLDocument.class, SystemDocument.class, SystemType.class, ProcessModelType.class});
    private static final Set<String> REMOVABLE_CAPABILITIES_NAMES = Sets.newHashSet((Object[])new String[]{"parentProcedures", "offerings"});
    private static final Set<String> REMOVABLE_COMPONENTS_ROLES = Collections.singleton("childProcedure");
    private static final Map<String, ImmutableMap<String, Set<String>>> SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS = ImmutableMap.of((Object)"SOS", (Object)ImmutableMap.builder().put((Object)"2.0.0", (Object)ImmutableSet.of((Object)"http://www.opengis.net/sensorML/1.0.1")).build());
    private static final ImmutableSet<SupportedType> SUPPORTED_TYPES = ImmutableSet.builder().add((Object)new ProcedureDescriptionFormat("http://www.opengis.net/sensorML/1.0.1")).build();

    public SensorMLDecoderV101() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public Set<SupportedType> getSupportedTypes() {
        return Collections.unmodifiableSet(SUPPORTED_TYPES);
    }

    public Set<String> getSupportedProcedureDescriptionFormats(String service, String version) {
        if (SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS.containsKey(service) && SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS.get(service).containsKey((Object)version)) {
            return (Set)SUPPORTED_TRANSACTIONAL_PROCEDURE_DESCRIPTION_FORMATS.get(service).get((Object)version);
        }
        return Collections.emptySet();
    }

    public AbstractSensorML decode(XmlObject element) throws DecodingException {
        XmlHelper.validateDocument((XmlObject)element);
        if (element instanceof SensorMLDocument) {
            return this.parseSensorML((SensorMLDocument)element);
        }
        if (element instanceof SystemDocument) {
            return this.parseSystem(((SystemDocument)element).getSystem());
        }
        if (element instanceof SystemType) {
            return this.parseSystem((SystemType)element);
        }
        if (element instanceof ProcessModelType) {
            return this.parseProcessModel((ProcessModelType)element);
        }
        throw new UnsupportedDecoderXmlInputException((Decoder<?, ?>)this, element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressFBWarnings(value={"BC_VACUOUS_INSTANCEOF"})
    private SensorML parseSensorML(SensorMLDocument xbSensorML) throws DecodingException {
        SensorML sensorML = new SensorML();
        for (SensorMLDocument.SensorML.Member xbMember : xbSensorML.getSensorML().getMemberArray()) {
            if (xbMember.getProcess() == null) throw new DecodingException(XmlHelper.getLocalName((XmlObject)xbMember), "The process of a member of the SensorML Document is null (%s)!", new Object[]{xbMember.getProcess()});
            if (!(xbMember.getProcess() instanceof AbstractProcessType)) throw SensorMLDecoderV101.unsupportedMemberProcess(xbMember);
            AbstractProcessType xbAbstractProcess = xbMember.getProcess();
            System abstractProcess = null;
            if (xbAbstractProcess.schemaType() == SystemType.type) {
                abstractProcess = this.parseSystem((SystemType)xbAbstractProcess);
            } else if (xbAbstractProcess.schemaType() == ProcessModelType.type) {
                abstractProcess = this.parseProcessModel((ProcessModelType)xbAbstractProcess);
            } else {
                if (xbAbstractProcess.schemaType() != ComponentType.type) throw SensorMLDecoderV101.unsupportedMemberProcess(xbMember);
                abstractProcess = this.parseComponent((ComponentType)xbAbstractProcess);
            }
            sensorML.addMember((AbstractProcess)abstractProcess);
        }
        sensorML.setXml(xbSensorML.xmlText(this.getXmlOptions()));
        return sensorML;
    }

    private void parseAbstractProcess(AbstractProcessType xbAbstractProcess, AbstractProcess abstractProcess) throws DecodingException {
        if (xbAbstractProcess.getId() != null) {
            abstractProcess.setGmlId(xbAbstractProcess.getId());
        }
        if (xbAbstractProcess.getIdentificationArray() != null) {
            this.parseIdentifications(abstractProcess, xbAbstractProcess.getIdentificationArray());
        }
        if (xbAbstractProcess.getClassificationArray() != null) {
            abstractProcess.setClassifications(this.parseClassification(xbAbstractProcess.getClassificationArray()));
        }
        if (xbAbstractProcess.getCharacteristicsArray() != null) {
            abstractProcess.setCharacteristics(this.parseCharacteristics(xbAbstractProcess.getCharacteristicsArray()));
        }
        if (xbAbstractProcess.getCapabilitiesArray() != null) {
            this.parseCapabilities(abstractProcess, xbAbstractProcess.getCapabilitiesArray());
            this.checkCapabilitiesForRemoval(xbAbstractProcess.getCapabilitiesArray()).forEach(arg_0 -> ((AbstractProcessType)xbAbstractProcess).removeCapabilities(arg_0));
        }
        if (xbAbstractProcess.isSetDescription()) {
            abstractProcess.addDescription(xbAbstractProcess.getDescription().getStringValue());
        }
        if (xbAbstractProcess.isSetValidTime()) {
            abstractProcess.setValidTime(this.parseValidTime(xbAbstractProcess.getValidTime()));
        }
        if (xbAbstractProcess.getContactArray() != null) {
            abstractProcess.setContact(this.parseContact(xbAbstractProcess.getContactArray()));
        }
        if (xbAbstractProcess.getDocumentationArray() != null) {
            abstractProcess.setDocumentation(this.parseDocumentation(xbAbstractProcess.getDocumentationArray()));
        }
        if (xbAbstractProcess.getHistoryArray() != null) {
            abstractProcess.setHistory(this.parseHistory(xbAbstractProcess.getHistoryArray()));
        }
        if (xbAbstractProcess.getKeywordsArray() != null) {
            abstractProcess.setKeywords(this.parseKeywords(xbAbstractProcess.getKeywordsArray()));
        }
        if (xbAbstractProcess.getNameArray() != null) {
            int length = xbAbstractProcess.getNameArray().length;
            for (int i = 0; i < length; ++i) {
                Object decodedElement = this.decodeXmlElement((XmlObject)xbAbstractProcess.getNameArray(i));
                if (!(decodedElement instanceof CodeType)) continue;
                abstractProcess.addName((CodeType)decodedElement);
            }
        }
    }

    private void parseAbstractDerivableComponent(AbstractDerivableComponentType xbAbstractDerivableComponent, AbstractComponent abstractComponent) throws DecodingException {
        if (xbAbstractDerivableComponent.isSetPosition()) {
            abstractComponent.setPosition(this.parsePosition(xbAbstractDerivableComponent.getPosition()));
        }
        if (xbAbstractDerivableComponent.isSetSmlLocation()) {
            abstractComponent.setLocation(this.parseLocation(xbAbstractDerivableComponent.getSmlLocation()));
        }
    }

    private void parseAbstractComponent(AbstractComponentType xbAbstractComponent, AbstractProcess abstractProcess) throws DecodingException {
        if (xbAbstractComponent.isSetInputs()) {
            abstractProcess.setInputs(this.parseInputs(xbAbstractComponent.getInputs()));
        }
        if (xbAbstractComponent.isSetOutputs()) {
            abstractProcess.setOutputs(this.parseOutputs(xbAbstractComponent.getOutputs()));
        }
        if (xbAbstractComponent.isSetParameters()) {
            abstractProcess.setParameters(this.parseParameters(xbAbstractComponent.getParameters()));
        }
    }

    private void parseAbstractPureProcess(AbstractPureProcessType xbAbstractPureProcess, ProcessModel processModel) throws DecodingException {
        if (xbAbstractPureProcess.isSetInputs()) {
            processModel.setInputs(this.parseInputs(xbAbstractPureProcess.getInputs()));
        }
        if (xbAbstractPureProcess.isSetOutputs()) {
            processModel.setOutputs(this.parseOutputs(xbAbstractPureProcess.getOutputs()));
        }
        if (xbAbstractPureProcess.isSetParameters()) {
            processModel.setParameters(this.parseParameters(xbAbstractPureProcess.getParameters()));
        }
    }

    private System parseSystem(SystemType xbSystemType) throws DecodingException {
        return this.parseSystem(xbSystemType, new System());
    }

    private System parseSystem(SystemType xbSystemType, System system) throws DecodingException {
        this.parseAbstractProcess((AbstractProcessType)xbSystemType, (AbstractProcess)system);
        this.parseAbstractComponent((AbstractComponentType)xbSystemType, (AbstractProcess)system);
        this.parseAbstractDerivableComponent((AbstractDerivableComponentType)xbSystemType, (AbstractComponent)system);
        if (xbSystemType.isSetComponents() && xbSystemType.getComponents().isSetComponentList()) {
            system.addComponents(this.parseComponents(xbSystemType.getComponents()));
            ComponentsDocument.Components.ComponentList componentList = xbSystemType.getComponents().getComponentList();
            this.checkComponentsForRemoval(componentList).forEach(arg_0 -> ((ComponentsDocument.Components.ComponentList)componentList).removeComponent(arg_0));
            this.checkAndRemoveEmptyComponents(xbSystemType);
        }
        String xmlDescription = this.addSensorMLWrapperForXmlDescription((AbstractProcessType)xbSystemType);
        system.setXml(xmlDescription);
        return system;
    }

    private AbstractProcess parseComponent(ComponentType componentType) throws DecodingException {
        Component component = new Component();
        this.parseAbstractProcess((AbstractProcessType)componentType, (AbstractProcess)component);
        this.parseAbstractDerivableComponent((AbstractDerivableComponentType)componentType, (AbstractComponent)component);
        this.parseAbstractComponent((AbstractComponentType)componentType, (AbstractProcess)component);
        if (componentType.isSetPosition()) {
            component.setPosition(this.parsePosition(componentType.getPosition()));
        }
        component.setXml(this.addSensorMLWrapperForXmlDescription((AbstractProcessType)componentType));
        return component;
    }

    private ProcessModel parseProcessModel(ProcessModelType xbProcessModel) throws DecodingException {
        ProcessModel processModel = new ProcessModel();
        this.parseAbstractProcess((AbstractProcessType)xbProcessModel, (AbstractProcess)processModel);
        this.parseAbstractPureProcess((AbstractPureProcessType)xbProcessModel, processModel);
        if (xbProcessModel.getMethod() != null) {
            processModel.setMethod(this.parseProcessMethod(xbProcessModel.getMethod()));
        }
        processModel.setXml(this.addSensorMLWrapperForXmlDescription((AbstractProcessType)xbProcessModel));
        return processModel;
    }

    private ProcessMethod parseProcessMethod(MethodPropertyType method) throws DecodingException {
        if (method.isSetHref()) {
            ProcessMethod processMethod = new ProcessMethod(method.getHref());
            if (method.isSetTitle()) {
                processMethod.setTitle(method.getTitle());
            }
            if (method.isSetRole()) {
                processMethod.setRole(method.getRole());
            }
            return processMethod;
        }
        if (method.isSetProcessMethod()) {
            ProcessMethod processMethod = new ProcessMethod(this.parseRulesDefinition(method.getProcessMethod().getRules().getRulesDefinition()));
            return processMethod;
        }
        throw new DecodingException("method", "The sml:method should contain a xlink:href attribut or a sml:ProcessMethod element!", new Object[0]);
    }

    private RulesDefinition parseRulesDefinition(ProcessMethodType.Rules.RulesDefinition xbRulesDefinition) {
        RulesDefinition rulesDefinition = new RulesDefinition();
        if (xbRulesDefinition.isSetDescription()) {
            rulesDefinition.setDescription(xbRulesDefinition.getDescription().getStringValue());
        }
        return rulesDefinition;
    }

    private void parseIdentifications(AbstractProcess abstractProcess, IdentificationDocument.Identification[] identificationArray) {
        for (IdentificationDocument.Identification xbIdentification : identificationArray) {
            if (xbIdentification.getIdentifierList() == null) continue;
            for (IdentificationDocument.Identification.IdentifierList.Identifier xbIdentifier : xbIdentification.getIdentifierList().getIdentifierArray()) {
                if (xbIdentifier.getName() == null || xbIdentifier.getTerm() == null) continue;
                SmlIdentifier identifier = new SmlIdentifier(xbIdentifier.getName(), xbIdentifier.getTerm().getDefinition(), xbIdentifier.getTerm().getValue());
                abstractProcess.addIdentifier(identifier);
                if (!this.isIdentificationProcedureIdentifier(identifier)) continue;
                abstractProcess.setIdentifier(identifier.getValue());
            }
        }
    }

    private List<SmlClassifier> parseClassification(ClassificationDocument.Classification[] classificationArray) {
        return Arrays.stream(classificationArray).map(ClassificationDocument.Classification::getClassifierList).map(ClassificationDocument.Classification.ClassifierList::getClassifierArray).flatMap(Arrays::stream).map(c -> {
            TermDocument.Term term = c.getTerm();
            String definition = term.isSetDefinition() ? term.getDefinition() : null;
            String codespace = term.isSetCodeSpace() ? term.getCodeSpace().getHref() : null;
            String value = term.getValue();
            return new SmlClassifier(c.getName(), definition, codespace, value);
        }).collect(Collectors.toList());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<SmlCharacteristics> parseCharacteristics(CharacteristicsDocument.Characteristics[] characteristicsArray) throws DecodingException {
        ArrayList<SmlCharacteristics> sosCharacteristicsList = new ArrayList<SmlCharacteristics>(characteristicsArray.length);
        for (CharacteristicsDocument.Characteristics xbCharacteristics : characteristicsArray) {
            SmlCharacteristics sosCharacteristics = new SmlCharacteristics();
            if (xbCharacteristics.isSetName()) {
                sosCharacteristics.setName(xbCharacteristics.getName());
            }
            if (xbCharacteristics.isSetAbstractDataRecord()) {
                Object decodedObject = this.decodeXmlElement((XmlObject)xbCharacteristics.getAbstractDataRecord());
                if (!(decodedObject instanceof DataRecord)) throw new DecodingException(XmlHelper.getLocalName((XmlObject)xbCharacteristics), "Error while parsing the characteristics of the SensorML (the characteristics' data record is not of type DataRecordPropertyType)!", new Object[0]);
                sosCharacteristics.setDataRecord((DataRecord)decodedObject);
            } else if (xbCharacteristics.isSetHref()) {
                sosCharacteristics.setHref(xbCharacteristics.getHref());
                if (xbCharacteristics.isSetTitle()) {
                    sosCharacteristics.setTitle(xbCharacteristics.getTitle());
                }
            }
            if (!sosCharacteristics.isSetName()) continue;
            sosCharacteristicsList.add(sosCharacteristics);
        }
        return sosCharacteristicsList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void parseCapabilities(AbstractProcess abstractProcess, CapabilitiesDocument.Capabilities[] capabilitiesArray) throws DecodingException {
        for (CapabilitiesDocument.Capabilities xbcaps : capabilitiesArray) {
            SmlCapabilities caps = new SmlCapabilities();
            if (xbcaps.isSetName()) {
                caps.setName(xbcaps.getName());
            }
            if (xbcaps.isSetAbstractDataRecord()) {
                Object o = this.decodeXmlElement((XmlObject)xbcaps.getAbstractDataRecord());
                if (!(o instanceof DataRecord)) throw new DecodingException(XmlHelper.getLocalName((XmlObject)xbcaps), "Error while parsing the capabilities of the SensorML (the capabilities data record is not of type DataRecordPropertyType)!", new Object[0]);
                DataRecord record = (DataRecord)o;
                ((SmlCapabilities)caps.setDataRecord(record)).setName(xbcaps.getName());
            } else if (xbcaps.isSetHref()) {
                caps.setHref(xbcaps.getHref());
                if (xbcaps.isSetTitle()) {
                    caps.setTitle(xbcaps.getTitle());
                }
            }
            if (!caps.isSetName()) continue;
            abstractProcess.addCapabilities(caps);
        }
    }

    private SmlPosition parsePosition(PositionDocument.Position position) throws DecodingException {
        if (!position.isSetPosition()) {
            throw new DecodingException(XmlHelper.getLocalName((XmlObject)position), "Error while parsing the position of the SensorML (the position is not set)!", new Object[0]);
        }
        SmlPosition sosSMLPosition = (SmlPosition)this.decodeXmlElement((XmlObject)position.getPosition());
        if (position.getName() != null) {
            sosSMLPosition.setName(position.getName());
        }
        return sosSMLPosition;
    }

    private SmlLocation parseLocation(SmlLocation.SmlLocation2 location) throws DecodingException {
        if (!location.isSetPoint()) {
            throw new DecodingException(XmlHelper.getLocalName((XmlObject)location), "Error while parsing the sml:location of the SensorML (point is not set, only point is supported)!", new Object[0]);
        }
        SmlLocation sosSmlLocation = null;
        Object point = this.decodeXmlElement((XmlObject)location.getPoint());
        if (point instanceof Point) {
            sosSmlLocation = new SmlLocation((Point)point);
        }
        return sosSmlLocation;
    }

    private Time parseValidTime(ValidTimeDocument.ValidTime validTime) {
        return null;
    }

    private List<String> parseParameters(ParametersDocument.Parameters parameters) {
        ArrayList<String> sosParameters = new ArrayList<String>(0);
        return sosParameters;
    }

    private List<SmlContact> parseContact(ContactDocument.Contact[] contactArray) {
        ArrayList smlContacts = Lists.newArrayList();
        if (contactArray != null && contactArray.length > 0) {
            for (ContactDocument.Contact contact : contactArray) {
                if (contact.isSetContactList()) {
                    smlContacts.add(this.parseContactListMembers(contact.getContactList()));
                    continue;
                }
                if (contact.isSetPerson()) {
                    smlContacts.add(this.parsePerson(contact.getPerson()));
                    continue;
                }
                if (contact.isSetResponsibleParty()) {
                    smlContacts.add(this.parseResponsibleParty(contact.getResponsibleParty()));
                    continue;
                }
                if (!contact.isSetHref()) continue;
                SmlReferencedContact thisSmlContact = new SmlReferencedContact();
                thisSmlContact.setHref(contact.getHref());
                if (contact.isSetTitle()) {
                    thisSmlContact.setTitle(contact.getTitle());
                }
                if (contact.getRole() != null) {
                    thisSmlContact.setRole(contact.getRole());
                }
                smlContacts.add(thisSmlContact);
            }
        }
        return smlContacts;
    }

    private SmlContact parseContactListMembers(ContactListDocument.ContactList contactList) {
        SmlContactList smlContactList = new SmlContactList();
        if (contactList.getMemberArray() != null && contactList.getMemberArray().length > 0) {
            for (ContactListDocument.ContactList.Member member : contactList.getMemberArray()) {
                SmlPerson thisSmlContact = null;
                if (member.getPerson() != null) {
                    thisSmlContact = this.parsePerson(member.getPerson());
                } else if (member.getResponsibleParty() != null) {
                    thisSmlContact = this.parseResponsibleParty(member.getResponsibleParty());
                } else if (member.isSetHref()) {
                    thisSmlContact = new SmlReferencedContact();
                    thisSmlContact.setHref(member.getHref());
                    if (member.isSetTitle()) {
                        thisSmlContact.setTitle(member.getTitle());
                    }
                }
                if (thisSmlContact == null) continue;
                if (member.getRole() != null) {
                    thisSmlContact.setRole(member.getRole());
                }
                smlContactList.addMember((SmlContact)thisSmlContact);
            }
        }
        return smlContactList;
    }

    private SmlPerson parsePerson(PersonDocument.Person person) {
        SmlPerson smlPerson = new SmlPerson();
        if (person != null) {
            if (!Strings.isNullOrEmpty((String)person.getAffiliation())) {
                smlPerson.setAffiliation(person.getAffiliation());
            }
            if (!Strings.isNullOrEmpty((String)person.getEmail())) {
                smlPerson.setEmail(person.getEmail());
            }
            if (!Strings.isNullOrEmpty((String)person.getName())) {
                smlPerson.setName(person.getName());
            }
            if (!Strings.isNullOrEmpty((String)person.getPhoneNumber())) {
                smlPerson.setPhoneNumber(person.getPhoneNumber());
            }
            if (!Strings.isNullOrEmpty((String)person.getSurname())) {
                smlPerson.setSurname(person.getSurname());
            }
            if (!Strings.isNullOrEmpty((String)person.getUserID())) {
                smlPerson.setUserID(person.getUserID());
            }
        }
        return smlPerson;
    }

    private SmlResponsibleParty parseResponsibleParty(ResponsiblePartyDocument.ResponsibleParty responsibleParty) {
        SmlResponsibleParty smlRespParty = new SmlResponsibleParty();
        if (responsibleParty != null) {
            if (!Strings.isNullOrEmpty((String)responsibleParty.getIndividualName())) {
                smlRespParty.setIndividualName(responsibleParty.getIndividualName());
            }
            if (!Strings.isNullOrEmpty((String)responsibleParty.getOrganizationName())) {
                smlRespParty.setOrganizationName(responsibleParty.getOrganizationName());
            }
            if (!Strings.isNullOrEmpty((String)responsibleParty.getPositionName())) {
                smlRespParty.setPositionName(responsibleParty.getPositionName());
            }
            if (responsibleParty.getContactInfo() != null) {
                ContactInfoDocument.ContactInfo contactInfo = responsibleParty.getContactInfo();
                if (contactInfo.getAddress() != null) {
                    OnlineResourceDocument.OnlineResource[] address = contactInfo.getAddress();
                    if (!Strings.isNullOrEmpty((String)address.getAdministrativeArea())) {
                        smlRespParty.setAdministrativeArea(address.getAdministrativeArea());
                    }
                    if (!Strings.isNullOrEmpty((String)address.getCity())) {
                        smlRespParty.setCity(address.getCity());
                    }
                    if (!Strings.isNullOrEmpty((String)address.getCountry())) {
                        smlRespParty.setCountry(address.getCountry());
                    }
                    if (address.getDeliveryPointArray() != null && address.getDeliveryPointArray().length > 0) {
                        String[] stringArray = address.getDeliveryPointArray();
                        int n = stringArray.length;
                        for (int i = 0; i < n; ++i) {
                            String deliveryPoint = stringArray[i];
                            smlRespParty.addDeliveryPoint(deliveryPoint);
                        }
                    }
                    if (!Strings.isNullOrEmpty((String)address.getElectronicMailAddress())) {
                        smlRespParty.setEmail(address.getElectronicMailAddress());
                    }
                    if (!Strings.isNullOrEmpty((String)address.getPostalCode())) {
                        smlRespParty.setPostalCode(address.getPostalCode());
                    }
                }
                if (!Strings.isNullOrEmpty((String)contactInfo.getContactInstructions())) {
                    smlRespParty.setContactInstructions(contactInfo.getContactInstructions());
                }
                if (!Strings.isNullOrEmpty((String)contactInfo.getHoursOfService())) {
                    smlRespParty.setHoursOfService(contactInfo.getHoursOfService());
                }
                if (contactInfo.getOnlineResourceArray() != null && contactInfo.getOnlineResourceArray().length > 0) {
                    for (OnlineResourceDocument.OnlineResource onlineResource : contactInfo.getOnlineResourceArray()) {
                        if (Strings.isNullOrEmpty((String)onlineResource.getHref())) continue;
                        smlRespParty.addOnlineResource(onlineResource.getHref());
                    }
                }
                if (contactInfo.getPhone() != null) {
                    ContactInfoDocument.ContactInfo.Phone phone = contactInfo.getPhone();
                    if (phone.getVoiceArray() != null && phone.getVoiceArray().length > 0) {
                        for (String phoneVoice : phone.getVoiceArray()) {
                            smlRespParty.addPhoneVoice(phoneVoice);
                        }
                    }
                    if (phone.getFacsimileArray() != null && phone.getFacsimileArray().length > 0) {
                        for (String phoneFax : phone.getFacsimileArray()) {
                            smlRespParty.addPhoneFax(phoneFax);
                        }
                    }
                }
            }
        }
        return smlRespParty;
    }

    private List<AbstractSmlDocumentation> parseDocumentation(DocumentationDocument.Documentation[] documentationArray) {
        ArrayList<AbstractSmlDocumentation> abstractDocumentation = new ArrayList<AbstractSmlDocumentation>(documentationArray.length);
        return abstractDocumentation;
    }

    private List<String> parseKeywords(KeywordsDocument.Keywords[] keywordsArray) {
        HashSet keywords = Sets.newHashSet();
        if (keywordsArray != null && keywordsArray.length > 0) {
            for (KeywordsDocument.Keywords keyword : keywordsArray) {
                String[] array;
                if (!keyword.isSetKeywordList() || (array = keyword.getKeywordList().getKeywordArray()) == null || array.length <= 0) continue;
                keywords.addAll(Arrays.asList(array));
            }
        }
        return Lists.newArrayList((Iterable)keywords);
    }

    private String parseHistory(HistoryDocument.History[] historyArray) {
        return "";
    }

    private List<SmlIo> parseInputs(InputsDocument.Inputs inputs) throws DecodingException {
        ArrayList<SmlIo> sosInputs = new ArrayList<SmlIo>(inputs.getInputList().getInputArray().length);
        for (IoComponentPropertyType xbInput : inputs.getInputList().getInputArray()) {
            sosInputs.add(this.parseIoComponentPropertyType(xbInput));
        }
        return sosInputs;
    }

    private List<SmlIo> parseOutputs(OutputsDocument.Outputs outputs) throws DecodingException {
        ArrayList<SmlIo> sosOutputs = new ArrayList<SmlIo>(outputs.getOutputList().getOutputArray().length);
        for (IoComponentPropertyType xbOutput : outputs.getOutputList().getOutputArray()) {
            sosOutputs.add(this.parseIoComponentPropertyType(xbOutput));
        }
        return sosOutputs;
    }

    private List<SmlComponent> parseComponents(ComponentsDocument.Components components) throws DecodingException {
        LinkedList sosSmlComponents = Lists.newLinkedList();
        if (components.isSetComponentList() && components.getComponentList().getComponentArray() != null) {
            for (ComponentsDocument.Components.ComponentList.Component component : components.getComponentList().getComponentArray()) {
                if (!component.isSetProcess() && !component.isSetHref()) continue;
                SmlComponent sosSmlcomponent = new SmlComponent(component.getName());
                AbstractProcess abstractProcess = null;
                if (component.isSetProcess()) {
                    if (component.getProcess() instanceof SystemType) {
                        abstractProcess = new System();
                        this.parseSystem((SystemType)component.getProcess(), (System)abstractProcess);
                    } else {
                        abstractProcess = new AbstractProcess();
                        this.parseAbstractProcess(component.getProcess(), abstractProcess);
                    }
                } else {
                    abstractProcess = new AbstractProcess();
                    abstractProcess.setIdentifier(component.getHref());
                }
                sosSmlcomponent.setProcess((AbstractSensorML)abstractProcess);
                sosSmlComponents.add(sosSmlcomponent);
            }
        }
        return sosSmlComponents;
    }

    private SmlIo parseIoComponentPropertyType(IoComponentPropertyType xbIoCompPropType) throws DecodingException {
        SmlIo sosIo = new SmlIo();
        sosIo.setIoName(xbIoCompPropType.getName());
        BooleanDocument.Boolean toDecode = null;
        if (xbIoCompPropType.isSetHref()) {
            sosIo.setHref(xbIoCompPropType.getHref());
            if (xbIoCompPropType.isSetTitle()) {
                sosIo.setTitle(xbIoCompPropType.getTitle());
            }
            return sosIo;
        }
        if (xbIoCompPropType.isSetBoolean()) {
            toDecode = xbIoCompPropType.getBoolean();
        } else if (xbIoCompPropType.isSetCategory()) {
            toDecode = xbIoCompPropType.getCategory();
        } else if (xbIoCompPropType.isSetCount()) {
            toDecode = xbIoCompPropType.getCount();
        } else if (xbIoCompPropType.isSetCountRange()) {
            toDecode = xbIoCompPropType.getCountRange();
        } else if (xbIoCompPropType.isSetObservableProperty()) {
            toDecode = xbIoCompPropType.getObservableProperty();
        } else if (xbIoCompPropType.isSetQuantity()) {
            toDecode = xbIoCompPropType.getQuantity();
        } else if (xbIoCompPropType.isSetQuantityRange()) {
            toDecode = xbIoCompPropType.getQuantityRange();
        } else if (xbIoCompPropType.isSetText()) {
            toDecode = xbIoCompPropType.getText();
        } else if (xbIoCompPropType.isSetTime()) {
            toDecode = xbIoCompPropType.getTime();
        } else if (xbIoCompPropType.isSetTimeRange()) {
            toDecode = xbIoCompPropType.getTimeRange();
        } else if (xbIoCompPropType.isSetAbstractDataArray1()) {
            toDecode = xbIoCompPropType.getAbstractDataArray1();
        } else if (xbIoCompPropType.isSetAbstractDataRecord()) {
            toDecode = xbIoCompPropType.getAbstractDataRecord();
        } else {
            throw new DecodingException(XmlHelper.getLocalName((XmlObject)xbIoCompPropType), "An 'IoComponentProperty' is not supported", new Object[0]);
        }
        Object decodedObject = this.decodeXmlElement((XmlObject)toDecode);
        if (!(decodedObject instanceof SweAbstractDataComponent)) {
            throw new DecodingException(XmlHelper.getLocalName((XmlObject)xbIoCompPropType), "The 'IoComponentProperty' with type '%s' as value for '%s' is not supported.", new Object[]{XmlHelper.getLocalName((XmlObject)toDecode), XmlHelper.getLocalName((XmlObject)xbIoCompPropType)});
        }
        sosIo.setIoValue((SweAbstractDataComponent)decodedObject);
        return sosIo;
    }

    private String addSensorMLWrapperForXmlDescription(AbstractProcessType xbProcessType) {
        SensorMLDocument xbSensorMLDoc = SensorMLDocument.Factory.newInstance((XmlOptions)this.getXmlOptions());
        SensorMLDocument.SensorML xbSensorML = xbSensorMLDoc.addNewSensorML();
        xbSensorML.setVersion("1.0.1");
        SensorMLDocument.SensorML.Member member = xbSensorML.addNewMember();
        AbstractProcessType xbAbstractProcessType = (AbstractProcessType)member.addNewProcess().substitute(this.getQnameForType(xbProcessType.schemaType()), xbProcessType.schemaType());
        xbAbstractProcessType.set((XmlObject)xbProcessType);
        return xbSensorMLDoc.xmlText(this.getXmlOptions());
    }

    private QName getQnameForType(SchemaType type) {
        if (type == SystemType.type) {
            return SensorMLConstants.SYSTEM_QNAME;
        }
        if (type == ProcessModelType.type) {
            return SensorMLConstants.PROCESS_MODEL_QNAME;
        }
        if (type == ComponentType.type) {
            return SensorMLConstants.COMPONENT_QNAME;
        }
        return SensorMLConstants.ABSTRACT_PROCESS_QNAME;
    }

    private List<Integer> checkCapabilitiesForRemoval(CapabilitiesDocument.Capabilities[] capabilitiesArray) {
        ArrayList<Integer> removeableCaps = new ArrayList<Integer>(capabilitiesArray.length);
        for (int i = 0; i < capabilitiesArray.length; ++i) {
            String name = capabilitiesArray[i].getName();
            if (name == null || !REMOVABLE_CAPABILITIES_NAMES.contains(name)) continue;
            removeableCaps.add(i);
        }
        Collections.sort(removeableCaps);
        Collections.reverse(removeableCaps);
        return removeableCaps;
    }

    private List<Integer> checkComponentsForRemoval(ComponentsDocument.Components.ComponentList componentList) {
        ArrayList<Integer> removeableComponents = new ArrayList<Integer>(0);
        if (componentList != null && componentList.getComponentArray() != null) {
            ComponentsDocument.Components.ComponentList.Component[] componentArray = componentList.getComponentArray();
            for (int i = 0; i < componentArray.length; ++i) {
                if (componentArray[i].getRole() == null || !REMOVABLE_COMPONENTS_ROLES.contains(componentArray[i].getRole())) continue;
                removeableComponents.add(i);
            }
        }
        return removeableComponents;
    }

    private void checkAndRemoveEmptyComponents(SystemType system) {
        boolean removeComponents = false;
        ComponentsDocument.Components components = system.getComponents();
        if (components != null) {
            if (components.getComponentList() == null) {
                removeComponents = true;
            } else if (components.getComponentList().getComponentArray() == null || components.getComponentList().getComponentArray() != null && components.getComponentList().getComponentArray().length == 0) {
                removeComponents = true;
            }
        }
        if (removeComponents) {
            system.unsetComponents();
        }
    }

    private static DecodingException unsupportedMemberProcess(SensorMLDocument.SensorML.Member xbMember) {
        return new DecodingException(XmlHelper.getLocalName((XmlObject)xbMember), "The process of a member of the SensorML Document (%s) is not supported!", new Object[]{xbMember.getProcess().getDomNode().getNodeName()});
    }
}

