/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.opengis.sos.x20.GetCapabilitiesDocument;
import net.opengis.sos.x20.GetCapabilitiesType;
import net.opengis.sos.x20.GetFeatureOfInterestDocument;
import net.opengis.sos.x20.GetFeatureOfInterestType;
import net.opengis.sos.x20.GetObservationByIdDocument;
import net.opengis.sos.x20.GetObservationByIdType;
import net.opengis.sos.x20.GetObservationDocument;
import net.opengis.sos.x20.GetObservationType;
import net.opengis.sos.x20.GetResultDocument;
import net.opengis.sos.x20.GetResultResponseDocument;
import net.opengis.sos.x20.GetResultResponseType;
import net.opengis.sos.x20.GetResultTemplateDocument;
import net.opengis.sos.x20.GetResultTemplateResponseDocument;
import net.opengis.sos.x20.GetResultTemplateResponseType;
import net.opengis.sos.x20.GetResultTemplateType;
import net.opengis.sos.x20.GetResultType;
import net.opengis.sos.x20.InsertObservationDocument;
import net.opengis.sos.x20.InsertObservationType;
import net.opengis.sos.x20.InsertResultDocument;
import net.opengis.sos.x20.InsertResultTemplateDocument;
import net.opengis.sos.x20.InsertResultTemplateType;
import net.opengis.sos.x20.InsertResultType;
import net.opengis.sos.x20.ResultTemplateType;
import net.opengis.swes.x20.ExtensibleRequestType;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.n52.janmayen.exception.CompositeException;
import org.n52.shetland.ogc.filter.SpatialFilter;
import org.n52.shetland.ogc.filter.TemporalFilter;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.time.Time;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.OmObservationConstellation;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.ows.service.GetCapabilitiesRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.ows.service.OwsServiceRequest;
import org.n52.shetland.ogc.ows.service.OwsServiceResponse;
import org.n52.shetland.ogc.sos.Sos2Constants;
import org.n52.shetland.ogc.sos.SosConstants;
import org.n52.shetland.ogc.sos.SosResultEncoding;
import org.n52.shetland.ogc.sos.SosResultStructure;
import org.n52.shetland.ogc.sos.request.GetFeatureOfInterestRequest;
import org.n52.shetland.ogc.sos.request.GetObservationByIdRequest;
import org.n52.shetland.ogc.sos.request.GetObservationRequest;
import org.n52.shetland.ogc.sos.request.GetResultRequest;
import org.n52.shetland.ogc.sos.request.GetResultTemplateRequest;
import org.n52.shetland.ogc.sos.request.InsertObservationRequest;
import org.n52.shetland.ogc.sos.request.InsertResultRequest;
import org.n52.shetland.ogc.sos.request.InsertResultTemplateRequest;
import org.n52.shetland.ogc.sos.response.GetResultResponse;
import org.n52.shetland.ogc.sos.response.GetResultTemplateResponse;
import org.n52.shetland.ogc.swe.SweAbstractDataComponent;
import org.n52.shetland.ogc.swe.encoding.SweAbstractEncoding;
import org.n52.shetland.util.CollectionHelper;
import org.n52.svalbard.decode.AbstractSwesDecoderv20;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.exception.DecodingException;
import org.n52.svalbard.decode.exception.UnsupportedDecoderXmlInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.util.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SosDecoderv20
extends AbstractSwesDecoderv20<OwsServiceCommunicationObject>
implements Decoder<OwsServiceCommunicationObject, XmlObject> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SosDecoderv20.class);
    private static final Set<DecoderKey> DECODER_KEYS = CollectionHelper.union((Set[])new Set[]{CodingHelper.decoderKeysForElements((String)"http://www.opengis.net/sos/2.0", (Class[])new Class[]{GetCapabilitiesDocument.class, GetObservationDocument.class, GetFeatureOfInterestDocument.class, GetObservationByIdDocument.class, InsertObservationDocument.class, InsertResultTemplateDocument.class, InsertResultDocument.class, GetResultTemplateDocument.class, GetResultDocument.class, GetResultTemplateResponseDocument.class, GetResultResponseDocument.class}), CodingHelper.xmlDecoderKeysForOperation((String)"SOS", (String)"2.0.0", (Enum[])new Enum[]{SosConstants.Operations.GetCapabilities, SosConstants.Operations.GetObservation, SosConstants.Operations.GetFeatureOfInterest, SosConstants.Operations.GetObservationById, SosConstants.Operations.InsertObservation, Sos2Constants.Operations.InsertResultTemplate, Sos2Constants.Operations.InsertResult, Sos2Constants.Operations.GetResultTemplate, SosConstants.Operations.GetResult})});

    public SosDecoderv20() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public OwsServiceCommunicationObject decode(XmlObject xml) throws DecodingException {
        LOGGER.debug("REQUESTTYPE:" + xml.getClass());
        XmlHelper.validateDocument((XmlObject)xml);
        if (xml instanceof GetCapabilitiesDocument) {
            return this.parseGetCapabilities((GetCapabilitiesDocument)xml);
        }
        if (xml instanceof GetObservationDocument) {
            return this.parseGetObservation((GetObservationDocument)xml);
        }
        if (xml instanceof GetFeatureOfInterestDocument) {
            return this.parseGetFeatureOfInterest((GetFeatureOfInterestDocument)xml);
        }
        if (xml instanceof GetObservationByIdDocument) {
            return this.parseGetObservationById((GetObservationByIdDocument)xml);
        }
        if (xml instanceof InsertObservationDocument) {
            return this.parseInsertObservation((InsertObservationDocument)xml);
        }
        if (xml instanceof InsertResultTemplateDocument) {
            return this.parseInsertResultTemplate((InsertResultTemplateDocument)xml);
        }
        if (xml instanceof InsertResultDocument) {
            return this.parseInsertResult((InsertResultDocument)xml);
        }
        if (xml instanceof GetResultTemplateDocument) {
            return this.parseGetResultTemplate((GetResultTemplateDocument)xml);
        }
        if (xml instanceof GetResultDocument) {
            return this.parseGetResult((GetResultDocument)xml);
        }
        if (xml instanceof GetResultTemplateResponseDocument) {
            return this.parseGetResultTemplateResponse((GetResultTemplateResponseDocument)xml);
        }
        if (xml instanceof GetResultResponseDocument) {
            return this.parseGetResultResponse((GetResultResponseDocument)xml);
        }
        throw new UnsupportedDecoderXmlInputException(this, xml);
    }

    private OwsServiceRequest parseGetCapabilities(GetCapabilitiesDocument getCapsDoc) throws DecodingException {
        GetCapabilitiesType getCapsType = getCapsDoc.getGetCapabilities2();
        GetCapabilitiesRequest request = new GetCapabilitiesRequest(getCapsType.getService());
        if (getCapsType.getAcceptFormats() != null && getCapsType.getAcceptFormats().sizeOfOutputFormatArray() != 0) {
            request.setAcceptFormats(Arrays.asList(getCapsType.getAcceptFormats().getOutputFormatArray()));
        }
        if (getCapsType.getAcceptVersions() != null && getCapsType.getAcceptVersions().sizeOfVersionArray() != 0) {
            request.setAcceptVersions(Arrays.asList(getCapsType.getAcceptVersions().getVersionArray()));
        }
        if (getCapsType.getSections() != null && getCapsType.getSections().getSectionArray().length != 0) {
            request.setSections(Arrays.asList(getCapsType.getSections().getSectionArray()));
        }
        if (getCapsType.getExtensionArray() != null && getCapsType.getExtensionArray().length > 0) {
            request.setExtensions((Extensions)this.parseExtensibleRequestExtension(getCapsType.getExtensionArray()));
        }
        return request;
    }

    private OwsServiceRequest parseGetObservation(GetObservationDocument getObsDoc) throws DecodingException {
        GetObservationRequest getObsRequest = new GetObservationRequest();
        GetObservationType getObsType = getObsDoc.getGetObservation();
        getObsRequest.setService(getObsType.getService());
        getObsRequest.setVersion(getObsType.getVersion());
        getObsRequest.setOfferings(Arrays.asList(getObsType.getOfferingArray()));
        getObsRequest.setObservedProperties(Arrays.asList(getObsType.getObservedPropertyArray()));
        getObsRequest.setProcedures(Arrays.asList(getObsType.getProcedureArray()));
        getObsRequest.setTemporalFilters(this.parseTemporalFilters4GetObservation(getObsType.getTemporalFilterArray()));
        if (getObsType.isSetSpatialFilter()) {
            getObsRequest.setSpatialFilter(this.parseSpatialFilter4GetObservation(getObsType.getSpatialFilter()));
        }
        getObsRequest.setFeatureIdentifiers(Arrays.asList(getObsType.getFeatureOfInterestArray()));
        if (getObsType.isSetResponseFormat()) {
            try {
                String responseFormat = URLDecoder.decode(getObsType.getResponseFormat(), "UTF-8");
                getObsRequest.setResponseFormat(responseFormat);
            }
            catch (UnsupportedEncodingException e) {
                throw new DecodingException((Throwable)e, "Error while encoding response format!");
            }
        }
        getObsRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)getObsType));
        return getObsRequest;
    }

    private OwsServiceRequest parseGetFeatureOfInterest(GetFeatureOfInterestDocument getFoiDoc) throws DecodingException {
        GetFeatureOfInterestRequest getFoiRequest = new GetFeatureOfInterestRequest();
        GetFeatureOfInterestType getFoiType = getFoiDoc.getGetFeatureOfInterest();
        getFoiRequest.setService(getFoiType.getService());
        getFoiRequest.setVersion(getFoiType.getVersion());
        getFoiRequest.setFeatureIdentifiers(Arrays.asList(getFoiType.getFeatureOfInterestArray()));
        getFoiRequest.setObservedProperties(Arrays.asList(getFoiType.getObservedPropertyArray()));
        getFoiRequest.setProcedures(Arrays.asList(getFoiType.getProcedureArray()));
        getFoiRequest.setSpatialFilters(this.parseSpatialFilters4GetFeatureOfInterest(getFoiType.getSpatialFilterArray()));
        getFoiRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)getFoiType));
        return getFoiRequest;
    }

    private OwsServiceRequest parseGetObservationById(GetObservationByIdDocument getObsByIdDoc) throws DecodingException {
        GetObservationByIdRequest getObsByIdRequest = new GetObservationByIdRequest();
        GetObservationByIdType getObsByIdType = getObsByIdDoc.getGetObservationById();
        getObsByIdRequest.setService(getObsByIdType.getService());
        getObsByIdRequest.setVersion(getObsByIdType.getVersion());
        getObsByIdRequest.setObservationIdentifier(Arrays.asList(getObsByIdType.getObservationArray()));
        getObsByIdRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)getObsByIdType));
        return getObsByIdRequest;
    }

    private OwsServiceRequest parseInsertObservation(InsertObservationDocument insertObservationDoc) throws DecodingException {
        XmlCursor cursor = insertObservationDoc.newCursor();
        if (cursor.toFirstChild() && cursor.namespaceForPrefix("xs") == null) {
            cursor.prefixForNamespace("http://www.w3.org/2001/XMLSchema");
        }
        cursor.dispose();
        InsertObservationRequest insertObservationRequest = new InsertObservationRequest();
        InsertObservationType insertObservationType = insertObservationDoc.getInsertObservation();
        insertObservationRequest.setService(insertObservationType.getService());
        insertObservationRequest.setVersion(insertObservationType.getVersion());
        if (insertObservationDoc.getInsertObservation().getOfferingArray() != null) {
            insertObservationRequest.setOfferings(Arrays.asList(insertObservationType.getOfferingArray()));
        }
        insertObservationRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)insertObservationType));
        if (insertObservationType.getObservationArray() != null) {
            int length = insertObservationType.getObservationArray().length;
            HashMap<String, Time> phenomenonTimes = new HashMap<String, Time>(length);
            HashMap<String, TimeInstant> resultTimes = new HashMap<String, TimeInstant>(length);
            HashMap<String, AbstractFeature> features = new HashMap<String, AbstractFeature>(length);
            CompositeException exceptions = new CompositeException();
            for (InsertObservationType.Observation observation : insertObservationType.getObservationArray()) {
                Object decodedObject = this.decodeXmlElement((XmlObject)observation.getOMObservation());
                if (decodedObject instanceof OmObservation) {
                    OmObservation sosObservation = (OmObservation)decodedObject;
                    this.checkAndAddPhenomenonTime(sosObservation.getPhenomenonTime(), phenomenonTimes);
                    this.checkAndAddResultTime(sosObservation.getResultTime(), resultTimes);
                    this.checkAndAddFeatures(sosObservation.getObservationConstellation().getFeatureOfInterest(), features);
                    insertObservationRequest.addObservation(sosObservation);
                    continue;
                }
                exceptions.add((Throwable)new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The requested observation type (%s) is not supported by this server!", new Object[]{observation.getOMObservation().getDomNode().getNodeName()}));
            }
            this.checkReferencedElements(insertObservationRequest.getObservations(), phenomenonTimes, resultTimes, features);
            try {
                exceptions.throwIfNotEmpty();
            }
            catch (CompositeException ex) {
                throw new DecodingException((Throwable)ex, (Enum)Sos2Constants.InsertObservationParams.observation);
            }
        } else {
            throw new DecodingException((Enum)Sos2Constants.InsertObservationParams.observation, "The request does not contain an observation", new Object[0]);
        }
        return insertObservationRequest;
    }

    private OwsServiceRequest parseInsertResultTemplate(InsertResultTemplateDocument insertResultTemplateDoc) throws DecodingException {
        InsertResultTemplateRequest sosInsertResultTemplate = new InsertResultTemplateRequest();
        InsertResultTemplateType insertResultTemplate = insertResultTemplateDoc.getInsertResultTemplate();
        sosInsertResultTemplate.setService(insertResultTemplate.getService());
        sosInsertResultTemplate.setVersion(insertResultTemplate.getVersion());
        ResultTemplateType resultTemplate = insertResultTemplate.getProposedTemplate().getResultTemplate();
        sosInsertResultTemplate.setIdentifier(resultTemplate.getIdentifier());
        OmObservationConstellation sosObservationConstellation = this.parseObservationTemplate(resultTemplate.getObservationTemplate());
        sosObservationConstellation.addOffering(resultTemplate.getOffering());
        sosInsertResultTemplate.setObservationTemplate(sosObservationConstellation);
        try {
            sosInsertResultTemplate.setResultStructure(this.parseResultStructure(XmlObject.Factory.parse((String)resultTemplate.getResultStructure().xmlText())));
            sosInsertResultTemplate.setResultEncoding(this.parseResultEncoding(XmlObject.Factory.parse((String)resultTemplate.getResultEncoding().xmlText())));
        }
        catch (XmlException e) {
            throw new DecodingException((Throwable)e, "Error while parsing InsertResultTemplate request!");
        }
        sosInsertResultTemplate.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)insertResultTemplate));
        return sosInsertResultTemplate;
    }

    private OwsServiceRequest parseInsertResult(InsertResultDocument insertResultDoc) throws DecodingException {
        InsertResultType insertResult = insertResultDoc.getInsertResult();
        InsertResultRequest sosInsertResultRequest = new InsertResultRequest();
        sosInsertResultRequest.setService(insertResult.getService());
        sosInsertResultRequest.setVersion(insertResult.getVersion());
        sosInsertResultRequest.setTemplateIdentifier(insertResult.getTemplate());
        sosInsertResultRequest.setResultValues(this.parseResultValues(insertResult.getResultValues()));
        sosInsertResultRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)insertResult));
        return sosInsertResultRequest;
    }

    private OwsServiceRequest parseGetResult(GetResultDocument getResultDoc) throws DecodingException {
        GetResultType getResult = getResultDoc.getGetResult();
        GetResultRequest sosGetResultRequest = new GetResultRequest();
        sosGetResultRequest.setService(getResult.getService());
        sosGetResultRequest.setVersion(getResult.getVersion());
        sosGetResultRequest.setOffering(getResult.getOffering());
        sosGetResultRequest.setObservedProperty(getResult.getObservedProperty());
        sosGetResultRequest.setFeatureIdentifiers(Arrays.asList(getResult.getFeatureOfInterestArray()));
        getResult.getFeatureOfInterestArray();
        if (getResult.isSetSpatialFilter()) {
            sosGetResultRequest.setSpatialFilter(this.parseSpatialFilter4GetResult(getResult.getSpatialFilter()));
        }
        sosGetResultRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)getResult));
        sosGetResultRequest.setTemporalFilter(this.parseTemporalFilters4GetResult(getResult.getTemporalFilterArray()));
        return sosGetResultRequest;
    }

    private OwsServiceRequest parseGetResultTemplate(GetResultTemplateDocument getResultTemplateDoc) throws DecodingException {
        GetResultTemplateType getResultTemplate = getResultTemplateDoc.getGetResultTemplate();
        GetResultTemplateRequest sosGetResultTemplateRequest = new GetResultTemplateRequest();
        sosGetResultTemplateRequest.setService(getResultTemplate.getService());
        sosGetResultTemplateRequest.setVersion(getResultTemplate.getVersion());
        sosGetResultTemplateRequest.setOffering(getResultTemplate.getOffering());
        sosGetResultTemplateRequest.setObservedProperty(getResultTemplate.getObservedProperty());
        sosGetResultTemplateRequest.setExtensions((Extensions)this.parseExtensibleRequest((ExtensibleRequestType)getResultTemplate));
        return sosGetResultTemplateRequest;
    }

    private OwsServiceResponse parseGetResultTemplateResponse(GetResultTemplateResponseDocument getResultTemplateResponseDoc) throws DecodingException {
        GetResultTemplateResponse sosGetResultTemplateResponse = new GetResultTemplateResponse();
        GetResultTemplateResponseType getResultTemplateResponse = getResultTemplateResponseDoc.getGetResultTemplateResponse();
        SosResultEncoding resultEncoding = this.parseResultEncoding((XmlObject)getResultTemplateResponse.getResultEncoding().getAbstractEncoding());
        SosResultStructure resultStructure = this.parseResultStructure((XmlObject)getResultTemplateResponse.getResultStructure().getAbstractDataComponent());
        sosGetResultTemplateResponse.setResultEncoding(resultEncoding);
        sosGetResultTemplateResponse.setResultStructure(resultStructure);
        return sosGetResultTemplateResponse;
    }

    private OwsServiceResponse parseGetResultResponse(GetResultResponseDocument getResultResponseDoc) throws DecodingException {
        GetResultResponse sosGetResultResponse = new GetResultResponse();
        GetResultResponseType getResultResponse = getResultResponseDoc.getGetResultResponse();
        String resultValues = this.parseResultValues(getResultResponse.getResultValues());
        sosGetResultResponse.setResultValues(resultValues);
        return sosGetResultResponse;
    }

    private SpatialFilter parseSpatialFilter4GetObservation(GetObservationType.SpatialFilter spatialFilter) throws DecodingException {
        Object filter;
        if (spatialFilter != null && spatialFilter.getSpatialOps() != null && (filter = this.decodeXmlElement((XmlObject)spatialFilter.getSpatialOps())) instanceof SpatialFilter) {
            return (SpatialFilter)filter;
        }
        return null;
    }

    private List<SpatialFilter> parseSpatialFilters4GetFeatureOfInterest(GetFeatureOfInterestType.SpatialFilter[] spatialFilters) throws DecodingException {
        ArrayList<SpatialFilter> sosSpatialFilters = new ArrayList<SpatialFilter>(spatialFilters.length);
        for (GetFeatureOfInterestType.SpatialFilter spatialFilter : spatialFilters) {
            Object filter = this.decodeXmlElement((XmlObject)spatialFilter.getSpatialOps());
            if (!(filter instanceof SpatialFilter)) continue;
            sosSpatialFilters.add((SpatialFilter)filter);
        }
        return sosSpatialFilters;
    }

    private SpatialFilter parseSpatialFilter4GetResult(GetResultType.SpatialFilter spatialFilter) throws DecodingException {
        Object filter;
        if (spatialFilter != null && spatialFilter.getSpatialOps() != null && (filter = this.decodeXmlElement((XmlObject)spatialFilter.getSpatialOps())) instanceof SpatialFilter) {
            return (SpatialFilter)filter;
        }
        return null;
    }

    private List<TemporalFilter> parseTemporalFilters4GetObservation(GetObservationType.TemporalFilter[] temporalFilters) throws DecodingException {
        ArrayList<TemporalFilter> sosTemporalFilters = new ArrayList<TemporalFilter>(temporalFilters.length);
        for (GetObservationType.TemporalFilter temporalFilter : temporalFilters) {
            Object filter = this.decodeXmlElement((XmlObject)temporalFilter.getTemporalOps());
            if (!(filter instanceof TemporalFilter)) continue;
            sosTemporalFilters.add((TemporalFilter)filter);
        }
        return sosTemporalFilters;
    }

    private List<TemporalFilter> parseTemporalFilters4GetResult(GetResultType.TemporalFilter[] temporalFilters) throws DecodingException {
        ArrayList<TemporalFilter> sosTemporalFilters = new ArrayList<TemporalFilter>(temporalFilters.length);
        for (GetResultType.TemporalFilter temporalFilter : temporalFilters) {
            Object filter = this.decodeXmlElement((XmlObject)temporalFilter.getTemporalOps());
            if (!(filter instanceof TemporalFilter)) continue;
            sosTemporalFilters.add((TemporalFilter)filter);
        }
        return sosTemporalFilters;
    }

    private OmObservationConstellation parseObservationTemplate(ResultTemplateType.ObservationTemplate observationTemplate) throws DecodingException {
        Object decodedObject = this.decodeXmlElement((XmlObject)observationTemplate.getOMObservation());
        if (decodedObject instanceof OmObservation) {
            OmObservation observation = (OmObservation)decodedObject;
            return observation.getObservationConstellation();
        }
        return null;
    }

    private SosResultStructure parseResultStructure(XmlObject resultStructure) throws DecodingException {
        Object decodedObject = this.decodeXmlElement(resultStructure);
        if (decodedObject instanceof SweAbstractDataComponent) {
            SweAbstractDataComponent sosSweData = (SweAbstractDataComponent)decodedObject;
            return new SosResultStructure(sosSweData, sosSweData.getXml());
        }
        throw new DecodingException((Enum)Sos2Constants.InsertResultTemplateParams.resultStructure, "The requested result structure (%s) is not supported by this server!", new Object[]{resultStructure.getDomNode().getNodeName()});
    }

    private SosResultEncoding parseResultEncoding(XmlObject resultEncoding) throws DecodingException {
        Object decodedObject = this.decodeXmlElement(resultEncoding);
        if (decodedObject instanceof SweAbstractEncoding) {
            SweAbstractEncoding sosSweEncoding = (SweAbstractEncoding)decodedObject;
            return new SosResultEncoding(sosSweEncoding, sosSweEncoding.getXml());
        }
        throw new DecodingException((Enum)Sos2Constants.InsertResultTemplateParams.resultEncoding, "The requested result encoding (%s) is not supported by this server!", new Object[]{resultEncoding.getDomNode().getNodeName()});
    }

    private String parseResultValues(XmlObject resultValues) throws DecodingException {
        if (resultValues.schemaType() == XmlString.type) {
            return ((XmlString)resultValues).getStringValue().trim();
        }
        if (resultValues.schemaType() == XmlObject.type) {
            Node resultValuesNode = resultValues.getDomNode();
            if (resultValuesNode.hasChildNodes()) {
                NodeList childNodes = resultValuesNode.getChildNodes();
                for (int i = 0; i < childNodes.getLength(); ++i) {
                    Node childNode = childNodes.item(i);
                    if (childNode.getNodeType() != 3) continue;
                    return childNode.getNodeValue().trim();
                }
            }
            throw new DecodingException((Enum)Sos2Constants.InsertResultParams.resultValues, "The value for the parameter '%s' is missing in the request!", new Object[]{Sos2Constants.InsertResultParams.resultValues});
        }
        throw new DecodingException("The requested resultValue type is not supported", new Object[0]);
    }

    private void checkAndAddPhenomenonTime(Time phenomenonTime, Map<String, Time> phenomenonTimes) {
        if (!phenomenonTime.isReferenced()) {
            phenomenonTimes.put(phenomenonTime.getGmlId(), phenomenonTime);
        }
    }

    private void checkAndAddResultTime(TimeInstant resultTime, Map<String, TimeInstant> resultTimes) {
        if (!resultTime.isReferenced()) {
            resultTimes.put(resultTime.getGmlId(), resultTime);
        }
    }

    private void checkAndAddFeatures(AbstractFeature featureOfInterest, Map<String, AbstractFeature> features) {
        if (!featureOfInterest.isReferenced()) {
            features.put(featureOfInterest.getGmlId(), featureOfInterest);
        }
    }

    private void checkReferencedElements(List<OmObservation> observations, Map<String, Time> phenomenonTimes, Map<String, TimeInstant> resultTimes, Map<String, AbstractFeature> features) throws DecodingException {
        for (OmObservation observation : observations) {
            AbstractFeature featureOfInterest;
            TimeInstant resultTime;
            Time phenomenonTime = observation.getPhenomenonTime();
            if (phenomenonTime.isReferenced()) {
                observation.getValue().setPhenomenonTime(phenomenonTimes.get(phenomenonTime.getGmlId()));
            }
            if ((resultTime = observation.getResultTime()).isReferenced()) {
                if (resultTimes.containsKey(resultTime.getGmlId())) {
                    observation.setResultTime(resultTimes.get(resultTime.getGmlId()));
                } else if (phenomenonTimes.containsKey(resultTime.getGmlId())) {
                    Time iTime = phenomenonTimes.get(resultTime.getGmlId());
                    if (iTime instanceof TimeInstant) {
                        observation.setResultTime((TimeInstant)iTime);
                    } else if (iTime instanceof TimePeriod) {
                        TimePeriod timePeriod = (TimePeriod)iTime;
                        observation.setResultTime(new TimeInstant(timePeriod.getEnd()));
                    } else {
                        throw new DecodingException("observation.resultTime", "The time value type is not supported", new Object[0]);
                    }
                }
            }
            if (!(featureOfInterest = observation.getObservationConstellation().getFeatureOfInterest()).isReferenced()) continue;
            observation.getObservationConstellation().setFeatureOfInterest(features.get(featureOfInterest.getGmlId()));
        }
    }
}

