/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.decode;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPHeaderElement;
import org.n52.shetland.w3c.wsa.WsaActionHeader;
import org.n52.shetland.w3c.wsa.WsaHeader;
import org.n52.shetland.w3c.wsa.WsaMessageIDHeader;
import org.n52.shetland.w3c.wsa.WsaReplyToHeader;
import org.n52.shetland.w3c.wsa.WsaToHeader;
import org.n52.svalbard.decode.Decoder;
import org.n52.svalbard.decode.DecoderKey;
import org.n52.svalbard.decode.XmlNamespaceDecoderKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WsaDecoder
implements Decoder<List<WsaHeader>, List<SOAPHeaderElement>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WsaDecoder.class);
    private static final Set<DecoderKey> DECODER_KEYS = Collections.singleton(new XmlNamespaceDecoderKey("http://www.w3.org/2005/08/addressing", SOAPHeaderElement.class));

    public WsaDecoder() {
        LOGGER.debug("Decoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(DECODER_KEYS));
    }

    public Set<DecoderKey> getKeys() {
        return Collections.unmodifiableSet(DECODER_KEYS);
    }

    public List<WsaHeader> decode(List<SOAPHeaderElement> list) {
        ArrayList wsaHeaders = Lists.newArrayListWithCapacity((int)list.size());
        boolean to = false;
        boolean replyTo = false;
        boolean messageId = false;
        boolean action = false;
        for (SOAPHeaderElement soapHeaderElement : list) {
            if (soapHeaderElement.getLocalName().equals("To")) {
                wsaHeaders.add(new WsaToHeader(soapHeaderElement.getValue()));
                to = true;
                continue;
            }
            if (soapHeaderElement.getLocalName().equals("Action")) {
                wsaHeaders.add(new WsaActionHeader(soapHeaderElement.getValue()));
                action = true;
                continue;
            }
            if (soapHeaderElement.getLocalName().equals("ReplyTo")) {
                Iterator iter = soapHeaderElement.getChildElements();
                while (iter.hasNext()) {
                    Node node = (Node)iter.next();
                    if (node.getLocalName() == null || !node.getLocalName().equals("Address")) continue;
                    wsaHeaders.add(new WsaReplyToHeader(node.getValue()));
                    replyTo = true;
                }
                continue;
            }
            if (!soapHeaderElement.getLocalName().equals("MessageID")) continue;
            wsaHeaders.add(new WsaMessageIDHeader(soapHeaderElement.getValue()));
            messageId = true;
        }
        if ((to || replyTo || messageId) && !action) {
            wsaHeaders.add(new WsaActionHeader("http://www.w3.org/2005/08/addressing/fault"));
        }
        return wsaHeaders;
    }
}

