/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import eu.europa.ec.inspire.schemas.ef.x40.AbstractMonitoringObjectPropertyType;
import eu.europa.ec.inspire.schemas.ef.x40.AbstractMonitoringObjectType;
import org.apache.xmlbeans.XmlObject;
import org.n52.shetland.inspire.base2.LegislationCitation;
import org.n52.shetland.inspire.ef.AbstractMonitoringObject;
import org.n52.shetland.inspire.ef.Hierarchy;
import org.n52.shetland.inspire.ef.ObservingCapability;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeType;
import org.n52.shetland.ogc.gml.ReferenceType;
import org.n52.shetland.w3c.xlink.SimpleAttrs;
import org.n52.svalbard.encode.AbstractEnvironmentalFaciltityEncoder;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.exception.EncodingException;

public abstract class AbstractMonitoringObjectEncoder
extends AbstractEnvironmentalFaciltityEncoder<XmlObject, AbstractFeature> {
    protected abstract String generateGmlId();

    protected void encodeAbstractMonitoringObject(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        this.setGmlId(amot, abstractMonitoringObject);
        this.setInspireId(amot, abstractMonitoringObject);
        this.setName(amot, abstractMonitoringObject);
        this.setAdditionalDescription(amot, abstractMonitoringObject);
        this.setMediaMonitored(amot, abstractMonitoringObject);
        this.setLegalBackground(amot, abstractMonitoringObject);
        this.setResponsibleParty(amot, abstractMonitoringObject);
        this.setGeometry(amot, abstractMonitoringObject);
        this.setOnlineResource(amot, abstractMonitoringObject);
        this.setPurpose(amot, abstractMonitoringObject);
        this.setObservingCapability(amot, abstractMonitoringObject);
        this.setBroader(amot, abstractMonitoringObject);
        this.setNarrower(amot, abstractMonitoringObject);
        this.setSupersedes(amot, abstractMonitoringObject);
        this.setSupersededBy(amot, abstractMonitoringObject);
    }

    private void setGmlId(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (!abstractMonitoringObject.isSetGmlID() && !abstractMonitoringObject.isSetGmlID()) {
            abstractMonitoringObject.setGmlId(this.generateGmlId());
        }
        amot.setId(abstractMonitoringObject.getGmlId());
    }

    private void setInspireId(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        amot.addNewInspireId().set(this.encodeBASEPropertyType(abstractMonitoringObject.getInspireId()));
    }

    private void setName(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (abstractMonitoringObject.isSetName()) {
            for (CodeType name : abstractMonitoringObject.getName()) {
                if (!name.isSetValue()) continue;
                amot.addNewName2().setStringValue(name.getValue());
            }
        }
    }

    private void setAdditionalDescription(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (abstractMonitoringObject.isSetAdditionalDescription()) {
            amot.addNewAdditionalDescription().setStringValue(abstractMonitoringObject.getAdditionalDescription());
        }
    }

    private void setMediaMonitored(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        for (ReferenceType mediaMonitored : abstractMonitoringObject.getMediaMonitored()) {
            amot.addNewMediaMonitored().set(this.encodeGML32(mediaMonitored));
        }
    }

    private void setLegalBackground(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetLegalBackground()) {
            for (LegislationCitation legislationCitation : abstractMonitoringObject.getLegalBackground()) {
                if (legislationCitation.isSetSimpleAttrs()) {
                    SimpleAttrs simpleAttrs = legislationCitation.getSimpleAttrs();
                    if (!simpleAttrs.isSetHref()) continue;
                    AbstractMonitoringObjectType.LegalBackground lb = amot.addNewLegalBackground();
                    lb.setHref(simpleAttrs.getHref());
                    if (!simpleAttrs.isSetTitle()) continue;
                    lb.setTitle(simpleAttrs.getTitle());
                    continue;
                }
                amot.addNewLegalBackground().addNewLegislationCitation().set(this.encodeEF(legislationCitation));
            }
        }
    }

    private void setResponsibleParty(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetResponsibleParty()) {
            amot.addNewResponsibleParty().addNewRelatedParty().set(this.encodeBASE2(abstractMonitoringObject.getResponsibleParty()));
        }
    }

    private void setGeometry(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetGeometry()) {
            if (abstractMonitoringObject.isSetGmlID()) {
                amot.addNewGeometry().set(this.encodeGML32(abstractMonitoringObject.getGeometry(), new EncodingContext().with((Enum)XmlBeansEncodingFlags.GMLID, (Object)abstractMonitoringObject.getGmlId())));
            } else {
                amot.addNewGeometry().set(this.encodeGML32(abstractMonitoringObject.getGeometry()));
            }
        }
    }

    private void setOnlineResource(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) {
        if (abstractMonitoringObject.isSetOnlineResources()) {
            for (String onlineResource : abstractMonitoringObject.getOnlineResource()) {
                amot.addNewOnlineResource().setStringValue(onlineResource);
            }
        }
    }

    private void setPurpose(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetPurpose()) {
            for (ReferenceType purpose : abstractMonitoringObject.getPurpose()) {
                amot.addNewPurpose().set(this.encodeGML32(purpose));
            }
        }
    }

    private void setObservingCapability(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetObservingCapability()) {
            for (ObservingCapability observingCapability : abstractMonitoringObject.getObservingCapability()) {
                if (observingCapability.isSetHref()) {
                    AbstractMonitoringObjectType.ObservingCapability oc = amot.addNewObservingCapability();
                    oc.setHref(observingCapability.getHref());
                    if (!observingCapability.isSetTitle()) continue;
                    oc.setTitle(observingCapability.getTitle());
                    continue;
                }
                amot.addNewObservingCapability().addNewObservingCapability().set(this.encodeEF(observingCapability));
            }
        }
    }

    private void setBroader(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetBroader()) {
            Hierarchy broader = abstractMonitoringObject.getBroader();
            if (broader.isSetSimpleAttrs()) {
                AbstractMonitoringObjectType.Broader b = amot.addNewBroader();
                b.setHref(broader.getSimpleAttrs().getHref());
                if (broader.getSimpleAttrs().isSetTitle()) {
                    b.setTitle(broader.getSimpleAttrs().getTitle());
                }
            } else {
                amot.addNewBroader().addNewHierarchy().set(this.encodeEF(broader));
            }
        }
    }

    private void setNarrower(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetNarrower()) {
            for (Hierarchy narrower : abstractMonitoringObject.getNarrower()) {
                if (narrower.isSetSimpleAttrs()) {
                    AbstractMonitoringObjectType.Narrower n = amot.addNewNarrower();
                    n.setHref(narrower.getSimpleAttrs().getHref());
                    if (!narrower.getSimpleAttrs().isSetTitle()) continue;
                    n.setTitle(narrower.getSimpleAttrs().getTitle());
                    continue;
                }
                amot.addNewNarrower().addNewHierarchy().set(this.encodeEF(narrower));
            }
        }
    }

    private void setSupersedes(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetSupersedes()) {
            for (AbstractMonitoringObject supersedes : abstractMonitoringObject.getSupersedes()) {
                if (supersedes.isSetSimpleAttrs()) {
                    AbstractMonitoringObjectType.Supersedes s = amot.addNewSupersedes();
                    s.setHref(supersedes.getSimpleAttrs().getHref());
                    if (!supersedes.getSimpleAttrs().isSetTitle()) continue;
                    s.setTitle(supersedes.getSimpleAttrs().getTitle());
                    continue;
                }
                amot.addNewSupersedes().addNewAbstractMonitoringObject().set(this.encodeEF(supersedes));
            }
        }
    }

    private void setSupersededBy(AbstractMonitoringObjectType amot, AbstractMonitoringObject abstractMonitoringObject) throws EncodingException {
        if (abstractMonitoringObject.isSetSupersededBy()) {
            for (AbstractMonitoringObject supersededBy : abstractMonitoringObject.getSupersededBy()) {
                if (supersededBy.isSetSimpleAttrs()) {
                    AbstractMonitoringObjectPropertyType sb = amot.addNewSupersededBy();
                    sb.setHref(supersededBy.getSimpleAttrs().getHref());
                    if (!supersededBy.getSimpleAttrs().isSetTitle()) continue;
                    sb.setTitle(supersededBy.getSimpleAttrs().getTitle());
                    continue;
                }
                amot.addNewSupersededBy().addNewAbstractMonitoringObject().set(this.encodeEF(supersededBy));
            }
        }
    }
}

