/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Locale;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.SOAPConstants;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import javax.xml.soap.SOAPMessage;
import org.apache.xmlbeans.XmlObject;
import org.n52.janmayen.http.MediaType;
import org.n52.janmayen.http.MediaTypes;
import org.n52.shetland.ogc.ows.OWSConstants;
import org.n52.shetland.ogc.ows.exception.CodedException;
import org.n52.shetland.ogc.ows.exception.ExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionCode;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.service.OwsOperationKey;
import org.n52.shetland.ogc.ows.service.OwsServiceCommunicationObject;
import org.n52.shetland.ogc.sos.exception.SosExceptionCode;
import org.n52.shetland.ogc.swes.exception.SwesExceptionCode;
import org.n52.shetland.w3c.soap.SoapFault;
import org.n52.shetland.w3c.soap.SoapHelper;
import org.n52.shetland.w3c.soap.SoapResponse;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.OperationResponseEncoderKey;
import org.n52.svalbard.encode.XmlEncoderKey;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.NoEncoderForKeyException;
import org.n52.svalbard.util.N52XmlHelper;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractSoapEncoder<T, S>
extends AbstractXmlEncoder<T, S> {
    public static final String DEFAULT_FAULT_REASON = "A server exception was encountered.";
    public static final String MISSING_RESPONSE_DETAIL_TEXT = "Missing SOS response document!";
    public static final String MISSING_EXCEPTION_DETAIL_TEXT = "Error while creating SOAPFault element from OWSException! OWSException is missing!";
    private final Set<EncoderKey> encoderKey;

    public AbstractSoapEncoder(String namespace) {
        this.encoderKey = ImmutableSet.of((Object)new XmlEncoderKey(namespace, SoapResponse.class));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(this.encoderKey);
    }

    @Override
    public MediaType getContentType() {
        return MediaTypes.APPLICATION_SOAP_XML;
    }

    @Override
    public T encode(S response) throws EncodingException {
        return (T)this.encode(response, null);
    }

    protected String createSOAPBody(SOAPMessage soapResponseMessage, XmlObject sosResponse, String actionURI) throws SOAPException {
        if (sosResponse != null) {
            this.addAndRemoveSchemaLocationForSOAP(sosResponse, soapResponseMessage);
            soapResponseMessage.getSOAPBody().addDocument((Document)sosResponse.getDomNode());
            return actionURI;
        }
        SoapFault fault = new SoapFault();
        fault.setFaultCode(SOAPConstants.SOAP_RECEIVER_FAULT);
        fault.setFaultSubcode(new QName("http://www.opengis.net/ows/1.1", OwsExceptionCode.NoApplicableCode.name(), "ows"));
        fault.setFaultReason(DEFAULT_FAULT_REASON);
        fault.setLocale(Locale.ENGLISH);
        fault.setDetailText(MISSING_RESPONSE_DETAIL_TEXT);
        this.createSOAPFault(soapResponseMessage.getSOAPBody().addFault(), fault);
        return null;
    }

    protected String createSOAPBody(SOAPMessage soapResponseMessage, SoapResponse soapResponse, String actionURI) throws SOAPException, EncodingException {
        return this.createSOAPBody(soapResponseMessage, this.getBodyContent(soapResponse), actionURI);
    }

    protected XmlObject getBodyContent(SoapResponse response) throws EncodingException {
        OperationResponseEncoderKey key = new OperationResponseEncoderKey(new OwsOperationKey((OwsServiceCommunicationObject)response.getBodyContent()), MediaTypes.APPLICATION_XML);
        Encoder encoder = this.getEncoder((EncoderKey)key, new EncoderKey[0]);
        if (encoder == null) {
            throw new NoEncoderForKeyException((Object)key);
        }
        return (XmlObject)encoder.encode((Object)response.getBodyContent());
    }

    private void addAndRemoveSchemaLocationForSOAP(XmlObject xmlObject, SOAPMessage soapResponseMessage) throws SOAPException {
        String value = null;
        Node nodeToRemove = null;
        NamedNodeMap attributeMap = xmlObject.getDomNode().getFirstChild().getAttributes();
        for (int i = 0; i < attributeMap.getLength(); ++i) {
            Node node = attributeMap.item(i);
            if (!node.getLocalName().equals("schemaLocation")) continue;
            value = node.getNodeValue();
            nodeToRemove = node;
        }
        if (nodeToRemove != null) {
            attributeMap.removeNamedItem(nodeToRemove.getNodeName());
        }
        SOAPEnvelope envelope = soapResponseMessage.getSOAPPart().getEnvelope();
        StringBuilder string = new StringBuilder();
        string.append(envelope.getNamespaceURI());
        string.append(' ');
        string.append(envelope.getNamespaceURI());
        if (value != null && !value.isEmpty()) {
            string.append(' ');
            string.append(value);
        }
        envelope.addAttribute(N52XmlHelper.getSchemaLocationQNameWithPrefix(), string.toString());
    }

    protected void createSOAPFault(SOAPFault fault, SoapFault soapFault) throws SOAPException {
        fault.setFaultCode(soapFault.getFaultCode());
        fault.setFaultString(soapFault.getFaultReason(), soapFault.getLocale());
        if (soapFault.getDetailText() != null) {
            fault.addDetail().setTextContent(soapFault.getDetailText());
        }
    }

    protected String createSOAPFaultFromExceptionResponse(SOAPFault soapFault, OwsExceptionReport owsExceptionReport) throws SOAPException {
        if (!owsExceptionReport.getExceptions().isEmpty()) {
            CodedException firstException = (CodedException)owsExceptionReport.getExceptions().iterator().next();
            if (soapFault.getNamespaceURI().equalsIgnoreCase("http://schemas.xmlsoap.org/soap/envelope/")) {
                QName qname = new QName(soapFault.getNamespaceURI(), "Client", soapFault.getPrefix());
                soapFault.setFaultCode(qname);
            } else {
                soapFault.setFaultCode(SOAPConstants.SOAP_SENDER_FAULT);
                if (firstException.getCode() != null) {
                    soapFault.appendFaultSubcode(new QName("http://www.opengis.net/ows/1.1", firstException.getCode().toString(), "ows"));
                } else {
                    soapFault.appendFaultSubcode(OWSConstants.QN_NO_APPLICABLE_CODE);
                }
            }
            soapFault.addFaultReasonText(SoapHelper.getSoapFaultReasonText((ExceptionCode)firstException.getCode()), Locale.ENGLISH);
            Detail detail = soapFault.addDetail();
            for (CodedException exception : owsExceptionReport.getExceptions()) {
                this.createSOAPFaultDetail(detail, exception);
            }
            return this.getExceptionActionURI(firstException.getCode());
        }
        SoapFault fault = new SoapFault();
        fault.setFaultCode(SOAPConstants.SOAP_RECEIVER_FAULT);
        fault.setFaultSubcode(OWSConstants.QN_NO_APPLICABLE_CODE);
        fault.setFaultReason(DEFAULT_FAULT_REASON);
        fault.setLocale(Locale.ENGLISH);
        fault.setDetailText(MISSING_EXCEPTION_DETAIL_TEXT);
        this.createSOAPFault(soapFault, fault);
        return "http://www.opengis.net/def/serviceOperation/sos/core/2.0/Exception";
    }

    protected String getExceptionActionURI(ExceptionCode exceptionCode) {
        if (exceptionCode instanceof OwsExceptionCode) {
            return "http://www.opengis.net/ows/1.1/Exception";
        }
        if (exceptionCode instanceof SwesExceptionCode) {
            return "http://www.opengis.net/swes/2.0/Exception";
        }
        if (exceptionCode instanceof SosExceptionCode) {
            return "http://www.opengis.net/def/serviceOperation/sos/core/2.0/Exception";
        }
        return "http://www.opengis.net/ows/1.1/Exception";
    }

    private void createSOAPFaultDetail(Detail detail, CodedException exception) throws SOAPException {
        SOAPElement exRep = detail.addChildElement(OWSConstants.QN_EXCEPTION);
        exRep.addNamespaceDeclaration("ows", "http://www.opengis.net/ows/1.1");
        String code = exception.getCode().toString();
        String locator = exception.getLocator();
        StringBuilder exceptionText = new StringBuilder();
        exceptionText.append(exception.getMessage());
        exceptionText.append('\n');
        if (exception.getCause() != null) {
            exceptionText.append('\n').append("[EXCEPTION]: ").append('\n');
            if (exception.getCause().getLocalizedMessage() != null && !exception.getCause().getLocalizedMessage().isEmpty()) {
                exceptionText.append(exception.getCause().getLocalizedMessage());
                exceptionText.append('\n');
            }
            if (exception.getCause().getMessage() != null && !exception.getCause().getMessage().isEmpty()) {
                exceptionText.append(exception.getCause().getMessage());
                exceptionText.append('\n');
            }
        }
        exRep.addAttribute(new QName("exceptionCode"), code);
        if (locator != null && !locator.isEmpty()) {
            exRep.addAttribute(new QName("locator"), locator);
        }
        if (exceptionText.length() != 0) {
            SOAPElement execText = exRep.addChildElement(OWSConstants.QN_EXCEPTION_TEXT);
            execText.setTextContent(exceptionText.toString());
        }
    }
}

