/*
 * Decompiled with CFR 0.152.
 */
package org.n52.svalbard.encode;

import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Sets;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.n52.faroe.ConfigurationError;
import org.n52.faroe.annotation.Configurable;
import org.n52.faroe.annotation.Setting;
import org.n52.shetland.aqd.AbstractEReportingHeader;
import org.n52.shetland.aqd.AqdConstants;
import org.n52.shetland.aqd.EReportObligationRepository;
import org.n52.shetland.aqd.EReportingHeader;
import org.n52.shetland.aqd.ReportObligationType;
import org.n52.shetland.aqd.ReportObligations;
import org.n52.shetland.ogc.SupportedType;
import org.n52.shetland.ogc.gml.AbstractFeature;
import org.n52.shetland.ogc.gml.CodeWithAuthority;
import org.n52.shetland.ogc.gml.time.TimeInstant;
import org.n52.shetland.ogc.gml.time.TimePeriod;
import org.n52.shetland.ogc.om.ObservationStream;
import org.n52.shetland.ogc.om.OmObservation;
import org.n52.shetland.ogc.om.StreamingValue;
import org.n52.shetland.ogc.om.features.FeatureCollection;
import org.n52.shetland.ogc.ows.exception.OwsExceptionReport;
import org.n52.shetland.ogc.ows.extension.Extensions;
import org.n52.shetland.ogc.sos.response.GetObservationResponse;
import org.n52.shetland.util.JavaHelper;
import org.n52.shetland.w3c.SchemaLocation;
import org.n52.shetland.w3c.xlink.Referenceable;
import org.n52.svalbard.encode.AbstractXmlEncoder;
import org.n52.svalbard.encode.Encoder;
import org.n52.svalbard.encode.EncoderFlags;
import org.n52.svalbard.encode.EncoderKey;
import org.n52.svalbard.encode.EncodingContext;
import org.n52.svalbard.encode.ObservationEncoder;
import org.n52.svalbard.encode.XmlBeansEncodingFlags;
import org.n52.svalbard.encode.XmlEncoderFlags;
import org.n52.svalbard.encode.XmlStreamEncoderFlags;
import org.n52.svalbard.encode.exception.EncodingException;
import org.n52.svalbard.encode.exception.UnsupportedEncoderInputException;
import org.n52.svalbard.util.CodingHelper;
import org.n52.svalbard.write.EReportingHeaderEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Configurable
public class AqdEncoder
extends AbstractXmlEncoder<XmlObject, Object>
implements ObservationEncoder<XmlObject, Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AqdEncoder.class);
    private static final Set<EncoderKey> ENCODER_KEY_TYPES = CodingHelper.encoderKeysForElements((String)"http://dd.eionet.europa.eu/schemaset/id2011850eu-1.0", (Class[])new Class[]{GetObservationResponse.class, OmObservation.class, EReportingHeader.class});
    private Optional<EReportObligationRepository> reportObligationRepository;
    private String namespace;
    private String observationPrefix;

    public AqdEncoder() {
        LOGGER.debug("Encoder for the following keys initialized successfully: {}!", (Object)Joiner.on((String)", ").join(ENCODER_KEY_TYPES));
    }

    public Set<EncoderKey> getKeys() {
        return Collections.unmodifiableSet(ENCODER_KEY_TYPES);
    }

    public Set<SchemaLocation> getSchemaLocations() {
        return Sets.newHashSet((Object[])new SchemaLocation[]{AqdConstants.NS_AQD_SCHEMA_LOCATION});
    }

    public void addNamespacePrefixToMap(Map<String, String> nameSpacePrefixMap) {
        nameSpacePrefixMap.put("http://dd.eionet.europa.eu/schemaset/id2011850eu-1.0", "aqd");
    }

    public boolean isObservationAndMeasurmentV20Type() {
        return false;
    }

    public boolean shouldObservationsWithSameXBeMerged() {
        return false;
    }

    public boolean supportsResultStreamingForMergedValues() {
        return false;
    }

    public Set<String> getSupportedResponseFormats(String service, String version) {
        if ("SOS".equals(service) && "1.0.0".equals(version)) {
            return Sets.newHashSet((Object[])new String[]{AqdConstants.AQD_CONTENT_TYPE.toString()});
        }
        return Sets.newHashSet((Object[])new String[]{"http://dd.eionet.europa.eu/schemaset/id2011850eu-1.0"});
    }

    public Map<String, Set<SupportedType>> getSupportedResponseFormatObservationTypes() {
        return Collections.emptyMap();
    }

    public XmlObject encode(Object element, EncodingContext ctx) throws EncodingException, UnsupportedEncoderInputException {
        if (element instanceof GetObservationResponse) {
            return this.encodeGetObservationResponse((GetObservationResponse)element, ctx);
        }
        if (element instanceof OmObservation) {
            return this.encodeOmObservation((OmObservation)element, ctx);
        }
        if (element instanceof EReportingHeader) {
            return this.encodeEReportingHeader((EReportingHeader)element, ctx);
        }
        throw new UnsupportedEncoderInputException((Encoder)this, element);
    }

    private XmlObject encodeGetObservationResponse(GetObservationResponse response, EncodingContext ctx) throws EncodingException {
        try {
            FeatureCollection featureCollection = this.getFeatureCollection(response);
            EReportingHeader eReportingHeader = this.getEReportingHeader(this.getReportObligationType(response));
            featureCollection.addMember((AbstractFeature)eReportingHeader);
            TimePeriod timePeriod = new TimePeriod();
            TimeInstant resultTime = new TimeInstant(new DateTime(DateTimeZone.UTC));
            int counter = 1;
            ObservationStream observationCollection = response.getObservationCollection();
            while (observationCollection.hasNext()) {
                OmObservation observation = (OmObservation)observationCollection.next();
                if (observation.getValue() instanceof ObservationStream) {
                    ObservationStream value = (ObservationStream)observation.getValue();
                    if (value instanceof StreamingValue) {
                        value = value.merge();
                    }
                    while (value.hasNext()) {
                        this.processObservation((OmObservation)value.next(), timePeriod, resultTime, featureCollection, (AbstractEReportingHeader)eReportingHeader, counter++);
                    }
                    continue;
                }
                this.processObservation(observation, timePeriod, resultTime, featureCollection, (AbstractEReportingHeader)eReportingHeader, counter++);
            }
            if (!timePeriod.isEmpty()) {
                eReportingHeader.setReportingPeriod(Referenceable.of((Object)timePeriod));
            }
            return this.encodeObjectToXml("http://www.opengis.net/gml/3.2", featureCollection, ctx.with((Enum)XmlEncoderFlags.ENCODE_NAMESPACE, (Object)"http://www.opengis.net/om/2.0").with((Enum)XmlBeansEncodingFlags.DOCUMENT));
        }
        catch (OwsExceptionReport ex) {
            throw new EncodingException((Throwable)ex);
        }
    }

    private XmlObject encodeOmObservation(OmObservation element, EncodingContext context) throws EncodingException {
        return this.encodeObjectToXml("http://www.opengis.net/om/2.0", element, context);
    }

    private XmlObject encodeEReportingHeader(EReportingHeader element, EncodingContext ctx) throws EncodingException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            EncodingContext context = ctx.with((Enum)EncoderFlags.ENCODER_REPOSITORY, (Object)this.getEncoderRepository()).with((Enum)XmlEncoderFlags.XML_OPTIONS, this::getXmlOptions);
            new EReportingHeaderEncoder(context, (OutputStream)baos, element).write();
            if (context.has((Enum)XmlStreamEncoderFlags.XML_WRITER)) {
                return null;
            }
            return XmlObject.Factory.parse((String)baos.toString("UTF8"));
        }
        catch (UnsupportedEncodingException | XMLStreamException | XmlException xmlse) {
            throw new EncodingException("Error encoding response", xmlse);
        }
    }

    private ReportObligationType getReportObligationType(GetObservationResponse response) throws EncodingException {
        try {
            return ReportObligations.getFlow((Extensions)response.getExtensions());
        }
        catch (OwsExceptionReport ex) {
            throw new EncodingException((Throwable)ex);
        }
    }

    private FeatureCollection getFeatureCollection(GetObservationResponse response) throws EncodingException {
        FeatureCollection featureCollection = new FeatureCollection();
        featureCollection.setGmlId("fc_" + JavaHelper.generateID((String)new DateTime().toString()));
        return featureCollection;
    }

    protected void processObservation(OmObservation observation, TimePeriod timePeriod, TimeInstant resultTime, FeatureCollection featureCollection, AbstractEReportingHeader eReportingHeader, int counter) {
        if (observation.isSetPhenomenonTime()) {
            observation.setGmlId(this.getObservationId(counter));
            eReportingHeader.addContent((AbstractFeature)new OmObservation().setIdentifier(new CodeWithAuthority(this.getObservationXlink(observation.getGmlId()))));
            timePeriod.extendToContain(observation.getPhenomenonTime());
            observation.setResultTime(resultTime);
            featureCollection.addMember((AbstractFeature)observation);
        }
    }

    protected String getObservationXlink(String gmlId) {
        StringBuilder id = new StringBuilder();
        if (this.isSetEReportingNamespace()) {
            id.append(this.getEReportingNamespace());
            if (!this.getEReportingNamespace().endsWith("/")) {
                id.append("/");
            }
        } else {
            id.append("#");
        }
        id.append(gmlId);
        return id.toString();
    }

    protected String getObservationId(int counter) {
        return (this.isSetEReportingObservationPrefix() ? this.getEReportingObservationPrefix() : "o_").concat(Integer.toString(counter));
    }

    public String getEReportingNamespace() {
        return this.namespace;
    }

    @Setting(value="eReporting.namespace")
    public void setEReportingNamespace(String namespace) throws ConfigurationError {
        this.namespace = namespace;
    }

    protected boolean isSetEReportingNamespace() {
        return !Strings.isNullOrEmpty((String)this.getEReportingNamespace());
    }

    @Setting(value="eReporting.observation.prefix")
    public void setEReportingObservationPrefix(String observationPrefix) throws ConfigurationError {
        this.observationPrefix = observationPrefix;
    }

    protected String getEReportingObservationPrefix() {
        return this.observationPrefix;
    }

    protected boolean isSetEReportingObservationPrefix() {
        return !Strings.isNullOrEmpty((String)this.getEReportingObservationPrefix());
    }

    protected EReportingHeader getEReportingHeader(ReportObligationType type) throws OwsExceptionReport, EncodingException {
        if (this.reportObligationRepository.isPresent()) {
            return this.reportObligationRepository.get().createHeader(type);
        }
        throw new EncodingException("Missing implementatation of %s!", new Object[]{EReportObligationRepository.class});
    }

    @Inject
    public void setReportObligationRepository(Optional<EReportObligationRepository> reportObligationRepository) {
        this.reportObligationRepository = reportObligationRepository;
    }
}

